/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.DateUtil;
import com.cgd.manage.dic.dict.po.DicDictionary;
import com.cgd.user.dictionary.intfce.SelectDicValBypCodesBusiService;
import com.cgd.user.dictionary.intfce.bo.DicValAndpCodeBO;
import com.cgd.user.dictionary.intfce.bo.SelectDicValBypCodesReqBO;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import com.gd.commodity.busi.GeneratePlaAgreementCodeService;
import com.gd.commodity.busi.bo.agreement.GeneratePlaAgreementCodeReqBO;
import com.gd.commodity.busi.bo.agreement.GeneratePlaAgreementCodeRspBO;
import com.gd.commodity.dao.SupplierAgreementMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratePlaAgreementCodeServiceImpl
implements GeneratePlaAgreementCodeService {
    private static final Logger logger = LoggerFactory.getLogger(GeneratePlaAgreementCodeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SupplierAgreementMapper supplierAgreementMapper;
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    private SelectDicValBypCodesBusiService selectDicValBypCodesBusiService;

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSelectUserInfoByUserIdBusiService(SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService) {
        this.selectUserInfoByUserIdBusiService = selectUserInfoByUserIdBusiService;
    }

    public void setSelectDicValBypCodesBusiService(SelectDicValBypCodesBusiService selectDicValBypCodesBusiService) {
        this.selectDicValBypCodesBusiService = selectDicValBypCodesBusiService;
    }

    public GeneratePlaAgreementCodeRspBO generateAgreementCode(GeneratePlaAgreementCodeReqBO generatePlaAgreementCodeReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u751f\u6210\u5e73\u53f0\u534f\u8bae\u7f16\u53f7\u4e1a\u52a1\u670d\u52a1 \uff1a" + generatePlaAgreementCodeReqBO.toString());
        }
        GeneratePlaAgreementCodeRspBO rsp = new GeneratePlaAgreementCodeRspBO();
        try {
            ArrayList<String> pCodes = new ArrayList<String>();
            pCodes.add("COMMODITY_AGREEMENTTYPE");
            pCodes.add("COMMODITY_PURCHASETYPE");
            SelectDicValBypCodesReqBO selectDicValBypCodesReqBO = new SelectDicValBypCodesReqBO();
            selectDicValBypCodesReqBO.setpCodes(pCodes);
            List dics = this.selectDicValBypCodesBusiService.selectDicValBypCodes(selectDicValBypCodesReqBO).getDicValAndpCodeBOs();
            SelectUserInfoByUserIdReqBO selectUserInfoByUserIdReqBO = new SelectUserInfoByUserIdReqBO();
            selectUserInfoByUserIdReqBO.setUserId(generatePlaAgreementCodeReqBO.getUserId());
            String supplierSortCode = null;
            SelectUserInfoByUserIdRspBO selectUserInfoByUserIdRspBO = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoByUserIdReqBO);
            if (null != selectUserInfoByUserIdRspBO && !"8888".equals(selectUserInfoByUserIdRspBO.getRespCode())) {
                supplierSortCode = selectUserInfoByUserIdRspBO.getCode();
            }
            List agreementTypeInfo = ((DicValAndpCodeBO)((Map)dics.get(0)).get("COMMODITY_AGREEMENTTYPE")).getDicDictionaries();
            String agreementTypeCode = null;
            for (DicDictionary dicDictionary : agreementTypeInfo) {
                if (!dicDictionary.getTitle().equals(generatePlaAgreementCodeReqBO.getAgreementType())) continue;
                agreementTypeCode = dicDictionary.getCode();
                break;
            }
            List purchaseTypeInfo = ((DicValAndpCodeBO)((Map)dics.get(0)).get("COMMODITY_PURCHASETYPE")).getDicDictionaries();
            String purchaseTypeCode = null;
            for (DicDictionary dicDictionary : purchaseTypeInfo) {
                if (!dicDictionary.getTitle().equals(generatePlaAgreementCodeReqBO.getPurchaseType())) continue;
                purchaseTypeCode = dicDictionary.getCode();
                break;
            }
            String time = DateUtil.dateToStr((Date)new Date(), (String)"yyyyMM");
            String maxNum = this.supplierAgreementMapper.selectMaxOrderNum(time);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            if (null != supplierSortCode) {
                sb.append(supplierSortCode).append("-");
            }
            sb.append(agreementTypeCode).append(purchaseTypeCode).append("-").append(time).append(num).toString();
            String plaAgreementCode = sb.toString();
            rsp.setIsSuccess(Boolean.valueOf(true));
            rsp.setResultMsg("\u6210\u529f");
            rsp.setPlaAgreementCode(plaAgreementCode);
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u5e73\u53f0\u534f\u8bae\u7f16\u53f7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            rsp.setIsSuccess(Boolean.valueOf(false));
            rsp.setResultMsg("\u5931\u8d25");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u751f\u6210\u5e73\u53f0\u534f\u8bae\u7f16\u53f7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }
}

