/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.AddCatalogTypeRelService;
import com.cgd.commodity.busi.bo.catalog.AddCatalogTypeRelReqBO;
import com.cgd.commodity.busi.bo.catalog.AddCatalogTypeRelRspBO;
import com.cgd.commodity.busi.bo.catalog.CommodityType;
import com.cgd.commodity.busi.impl.QryCommodityTypeServiceImpl;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.po.CommodityGuideCatalog;
import com.cgd.common.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddCatalogTypeRelServiceImpl
implements AddCatalogTypeRelService {
    private static final Logger logger = LoggerFactory.getLogger(QryCommodityTypeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public AddCatalogTypeRelRspBO addCatalogTypeRel(AddCatalogTypeRelReqBO addCatalogTypeRelReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7c7b\u76ee\u4e0e\u5546\u54c1\u7c7b\u578b\u5173\u7cfb\u7ef4\u62a4\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + addCatalogTypeRelReqBO.toString());
        }
        ArrayList<Long> needAddId = new ArrayList<Long>();
        ArrayList<Long> needInsertId = new ArrayList<Long>();
        ArrayList<Long> needUpdateId = new ArrayList<Long>();
        ArrayList<Long> needModityId = new ArrayList<Long>();
        AddCatalogTypeRelRspBO rsp = new AddCatalogTypeRelRspBO();
        try {
            if (addCatalogTypeRelReqBO.getCommodityTypes().size() > 0) {
                for (CommodityType commodityType : addCatalogTypeRelReqBO.getCommodityTypes()) {
                    if (commodityType.getOperatorType() == 0) {
                        needAddId.add(commodityType.getCommodityTypeId());
                        continue;
                    }
                    needUpdateId.add(commodityType.getCommodityTypeId());
                }
                List<Long> softDelList = this.commodityGuideCatalogMapper.getSoftDelCommodityTypeId(addCatalogTypeRelReqBO.getGuideCatalogId());
                CommodityGuideCatalog commodityGuideCatalog = this.commodityGuideCatalogMapper.selectByPrimaryKey(addCatalogTypeRelReqBO.getGuideCatalogId());
                Integer channelId = 0;
                if (commodityGuideCatalog != null) {
                    channelId = commodityGuideCatalog.getChannelId();
                }
                for (Long id : needAddId) {
                    if (softDelList.contains(id)) {
                        needModityId.add(id);
                        continue;
                    }
                    needInsertId.add(id);
                }
                if (needInsertId.size() > 0) {
                    this.commodityGuideCatalogMapper.insertCatalogTypeRelWithId(addCatalogTypeRelReqBO.getGuideCatalogId(), needInsertId, channelId);
                }
                if (needUpdateId.size() > 0) {
                    this.commodityGuideCatalogMapper.updateCatalogTypeRelWithId(addCatalogTypeRelReqBO.getGuideCatalogId(), needUpdateId, 1);
                }
                if (needModityId.size() > 0) {
                    this.commodityGuideCatalogMapper.updateCatalogTypeRelWithId(addCatalogTypeRelReqBO.getGuideCatalogId(), needModityId, 0);
                }
            }
            rsp.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("\u7c7b\u76ee\u4e0e\u5546\u54c1\u7c7b\u578b\u5173\u7cfb\u7ef4\u62a4\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            rsp.setResultMsg("\u7c7b\u76ee\u4e0e\u5546\u54c1\u7c7b\u578b\u5173\u7cfb\u7ef4\u62a4\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7c7b\u76ee\u4e0e\u5546\u54c1\u7c7b\u578b\u5173\u7cfb\u7ef4\u62a4\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }
}

