/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.atom.GenerateStationMsgLogSeqService;
import com.cgd.commodity.atom.bo.GenerateStationMsgLogSeqRspBO;
import com.cgd.commodity.busi.AddMsgLogService;
import com.cgd.commodity.busi.bo.agreement.AddMsgLogReqBO;
import com.cgd.commodity.busi.bo.agreement.AddMsgLogRspBO;
import com.cgd.commodity.busi.vo.agreement.MsgDetailLogVO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.StationMsgDetailLogMapper;
import com.cgd.commodity.dao.StationMsgLogMapper;
import com.cgd.commodity.po.StationMsgDetailLog;
import com.cgd.commodity.po.StationMsgLog;
import com.cgd.common.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddMsgLogServiceImpl
implements AddMsgLogService {
    private static final Logger logger = LoggerFactory.getLogger(AddMsgLogServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private GenerateStationMsgLogSeqService generateStationMsgLogSeqService;
    private StationMsgLogMapper stationMsgLogMapper;
    private StationMsgDetailLogMapper stationMsgDetailLogMapper;

    public AddMsgLogRspBO addMsgLog(AddMsgLogReqBO addMsgLogReqBO) {
        if (this.isDebugEnabled) {
            logger.info("\u65b0\u589e\u6d88\u606f\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + addMsgLogReqBO.toString());
        }
        AddMsgLogRspBO rsp = new AddMsgLogRspBO();
        try {
            GenerateStationMsgLogSeqRspBO generateStationMsgLogSeqRspBO = this.generateStationMsgLogSeqService.generateStationMsgLogSeq();
            StationMsgLog stationMsgLog = this.initStationMsgLog(addMsgLogReqBO, generateStationMsgLogSeqRspBO);
            this.stationMsgLogMapper.insert(stationMsgLog);
            List<StationMsgDetailLog> stationMsgDetailLogs = this.initStationMsgDetailLog(addMsgLogReqBO, generateStationMsgLogSeqRspBO);
            if (null != stationMsgDetailLogs && stationMsgDetailLogs.size() > 0) {
                this.stationMsgDetailLogMapper.insertBatch(stationMsgDetailLogs);
            }
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u6210\u529f");
            rsp.setIsSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6d88\u606f\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u589e\u6d88\u606f\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    private List<StationMsgDetailLog> initStationMsgDetailLog(AddMsgLogReqBO addMsgLogReqBO, GenerateStationMsgLogSeqRspBO generateStationMsgLogSeqRspBO) {
        ArrayList<StationMsgDetailLog> stationMsgDetailLogs = new ArrayList<StationMsgDetailLog>();
        if (null != addMsgLogReqBO.getMsgDetailLogList() && addMsgLogReqBO.getMsgDetailLogList().size() > 0) {
            for (MsgDetailLogVO msgDetailLogVO : addMsgLogReqBO.getMsgDetailLogList()) {
                StationMsgDetailLog stationMsgDetailLog = new StationMsgDetailLog();
                stationMsgDetailLog.setAgreementId(msgDetailLogVO.getAgreementId());
                stationMsgDetailLog.setAgreementName(msgDetailLogVO.getAgreementName());
                stationMsgDetailLog.setCreateLoginId(msgDetailLogVO.getCreateLoginId());
                stationMsgDetailLog.setCreateTime(msgDetailLogVO.getCreateTime());
                stationMsgDetailLog.setIsDelete((byte)Constant.IS_DELETE.intValue());
                stationMsgDetailLog.setMsgId(generateStationMsgLogSeqRspBO.getMsgId());
                stationMsgDetailLog.setRemark(msgDetailLogVO.getRemark());
                stationMsgDetailLog.setSkuId(msgDetailLogVO.getSkuId());
                stationMsgDetailLog.setSkuName(msgDetailLogVO.getSkuName());
                stationMsgDetailLog.setSupplierId(msgDetailLogVO.getSupplierId());
                stationMsgDetailLog.setSupplierName(msgDetailLogVO.getSupplierName());
                stationMsgDetailLog.setUpdateLoginId(msgDetailLogVO.getUpdateLoginId());
                stationMsgDetailLog.setUpdateTime(msgDetailLogVO.getUpdateTime());
                stationMsgDetailLogs.add(stationMsgDetailLog);
            }
        }
        return stationMsgDetailLogs;
    }

    private StationMsgLog initStationMsgLog(AddMsgLogReqBO addMsgLogReqBO, GenerateStationMsgLogSeqRspBO generateStationMsgLogSeqRspBO) {
        StationMsgLog stationMsgLog = new StationMsgLog();
        stationMsgLog.setMsgId(generateStationMsgLogSeqRspBO.getMsgId());
        stationMsgLog.setCreateLoginId(addMsgLogReqBO.getCreateLoginId());
        stationMsgLog.setCreateTime(addMsgLogReqBO.getCreateTime());
        stationMsgLog.setIsDelete((byte)Constant.IS_DELETE.intValue());
        if (null != addMsgLogReqBO.getMsgType()) {
            stationMsgLog.setMsgType((byte)addMsgLogReqBO.getMsgType().intValue());
        }
        stationMsgLog.setOperateTime(addMsgLogReqBO.getOperateTime());
        stationMsgLog.setOperator(addMsgLogReqBO.getOperator());
        stationMsgLog.setOperatorId(addMsgLogReqBO.getOperatorId());
        stationMsgLog.setReceiverId(addMsgLogReqBO.getReceiveId());
        stationMsgLog.setReceiverName(addMsgLogReqBO.getReceiveName());
        stationMsgLog.setSupplierId(addMsgLogReqBO.getSupplierId());
        stationMsgLog.setSupplierName(addMsgLogReqBO.getSupplierName());
        stationMsgLog.setUpdateLoginId(addMsgLogReqBO.getUpdateLoginId());
        stationMsgLog.setUpdateTime(addMsgLogReqBO.getUpdateTime());
        stationMsgLog.setRemark(addMsgLogReqBO.getRemark());
        return stationMsgLog;
    }

    public void setGenerateStationMsgLogSeqService(GenerateStationMsgLogSeqService generateStationMsgLogSeqService) {
        this.generateStationMsgLogSeqService = generateStationMsgLogSeqService;
    }

    public void setStationMsgLogMapper(StationMsgLogMapper stationMsgLogMapper) {
        this.stationMsgLogMapper = stationMsgLogMapper;
    }

    public void setStationMsgDetailLogMapper(StationMsgDetailLogMapper stationMsgDetailLogMapper) {
        this.stationMsgDetailLogMapper = stationMsgDetailLogMapper;
    }
}

