/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.atom.GenerateSkuApproveLogSeqService;
import com.cgd.commodity.atom.bo.GenerateSkuApproveLogSeqRspBO;
import com.cgd.commodity.busi.BusiCreateExamineService;
import com.cgd.commodity.busi.bo.BusiCreateExamineReqBO;
import com.cgd.commodity.busi.bo.BusiCreateExamineReqInfo;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.SkuApproveDetailLogMapper;
import com.cgd.commodity.dao.SkuApproveLogMapper;
import com.cgd.commodity.po.SkuApproveDetailLog;
import com.cgd.commodity.po.SkuApproveLog;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusiCreateExamineServiceImpl
implements BusiCreateExamineService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCreateExamineServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuApproveLogMapper skuApproveLogMapper;
    private SkuApproveDetailLogMapper skuApproveDetailLogMapper;
    private GenerateSkuApproveLogSeqService generateSkuApproveLogSeqService;

    public void setSkuApproveLogMapper(SkuApproveLogMapper skuApproveLogMapper) {
        this.skuApproveLogMapper = skuApproveLogMapper;
    }

    public void setSkuApproveDetailLogMapper(SkuApproveDetailLogMapper skuApproveDetailLogMapper) {
        this.skuApproveDetailLogMapper = skuApproveDetailLogMapper;
    }

    public void setGenerateSkuApproveLogSeqService(GenerateSkuApproveLogSeqService generateSkuApproveLogSeqService) {
        this.generateSkuApproveLogSeqService = generateSkuApproveLogSeqService;
    }

    public RspBusiBaseBO createExamine(BusiCreateExamineReqBO busiCreateExamineReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5ba1\u6279\u4fe1\u606f\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiCreateExamineReqBO.toString());
        }
        if (null == busiCreateExamineReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5ba1\u6279\u4fe1\u606f\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiCreateExamineReqBO.getApprover()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5ba1\u6279\u4fe1\u606f\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5ba1\u6279\u4eba[approver]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiCreateExamineReqBO.getApproveType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5ba1\u6279\u4fe1\u606f\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5ba1\u6279\u7c7b\u578b[approveType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (busiCreateExamineReqBO.getCreateExamineInfos().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5ba1\u6279\u4fe1\u606f\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u660e\u7ec6\u96c6\u5408[createExamineInfos]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            GenerateSkuApproveLogSeqRspBO generateSkuApproveLogSeqRspBO = this.generateSkuApproveLogSeqService.generateSkuApproveLogSeq();
            SkuApproveLog skuApproveLog = this.initSkuApproveLog(busiCreateExamineReqBO, generateSkuApproveLogSeqRspBO);
            this.skuApproveLogMapper.insert(skuApproveLog);
            List<SkuApproveDetailLog> skuApproveDetailLogs = this.initSkuApproveDetailLog(busiCreateExamineReqBO, generateSkuApproveLogSeqRspBO);
            this.skuApproveDetailLogMapper.insertBatch(skuApproveDetailLogs);
            RspBusiBaseBO RspBusiBaseBO2 = new RspBusiBaseBO();
            RspBusiBaseBO2.setRespCode("0000");
            RspBusiBaseBO2.setRespDesc("\u6210\u529f");
            return RspBusiBaseBO2;
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6279\u4fe1\u606f\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5ba1\u6279\u4fe1\u606f\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u4fdd\u5b58\u51fa\u9519");
        }
    }

    private SkuApproveLog initSkuApproveLog(BusiCreateExamineReqBO busiCreateExamineReqBO, GenerateSkuApproveLogSeqRspBO generateSkuApproveLogSeqRspBO) {
        try {
            SkuApproveLog skuApproveLog = new SkuApproveLog();
            skuApproveLog.setApproveId(generateSkuApproveLogSeqRspBO.getApproveId());
            skuApproveLog.setApprover(busiCreateExamineReqBO.getApprover());
            skuApproveLog.setApproveTime(busiCreateExamineReqBO.getCreateTime());
            skuApproveLog.setApproveType(busiCreateExamineReqBO.getApproveType());
            skuApproveLog.setCreateLoginId(busiCreateExamineReqBO.getCreateLoginId());
            skuApproveLog.setCreateTime(busiCreateExamineReqBO.getCreateTime());
            skuApproveLog.setSkuNumber(busiCreateExamineReqBO.getCreateExamineInfos().size());
            skuApproveLog.setRemark(busiCreateExamineReqBO.getRemark());
            skuApproveLog.setSupplierId(busiCreateExamineReqBO.getSupplierId());
            skuApproveLog.setIsDelete(Constant.IS_DELETE);
            skuApproveLog.setRemark(busiCreateExamineReqBO.getRemark());
            skuApproveLog.setRejectContent(busiCreateExamineReqBO.getRejectContent());
            skuApproveLog.setSuggestContent(busiCreateExamineReqBO.getSuggestContent());
            if (null != busiCreateExamineReqBO.getUpdateLoginId()) {
                skuApproveLog.setUpdateLoginId(busiCreateExamineReqBO.getUpdateLoginId());
                skuApproveLog.setUpdateTime(new Date());
            }
            return skuApproveLog;
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6279\u4fe1\u606f\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5ba1\u6279\u65e5\u5fd7\u5165\u53c2\u51fa\u9519" + e);
            throw new RuntimeException("\u5ba1\u6279\u4fe1\u606f\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5ba1\u6279\u65e5\u5fd7\u5165\u53c2\u51fa\u9519");
        }
    }

    private List<SkuApproveDetailLog> initSkuApproveDetailLog(BusiCreateExamineReqBO busiCreateExamineReqBO, GenerateSkuApproveLogSeqRspBO generateSkuApproveLogSeqRspBO) {
        try {
            LinkedList<SkuApproveDetailLog> skuApproveDetailLogs = new LinkedList<SkuApproveDetailLog>();
            for (BusiCreateExamineReqInfo busiCreateExamineReqInfo : busiCreateExamineReqBO.getCreateExamineInfos()) {
                SkuApproveDetailLog skuApproveDetailLog = new SkuApproveDetailLog();
                skuApproveDetailLog.setSupplierId(busiCreateExamineReqBO.getSupplierId());
                skuApproveDetailLog.setApproveId(generateSkuApproveLogSeqRspBO.getApproveId());
                skuApproveDetailLog.setMarketPrice(busiCreateExamineReqInfo.getMarketPrice());
                skuApproveDetailLog.setAgreementPrice(busiCreateExamineReqInfo.getAgreementPrice());
                skuApproveDetailLog.setSkuCatalog(busiCreateExamineReqInfo.getSkuCatalog());
                skuApproveDetailLog.setSkuId(busiCreateExamineReqInfo.getSkuId());
                skuApproveDetailLog.setSkuName(busiCreateExamineReqInfo.getSkuName());
                skuApproveDetailLog.setSupplierName(busiCreateExamineReqInfo.getSupplierName());
                skuApproveDetailLog.setBrandName(busiCreateExamineReqInfo.getBrandName());
                if (null != busiCreateExamineReqBO.getUpdateLoginId()) {
                    skuApproveDetailLog.setUpdateLoginId(busiCreateExamineReqBO.getUpdateLoginId());
                    skuApproveDetailLog.setUpdateTime(busiCreateExamineReqBO.getCreateTime());
                }
                Float discountRate = Float.valueOf((float)busiCreateExamineReqInfo.getAgreementPrice().longValue() / (float)busiCreateExamineReqInfo.getMarketPrice().longValue());
                BigDecimal bigDecimal = new BigDecimal(discountRate.floatValue());
                Float discountRateFloat = Float.valueOf(bigDecimal.setScale(2, 4).floatValue());
                skuApproveDetailLog.setDiscountRate(discountRateFloat);
                if (null != busiCreateExamineReqInfo.getPubTime()) {
                    skuApproveDetailLog.setPubTime(busiCreateExamineReqInfo.getPubTime());
                } else {
                    skuApproveDetailLog.setPubTime(new Date());
                }
                skuApproveDetailLog.setCreateLoginId(busiCreateExamineReqBO.getCreateLoginId());
                skuApproveDetailLog.setCreateTime(new Date());
                skuApproveDetailLog.setIsDelete((byte)Constant.IS_DELETE.intValue());
                skuApproveDetailLog.setRemark(busiCreateExamineReqInfo.getRemark());
                skuApproveDetailLog.setSuccess((byte)busiCreateExamineReqInfo.getSuccess().intValue());
                skuApproveDetailLog.setResultMsg(busiCreateExamineReqInfo.getResultMsg());
                skuApproveDetailLog.setApproveType((byte)busiCreateExamineReqInfo.getApproveType().intValue());
                skuApproveDetailLog.setApproveSkuState(busiCreateExamineReqInfo.getApproveSkuSate());
                skuApproveDetailLogs.add(skuApproveDetailLog);
            }
            return skuApproveDetailLogs;
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6279\u4fe1\u606f\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5ba1\u6279\u660e\u7ec6\u65e5\u5fd7\u5165\u53c2\u51fa\u9519" + e);
            throw new RuntimeException("\u5ba1\u6279\u4fe1\u606f\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5ba1\u6279\u660e\u7ec6\u65e5\u5fd7\u5165\u53c2\u51fa\u9519");
        }
    }
}

