/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.lang.StringUtils;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONException;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.cgd.commodity.busi.CmprSKUPrcsPrcService;
import com.cgd.commodity.busi.bo.BusiCmprSKUPrcsPrcReqBO;
import com.cgd.commodity.busi.bo.BusiCmprSKUPrcsPrcRspBO;
import com.cgd.commodity.busi.bo.BusiCmprSKUPrcsPrcRspInfo;
import com.cgd.commodity.constant.Constant;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.search.builder.search.SearchBuilder;
import com.cgd.search.builder.search.SearchRequestBuilder;
import com.cgd.search.builder.search.SearchRequestBuilderAdapter;
import com.cgd.search.builder.search.query.BooleanQueryCondition;
import com.cgd.search.builder.search.query.MatchQueryCondition;
import com.cgd.search.builder.search.query.QueryCondition;
import com.cgd.search.builder.search.result.Result;
import com.cgd.search.builder.search.sort.SearchSortMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CmprSKUPrcsPrcServiceImpl
implements CmprSKUPrcsPrcService {
    private static final Log log = LogFactory.getLog(CmprSKUPrcsPrcServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private SearchRequestBuilderAdapter searchRequestBuilderAdapter;
    private Properties prop;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public BusiCmprSKUPrcsPrcRspBO cmprSKUPrcsPrc(BusiCmprSKUPrcsPrcReqBO busiCmprSKUPrcsPrcReqBO) {
        BusiCmprSKUPrcsPrcRspBO bo = new BusiCmprSKUPrcsPrcRspBO();
        if (this.isDebugEnabled) {
            log.debug((Object)("\u7cbe\u786e\u6bd4\u4ef7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiCmprSKUPrcsPrcReqBO.toString()));
        }
        if (null == busiCmprSKUPrcsPrcReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7cbe\u786e\u6bd4\u4ef7\u4e1a\u52a1\u670d\u52a1\u5355\u54c1ID[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (busiCmprSKUPrcsPrcReqBO.getUserId() != null) {
            bo.setIsLogin(Boolean.valueOf(true));
        } else {
            bo.setIsLogin(Boolean.valueOf(false));
        }
        Long skuId = busiCmprSKUPrcsPrcReqBO.getSkuId();
        String upCode = busiCmprSKUPrcsPrcReqBO.getUpcCode();
        String mfgSku = this.searchMfg("id", String.valueOf(skuId));
        List<Object> compSkuPriceByUpcAndMfgInfoUPC = new ArrayList();
        List<Object> compSkuPriceByUpcAndMfgInfoMFG = new ArrayList();
        ArrayList result = new ArrayList();
        ArrayList resultAll = new ArrayList();
        if (StringUtils.isEmpty((String)busiCmprSKUPrcsPrcReqBO.getUpcCode()) && StringUtils.isEmpty((String)mfgSku)) {
            bo.setBusiCmprSKUPrcsPrcRspInfos(null);
        } else if (StringUtils.isEmpty((String)busiCmprSKUPrcsPrcReqBO.getUpcCode())) {
            compSkuPriceByUpcAndMfgInfoMFG = this.search("mfgsku", mfgSku);
            bo.setBusiCmprSKUPrcsPrcRspInfos(compSkuPriceByUpcAndMfgInfoMFG);
        } else if (StringUtils.isEmpty((String)mfgSku)) {
            compSkuPriceByUpcAndMfgInfoUPC = this.search("upc", upCode);
            bo.setBusiCmprSKUPrcsPrcRspInfos(compSkuPriceByUpcAndMfgInfoUPC);
        } else {
            compSkuPriceByUpcAndMfgInfoMFG = this.search("mfgsku", mfgSku);
            compSkuPriceByUpcAndMfgInfoUPC = this.search("upc", upCode);
            if (compSkuPriceByUpcAndMfgInfoMFG == null && compSkuPriceByUpcAndMfgInfoUPC == null) {
                bo.setBusiCmprSKUPrcsPrcRspInfos(null);
            } else if (compSkuPriceByUpcAndMfgInfoMFG == null) {
                bo.setBusiCmprSKUPrcsPrcRspInfos(compSkuPriceByUpcAndMfgInfoUPC);
            } else if (compSkuPriceByUpcAndMfgInfoUPC == null) {
                bo.setBusiCmprSKUPrcsPrcRspInfos(compSkuPriceByUpcAndMfgInfoMFG);
            } else {
                HashMap<Long, BusiCmprSKUPrcsPrcRspInfo> cmprSKUPrcsPrcRspInfoMap = new HashMap<Long, BusiCmprSKUPrcsPrcRspInfo>();
                for (BusiCmprSKUPrcsPrcRspInfo busiCmprSKUPrcsPrcRspInfo : compSkuPriceByUpcAndMfgInfoUPC) {
                    cmprSKUPrcsPrcRspInfoMap.put(busiCmprSKUPrcsPrcRspInfo.getSupplierId(), busiCmprSKUPrcsPrcRspInfo);
                }
                for (BusiCmprSKUPrcsPrcRspInfo busiCmprSKUPrcsPrcRspInfo : compSkuPriceByUpcAndMfgInfoMFG) {
                    if (cmprSKUPrcsPrcRspInfoMap.keySet().contains(busiCmprSKUPrcsPrcRspInfo.getSupplierId())) {
                        BusiCmprSKUPrcsPrcRspInfo sKUPrcMapInfo = (BusiCmprSKUPrcsPrcRspInfo)cmprSKUPrcsPrcRspInfoMap.get(busiCmprSKUPrcsPrcRspInfo.getSupplierId());
                        if (busiCmprSKUPrcsPrcRspInfo.getMarketPrice().compareTo(sKUPrcMapInfo.getMarketPrice()) != -1) continue;
                        cmprSKUPrcsPrcRspInfoMap.put(busiCmprSKUPrcsPrcRspInfo.getSupplierId(), busiCmprSKUPrcsPrcRspInfo);
                        continue;
                    }
                    cmprSKUPrcsPrcRspInfoMap.put(busiCmprSKUPrcsPrcRspInfo.getSupplierId(), busiCmprSKUPrcsPrcRspInfo);
                }
                Collection skuCol = cmprSKUPrcsPrcRspInfoMap.values();
                Iterator iterator = skuCol.iterator();
                while (iterator.hasNext()) {
                    result.add(iterator.next());
                }
                bo.setBusiCmprSKUPrcsPrcRspInfos(result);
            }
        }
        return bo;
    }

    private List<BusiCmprSKUPrcsPrcRspInfo> search(String key, String value) {
        Result result;
        SearchBuilder searchBuilder = SearchBuilder.newBuilder((SearchRequestBuilder)this.searchRequestBuilderAdapter.requestBuilder());
        searchBuilder.setIndexName(String.valueOf(this.prop.getProperty("os.appName")));
        searchBuilder.fetchBuilder().addCol("sku_id").addCol("ext_sku_id").addCol("sku_name").addCol("supplier_id").addCol("supplier_name").addCol("market_price").addCol("agreement_price").addCol("member_price").addCol("sale_price").addCol("picture_url");
        BooleanQueryCondition booleanQueryCondition = new BooleanQueryCondition();
        MatchQueryCondition match_2 = new MatchQueryCondition();
        match_2.setColumnName(key);
        match_2.setValue("'" + value + "'");
        booleanQueryCondition.must().add(match_2);
        MatchQueryCondition match_3 = new MatchQueryCondition();
        match_3.setColumnName("sku_status");
        match_3.setValue("'" + Constant.SKU_STATUS_SHELVED + "'");
        booleanQueryCondition.must().add(match_3);
        searchBuilder.queryBuilder().setCondition((QueryCondition)booleanQueryCondition);
        searchBuilder.aggregateBuilder().setGroupId("supplier_id").count();
        searchBuilder.sortBuilder().addCol("sale_price", SearchSortMode.ASC);
        searchBuilder.sortBuilder().addCol("on_shelve_time", SearchSortMode.DESC);
        searchBuilder.sortBuilder().addCol("sold_number", SearchSortMode.DESC);
        try {
            result = searchBuilder.build();
            log.debug((Object)("\u641c\u7d22\u7ed3\u679c\u4e3a\uff1a" + result.toString()));
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug((Object)"\u8c03\u7528search\u4e2d\u5fc3\u51fa\u9519-\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            }
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u8c03\u7528search\u4e2d\u5fc3\u51fa\u9519-\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
        ArrayList<BusiCmprSKUPrcsPrcRspInfo> compSkuPriceByUpcAndMfgInfos = new ArrayList<BusiCmprSKUPrcsPrcRspInfo>();
        BusiCmprSKUPrcsPrcRspInfo busiCmprSKUPrcsPrcRspInfo = null;
        HashMap<String, BusiCmprSKUPrcsPrcRspInfo> map = new HashMap<String, BusiCmprSKUPrcsPrcRspInfo>();
        String supplierId = null;
        BusiCmprSKUPrcsPrcRspInfo tempObj = null;
        if (result.isStatus()) {
            JSONArray skuInfoResultJson = result.getItems();
            if (skuInfoResultJson.length() < 1) {
                return null;
            }
            JSONArray arr = result.getAggs();
            int aggCount = arr.getJSONObject(0).getJSONArray("items").length();
            for (int i = 0; i < skuInfoResultJson.length(); ++i) {
                JSONObject obj = skuInfoResultJson.getJSONObject(i);
                supplierId = obj.getString("supplier_id");
                long skuIdTemp = obj.getLong("sku_id");
                tempObj = (BusiCmprSKUPrcsPrcRspInfo)map.get(supplierId);
                if (tempObj != null) continue;
                busiCmprSKUPrcsPrcRspInfo = new BusiCmprSKUPrcsPrcRspInfo();
                busiCmprSKUPrcsPrcRspInfo.setSkuId(Long.valueOf(obj.getLong("sku_id")));
                busiCmprSKUPrcsPrcRspInfo.setExtSkuId(obj.getString("ext_sku_id"));
                busiCmprSKUPrcsPrcRspInfo.setSkuName(obj.getString("sku_name"));
                busiCmprSKUPrcsPrcRspInfo.setSupplierId(Long.valueOf(obj.getLong("supplier_id")));
                busiCmprSKUPrcsPrcRspInfo.setSupplierName(obj.getString("supplier_name"));
                try {
                    if (obj.get("market_price") != null) {
                        busiCmprSKUPrcsPrcRspInfo.setMarketPrice(MoneyUtil.Long2BigDecimal((Long)Long.parseLong(String.valueOf(obj.get("market_price")))));
                    }
                    if (obj.get("agreement_price") != null) {
                        busiCmprSKUPrcsPrcRspInfo.setAgreementPrice(MoneyUtil.Long2BigDecimal((Long)Long.parseLong(String.valueOf(obj.get("agreement_price")))));
                    }
                    if (obj.get("member_price") != null) {
                        busiCmprSKUPrcsPrcRspInfo.setMemberPrice(MoneyUtil.Long2BigDecimal((Long)Long.parseLong(String.valueOf(obj.get("member_price")))));
                    }
                    if (obj.get("sale_price") != null) {
                        busiCmprSKUPrcsPrcRspInfo.setSalePrice(MoneyUtil.Long2BigDecimal((Long)Long.parseLong(String.valueOf(obj.get("sale_price")))));
                    }
                }
                catch (NumberFormatException e) {
                    log.debug((Object)"\u4ef7\u683c\u88c5\u6362\u9519\u8bef", (Throwable)e);
                    e.printStackTrace();
                }
                catch (JSONException e) {
                    log.debug((Object)"JSONException\u9519\u8bef", (Throwable)e);
                    e.printStackTrace();
                }
                catch (Exception e) {
                    log.debug((Object)"\u9519\u8bef", (Throwable)e);
                    e.printStackTrace();
                }
                busiCmprSKUPrcsPrcRspInfo.setPriPicAddr(obj.getString("picture_url"));
                map.put(supplierId, busiCmprSKUPrcsPrcRspInfo);
                if (map.size() != aggCount) {
                    continue;
                }
                break;
            }
        } else {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u8c03\u7528search\u4e2d\u5fc3\u51fa\u9519-\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
        for (String s : map.keySet()) {
            compSkuPriceByUpcAndMfgInfos.add((BusiCmprSKUPrcsPrcRspInfo)map.get(s));
        }
        return compSkuPriceByUpcAndMfgInfos;
    }

    private String searchMfg(String key, String value) {
        JSONArray skuInfoResultJson;
        Result result;
        String mfgSku = null;
        SearchBuilder searchBuilder = SearchBuilder.newBuilder((SearchRequestBuilder)this.searchRequestBuilderAdapter.requestBuilder());
        searchBuilder.setIndexName(String.valueOf(this.prop.getProperty("os.appName")));
        searchBuilder.fetchBuilder().addCol("mfgsku");
        BooleanQueryCondition booleanQueryCondition = new BooleanQueryCondition();
        MatchQueryCondition match_2 = new MatchQueryCondition();
        match_2.setColumnName(key);
        match_2.setValue("'" + value + "'");
        booleanQueryCondition.must().add(match_2);
        MatchQueryCondition match_3 = new MatchQueryCondition();
        match_3.setColumnName("sku_status");
        match_3.setValue("'" + Constant.SKU_STATUS_SHELVED + "'");
        booleanQueryCondition.must().add(match_3);
        searchBuilder.queryBuilder().setCondition((QueryCondition)booleanQueryCondition);
        searchBuilder.aggregateBuilder().setGroupId("supplier_id").count();
        searchBuilder.sortBuilder().addCol("sale_price", SearchSortMode.ASC);
        searchBuilder.sortBuilder().addCol("on_shelve_time", SearchSortMode.DESC);
        searchBuilder.sortBuilder().addCol("sold_number", SearchSortMode.DESC);
        try {
            result = searchBuilder.build();
            log.debug((Object)("\u641c\u7d22\u7ed3\u679c\u4e3a\uff1a" + result.toString()));
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug((Object)"\u8c03\u7528search\u4e2d\u5fc3\u51fa\u9519-\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            }
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u8c03\u7528search\u4e2d\u5fc3\u51fa\u9519-\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
        HashMap map = new HashMap();
        if (result.isStatus()) {
            skuInfoResultJson = result.getItems();
            if (skuInfoResultJson.length() < 1) {
                return null;
            }
        } else {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u8c03\u7528search\u4e2d\u5fc3\u51fa\u9519-\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
        JSONObject obj = skuInfoResultJson.getJSONObject(0);
        mfgSku = obj.getString("mfgsku");
        return mfgSku;
    }
}

