/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.MdmQryCatalogNameService;
import com.cgd.commodity.busi.bo.MdmQryCatalogNameReqBO;
import com.cgd.commodity.busi.bo.MdmQryCatalogNameRspBO;
import com.cgd.commodity.busi.vo.MdmQryCatalogNameRspVO;
import com.cgd.commodity.dao.MdmCatalogMapper;
import com.cgd.commodity.po.MdmCatalogPO;
import com.cgd.common.exception.BusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class MdmQryCatalogNameServiceImpl
implements MdmQryCatalogNameService {
    private static final Logger logger = LoggerFactory.getLogger(MdmQryCatalogNameServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    MdmCatalogMapper mdmCatalogMapper;

    public MdmQryCatalogNameRspBO qryCatalogName(MdmQryCatalogNameReqBO mdmQryCatalogNameReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u4e3b\u6570\u636e\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + mdmQryCatalogNameReqBO.toString());
        }
        MdmQryCatalogNameRspBO rspBO = new MdmQryCatalogNameRspBO();
        MdmQryCatalogNameRspVO rspVO = new MdmQryCatalogNameRspVO();
        try {
            int catalogLevel = MdmQryCatalogNameServiceImpl.initCataLevel(mdmQryCatalogNameReqBO.getCatalogId());
            if (catalogLevel > 0) {
                MdmCatalogPO mdmCatalogPO = this.mdmCatalogMapper.selectByCatalogIdAndLevel(Long.valueOf(mdmQryCatalogNameReqBO.getCatalogId()), catalogLevel);
                if (null != mdmCatalogPO) {
                    BeanUtils.copyProperties((Object)mdmCatalogPO, (Object)rspVO);
                    rspVO.setCatalogLevel(mdmCatalogPO.getCataloglevel());
                    List<MdmCatalogPO> catalogIds = this.mdmCatalogMapper.getCheckByParentCatalogId(mdmCatalogPO.getCatalogId());
                    if (catalogIds.isEmpty()) {
                        rspVO.setLastLevel(true);
                    } else {
                        rspVO.setLastLevel(false);
                    }
                    rspVO.setCatalogId(this.cataLogToString(mdmCatalogPO));
                    rspBO.setMdmQryCatalogNameRspVO(rspVO);
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                } else {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                }
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5206\u7c7b\u7f16\u7801\u4e0d\u5408\u6cd5");
            }
            return rspBO;
        }
        catch (Exception e) {
            rspBO.setRespDesc("\u4e3b\u6570\u636e\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u51fa\u9519");
            rspBO.setRespCode("8888");
            logger.error("\u4e3b\u6570\u636e\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u51fa\u9519", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e3b\u6570\u636e\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u51fa\u9519");
        }
    }

    private String cataLogToString(MdmCatalogPO mdmCatalogPO) {
        String result = String.valueOf(mdmCatalogPO.getCatalogId());
        int catalogIdLength = String.valueOf(mdmCatalogPO.getCatalogId()).length();
        if (catalogIdLength == 1 || catalogIdLength == 3 || catalogIdLength == 5 || catalogIdLength == 8) {
            result = "0" + result;
        }
        return result;
    }

    private static int initCataLevel(String catalogId) {
        int catalogIdLength = catalogId.length();
        switch (catalogIdLength) {
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 9: {
                return 4;
            }
        }
        return -1;
    }

    public void setMdmCatalogMapper(MdmCatalogMapper mdmCatalogMapper) {
        this.mdmCatalogMapper = mdmCatalogMapper;
    }
}

