/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryCatalogService;
import com.cgd.commodity.busi.bo.BusiQryCatalogReqBO;
import com.cgd.commodity.busi.bo.BusiQryCatalogRspBO;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.common.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryCatalogServiceImpl
implements QryCatalogService {
    private static final Logger logger = LoggerFactory.getLogger(QryCatalogServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public BusiQryCatalogRspBO qryCatalog(BusiQryCatalogReqBO busiQryCatalogReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u7c7b\u76ee\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + busiQryCatalogReqBO.toString());
        }
        if (null == busiQryCatalogReqBO.getChannelId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u7c7b\u76ee\u4e1a\u52a1\u670d\u52a1\u9891\u9053ID[channelId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiQryCatalogReqBO.getCatalogLevel()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u7c7b\u76ee\u4e1a\u52a1\u670d\u52a1\u7c7b\u76ee\u7b49\u7ea7[catalogLevel]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            BusiQryCatalogRspBO busiQryCatalogRspBO = new BusiQryCatalogRspBO();
            List<Object> catalogInfos = new ArrayList();
            catalogInfos = busiQryCatalogReqBO.getUpperCatalogId() != null && busiQryCatalogReqBO.getUpperCatalogId() != 0L ? this.commodityGuideCatalogMapper.selectByUpperCatalogIdAndChannelId(busiQryCatalogReqBO.getUpperCatalogId(), busiQryCatalogReqBO.getChannelId()) : this.commodityGuideCatalogMapper.selectByCatalogLevelAndChannelId(busiQryCatalogReqBO.getCatalogLevel(), busiQryCatalogReqBO.getChannelId());
            busiQryCatalogRspBO.setCatalogInfos(catalogInfos);
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2\u7c7b\u76ee\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u51fa\u53c2\uff1a" + busiQryCatalogRspBO.toString());
            }
            return busiQryCatalogRspBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7c7b\u76ee\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u7c7b\u76ee\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
    }
}

