/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.busi.QryRegainOnShelvesSkuService;
import com.cgd.commodity.busi.bo.QryRegainOnShelvesSkuReqBO;
import com.cgd.commodity.busi.bo.QryRegainOnShelvesSkuRspBO;
import com.cgd.commodity.busi.vo.QryRegainOnShelvesSkuRspVO;
import com.cgd.commodity.dao.CatalogCommodityTypeMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuRecoveOnShelveLogMapper;
import com.cgd.commodity.po.CatalogCommodityType;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuRecoveOnShelveLog;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.workflow.task.busin.service.QryTodoTaskProcInstMapBusiService;
import com.cgd.workflow.task.busin.service.bo.QueryTodoTaskProcInstMapReqBO;
import com.cgd.workflow.task.busin.service.bo.QueryTodoTaskProcInstMapRspBO;
import com.cgd.workflow.task.busin.service.bo.TaskRspBO;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QryRegainOnShelvesSkuServiceImpl
implements QryRegainOnShelvesSkuService {
    private static final Logger logger = LoggerFactory.getLogger(QryRegainOnShelvesSkuServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private QryTodoTaskProcInstMapBusiService qryTodoTaskProcInstMapBusiService;
    private SkuRecoveOnShelveLogMapper skuRecoveOnShelveLogMapper;
    private SkuMapper skuMapper;
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;

    public void setCatalogCommodityTypeMapper(CatalogCommodityTypeMapper catalogCommodityTypeMapper) {
        this.catalogCommodityTypeMapper = catalogCommodityTypeMapper;
    }

    public void setQryTodoTaskProcInstMapBusiService(QryTodoTaskProcInstMapBusiService qryTodoTaskProcInstMapBusiService) {
        this.qryTodoTaskProcInstMapBusiService = qryTodoTaskProcInstMapBusiService;
    }

    public void setSkuRecoveOnShelveLogMapper(SkuRecoveOnShelveLogMapper skuRecoveOnShelveLogMapper) {
        this.skuRecoveOnShelveLogMapper = skuRecoveOnShelveLogMapper;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public void setSelectUserInfoByUserIdBusiService(SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService) {
        this.selectUserInfoByUserIdBusiService = selectUserInfoByUserIdBusiService;
    }

    public RspPageBO<QryRegainOnShelvesSkuRspBO> qryRegainOnShelvesSku(QryRegainOnShelvesSkuReqBO qryRegainOnShelvesSkuReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u53d1\u5e03\u6062\u590d\u4e0a\u67b6\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryRegainOnShelvesSkuReqBO.toString());
        }
        if (null == qryRegainOnShelvesSkuReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237Id[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (qryRegainOnShelvesSkuReqBO.getFlag() == 0 && qryRegainOnShelvesSkuReqBO.getAgreementId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8baeId[agreementId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.isEmpty((Object)qryRegainOnShelvesSkuReqBO.getBrandName())) {
            qryRegainOnShelvesSkuReqBO.setBrandName(qryRegainOnShelvesSkuReqBO.getBrandName().replaceAll(" ", ""));
        }
        if (!StringUtils.isEmpty((Object)qryRegainOnShelvesSkuReqBO.getSkuName())) {
            qryRegainOnShelvesSkuReqBO.setSkuName(qryRegainOnShelvesSkuReqBO.getSkuName().replaceAll(" ", ""));
        }
        RspPageBO rspPageBO = new RspPageBO();
        Page page = new Page(qryRegainOnShelvesSkuReqBO.getPageNo(), qryRegainOnShelvesSkuReqBO.getPageSize());
        try {
            SelectUserInfoByUserIdReqBO selectUserInfoByUserIdReqBO = new SelectUserInfoByUserIdReqBO();
            selectUserInfoByUserIdReqBO.setUserId(qryRegainOnShelvesSkuReqBO.getUserId());
            Long supplierId = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoByUserIdReqBO).getCompId();
            QueryTodoTaskProcInstMapReqBO queryTodoTaskProcInstMapReqBO = new QueryTodoTaskProcInstMapReqBO();
            queryTodoTaskProcInstMapReqBO.setUserId(qryRegainOnShelvesSkuReqBO.getUserId());
            queryTodoTaskProcInstMapReqBO.setBusinessType("12");
            QueryTodoTaskProcInstMapRspBO queryTodoTaskProcInst = this.queryTodoTaskProcInst(queryTodoTaskProcInstMapReqBO);
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            if (null != qryRegainOnShelvesSkuReqBO.getCatalogId()) {
                List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(qryRegainOnShelvesSkuReqBO.getCatalogId());
                for (CatalogCommodityType catalogCommodityType : catalogs) {
                    commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                }
            }
            if (queryTodoTaskProcInst != null && queryTodoTaskProcInst.getProcinstTaskMap() != null && queryTodoTaskProcInst.getProcinstTaskMap().size() > 0) {
                ArrayList<Sku> skuList = new ArrayList<Sku>();
                for (String key : queryTodoTaskProcInst.getProcinstTaskMap().keySet()) {
                    Sku sku;
                    SkuRecoveOnShelveLog skuRecoveOnShelveLog;
                    TaskRspBO taskRspBO = (TaskRspBO)queryTodoTaskProcInst.getProcinstTaskMap().get(key);
                    String procInstId = taskRspBO.getProcInstId();
                    if (procInstId == null || "".equals(procInstId) || (skuRecoveOnShelveLog = this.skuRecoveOnShelveLogMapper.queryByProcInstId(procInstId, supplierId, qryRegainOnShelvesSkuReqBO.getAgreementId())) == null || (sku = this.skuMapper.selectBySkuIdAndSupplier(skuRecoveOnShelveLog.getSkuId(), skuRecoveOnShelveLog.getSupplierId())) == null) continue;
                    sku.setTaskId(taskRspBO.getTaskId());
                    skuList.add(sku);
                }
                List<Object> qryRegainOnShelvesSkuRspBOs = new ArrayList();
                if (skuList != null && skuList.size() > 0) {
                    List<QryRegainOnShelvesSkuRspVO> qryRegainOnShelvesSkuRspVOs;
                    int indexOf;
                    String skuName = qryRegainOnShelvesSkuReqBO.getSkuName();
                    if (skuName != null && !"".equals(skuName) && (indexOf = skuName.indexOf(92)) != -1) {
                        String name = skuName.replaceAll("\\\\", "\\\\\\\\");
                        qryRegainOnShelvesSkuReqBO.setSkuName(name);
                    }
                    if ((qryRegainOnShelvesSkuRspVOs = this.skuMapper.qryRegainOnShelvesSku((Page<QryRegainOnShelvesSkuRspVO>)page, qryRegainOnShelvesSkuReqBO, commodityTypeIds, skuList)) != null && qryRegainOnShelvesSkuRspVOs.size() > 0 && skuList != null && skuList.size() > 0) {
                        for (QryRegainOnShelvesSkuRspVO qryRegainOnShelvesSkuRspVO : qryRegainOnShelvesSkuRspVOs) {
                            for (Sku sku : skuList) {
                                if (!qryRegainOnShelvesSkuRspVO.getSkuId().equals(sku.getSkuId()) || !qryRegainOnShelvesSkuRspVO.getSupplierId().equals(sku.getSupplierId())) continue;
                                qryRegainOnShelvesSkuRspVO.setTaskId(sku.getTaskId());
                            }
                        }
                    }
                    qryRegainOnShelvesSkuRspBOs = this.resolveRsp(qryRegainOnShelvesSkuRspVOs);
                }
                rspPageBO.setRecordsTotal(page.getTotalCount());
                rspPageBO.setTotal(page.getTotalPages());
                rspPageBO.setPageNo(qryRegainOnShelvesSkuReqBO.getPageNo());
                rspPageBO.setRows(qryRegainOnShelvesSkuRspBOs);
                if (this.isDebugEnabled) {
                    logger.debug("\u67e5\u8be2\u5546\u54c1\u53d1\u5e03\u6062\u590d\u4e0a\u67b6\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + qryRegainOnShelvesSkuReqBO.toString());
                }
                return rspPageBO;
            }
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qryRegainOnShelvesSkuReqBO.getPageNo());
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u53d1\u5e03\u6062\u590d\u4e0a\u67b6\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5546\u54c1\u53d1\u5e03\u6062\u590d\u4e0a\u67b6\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private QueryTodoTaskProcInstMapRspBO queryTodoTaskProcInst(QueryTodoTaskProcInstMapReqBO queryTodoTaskProcInstMapReqBO) {
        try {
            QueryTodoTaskProcInstMapRspBO queryTodoTaskProcInstMap = this.qryTodoTaskProcInstMapBusiService.queryTodoTaskProcInstMap(queryTodoTaskProcInstMapReqBO);
            return queryTodoTaskProcInstMap;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5de5\u4f5c\u6d41\u67e5\u8be2\u5f85\u529e\u4efb\u52a1\u4e0e\u6d41\u7a0b\u5b9e\u4f8bid\u5173\u8054\u7684map\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u5de5\u4f5c\u6d41\u67e5\u8be2\u5f85\u529e\u4efb\u52a1\u4e0e\u6d41\u7a0b\u5b9e\u4f8bid\u5173\u8054\u7684map\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QryRegainOnShelvesSkuRspBO> resolveRsp(List<QryRegainOnShelvesSkuRspVO> qryRegainOnShelvesSkuRspVOs) throws Exception {
        ArrayList<QryRegainOnShelvesSkuRspBO> qryRegainOnShelvesSkuRspBOs = new ArrayList<QryRegainOnShelvesSkuRspBO>();
        if (!qryRegainOnShelvesSkuRspVOs.isEmpty()) {
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            for (QryRegainOnShelvesSkuRspVO qryRegainOnShelvesSkuRspVO : qryRegainOnShelvesSkuRspVOs) {
                commodityTypeIds.add(qryRegainOnShelvesSkuRspVO.getCommodityTypeId());
            }
            List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeIdAndLocation(commodityTypeIds);
            for (QryRegainOnShelvesSkuRspVO qryRegainOnShelvesSkuRspVO : qryRegainOnShelvesSkuRspVOs) {
                QryRegainOnShelvesSkuRspBO qryRegainOnShelvesSkuRspBO = new QryRegainOnShelvesSkuRspBO();
                qryRegainOnShelvesSkuRspBO = this.getQryRegainOnShelvesSkuRspBO(qryRegainOnShelvesSkuRspBO, qryRegainOnShelvesSkuRspVO);
                if (!catalogMaps.isEmpty()) {
                    for (Map<String, Object> map : catalogMaps) {
                        if (!map.get("commodityTypeId").equals(qryRegainOnShelvesSkuRspVO.getCommodityTypeId())) continue;
                        qryRegainOnShelvesSkuRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                        qryRegainOnShelvesSkuRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                        qryRegainOnShelvesSkuRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                    }
                }
                qryRegainOnShelvesSkuRspBOs.add(qryRegainOnShelvesSkuRspBO);
            }
        }
        return qryRegainOnShelvesSkuRspBOs;
    }

    private QryRegainOnShelvesSkuRspBO getQryRegainOnShelvesSkuRspBO(QryRegainOnShelvesSkuRspBO qryRegainOnShelvesSkuRspBO, QryRegainOnShelvesSkuRspVO qryRegainOnShelvesSkuRspVO) throws Exception {
        qryRegainOnShelvesSkuRspBO.setBrandName(qryRegainOnShelvesSkuRspVO.getBrandName());
        qryRegainOnShelvesSkuRspBO.setCreateTime(qryRegainOnShelvesSkuRspVO.getCreateTime());
        qryRegainOnShelvesSkuRspBO.setFigure(qryRegainOnShelvesSkuRspVO.getFigure());
        qryRegainOnShelvesSkuRspBO.setMarketPrice(MoneyUtil.Long2BigDecimal((Long)qryRegainOnShelvesSkuRspVO.getMarketPrice()));
        qryRegainOnShelvesSkuRspBO.setModel(qryRegainOnShelvesSkuRspVO.getModel());
        qryRegainOnShelvesSkuRspBO.setSkuDetail(qryRegainOnShelvesSkuRspVO.getSkuDetail());
        qryRegainOnShelvesSkuRspBO.setSkuId(qryRegainOnShelvesSkuRspVO.getSkuId());
        qryRegainOnShelvesSkuRspBO.setSkuMainPicUrl(qryRegainOnShelvesSkuRspVO.getSkuMainPicUrl());
        qryRegainOnShelvesSkuRspBO.setSkuName(qryRegainOnShelvesSkuRspVO.getSkuName());
        qryRegainOnShelvesSkuRspBO.setSpec(qryRegainOnShelvesSkuRspVO.getSpec());
        qryRegainOnShelvesSkuRspBO.setTexture(qryRegainOnShelvesSkuRspVO.getTexture());
        qryRegainOnShelvesSkuRspBO.setTaskId(qryRegainOnShelvesSkuRspVO.getTaskId());
        qryRegainOnShelvesSkuRspBO.setAgreementId(qryRegainOnShelvesSkuRspVO.getAgreementId());
        qryRegainOnShelvesSkuRspBO.setAgreementSkuId(qryRegainOnShelvesSkuRspVO.getAgreementSkuId());
        qryRegainOnShelvesSkuRspBO.setSupplierId(qryRegainOnShelvesSkuRspVO.getSupplierId());
        String packParam = qryRegainOnShelvesSkuRspVO.getPackParam();
        if (packParam != null && !"".equals(packParam)) {
            JSONObject parseObject = JSON.parseObject((String)packParam);
            qryRegainOnShelvesSkuRspBO.setPackParamLong((String)parseObject.get((Object)"packParamLong"));
            qryRegainOnShelvesSkuRspBO.setPackParamWide((String)parseObject.get((Object)"packParamWide"));
            qryRegainOnShelvesSkuRspBO.setPackParamHigh((String)parseObject.get((Object)"packParamHigh"));
            qryRegainOnShelvesSkuRspBO.setPackParamWeight((String)parseObject.get((Object)"packParamWeight"));
            qryRegainOnShelvesSkuRspBO.setPackParamList((String)parseObject.get((Object)"packParamList"));
        }
        return qryRegainOnShelvesSkuRspBO;
    }
}

