/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySkuOffShelfDetailService;
import com.cgd.commodity.busi.bo.QrySkuOffShelfDetailReqBO;
import com.cgd.commodity.busi.bo.QrySkuOffShelfDetailRspBO;
import com.cgd.commodity.busi.vo.QrySkuOffShelfApproveDetailVO;
import com.cgd.commodity.dao.SkuApproveDetailLogMapper;
import com.cgd.commodity.dao.SkuApproveLogMapper;
import com.cgd.commodity.po.SkuApproveDetailLog;
import com.cgd.commodity.po.SkuApproveLog;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrySkuOffShelfDetailServiceImpl
implements QrySkuOffShelfDetailService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuOffShelfDetailServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuApproveLogMapper skuApproveLogMapper;
    private SkuApproveDetailLogMapper skuApproveDetailLogMapper;

    public void setSkuApproveLogMapper(SkuApproveLogMapper skuApproveLogMapper) {
        this.skuApproveLogMapper = skuApproveLogMapper;
    }

    public void setSkuApproveDetailLogMapper(SkuApproveDetailLogMapper skuApproveDetailLogMapper) {
        this.skuApproveDetailLogMapper = skuApproveDetailLogMapper;
    }

    public QrySkuOffShelfDetailRspBO qrySkuOffShelfDetail(QrySkuOffShelfDetailReqBO qrySkuOffShelfDetailReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySkuOffShelfDetailReqBO.toString());
        }
        if (null == qrySkuOffShelfDetailReqBO.getApproveId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5ba1\u6279Id[approveId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SkuApproveLog skuApproveLog = this.skuApproveLogMapper.selectByPrimaryKey(qrySkuOffShelfDetailReqBO.getApproveId());
            Page page = new Page(qrySkuOffShelfDetailReqBO.getPageNo(), qrySkuOffShelfDetailReqBO.getPageSize());
            QrySkuOffShelfDetailRspBO qrySkuOffShelfDetailRspBO = new QrySkuOffShelfDetailRspBO();
            RspPageBO rspPageBO = new RspPageBO();
            if (null != skuApproveLog) {
                List<SkuApproveDetailLog> approveLogs = this.skuApproveDetailLogMapper.selectByApproveId((Page<SkuApproveDetailLog>)page, qrySkuOffShelfDetailReqBO.getApproveId(), skuApproveLog.getApproveType());
                List<QrySkuOffShelfApproveDetailVO> qrySkuOffShelfApproveDetailVOs = this.resolveRsp(approveLogs);
                rspPageBO.setRecordsTotal(page.getTotalCount());
                rspPageBO.setTotal(page.getTotalPages());
                rspPageBO.setPageNo(qrySkuOffShelfDetailReqBO.getPageNo());
                rspPageBO.setRows(qrySkuOffShelfApproveDetailVOs);
                qrySkuOffShelfDetailRspBO.setOperatorId(skuApproveLog.getCreateLoginId());
                qrySkuOffShelfDetailRspBO.setOperatorName(skuApproveLog.getApprover());
                qrySkuOffShelfDetailRspBO.setOperatorSkuNum(skuApproveLog.getSkuNumber());
                qrySkuOffShelfDetailRspBO.setOperatorTime(skuApproveLog.getApproveTime());
                qrySkuOffShelfDetailRspBO.setOperatorType(Integer.valueOf(skuApproveLog.getApproveType()));
                qrySkuOffShelfDetailRspBO.setSkuOffShelfApproveDetails(rspPageBO);
            }
            return qrySkuOffShelfDetailRspBO;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QrySkuOffShelfApproveDetailVO> resolveRsp(List<SkuApproveDetailLog> approveLogs) {
        try {
            if (!approveLogs.isEmpty()) {
                ArrayList<QrySkuOffShelfApproveDetailVO> qrySkuOffShelfApproveDetailVOs = new ArrayList<QrySkuOffShelfApproveDetailVO>();
                for (SkuApproveDetailLog skuApproveDetailLog : approveLogs) {
                    QrySkuOffShelfApproveDetailVO qrySkuOffShelfApproveDetailVO = new QrySkuOffShelfApproveDetailVO();
                    qrySkuOffShelfApproveDetailVO.setBrandName(skuApproveDetailLog.getBrandName());
                    NumberFormat nFromat = NumberFormat.getPercentInstance();
                    String rates = nFromat.format(skuApproveDetailLog.getDiscountRate());
                    qrySkuOffShelfApproveDetailVO.setDiscountRate(rates);
                    if (0 == skuApproveDetailLog.getSuccess()) {
                        qrySkuOffShelfApproveDetailVO.setIsSuccess(Boolean.valueOf(false));
                    } else {
                        qrySkuOffShelfApproveDetailVO.setIsSuccess(Boolean.valueOf(true));
                    }
                    qrySkuOffShelfApproveDetailVO.setAgreementPrice(MoneyUtil.Long2BigDecimal((Long)skuApproveDetailLog.getAgreementPrice()));
                    qrySkuOffShelfApproveDetailVO.setMarketPrice(MoneyUtil.Long2BigDecimal((Long)skuApproveDetailLog.getMarketPrice()));
                    qrySkuOffShelfApproveDetailVO.setResultMsg(skuApproveDetailLog.getResultMsg());
                    qrySkuOffShelfApproveDetailVO.setSkuCatalog(skuApproveDetailLog.getSkuCatalog());
                    qrySkuOffShelfApproveDetailVO.setSkuId(skuApproveDetailLog.getSkuId());
                    qrySkuOffShelfApproveDetailVO.setSkuName(skuApproveDetailLog.getSkuName());
                    qrySkuOffShelfApproveDetailVO.setSupplierId(skuApproveDetailLog.getSupplierId());
                    qrySkuOffShelfApproveDetailVO.setSupplierName(skuApproveDetailLog.getSupplierName());
                    qrySkuOffShelfApproveDetailVO.setApproveSkuState(skuApproveDetailLog.getApproveSkuState());
                    qrySkuOffShelfApproveDetailVO.setApproveId(skuApproveDetailLog.getApproveId());
                    qrySkuOffShelfApproveDetailVOs.add(qrySkuOffShelfApproveDetailVO);
                }
                return qrySkuOffShelfApproveDetailVOs;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25\uff1a" + e);
            return null;
        }
    }
}

