/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.atom.GenerateSkuInfoChangeSeqService;
import com.cgd.commodity.atom.bo.GenerateSkuInfoChangeSeqRspBO;
import com.cgd.commodity.busi.SkuInfoChangeService;
import com.cgd.commodity.busi.bo.supply.SkuInfoChangeReqBO;
import com.cgd.commodity.busi.bo.supply.SkuInfoChangeRspBO;
import com.cgd.commodity.busi.vo.supply.SkuInfoChangeVO;
import com.cgd.commodity.busi.vo.supply.SkuPicChangeVO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.constant.SupplyConstant;
import com.cgd.commodity.dao.SkuInfoChangeLogMapper;
import com.cgd.commodity.dao.SkuInfoChangeMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPicChangeMapper;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuInfoChange;
import com.cgd.commodity.po.SkuInfoChangeLog;
import com.cgd.commodity.po.SkuPicChange;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.workflow.bo.BpmStartReqBO;
import com.cgd.workflow.bo.BpmStartRspBO;
import com.cgd.workflow.busin.service.BpmStartBusinService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SkuInfoChangeServiceImpl
implements SkuInfoChangeService {
    private static final Logger logger = LoggerFactory.getLogger(SkuInfoChangeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private SkuInfoChangeMapper skuInfoChangeMapper;
    private GenerateSkuInfoChangeSeqService generateSkuInfoChangeSeqService;
    private SkuPicChangeMapper skuPicChangeMapper;
    private SkuInfoChangeLogMapper skuInfoChangeLogMapper;
    private BpmStartBusinService bpmStartBusinService;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSkuInfoChangeMapper(SkuInfoChangeMapper skuInfoChangeMapper) {
        this.skuInfoChangeMapper = skuInfoChangeMapper;
    }

    public void setGenerateSkuInfoChangeSeqService(GenerateSkuInfoChangeSeqService generateSkuInfoChangeSeqService) {
        this.generateSkuInfoChangeSeqService = generateSkuInfoChangeSeqService;
    }

    public void setSkuPicChangeMapper(SkuPicChangeMapper skuPicChangeMapper) {
        this.skuPicChangeMapper = skuPicChangeMapper;
    }

    public void setSkuInfoChangeLogMapper(SkuInfoChangeLogMapper skuInfoChangeLogMapper) {
        this.skuInfoChangeLogMapper = skuInfoChangeLogMapper;
    }

    public void setBpmStartBusinService(BpmStartBusinService bpmStartBusinService) {
        this.bpmStartBusinService = bpmStartBusinService;
    }

    public SkuInfoChangeRspBO updateSkuInfoChange(SkuInfoChangeReqBO skuInfoChangeReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7f16\u8f91\u4e0a\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + skuInfoChangeReqBO.toString());
        }
        SkuInfoChangeRspBO skuInfoChangeRspBO = new SkuInfoChangeRspBO();
        Boolean checkStatus = this.checkSkuStatus(skuInfoChangeReqBO);
        if (!checkStatus.booleanValue()) {
            skuInfoChangeRspBO.setSuccess(false);
            skuInfoChangeRspBO.setResultMsg("\u5546\u54c1\u72b6\u6001\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u7a0d\u540e\u5904\u7406");
            return skuInfoChangeRspBO;
        }
        Boolean checkResult = this.checkSkuIsHasApproveLog(skuInfoChangeReqBO);
        if (!checkResult.booleanValue()) {
            skuInfoChangeRspBO.setSuccess(false);
            skuInfoChangeRspBO.setResultMsg("\u5546\u54c1\u6b63\u5904\u4e8e\u5ba1\u6838\u4e2d\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838\u7ed3\u679c");
            return skuInfoChangeRspBO;
        }
        try {
            SkuInfoChangeVO skuInfoChangeVO = this.skuMapper.qrySkuById(skuInfoChangeReqBO.getSkuId(), skuInfoChangeReqBO.getSupplierId());
            GenerateSkuInfoChangeSeqRspBO generateSkuInfoChangeSeqRspBO = this.generateSkuInfoChangeSeqService.generateSkuInfoChange();
            this.initSkuInfoChange(skuInfoChangeReqBO, skuInfoChangeVO, generateSkuInfoChangeSeqRspBO);
            this.initSkuPicChange(skuInfoChangeReqBO, generateSkuInfoChangeSeqRspBO);
            this.skuInfoChangeApprove(skuInfoChangeReqBO, skuInfoChangeVO, generateSkuInfoChangeSeqRspBO);
            skuInfoChangeRspBO.setSuccess(true);
            skuInfoChangeRspBO.setResultMsg("\u63d0\u4ea4\u6210\u529f");
            return skuInfoChangeRspBO;
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u4e0a\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "CREATE_SKU_SERVICE_RSP_FAIL" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, "\u7f16\u8f91\u4e0a\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7f16\u8f91\u4e0a\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private Boolean checkSkuIsHasApproveLog(SkuInfoChangeReqBO skuInfoChangeReqBO) {
        try {
            List<Long> skuIds = this.skuInfoChangeLogMapper.checkSkuIsHasApproveLog(skuInfoChangeReqBO.getSkuId(), skuInfoChangeReqBO.getSupplierId());
            if (!skuIds.isEmpty()) {
                if (skuIds.size() > 0) {
                    return false;
                }
                return true;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u4e0a\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u68c0\u67e5\u8bb0\u5f55\u8868\u4e2d\u662f\u5426\u6709\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25:" + e);
            throw new BusinessException(null, "\u68c0\u67e5\u8bb0\u5f55\u8868\u4e2d\u662f\u5426\u6709\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25");
        }
    }

    private Boolean checkSkuStatus(SkuInfoChangeReqBO skuInfoChangeReqBO) {
        try {
            Sku sku = this.skuMapper.selectBySkuIdAndSupplierId(skuInfoChangeReqBO.getSkuId(), skuInfoChangeReqBO.getSupplierId());
            if (2 == sku.getSkuStatus() || 5 == sku.getSkuStatus()) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u4e0a\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u68c0\u67e5\u5546\u54c1\u72b6\u6001\u5931\u8d25:" + e);
            throw new BusinessException(null, "\u68c0\u67e5\u5546\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    private void initSkuInfoChange(SkuInfoChangeReqBO skuInfoChangeReqBO, SkuInfoChangeVO skuInfoChangeVO, GenerateSkuInfoChangeSeqRspBO generateSkuInfoChangeSeqRspBO) {
        try {
            SkuInfoChange skuInfoChange = new SkuInfoChange();
            skuInfoChange.setAgreementId(skuInfoChangeVO.getAgreementId());
            skuInfoChange.setAgreementSkuId(skuInfoChangeVO.getAgreementSkuId());
            skuInfoChange.setChangeId(generateSkuInfoChangeSeqRspBO.getChangeId());
            skuInfoChange.setCreateLoginId(skuInfoChangeReqBO.getUserId());
            skuInfoChange.setCreateTime(new Date());
            skuInfoChange.setIsDelete(Constant.IS_DELETE.byteValue());
            skuInfoChange.setSkuId(skuInfoChangeVO.getSkuId());
            skuInfoChange.setSupplierId(skuInfoChangeVO.getSupplierId());
            skuInfoChange.setCommodityTypeId(skuInfoChangeVO.getCommodityTypeId());
            if (null != skuInfoChangeReqBO.getMarketPrice()) {
                skuInfoChange.setMarketPrice(MoneyUtil.BigDecimal2Long((BigDecimal)skuInfoChangeReqBO.getMarketPrice()));
            }
            String packageParam = this.initPackageParam(skuInfoChangeReqBO);
            skuInfoChange.setPackParam(packageParam);
            skuInfoChange.setSkuDetail(skuInfoChangeReqBO.getSkuDetail());
            skuInfoChange.setSkuName(skuInfoChangeReqBO.getSkuName());
            skuInfoChange.setSkuStatus(skuInfoChangeVO.getSkuStatus().byteValue());
            skuInfoChange.setSupplierId(skuInfoChangeReqBO.getSupplierId());
            skuInfoChange.setSupplierName(skuInfoChangeVO.getSupplierName());
            this.skuInfoChangeMapper.insertSelective(skuInfoChange);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u4e0a\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5546\u54c1\u4fe1\u606f\u53d8\u66f4\u5931\u8d25:" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1\u4fe1\u606f\u53d8\u66f4\u5931\u8d25");
        }
    }

    private String initPackageParam(SkuInfoChangeReqBO skuInfoChangeReqBO) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("{");
        sb.append("\"packParamLong\":");
        if (!StringUtils.isEmpty((Object)skuInfoChangeReqBO.getPackParamLong())) {
            sb.append("\"" + skuInfoChangeReqBO.getPackParamLong() + "\",");
        } else {
            sb.append("null,");
        }
        sb.append("\"packParamWide\":");
        if (!StringUtils.isEmpty((Object)skuInfoChangeReqBO.getPackParamWide())) {
            sb.append("\"" + skuInfoChangeReqBO.getPackParamWide() + "\",");
        } else {
            sb.append("null,");
        }
        sb.append("\"packParamHigh\":");
        if (!StringUtils.isEmpty((Object)skuInfoChangeReqBO.getPackParamHigh())) {
            sb.append("\"" + skuInfoChangeReqBO.getPackParamHigh() + "\",");
        } else {
            sb.append("null,");
        }
        sb.append("\"packParamWeight\":");
        if (!StringUtils.isEmpty((Object)skuInfoChangeReqBO.getPackParamWeight())) {
            sb.append("\"" + skuInfoChangeReqBO.getPackParamWeight() + "\",");
        } else {
            sb.append("null,");
        }
        sb.append("\"packParamList\":");
        if (!StringUtils.isEmpty((Object)skuInfoChangeReqBO.getPackParamList())) {
            sb.append("\"" + skuInfoChangeReqBO.getPackParamList() + "\",");
        } else {
            sb.append("null,");
        }
        sb.append("}");
        return sb.toString().replace(",}", "}");
    }

    private void initSkuPicChange(SkuInfoChangeReqBO skuInfoChangeReqBO, GenerateSkuInfoChangeSeqRspBO generateSkuInfoChangeSeqRspBO) {
        try {
            ArrayList<SkuPicChange> skuPicChanges = new ArrayList<SkuPicChange>();
            if (!skuInfoChangeReqBO.getSkuPics().isEmpty()) {
                for (SkuPicChangeVO skuPicChangeVO : skuInfoChangeReqBO.getSkuPics()) {
                    SkuPicChange skuPicChange = new SkuPicChange();
                    skuPicChange.setChangeId(generateSkuInfoChangeSeqRspBO.getChangeId());
                    skuPicChange.setCreateLoginId(skuInfoChangeReqBO.getUserId());
                    skuPicChange.setCreateTime(new Date());
                    skuPicChange.setIsDelete(Constant.IS_DELETE.byteValue());
                    skuPicChange.setIsPrimary(skuPicChangeVO.getIsPrimary());
                    skuPicChange.setPicOrder(skuPicChangeVO.getPicOrder());
                    skuPicChange.setSkuId(skuInfoChangeReqBO.getSkuId());
                    skuPicChange.setSkuPicUrl(skuPicChangeVO.getSkuPicUrl());
                    skuPicChange.setSupplierId(skuInfoChangeReqBO.getSupplierId());
                    skuPicChange.setIsPrimary(skuPicChangeVO.getIsPrimary());
                    skuPicChanges.add(skuPicChange);
                }
            }
            if (!skuPicChanges.isEmpty()) {
                this.skuPicChangeMapper.insertOfBatch(skuPicChanges);
            }
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u4e0a\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u56fe\u7247\u53d8\u66f4\u5931\u8d25:" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u56fe\u7247\u53d8\u66f4\u5931\u8d25");
        }
    }

    private void skuInfoChangeApprove(SkuInfoChangeReqBO skuInfoChangeReqBO, SkuInfoChangeVO skuInfoChangeVO, GenerateSkuInfoChangeSeqRspBO generateSkuInfoChangeSeqRspBO) {
        try {
            BpmStartReqBO bpmStartReqBO = new BpmStartReqBO();
            bpmStartReqBO.setBusinessTitle("\u5546\u54c1\u4fe1\u606f\u53d8\u66f4\u5e76\u63d0\u4ea4\u5ba1\u6838");
            bpmStartReqBO.setBusinessType("13");
            bpmStartReqBO.setBusinessId(String.valueOf(skuInfoChangeReqBO.getSkuId()));
            bpmStartReqBO.setDetailUrl("\u5546\u54c1\u4fe1\u606f\u53d8\u66f4\u5ba1\u6838");
            bpmStartReqBO.setApplyerId(skuInfoChangeReqBO.getUserId());
            bpmStartReqBO.setStartFlag("1");
            bpmStartReqBO.setUserId(skuInfoChangeReqBO.getUserId());
            HashMap<String, Long> variables = new HashMap<String, Long>();
            variables.put("supplierId", skuInfoChangeReqBO.getSupplierId());
            bpmStartReqBO.setVariables(variables);
            BpmStartRspBO bpmStart = this.bpmStartBusinService.bpmStart(bpmStartReqBO);
            if (!"0000".equals(bpmStart.getRespCode())) {
                logger.info("\u7f16\u8f91\u4e0a\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1" + bpmStart.getRespDesc());
                throw new Exception(bpmStart.getRespDesc());
            }
            SkuInfoChangeLog skuInfoChangeLog = new SkuInfoChangeLog();
            skuInfoChangeLog.setProcInstlId(bpmStart.getProcInstId());
            skuInfoChangeLog.setSkuId(skuInfoChangeReqBO.getSkuId());
            skuInfoChangeLog.setSupplierId(skuInfoChangeReqBO.getSupplierId());
            skuInfoChangeLog.setApproveType(SupplyConstant.APPROVE_INFO_CHANGE_TYPE);
            skuInfoChangeLog.setApproveStatus(SupplyConstant.APPROVE_STATUS_START);
            skuInfoChangeLog.setApproveResult(SupplyConstant.APPROVE_SUB_TYPE);
            skuInfoChangeLog.setCreateLoginId(skuInfoChangeReqBO.getUserId());
            skuInfoChangeLog.setCreateLoginName(skuInfoChangeReqBO.getUserName());
            skuInfoChangeLog.setCreateTime(new Date());
            skuInfoChangeLog.setIsDelete(Constant.IS_DELETE.byteValue());
            skuInfoChangeLog.setChangeId(generateSkuInfoChangeSeqRspBO.getChangeId());
            skuInfoChangeLog.setAgreementId(skuInfoChangeVO.getAgreementId());
            skuInfoChangeLog.setAgreementSkuId(skuInfoChangeVO.getAgreementSkuId());
            this.skuInfoChangeLogMapper.insertSelective(skuInfoChangeLog);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u4e0a\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u542f\u52a8\u5de5\u4f5c\u6d41\u5931\u8d25" + e);
            throw new BusinessException(null, "\u542f\u52a8\u5de5\u4f5c\u6d41\u5931\u8d25");
        }
    }
}

