/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.gd.commodity.busi.UpdateBatchMarkupRateService;
import com.gd.commodity.busi.bo.agreement.BatchSetMarkupRateReqBO;
import com.gd.commodity.busi.bo.agreement.BatchSetMarkupRateRspBO;
import com.gd.commodity.dao.SupplierAgreementSkuMapper;
import com.gd.commodity.po.SupplierAgreementSku;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateBatchMarkupRateServiceImpl
implements UpdateBatchMarkupRateService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateBatchMarkupRateServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;

    public BatchSetMarkupRateRspBO updateBatchMarkupRate(BatchSetMarkupRateReqBO batchSetMarkupRateReqBO) throws Exception {
        if (this.isDebugEnabled) {
            logger.debug("\u8bbe\u7f6e\u52a0\u4ef7\u6bd4\u7387\u4e1a\u52a1\u670d\u52a1\uff08\u6279\u91cf\uff09\u5165\u53c2\uff1a" + batchSetMarkupRateReqBO.toString());
        }
        BatchSetMarkupRateRspBO batchSetMarkupRateRspBO = new BatchSetMarkupRateRspBO();
        try {
            Double markupRate = batchSetMarkupRateReqBO.getMarkupRate();
            Long supplierId = batchSetMarkupRateReqBO.getSupplierId();
            Long agreementId = batchSetMarkupRateReqBO.getAgreementId();
            List<SupplierAgreementSku> list = this.supplierAgreementSkuMapper.selectByAgreementId(agreementId, supplierId);
            ArrayList<SupplierAgreementSku> supplierAgreementSkuList = new ArrayList<SupplierAgreementSku>();
            DecimalFormat df = new DecimalFormat("#.0000");
            if (list.size() > 0) {
                for (SupplierAgreementSku supplierAgreementSku : list) {
                    SupplierAgreementSku supplierAgreementSku1 = this.supplierAgreementSkuMapper.selectByPrimaryKey(supplierAgreementSku.getAgreementSkuId(), supplierId);
                    supplierAgreementSku1.setMarkupRate(markupRate);
                    supplierAgreementSku1.setSupplierId(supplierId);
                    supplierAgreementSku1.setSalePrice(Math.round((double)supplierAgreementSku1.getBuyPrice().longValue() * (1.0 + Double.valueOf(df.format(markupRate / 100.0)))));
                    supplierAgreementSku1.setSalePriceSum(Math.round((double)supplierAgreementSku1.getBuyPriceSum().longValue() * (1.0 + Double.valueOf(df.format(markupRate / 100.0)))));
                    supplierAgreementSkuList.add(supplierAgreementSku1);
                }
            }
            if (supplierAgreementSkuList.size() > 0) {
                this.supplierAgreementSkuMapper.updateBySupplierAgreementSkuList(supplierAgreementSkuList);
            }
            batchSetMarkupRateRspBO.setIsSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            batchSetMarkupRateRspBO.setIsSuccess(Boolean.valueOf(false));
            logger.error("UpdateBatchMarkupRateServiceImpl========>\u8bbe\u7f6e\u52a0\u4ef7\u6bd4\u7387\u4e1a\u52a1\u670d\u52a1\uff08\u6279\u91cf\uff09\u4e1a\u52a1\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8bbe\u7f6e\u52a0\u4ef7\u6bd4\u7387\u4e1a\u52a1\u670d\u52a1\uff08\u6279\u91cf\uff09\u4e1a\u52a1\u670d\u52a1\u5b9e\u73b0\u51fa\u9519");
        }
        return batchSetMarkupRateRspBO;
    }

    public void setSupplierAgreementSkuMapper(SupplierAgreementSkuMapper supplierAgreementSkuMapper) {
        this.supplierAgreementSkuMapper = supplierAgreementSkuMapper;
    }
}

