/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.distribute.impl;

import com.cgd.base.mq.MqProducer;
import com.cgd.commodity.busi.QryWaitAgrSkuService;
import com.cgd.commodity.busi.bo.supply.QryWaitAgrSkuReqBO;
import com.cgd.commodity.busi.bo.supply.QryWaitAgrSkuRspBO;
import com.cgd.commodity.intfce.bo.PropValueListConsumerBO;
import com.cgd.common.bo.RspPageBO;
import com.ohaotian.commodity.atom.GenerateCommoditySeqService;
import com.ohaotian.commodity.atom.GeneratePASkuSeqService;
import com.ohaotian.commodity.atom.GeneratePropValueListSeqService;
import com.ohaotian.commodity.atom.GenerateSkuSpecSeqService;
import com.ohaotian.commodity.atom.bo.GenerateCommoditySeqRspBO;
import com.ohaotian.commodity.atom.bo.GeneratePASkuSeqRspBO;
import com.ohaotian.commodity.atom.bo.GeneratePropValueListSeqRspBO;
import com.ohaotian.commodity.atom.bo.GenerateSkuSpecSeqRspBO;
import com.ohaotian.commodity.busi.constant.CommodityTopicConstant;
import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.busi.distribute.ImportSkuExcelService;
import com.ohaotian.commodity.busi.distribute.bo.AgrDetailBO;
import com.ohaotian.commodity.busi.distribute.bo.FailMaterialBO;
import com.ohaotian.commodity.busi.distribute.bo.ImportSkuExcelReqBO;
import com.ohaotian.commodity.busi.distribute.bo.ImportSkuExcelRspBO;
import com.ohaotian.commodity.common.exception.BusinessException;
import com.ohaotian.commodity.dao.CommodityMapper;
import com.ohaotian.commodity.dao.CommodityPropDefMapper;
import com.ohaotian.commodity.dao.CommodityPropGrpMapper;
import com.ohaotian.commodity.dao.CommodityTypeMapper;
import com.ohaotian.commodity.dao.EMdmMaterialMapper;
import com.ohaotian.commodity.dao.PropValueListMapper;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.SkuSpecMapper;
import com.ohaotian.commodity.dao.SupplierAgreementMapper;
import com.ohaotian.commodity.dao.SupplierAgreementSkuMapper;
import com.ohaotian.commodity.dao.po.Commodity;
import com.ohaotian.commodity.dao.po.CommodityPropDef;
import com.ohaotian.commodity.dao.po.CommodityPropGrp;
import com.ohaotian.commodity.dao.po.CommodityType;
import com.ohaotian.commodity.dao.po.EMdmMaterial;
import com.ohaotian.commodity.dao.po.PropValueList;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.commodity.dao.po.SkuPrice;
import com.ohaotian.commodity.dao.po.SkuSpec;
import com.ohaotian.commodity.dao.po.SkuSyncExceptionLog;
import com.ohaotian.commodity.dao.po.SupplierAgreement;
import com.ohaotian.commodity.dao.po.SupplierAgreementSku;
import com.ohaotian.commodity.intfce.bo.SkuSyncExceptionLogBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="importSkuExcelService")
public class ImportSkuExcelServiceImpl
implements ImportSkuExcelService {
    private static final Logger logger = LoggerFactory.getLogger(ImportSkuExcelServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    QryWaitAgrSkuService qryWaitAgrSkuService;
    @Autowired
    private GeneratePASkuSeqService generatePASkuSeqService;
    @Autowired
    private SupplierAgreementMapper supplierAgreementMapper;
    @Autowired
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    @Autowired
    private EMdmMaterialMapper eMdmMaterialMapperC;
    @Autowired
    private GenerateCommoditySeqService generateCommoditySeqService;
    @Autowired
    private GenerateSkuSpecSeqService generateSkuSpecSeqService;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private CommodityMapper commodityMapper;
    @Autowired
    private SkuSpecMapper skuSpecMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private CommodityTypeMapper commodityTypeMapper;
    @Autowired
    private CommodityPropGrpMapper commodityPropGrpMapper;
    @Autowired
    private CommodityPropDefMapper commodityPropDefMapper;
    @Autowired
    private PropValueListMapper propValueListMapper;
    @Autowired
    private GeneratePropValueListSeqService generatePropValueListSeqService;

    public ImportSkuExcelRspBO importSkuExcel(ImportSkuExcelReqBO importSkuExcelReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + importSkuExcelReqBO.toString());
        }
        ImportSkuExcelRspBO rspBO = new ImportSkuExcelRspBO();
        ArrayList<FailMaterialBO> failMaterialBOS = new ArrayList<FailMaterialBO>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        if (null != importSkuExcelReqBO) {
            if (null == importSkuExcelReqBO.getAgreementId() || null == importSkuExcelReqBO.getSupplierId() || null == importSkuExcelReqBO.getAgrDetails()) {
                rspBO.setRespCode("7777");
                rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
                return rspBO;
            }
        } else {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            return rspBO;
        }
        try {
            Boolean failFlag = false;
            QryWaitAgrSkuReqBO qryWaitAgrSkuReqBO = new QryWaitAgrSkuReqBO();
            qryWaitAgrSkuReqBO.setAgreementId(importSkuExcelReqBO.getAgreementId());
            qryWaitAgrSkuReqBO.setSupplierId(importSkuExcelReqBO.getSupplierId());
            qryWaitAgrSkuReqBO.setPageNo(Integer.valueOf(1));
            qryWaitAgrSkuReqBO.setPageSize(Integer.valueOf(1000));
            RspPageBO resultPage = this.qryWaitAgrSkuService.qryWaitAgrSku(qryWaitAgrSkuReqBO);
            List result = resultPage.getRows();
            HashMap<Long, QryWaitAgrSkuRspBO> materialIdMap = new HashMap<Long, QryWaitAgrSkuRspBO>();
            for (QryWaitAgrSkuRspBO qryWaitAgrSkuRspBO : result) {
                materialIdMap.put(Long.valueOf(qryWaitAgrSkuRspBO.getMaterialId()), qryWaitAgrSkuRspBO);
            }
            for (AgrDetailBO agrDetailBO : importSkuExcelReqBO.getAgrDetails()) {
                if (null != materialIdMap.get(agrDetailBO.getMaterialId())) {
                    GeneratePASkuSeqRspBO generatePASkuSeqRspBO = this.generatePASkuSeqService.generatePASkuSeq();
                    FailMaterialBO failMaterialBO = this.creatPASkuInit(agrDetailBO, importSkuExcelReqBO, (QryWaitAgrSkuRspBO)materialIdMap.get(agrDetailBO.getMaterialId()), generatePASkuSeqRspBO);
                    if (null != failMaterialBO) {
                        failMaterialBOS.add(failMaterialBO);
                        continue;
                    }
                    skuIds.add(generatePASkuSeqRspBO.getSkuId());
                    continue;
                }
                failFlag = true;
                FailMaterialBO failMaterialBO = new FailMaterialBO();
                failMaterialBO.setMaterialId(agrDetailBO.getMaterialId());
                failMaterialBO.setFailDesc("\u7269\u6599\u660e\u7ec6\u4e0d\u5b58\u5728");
                failMaterialBOS.add(failMaterialBO);
            }
            rspBO.setFailMaterials(failMaterialBOS);
            rspBO.setSkuIds(skuIds);
            rspBO.setTotalCount(importSkuExcelReqBO.getAgrDetails().size());
            if (failFlag.booleanValue()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5931\u8d25");
            } else {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            }
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u660e\u7ec6\u6a21\u677f\u5bfc\u5165\u5546\u54c1\u4fe1\u606f\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u534f\u8bae\u660e\u7ec6\u6a21\u677f\u5bfc\u5165\u5546\u54c1\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
        }
    }

    private FailMaterialBO creatPASkuInit(AgrDetailBO agrDetailBO, ImportSkuExcelReqBO importSkuExcelReqBO, QryWaitAgrSkuRspBO qryWaitAgrSkuRspBO, GeneratePASkuSeqRspBO generatePASkuSeqRspBO) {
        Boolean failFlag = false;
        FailMaterialBO failMaterialBO = new FailMaterialBO();
        SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(importSkuExcelReqBO.getAgreementId(), importSkuExcelReqBO.getSupplierId());
        SupplierAgreementSku supplierAgreementSku = this.supplierAgreementSkuMapper.selectById(qryWaitAgrSkuRspBO.getAgreementSkuId(), importSkuExcelReqBO.getSupplierId());
        EMdmMaterial eMdmMaterial = this.eMdmMaterialMapperC.selectByMaterialCode(agrDetailBO.getMaterialId());
        List<Map<String, Object>> propMap = null;
        CommodityType commodityType = null;
        if (null != eMdmMaterial) {
            propMap = this.eMdmMaterialMapperC.qryPropNameAndValue(eMdmMaterial.getSysId(), eMdmMaterial.getCatalogId(), agrDetailBO.getMaterialId());
            if (null != eMdmMaterial.getCatalogId()) {
                commodityType = this.commodityTypeMapper.selectByCatalogId(eMdmMaterial.getCatalogId());
            }
        }
        if (null != supplierAgreement && null != supplierAgreementSku && null != eMdmMaterial) {
            GenerateCommoditySeqRspBO generateCommoditySeqRspBO = this.generateCommoditySeqService.generateCommoditySeq();
            Sku sku = this.initSku(importSkuExcelReqBO, agrDetailBO, supplierAgreement, supplierAgreementSku, eMdmMaterial, generateCommoditySeqRspBO, generatePASkuSeqRspBO, commodityType);
            Commodity commodity = this.initCommodity(importSkuExcelReqBO, supplierAgreement, supplierAgreementSku, generateCommoditySeqRspBO, sku, commodityType);
            this.initSkuPrice(sku, importSkuExcelReqBO, supplierAgreementSku, qryWaitAgrSkuRspBO);
            this.initSkuSpec(propMap, commodity, sku, importSkuExcelReqBO, supplierAgreementSku, commodityType);
        } else {
            failFlag = true;
            String errorMsg = "\u534f\u8bae\u6216\u8005\u4e3b\u6570\u636e\u4e0d\u5b58\u5728";
            this.sendMsgForSkuSyncExceptionLog(importSkuExcelReqBO, errorMsg, agrDetailBO);
            failMaterialBO.setFailDesc(errorMsg);
        }
        if (failFlag.booleanValue()) {
            return failMaterialBO;
        }
        return null;
    }

    private Sku initSku(ImportSkuExcelReqBO importSkuExcelReqBO, AgrDetailBO agrDetailBO, SupplierAgreement supplierAgreement, SupplierAgreementSku supplierAgreementSku, EMdmMaterial eMdmMaterial, GenerateCommoditySeqRspBO generateCommoditySeqRspBO, GeneratePASkuSeqRspBO generatePASkuSeqRspBO, CommodityType commodityType) {
        try {
            Sku sku = new Sku();
            sku.setSkuId(generatePASkuSeqRspBO.getSkuId());
            sku.setCommodityId(generateCommoditySeqRspBO.getCommodityId());
            sku.setSupplierId(importSkuExcelReqBO.getSupplierId());
            sku.setSupplierName(supplierAgreement.getSupplierName());
            sku.setVendorId(supplierAgreement.getVendorId());
            sku.setVendorName(supplierAgreement.getVendorName());
            if (!StringUtils.isEmpty((Object)supplierAgreementSku.getMaterialId())) {
                sku.setMaterialId(Long.parseLong(supplierAgreementSku.getMaterialId()));
            } else {
                sku.setMaterialId(eMdmMaterial.getMaterialCode());
            }
            sku.setSkuLongName(eMdmMaterial.getLongDesc());
            sku.setBrandId(supplierAgreementSku.getBrandId());
            sku.setBrandName(supplierAgreementSku.getBrandName());
            sku.setMeasureId(supplierAgreementSku.getMeasureId());
            sku.setMeasureName(supplierAgreementSku.getMeasureName());
            sku.setMfgSku(eMdmMaterial.getMainModel());
            if (null != commodityType.getCommodityTypeId()) {
                sku.setCommodityTypeId(commodityType.getCommodityTypeId());
            } else {
                sku.setCommodityTypeId(supplierAgreementSku.getCommodityTypeId());
            }
            sku.setSkuLocation(1);
            sku.setSkuName(agrDetailBO.getSkuName());
            sku.setSkuDetail(agrDetailBO.getSkuDetail());
            String packageParam = this.initPackageParam(agrDetailBO);
            sku.setPackParam(packageParam);
            sku.setOnShelveWay(0);
            sku.setSkuStatus(Constant.SKU_STATUS_DRAFT);
            sku.setBrandId(supplierAgreementSku.getBrandId());
            sku.setBrandName(supplierAgreementSku.getBrandName());
            sku.setIsSupplierAgreement(Constant.IS_NOT_SUPPLIER_AGREEMENT);
            sku.setCreateLoginId(importSkuExcelReqBO.getUserId());
            sku.setCreateTime(new Date());
            sku.setIsDelete(Constant.IS_DELETE);
            this.skuMapper.insertSelective(sku);
            return sku;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1sku\u521d\u59cb\u5316\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1SKU\u5931\u8d25");
        }
    }

    private String initPackageParam(AgrDetailBO agrDetailBO) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("{");
        sb.append("\"packParamLong\":");
        if (!StringUtils.isEmpty((Object)agrDetailBO.getPackParamLong())) {
            sb.append("\"" + agrDetailBO.getPackParamLong() + "\",");
        } else {
            sb.append("null,");
        }
        sb.append("\"packParamWide\":");
        if (!StringUtils.isEmpty((Object)agrDetailBO.getPackParamWide())) {
            sb.append("\"" + agrDetailBO.getPackParamWide() + "\",");
        } else {
            sb.append("null,");
        }
        sb.append("\"packParamHigh\":");
        if (!StringUtils.isEmpty((Object)agrDetailBO.getPackParamHigh())) {
            sb.append("\"" + agrDetailBO.getPackParamHigh() + "\",");
        } else {
            sb.append("null,");
        }
        sb.append("\"packParamWeight\":");
        if (!StringUtils.isEmpty((Object)agrDetailBO.getPackParamWeight())) {
            sb.append("\"" + agrDetailBO.getPackParamWeight() + "\",");
        } else {
            sb.append("null,");
        }
        sb.append("\"packParamList\":");
        if (!StringUtils.isEmpty((Object)agrDetailBO.getPackParamList())) {
            sb.append("\"" + agrDetailBO.getPackParamList() + "\",");
        } else {
            sb.append("null,");
        }
        sb.append("}");
        return sb.toString().replace(",}", "}");
    }

    private Commodity initCommodity(ImportSkuExcelReqBO importSkuExcelReqBO, SupplierAgreement supplierAgreement, SupplierAgreementSku supplierAgreementSku, GenerateCommoditySeqRspBO generateCommoditySeqRspBO, Sku sku, CommodityType commodityType) {
        try {
            Commodity newCommodity = new Commodity();
            Commodity commodity = this.commodityMapper.selectByTypeIdAndSupplierId(commodityType.getCommodityTypeId(), supplierAgreement.getSupplierId());
            if (null == commodity) {
                newCommodity.setCommodityCode(String.valueOf(sku.getSkuId()));
                newCommodity.setCommodityLocation(new Long(1L));
                if (null != commodityType.getCommodityTypeId()) {
                    newCommodity.setCommodityTypeId(commodityType.getCommodityTypeId());
                } else {
                    newCommodity.setCommodityTypeId(supplierAgreementSku.getCommodityTypeId());
                }
                newCommodity.setSupplierId(supplierAgreement.getSupplierId());
                newCommodity.setSupplierName(supplierAgreement.getSupplierName());
                newCommodity.setCreateLoginId(importSkuExcelReqBO.getUserId());
                newCommodity.setCreateTime(new Date());
                newCommodity.setIsDelete(Constant.IS_DELETE);
                newCommodity.setCommodityId(generateCommoditySeqRspBO.getCommodityId());
                newCommodity.setSupplierShopId(supplierAgreement.getSupplierId());
                this.commodityMapper.insertSelective(newCommodity);
                return newCommodity;
            }
            return commodity;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1SPU\u521d\u59cb\u5316\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1\uff08SPU\uff09\u5931\u8d25");
        }
    }

    private void initSkuPrice(Sku sku, ImportSkuExcelReqBO importSkuExcelReqBO, SupplierAgreementSku supplierAgreementSku, QryWaitAgrSkuRspBO qryWaitAgrSkuRspBO) {
        try {
            SkuPrice skuPrice = new SkuPrice();
            skuPrice.setSkuId(sku.getSkuId());
            skuPrice.setAgreementId(importSkuExcelReqBO.getAgreementId());
            skuPrice.setAgreementSkuId(qryWaitAgrSkuRspBO.getAgreementSkuId());
            skuPrice.setAgreementPrice(supplierAgreementSku.getSalePrice());
            skuPrice.setSalePrice(supplierAgreementSku.getSalePrice());
            skuPrice.setMemberPrice(supplierAgreementSku.getSalePrice());
            skuPrice.setSupplierId(importSkuExcelReqBO.getSupplierId());
            skuPrice.setCreateLoginId(importSkuExcelReqBO.getUserId());
            skuPrice.setCreateTime(new Date());
            skuPrice.setCurrencyType(Constant.CURRENCY_TYPE_RMB);
            skuPrice.setIsDelete(Constant.IS_DELETE);
            this.skuPriceMapper.insert(skuPrice);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5546\u54c1\u4ef7\u683c\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1\u4ef7\u683c\u5931\u8d25");
        }
    }

    private void initSkuSpec(List<Map<String, Object>> propMaps, Commodity commodity, Sku sku, ImportSkuExcelReqBO importSkuExcelReqBO, SupplierAgreementSku supplierAgreementSku, CommodityType commodityType) {
        try {
            List<CommodityPropGrp> commodityPropGrps = null;
            if (null != commodityType) {
                commodityPropGrps = this.commodityPropGrpMapper.qryPowerByTypeId(commodityType.getCommodityTypeId());
            }
            ArrayList<SkuSpec> skuSpecs = new ArrayList<SkuSpec>();
            if (null != propMaps && !propMaps.isEmpty()) {
                for (Map<String, Object> map : propMaps) {
                    String propName = (String)map.get("propName");
                    if (StringUtils.isEmpty((Object)propName)) continue;
                    SkuSpec skuSpec = new SkuSpec();
                    GenerateSkuSpecSeqRspBO generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
                    skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(importSkuExcelReqBO.getSupplierId());
                    CommodityPropDef commodityPropDef = this.commodityPropDefMapper.selectDefIdByPropName(propName);
                    if (null == commodityPropDef) continue;
                    skuSpec.setCommoditySpecId(commodityPropDef.getCommodityPropDefId());
                    skuSpec.setPropName((String)map.get("propName"));
                    skuSpec.setPropShowName((String)map.get("propName"));
                    PropValueList propValueList = this.initPropValueList(commodityPropDef.getCommodityPropDefId(), propName, (String)map.get("propValue"));
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    } else {
                        skuSpec.setPropValueListId((Long)map.get("propValueId"));
                    }
                    skuSpec.setPropValue((String)map.get("propValue"));
                    skuSpec.setCreateLoginId(importSkuExcelReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(commodityPropGrps.get(0).getCommodityPropGrpId());
                    }
                    skuSpecs.add(skuSpec);
                }
            } else if (null != supplierAgreementSku) {
                PropValueList propValueList;
                CommodityPropDef commodityPropDef;
                GenerateSkuSpecSeqRspBO generateSkuSpecRspBo;
                SkuSpec skuSpec;
                String model = supplierAgreementSku.getModel();
                String figure = supplierAgreementSku.getFigure();
                String spec = supplierAgreementSku.getSpec();
                String texture = supplierAgreementSku.getTexture();
                if (!StringUtils.isEmpty((Object)model)) {
                    skuSpec = new SkuSpec();
                    generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
                    skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(importSkuExcelReqBO.getSupplierId());
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(commodityPropGrps.get(0).getCommodityPropGrpId());
                    }
                    if (null != (commodityPropDef = this.commodityPropDefMapper.selectDefIdByPropName("\u578b\u53f7"))) {
                        skuSpec.setCommoditySpecId(commodityPropDef.getCommodityPropDefId());
                    }
                    skuSpec.setPropName("\u578b\u53f7");
                    skuSpec.setPropShowName("\u578b\u53f7");
                    propValueList = this.initPropValueList(commodityPropDef.getCommodityPropDefId(), "\u578b\u53f7", model);
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    }
                    skuSpec.setPropValue(model);
                    skuSpec.setCreateLoginId(importSkuExcelReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
                if (!StringUtils.isEmpty((Object)figure)) {
                    skuSpec = new SkuSpec();
                    generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
                    skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(importSkuExcelReqBO.getSupplierId());
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(commodityPropGrps.get(0).getCommodityPropGrpId());
                    }
                    if (null != (commodityPropDef = this.commodityPropDefMapper.selectDefIdByPropName("\u56fe\u53f7"))) {
                        skuSpec.setCommoditySpecId(commodityPropDef.getCommodityPropDefId());
                    }
                    skuSpec.setPropName("\u56fe\u53f7");
                    skuSpec.setPropShowName("\u56fe\u53f7");
                    propValueList = this.initPropValueList(commodityPropDef.getCommodityPropDefId(), "\u56fe\u53f7", model);
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    }
                    skuSpec.setPropValue(model);
                    skuSpec.setCreateLoginId(importSkuExcelReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
                if (!StringUtils.isEmpty((Object)spec)) {
                    skuSpec = new SkuSpec();
                    generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
                    skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(importSkuExcelReqBO.getSupplierId());
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(commodityPropGrps.get(0).getCommodityPropGrpId());
                    }
                    if (null != (commodityPropDef = this.commodityPropDefMapper.selectDefIdByPropName("\u89c4\u683c"))) {
                        skuSpec.setCommoditySpecId(commodityPropDef.getCommodityPropDefId());
                    }
                    skuSpec.setPropName("\u89c4\u683c");
                    skuSpec.setPropShowName("\u89c4\u683c");
                    propValueList = this.initPropValueList(commodityPropDef.getCommodityPropDefId(), "\u89c4\u683c", model);
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    }
                    skuSpec.setPropValue(model);
                    skuSpec.setCreateLoginId(importSkuExcelReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
                if (!StringUtils.isEmpty((Object)texture)) {
                    skuSpec = new SkuSpec();
                    generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
                    skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(importSkuExcelReqBO.getSupplierId());
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(commodityPropGrps.get(0).getCommodityPropGrpId());
                    }
                    if (null != (commodityPropDef = this.commodityPropDefMapper.selectDefIdByPropName("\u6750\u8d28"))) {
                        skuSpec.setCommoditySpecId(commodityPropDef.getCommodityPropDefId());
                    }
                    skuSpec.setPropName("\u6750\u8d28");
                    skuSpec.setPropShowName("\u6750\u8d28");
                    propValueList = this.initPropValueList(commodityPropDef.getCommodityPropDefId(), "\u6750\u8d28", model);
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    }
                    skuSpec.setPropValue(model);
                    skuSpec.setCreateLoginId(importSkuExcelReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
            }
            if (skuSpecs != null && skuSpecs.size() > 0) {
                this.skuSpecMapper.insertSkuSpecBatch(skuSpecs);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5546\u54c1\u89c4\u683c\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1\u89c4\u683c\u5931\u8d25");
        }
    }

    private void sendMsgForSkuSyncExceptionLog(ImportSkuExcelReqBO importSkuExcelReqBO, String errorMsg, AgrDetailBO agrDetailBO) {
        SkuSyncExceptionLogBO skuSyncExceptionLogBO = new SkuSyncExceptionLogBO();
        try {
            SkuSyncExceptionLog skuSyncExceptionLog = new SkuSyncExceptionLog();
            skuSyncExceptionLog.setSkuName(agrDetailBO.getSkuName());
            skuSyncExceptionLog.setExtSkuId(null);
            skuSyncExceptionLog.setSkuLocation(1);
            skuSyncExceptionLog.setSupplierId(importSkuExcelReqBO.getSupplierId());
            skuSyncExceptionLog.setCreateLoginId(importSkuExcelReqBO.getUserId());
            skuSyncExceptionLog.setCreateTime(new Date());
            skuSyncExceptionLog.setIsDelete(Constant.IS_DELETE);
            skuSyncExceptionLog.setErrorMsg(errorMsg);
            BeanUtils.copyProperties((Object)skuSyncExceptionLogBO, (Object)skuSyncExceptionLog);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25");
        }
        try {
            MqProducer.sendMsg((String)"SKU_SYNC_INSERT_TOPIC", (String)CommodityTopicConstant.SKU_SYNC_INSERT_TAG, (Object)skuSyncExceptionLogBO);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u6d88\u606f\u5931\u8d25" + e);
            throw new BusinessException(null, "\u53d1\u9001\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u6d88\u606f\u5931\u8d25");
        }
    }

    private PropValueList initPropValueList(Long commodityPropDefId, String propName, String propValue) {
        try {
            PropValueList propValueList = new PropValueList();
            propValueList.setCommodityPropDefId(commodityPropDefId);
            propValueList.setPropCode(propName);
            propValueList.setPropValue(propValue);
            PropValueList oldPropValueList = this.propValueListMapper.selectByValue(propValueList);
            if (null == oldPropValueList && null != propValue) {
                GeneratePropValueListSeqRspBO generatePropValueListSeqRspBO = this.generatePropValueListSeqService.generatePropValueListSeq();
                oldPropValueList = new PropValueList();
                oldPropValueList.setPropValueListId(generatePropValueListSeqRspBO.getPropValueListId());
                PropValueListConsumerBO propValueListConsumerBO = new PropValueListConsumerBO();
                propValueListConsumerBO.setPropValueListId(generatePropValueListSeqRspBO.getPropValueListId());
                propValueListConsumerBO.setCommodityPropDefId(commodityPropDefId);
                propValueListConsumerBO.setPropCode(propName);
                propValueListConsumerBO.setPropValue(propValue);
                propValueListConsumerBO.setCreateTime(new Date());
                propValueListConsumerBO.setIsDelete(Byte.valueOf(Constant.IS_DELETE.byteValue()));
                MqProducer.sendMsg((String)"PROPVALUELIST_INSERT_TOPIC", (String)CommodityTopicConstant.PROPVALUELIST_INSERT_TAG, (Object)propValueListConsumerBO);
            }
            return oldPropValueList;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5c5e\u6027\u503c\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5c5e\u6027\u503c\u5931\u8d25");
        }
    }
}

