/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryHasSkuAgrsByManageUserService;
import com.cgd.commodity.busi.bo.supply.QryHasSkuAgrsByManageUserReqBO;
import com.cgd.commodity.busi.bo.supply.QryHasSkuAgrsByManageUserRspBO;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.po.SupplierAgreement;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdAndCompIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdAndCompIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdAndCompIdRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryHasSkuAgrsByManageUserServiceImpl
implements QryHasSkuAgrsByManageUserService {
    private static final Logger logger = LoggerFactory.getLogger(QryHasSkuAgrsByManageUserServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SelectUserInfoByUserIdAndCompIdBusiService selectUserInfoByUserIdAndCompIdBusiService;
    private SupplierAgreementMapper supplierAgreementMapper;
    private SkuPriceMapper skuPriceMapper;

    public void setSelectUserInfoByUserIdAndCompIdBusiService(SelectUserInfoByUserIdAndCompIdBusiService selectUserInfoByUserIdAndCompIdBusiService) {
        this.selectUserInfoByUserIdAndCompIdBusiService = selectUserInfoByUserIdAndCompIdBusiService;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSkuPriceMapper(SkuPriceMapper skuPriceMapper) {
        this.skuPriceMapper = skuPriceMapper;
    }

    public RspPageBO<QryHasSkuAgrsByManageUserRspBO> qryHasSkuAgrsByManageUser(QryHasSkuAgrsByManageUserReqBO qryHasSkuAgrsByManageUserReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u6709\u8bb0\u5f55\u7684\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryHasSkuAgrsByManageUserReqBO.toString());
        }
        if (null == qryHasSkuAgrsByManageUserReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long supplierId = null;
        supplierId = "0".equals(qryHasSkuAgrsByManageUserReqBO.getIsprofess()) ? qryHasSkuAgrsByManageUserReqBO.getCompanyId() : this.getUserSupplierId(qryHasSkuAgrsByManageUserReqBO.getUserId());
        if (null == supplierId) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237ID[" + qryHasSkuAgrsByManageUserReqBO.getUserId() + "]\u6ca1\u6709\u5bf9\u5e94\u7684\u4e13\u4e1a\u673a\u6784");
        }
        try {
            List<SupplierAgreement> allSupplierAgreement = this.supplierAgreementMapper.qryAgrByProducerIdAndSupplierId(supplierId, qryHasSkuAgrsByManageUserReqBO.getUserId());
            Page page = new Page(qryHasSkuAgrsByManageUserReqBO.getPageNo(), qryHasSkuAgrsByManageUserReqBO.getPageSize());
            RspPageBO rspPageBO = new RspPageBO();
            if (!allSupplierAgreement.isEmpty()) {
                List<Long> agreementIds = new ArrayList<Long>();
                for (SupplierAgreement supplierAgreement : allSupplierAgreement) {
                    agreementIds.add(supplierAgreement.getAgreementId());
                }
                if (!agreementIds.isEmpty() && !(agreementIds = this.skuPriceMapper.selectByAgrIds(agreementIds, allSupplierAgreement.get(0).getSupplierId())).isEmpty()) {
                    List<SupplierAgreement> supplierAgreements = this.supplierAgreementMapper.qryHasSkuAgrs((Page<QryHasSkuAgrsByManageUserReqBO>)page, agreementIds, qryHasSkuAgrsByManageUserReqBO, supplierId);
                    List<QryHasSkuAgrsByManageUserRspBO> result = this.resolveRsp(supplierAgreements);
                    rspPageBO.setRows(result);
                }
            }
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qryHasSkuAgrsByManageUserReqBO.getPageNo());
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6709\u8bb0\u5f55\u7684\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u6709\u8bb0\u5f55\u7684\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private Long getUserSupplierId(Long userId) {
        try {
            SelectUserInfoByUserIdAndCompIdReqBO selectUserInfoAndCompIdReqBO = new SelectUserInfoByUserIdAndCompIdReqBO();
            selectUserInfoAndCompIdReqBO.setUserId(userId);
            SelectUserInfoByUserIdAndCompIdRspBO selectUserInfoByUserIdAndCompIdRspBO = this.selectUserInfoByUserIdAndCompIdBusiService.selectUserInfoByUserIdAndCompId(selectUserInfoAndCompIdReqBO);
            if ("0000".equals(selectUserInfoByUserIdAndCompIdRspBO.getRespCode())) {
                return selectUserInfoByUserIdAndCompIdRspBO.getCompId();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u542f\u7528\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u7528\u6237\u67e5\u94fa\u8d27\u5355\u4f4d\u4fe1\u606f\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6839\u636e\u7528\u6237\u67e5\u94fa\u8d27\u5355\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
    }

    private List<QryHasSkuAgrsByManageUserRspBO> resolveRsp(List<SupplierAgreement> supplierAgreements) {
        try {
            ArrayList<QryHasSkuAgrsByManageUserRspBO> qryHasSkuAgrsByManageUserRspBOs = new ArrayList<QryHasSkuAgrsByManageUserRspBO>();
            if (!supplierAgreements.isEmpty()) {
                for (SupplierAgreement supplierAgreement : supplierAgreements) {
                    Map<String, Long> skuNumMap = this.skuPriceMapper.qrySkuNumsByAgrId(supplierAgreement.getAgreementId(), supplierAgreement.getSupplierId());
                    QryHasSkuAgrsByManageUserRspBO qryHasSkuAgrsByManageUserRspBO = new QryHasSkuAgrsByManageUserRspBO();
                    qryHasSkuAgrsByManageUserRspBO.setAgreementId(supplierAgreement.getAgreementId());
                    qryHasSkuAgrsByManageUserRspBO.setAgreementName(supplierAgreement.getAgreementName());
                    qryHasSkuAgrsByManageUserRspBO.setAgreementType(supplierAgreement.getAgreementType());
                    qryHasSkuAgrsByManageUserRspBO.setEntAgreementCode(supplierAgreement.getEntAgreementCode());
                    qryHasSkuAgrsByManageUserRspBO.setPlaAgreementCode(supplierAgreement.getPlaAgreementCode());
                    qryHasSkuAgrsByManageUserRspBO.setSupplierId(supplierAgreement.getSupplierId());
                    qryHasSkuAgrsByManageUserRspBO.setProducerName(supplierAgreement.getProducerName());
                    qryHasSkuAgrsByManageUserRspBO.setIsDispatch(supplierAgreement.getIsDispatch());
                    qryHasSkuAgrsByManageUserRspBO.setSignTime(supplierAgreement.getSignTime());
                    qryHasSkuAgrsByManageUserRspBO.setVendorId(supplierAgreement.getVendorId());
                    qryHasSkuAgrsByManageUserRspBO.setVendorName(supplierAgreement.getVendorName());
                    if (!skuNumMap.isEmpty()) {
                        qryHasSkuAgrsByManageUserRspBO.setSupplySkuNum(skuNumMap.get("SUPPLY_SKU_NUM"));
                    }
                    qryHasSkuAgrsByManageUserRspBOs.add(qryHasSkuAgrsByManageUserRspBO);
                }
                return qryHasSkuAgrsByManageUserRspBOs;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6709\u8bb0\u5f55\u7684\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u7edf\u8ba1\u5546\u54c1\u5404\u72b6\u6001\u6570\u91cf-\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u7edf\u8ba1\u5546\u54c1\u5404\u72b6\u6001\u6570\u91cf-\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25");
        }
    }
}

