/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.ohaotian.commodity.busi.distribute.web.ExportPubSkusService;
import com.ohaotian.commodity.busi.distribute.web.bo.ExportPubSkusBO;
import com.ohaotian.commodity.busi.distribute.web.bo.ExportPubSkusReqBO;
import com.ohaotian.commodity.busi.distribute.web.bo.ExportPubSkusRspBO;
import com.ohaotian.commodity.busi.distribute.web.bo.ExportPubSkusRspVO;
import com.ohaotian.commodity.common.exception.BusinessException;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SupplierAgreementMapper;
import com.ohaotian.commodity.dao.po.SupplierAgreement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="exportPubSkusService")
public class ExportPubSkusServiceImpl
implements ExportPubSkusService {
    private static final Logger logger = LoggerFactory.getLogger(ExportPubSkusServiceImpl.class);
    private final boolean isDebugEnablled = logger.isDebugEnabled();
    @Autowired
    SkuMapper skuMapper;
    @Autowired
    SupplierAgreementMapper supplierAgreementMapper;

    public ExportPubSkusRspBO exportPubSkus(ExportPubSkusReqBO exportPubSkusReqBO) {
        if (this.isDebugEnablled) {
            logger.debug("\u5bfc\u51fa\u5546\u54c1\u6807\u8bc6\u7801\u670d\u52a1\u5165\u53c2\uff1a" + exportPubSkusReqBO.toString());
        }
        ExportPubSkusRspBO exportPubSkusRspBO = new ExportPubSkusRspBO();
        try {
            SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(exportPubSkusReqBO.getAgreementId(), exportPubSkusReqBO.getSupplierId());
            List<ExportPubSkusBO> exportPubSkusBOs = this.skuMapper.qryPubSkuIdAndName(exportPubSkusReqBO.getSupplierId(), exportPubSkusReqBO.getAgreementId());
            ArrayList<ExportPubSkusRspVO> exportPubSkusRspVOS = new ArrayList<ExportPubSkusRspVO>();
            if (null != exportPubSkusBOs || null != supplierAgreement) {
                for (ExportPubSkusBO exportPubSkusBO : exportPubSkusBOs) {
                    ExportPubSkusRspVO exportPubSkusRspVO = new ExportPubSkusRspVO();
                    exportPubSkusRspVO.setSkuId(exportPubSkusBO.getSkuId());
                    exportPubSkusRspVO.setSkuName(exportPubSkusBO.getSkuName());
                    exportPubSkusRspVO.setEntAgreementCode(supplierAgreement.getEntAgreementCode());
                    exportPubSkusRspVO.setPlaAgreementCode(supplierAgreement.getPlaAgreementCode());
                    exportPubSkusRspVO.setSupplierName(supplierAgreement.getSupplierName());
                    exportPubSkusRspVO.setModel(exportPubSkusBO.getModel());
                    exportPubSkusRspVOS.add(exportPubSkusRspVO);
                }
            } else {
                exportPubSkusRspBO.setRespCode("8888");
                exportPubSkusRspBO.setRespDesc("\u534f\u8bae\u6216\u8005Sku\u4e0d\u5b58\u5728");
            }
            exportPubSkusRspBO.setEntAgreementCode(supplierAgreement.getEntAgreementCode());
            exportPubSkusRspBO.setAgreementName(supplierAgreement.getAgreementName());
            exportPubSkusRspBO.setExportPubSkusRspVOS(exportPubSkusRspVOS);
            return exportPubSkusRspBO;
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5546\u54c1\u6807\u8bc6\u7801\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5bfc\u51fa\u5546\u54c1\u6807\u8bc6\u7801\u670d\u52a1\u5931\u8d25");
        }
    }
}

