/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryPubSkusByAgrIdService;
import com.cgd.commodity.busi.bo.supply.QryPubSkusByAgrIdReqBO;
import com.cgd.commodity.busi.bo.supply.QryPubSkusByAgrIdRspBO;
import com.cgd.commodity.busi.vo.supply.QryPubSkusByAgrIdReqVO;
import com.cgd.commodity.dao.CatalogCommodityTypeMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuOnShelveLogMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.po.CatalogCommodityType;
import com.cgd.commodity.po.SupplierAgreement;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.workflow.bo.QryHistoryCommentsReqBO;
import com.cgd.workflow.bo.QueryHistoryCommentsRspBO;
import com.cgd.workflow.bo.TaskCommentRspBO;
import com.cgd.workflow.busin.service.QueryHistoryCommentsBusinService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryPubSkusByAgrIdServiceImpl
implements QryPubSkusByAgrIdService {
    private static final Logger logger = LoggerFactory.getLogger(QryPubSkusByAgrIdServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;
    private SkuMapper skuMapper;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    private SupplierAgreementMapper supplierAgreementMapper;
    private SkuOnShelveLogMapper skuOnShelveLogMapper;
    private QueryHistoryCommentsBusinService queryHistoryCommentsBusinService;

    public void setCatalogCommodityTypeMapper(CatalogCommodityTypeMapper catalogCommodityTypeMapper) {
        this.catalogCommodityTypeMapper = catalogCommodityTypeMapper;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSkuOnShelveLogMapper(SkuOnShelveLogMapper skuOnShelveLogMapper) {
        this.skuOnShelveLogMapper = skuOnShelveLogMapper;
    }

    public void setQueryHistoryCommentsBusinService(QueryHistoryCommentsBusinService queryHistoryCommentsBusinService) {
        this.queryHistoryCommentsBusinService = queryHistoryCommentsBusinService;
    }

    public RspPageBO<QryPubSkusByAgrIdRspBO> qryPubSkusByAgrId(QryPubSkusByAgrIdReqBO qryPubSkusByAgrIdReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5df2\u53d1\u5e03\u5355\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryPubSkusByAgrIdReqBO.toString());
        }
        try {
            int indexOf;
            String skuName = qryPubSkusByAgrIdReqBO.getSkuName();
            if (skuName != null && !"".equals(skuName) && (indexOf = skuName.indexOf(92)) != -1) {
                String name = skuName.replaceAll("\\\\", "\\\\\\\\");
                qryPubSkusByAgrIdReqBO.setSkuName(name);
            }
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            if (null != qryPubSkusByAgrIdReqBO.getCatalogId()) {
                List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(qryPubSkusByAgrIdReqBO.getCatalogId());
                for (CatalogCommodityType catalogCommodityType : catalogs) {
                    commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                }
            }
            Page page = new Page(qryPubSkusByAgrIdReqBO.getPageNo(), qryPubSkusByAgrIdReqBO.getPageSize());
            SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(qryPubSkusByAgrIdReqBO.getAgreementId(), qryPubSkusByAgrIdReqBO.getSupplierId());
            List<QryPubSkusByAgrIdReqVO> qryPubSkuRspVOs = this.skuMapper.qryPubSkusByAgrId((Page<QryPubSkusByAgrIdReqBO>)page, qryPubSkusByAgrIdReqBO, commodityTypeIds, supplierAgreement.getAgreementStatus());
            List<QryPubSkusByAgrIdRspBO> qryPubSkuRspBOs = this.resolveRsp(qryPubSkuRspVOs, supplierAgreement);
            RspPageBO rspPageBO = new RspPageBO();
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qryPubSkusByAgrIdReqBO.getPageNo());
            rspPageBO.setRows(qryPubSkuRspBOs);
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5df2\u53d1\u5e03\u5355\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5df2\u53d1\u5e03\u5355\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QryPubSkusByAgrIdRspBO> resolveRsp(List<QryPubSkusByAgrIdReqVO> qryPubSkuRspVOs, SupplierAgreement supplierAgreement) throws Exception {
        ArrayList<QryPubSkusByAgrIdRspBO> qryPubSkuRspBOs = new ArrayList<QryPubSkusByAgrIdRspBO>();
        if (!qryPubSkuRspVOs.isEmpty()) {
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            for (QryPubSkusByAgrIdReqVO qryPubSkusByAgrIdReqVO : qryPubSkuRspVOs) {
                commodityTypeIds.add(qryPubSkusByAgrIdReqVO.getCommodityTypeId());
            }
            List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeIdAndLocation(commodityTypeIds);
            for (QryPubSkusByAgrIdReqVO qryPubSkusByAgrIdReqVO : qryPubSkuRspVOs) {
                QryPubSkusByAgrIdRspBO qryPubSkusByAgrIdRspBO = new QryPubSkusByAgrIdRspBO();
                qryPubSkusByAgrIdRspBO = this.getQryPubSkuRspBO(qryPubSkusByAgrIdRspBO, qryPubSkusByAgrIdReqVO, supplierAgreement);
                if (!catalogMaps.isEmpty()) {
                    for (Map<String, Object> map : catalogMaps) {
                        if (!map.get("commodityTypeId").equals(qryPubSkusByAgrIdReqVO.getCommodityTypeId())) continue;
                        qryPubSkusByAgrIdRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                        qryPubSkusByAgrIdRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                        qryPubSkusByAgrIdRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                    }
                }
                qryPubSkuRspBOs.add(qryPubSkusByAgrIdRspBO);
            }
        }
        return qryPubSkuRspBOs;
    }

    private QryPubSkusByAgrIdRspBO getQryPubSkuRspBO(QryPubSkusByAgrIdRspBO qryPubSkusByAgrIdRspBO, QryPubSkusByAgrIdReqVO qryPubSkusByAgrIdReqVO, SupplierAgreement supplierAgreement) {
        try {
            if (null != supplierAgreement) {
                qryPubSkusByAgrIdRspBO.setAgreementId(supplierAgreement.getAgreementId());
                qryPubSkusByAgrIdRspBO.setEntAgreementCode(supplierAgreement.getEntAgreementCode());
                qryPubSkusByAgrIdRspBO.setPlaAgreementCode(supplierAgreement.getPlaAgreementCode());
                qryPubSkusByAgrIdRspBO.setAgreementName(supplierAgreement.getAgreementName());
            }
            qryPubSkusByAgrIdRspBO.setAgreementSkuId(qryPubSkusByAgrIdReqVO.getAgreementSkuId());
            qryPubSkusByAgrIdRspBO.setBrandName(qryPubSkusByAgrIdReqVO.getBrandName());
            qryPubSkusByAgrIdRspBO.setFigure(qryPubSkusByAgrIdReqVO.getFigure());
            qryPubSkusByAgrIdRspBO.setModel(qryPubSkusByAgrIdReqVO.getModel());
            qryPubSkusByAgrIdRspBO.setSpec(qryPubSkusByAgrIdReqVO.getSpec());
            qryPubSkusByAgrIdRspBO.setTexture(qryPubSkusByAgrIdReqVO.getTexture());
            qryPubSkusByAgrIdRspBO.setPubTime(qryPubSkusByAgrIdReqVO.getCreateTime());
            qryPubSkusByAgrIdRspBO.setSkuId(qryPubSkusByAgrIdReqVO.getSkuId());
            qryPubSkusByAgrIdRspBO.setSkuName(qryPubSkusByAgrIdReqVO.getSkuName());
            qryPubSkusByAgrIdRspBO.setSupplierId(qryPubSkusByAgrIdReqVO.getSupplierId());
            qryPubSkusByAgrIdRspBO.setSupplierName(qryPubSkusByAgrIdReqVO.getSupplierName());
            qryPubSkusByAgrIdRspBO.setVendorId(qryPubSkusByAgrIdReqVO.getVendorId());
            qryPubSkusByAgrIdRspBO.setVendorName(qryPubSkusByAgrIdReqVO.getVendorName());
            if (null != qryPubSkusByAgrIdReqVO.getSkuMainPicUrl()) {
                qryPubSkusByAgrIdRspBO.setSkuMainPicUrl(qryPubSkusByAgrIdReqVO.getSkuMainPicUrl());
            }
            if (4 == supplierAgreement.getAgreementStatus()) {
                qryPubSkusByAgrIdRspBO.setSkuStatus(qryPubSkusByAgrIdReqVO.getSkuStatus());
            }
            Byte status = 9;
            if (3 == supplierAgreement.getAgreementStatus()) {
                qryPubSkusByAgrIdRspBO.setSkuStatus(status);
            }
            if (5 == supplierAgreement.getAgreementStatus()) {
                qryPubSkusByAgrIdRspBO.setSkuStatus(status);
            }
            if (6 == supplierAgreement.getAgreementStatus()) {
                qryPubSkusByAgrIdRspBO.setSkuStatus(status);
            }
            if (7 == supplierAgreement.getAgreementStatus()) {
                qryPubSkusByAgrIdRspBO.setSkuStatus(status);
            }
            String procInstlId = this.skuOnShelveLogMapper.selectBySkuIdAndSupplierIdNew(qryPubSkusByAgrIdReqVO.getSkuId(), qryPubSkusByAgrIdReqVO.getSupplierId());
            qryPubSkusByAgrIdRspBO.setProcInstlId(procInstlId);
            if (3 == qryPubSkusByAgrIdReqVO.getSkuStatus().intValue()) {
                String procInstlIdR = this.skuOnShelveLogMapper.selectBySkuIdAndSupplierId(qryPubSkusByAgrIdReqVO.getSkuId(), qryPubSkusByAgrIdReqVO.getSupplierId());
                String approveContent = this.getApproveContent(procInstlIdR);
                qryPubSkusByAgrIdRspBO.setProcInstlId(procInstlId);
                qryPubSkusByAgrIdRspBO.setApproveContent(approveContent);
            }
            return qryPubSkusByAgrIdRspBO;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5df2\u53d1\u5e03\u5355\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5c01\u88c5\u54cd\u5e94\u5b9e\u4f53sku\u6570\u636e\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5c01\u88c5\u54cd\u5e94\u5b9e\u4f53sku\u6570\u636e\u5931\u8d25");
        }
    }

    private String getApproveContent(String procInstlId) {
        try {
            QryHistoryCommentsReqBO qryHistoryCommentsReqBO = new QryHistoryCommentsReqBO();
            qryHistoryCommentsReqBO.setProcInstId(procInstlId);
            QueryHistoryCommentsRspBO queryHistoryCommentsRspBO = this.queryHistoryCommentsBusinService.queryHistoryComments(qryHistoryCommentsReqBO);
            if ("0000".equals(queryHistoryCommentsRspBO.getRespCode()) && null != queryHistoryCommentsRspBO.getTaskCommentRspBOs() && !queryHistoryCommentsRspBO.getTaskCommentRspBOs().isEmpty()) {
                for (TaskCommentRspBO taskCommentRspBO : queryHistoryCommentsRspBO.getTaskCommentRspBOs()) {
                    if (!"0".equals(taskCommentRspBO.getOperateKey())) continue;
                    return taskCommentRspBO.getComment();
                }
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5df2\u53d1\u5e03\u5355\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u5ba1\u6279\u5386\u53f2\u8bb0\u5f55\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5ba1\u6279\u5386\u53f2\u8bb0\u5f55\u5931\u8d25");
        }
    }
}

