/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySaleNumService;
import com.cgd.commodity.busi.bo.SaleNumReqBO;
import com.cgd.commodity.busi.bo.SaleNumRspBO;
import com.cgd.commodity.dao.SkuSaleNumMapper;
import com.cgd.commodity.po.SkuSaleNum;
import com.cgd.common.exception.BusinessException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QrySaleNumServiceImpl
implements QrySaleNumService {
    private static final Logger logger = LoggerFactory.getLogger(QrySaleNumServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuSaleNumMapper skuSaleNumMapper;
    private Properties prop;

    public SaleNumRspBO qrySaleNum(SaleNumReqBO saleNumReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u4e2d\u5fc3\u83b7\u53d6\u9500\u91cf\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + saleNumReqBO.toString());
        }
        if (null == saleNumReqBO.getSkuId() || "".equals(saleNumReqBO.getSkuId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4e2d\u5fc3\u83b7\u53d6\u9500\u91cf\u4e1a\u52a1\u670d\u52a1\u5355\u54c1ID[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == saleNumReqBO.getSupplierId() || "".equals(saleNumReqBO.getSupplierId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4e2d\u5fc3\u83b7\u53d6\u9500\u91cf\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String hsn = this.prop.getProperty("SUPPLIER_ID_" + saleNumReqBO.getSupplierId());
        if (null == hsn) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u4e2d\u5fc3\u83b7\u53d6\u9500\u91cf\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u5b58\u5728");
        }
        SkuSaleNum skuSaleNum = this.skuSaleNumMapper.selectSoldNumber(saleNumReqBO.getSkuId(), saleNumReqBO.getSupplierId());
        SaleNumRspBO saleNumRspBO = new SaleNumRspBO();
        if (skuSaleNum != null) {
            saleNumRspBO.setSaleNum(skuSaleNum.getSoldNumber());
            saleNumRspBO.setSkuId(skuSaleNum.getSkuId());
        }
        return saleNumRspBO;
    }

    public Properties getProp() {
        return this.prop;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }
}

