/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.base.mq.MqProducer;
import com.cgd.base.util.DelFormatHelper;
import com.cgd.commodity.atom.GenerateBrandSeqService;
import com.cgd.commodity.atom.bo.GenerateBrandSeqRspBO;
import com.cgd.commodity.dao.BrandMapper;
import com.cgd.commodity.dao.CommodityMeasureMapper;
import com.cgd.commodity.dao.EMdmMaterialMapper;
import com.cgd.commodity.dao.MdmCatalogMapper;
import com.cgd.commodity.intfce.bo.BrandConsumerBO;
import com.cgd.commodity.po.Brand;
import com.cgd.commodity.po.CommodityMeasure;
import com.cgd.commodity.po.EMdmMaterial;
import com.cgd.commodity.po.MdmCatalogPO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.gd.commodity.busi.AddAgrDetailChangeService;
import com.gd.commodity.busi.bo.agreement.AddAgrDetailChangeBO;
import com.gd.commodity.busi.bo.agreement.AddAgrDetailChangeReqBO;
import com.gd.commodity.busi.bo.agreement.AddAgrDetailChangeRspBO;
import com.gd.commodity.busi.vo.agreement.AgrAdjustPriceFormulaChangeVO;
import com.gd.commodity.constant.CommodityTopicConstant;
import com.gd.commodity.constant.Constant;
import com.gd.commodity.dao.AdjustPriceForMulaInfoMapper;
import com.gd.commodity.dao.AdjustPriceFormulaMapper;
import com.gd.commodity.dao.AgrAdjustPriceFormulaChangeMapper;
import com.gd.commodity.dao.AgreementDetailChangeMapper;
import com.gd.commodity.po.AdjustPriceForMulaInfo;
import com.gd.commodity.po.AdjustPriceFormula;
import com.gd.commodity.po.AgrAdjustPriceFormulaChange;
import com.gd.commodity.po.AgreementDetailChange;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class AddAgrDetailChangeServiceImpl
implements AddAgrDetailChangeService {
    private static final Logger logger = LoggerFactory.getLogger(AddAgrDetailChangeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementDetailChangeMapper agreementDetailChangeMapper;
    private BrandMapper brandMapper;
    private GenerateBrandSeqService generateBrandSeqService;
    private EMdmMaterialMapper eMdmMaterialMapper;
    private AdjustPriceFormulaMapper adjustPriceFormulaMapper;
    private AgrAdjustPriceFormulaChangeMapper agrAdjustPriceFormulaChangeMapper;
    private AdjustPriceForMulaInfoMapper adjustPriceForMulaInfoMapper;
    private CommodityMeasureMapper commodityMeasureMapper;
    private MdmCatalogMapper mdmCatalogMapper;

    public void setAdjustPriceForMulaInfoMapper(AdjustPriceForMulaInfoMapper adjustPriceForMulaInfoMapper) {
        this.adjustPriceForMulaInfoMapper = adjustPriceForMulaInfoMapper;
    }

    public void setAgreementDetailChangeMapper(AgreementDetailChangeMapper agreementDetailChangeMapper) {
        this.agreementDetailChangeMapper = agreementDetailChangeMapper;
    }

    public void setBrandMapper(BrandMapper brandMapper) {
        this.brandMapper = brandMapper;
    }

    public void setGenerateBrandSeqService(GenerateBrandSeqService generateBrandSeqService) {
        this.generateBrandSeqService = generateBrandSeqService;
    }

    public void seteMdmMaterialMapper(EMdmMaterialMapper eMdmMaterialMapper) {
        this.eMdmMaterialMapper = eMdmMaterialMapper;
    }

    public void setAdjustPriceFormulaMapper(AdjustPriceFormulaMapper adjustPriceFormulaMapper) {
        this.adjustPriceFormulaMapper = adjustPriceFormulaMapper;
    }

    public void setAgrAdjustPriceFormulaChangeMapper(AgrAdjustPriceFormulaChangeMapper agrAdjustPriceFormulaChangeMapper) {
        this.agrAdjustPriceFormulaChangeMapper = agrAdjustPriceFormulaChangeMapper;
    }

    public void setCommodityMeasureMapper(CommodityMeasureMapper commodityMeasureMapper) {
        this.commodityMeasureMapper = commodityMeasureMapper;
    }

    public void setMdmCatalogMapper(MdmCatalogMapper mdmCatalogMapper) {
        this.mdmCatalogMapper = mdmCatalogMapper;
    }

    public AddAgrDetailChangeRspBO addAgrDetailChange(AddAgrDetailChangeReqBO addAgrDetailChangeReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u65b0\u589e\u8865\u5145\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + addAgrDetailChangeReqBO.toString());
        }
        AddAgrDetailChangeRspBO rsp = new AddAgrDetailChangeRspBO();
        if (addAgrDetailChangeReqBO.getAgrDeatailChangeList() != null && addAgrDetailChangeReqBO.getAgrDeatailChangeList().size() > 0) {
            List<EMdmMaterial> eMdmMaterialList;
            ArrayList<String> materialCodeList = new ArrayList<String>();
            for (AddAgrDetailChangeBO agrDetailChange : addAgrDetailChangeReqBO.getAgrDeatailChangeList()) {
                if (null == agrDetailChange.getIsMaterialId() || 1 != agrDetailChange.getChangeType() || 1 != agrDetailChange.getIsMaterialId() || materialCodeList.contains(agrDetailChange.getMaterialId())) continue;
                materialCodeList.add(agrDetailChange.getMaterialId());
            }
            if (materialCodeList.size() > 0 && !(rsp = this.checkEMdmMaterial(eMdmMaterialList = this.eMdmMaterialMapper.selectByCodeList(materialCodeList), materialCodeList)).isSuccess()) {
                return rsp;
            }
        }
        try {
            ArrayList<AgreementDetailChange> list = new ArrayList<AgreementDetailChange>();
            if (addAgrDetailChangeReqBO != null && addAgrDetailChangeReqBO.getAgrDeatailChangeList().size() > 0) {
                if (addAgrDetailChangeReqBO.getUploadFlag() != null && addAgrDetailChangeReqBO.getUploadFlag() == 1 && (StringUtils.isEmpty((Object)addAgrDetailChangeReqBO.getUploadAgreementFlag()) || "0".equals(addAgrDetailChangeReqBO.getUploadAgreementFlag()))) {
                    this.agreementDetailChangeMapper.deleteByIdsAndChangeCode(((AddAgrDetailChangeBO)addAgrDetailChangeReqBO.getAgrDeatailChangeList().get(0)).getAgreementId(), ((AddAgrDetailChangeBO)addAgrDetailChangeReqBO.getAgrDeatailChangeList().get(0)).getSupplierId(), ((AddAgrDetailChangeBO)addAgrDetailChangeReqBO.getAgrDeatailChangeList().get(0)).getChangeCode());
                }
                HashMap<String, Long> measureNameAndIdMap = new HashMap<String, Long>();
                AdjustPriceFormula adjustPriceFormula = null;
                List<AdjustPriceForMulaInfo> adjustPriceForMulaInfos = null;
                if (null != addAgrDetailChangeReqBO.getFormulaId()) {
                    adjustPriceFormula = this.adjustPriceFormulaMapper.selectByPrimaryKey(addAgrDetailChangeReqBO.getFormulaId());
                    Byte formulaInfoType = 1;
                    adjustPriceForMulaInfos = this.adjustPriceForMulaInfoMapper.selectByFormulaId(addAgrDetailChangeReqBO.getFormulaId(), formulaInfoType);
                }
                ArrayList<AgrAdjustPriceFormulaChange> agrAdjustPriceFormulaChangeList = new ArrayList<AgrAdjustPriceFormulaChange>();
                for (AddAgrDetailChangeBO agrDetailChange : addAgrDetailChangeReqBO.getAgrDeatailChangeList()) {
                    Long brandId = this.getBrandId(agrDetailChange);
                    AgreementDetailChange agreementDetailChange = new AgreementDetailChange();
                    BeanUtils.copyProperties((Object)agreementDetailChange, (Object)agrDetailChange);
                    agreementDetailChange.setRemark(agrDetailChange.getRemark());
                    Long agreementDetailChangeSkuSeq = this.agreementDetailChangeMapper.generateAgreementDetailChangeSeq();
                    if (agrDetailChange.getMeasureId() == null) {
                        Long measureId = (Long)measureNameAndIdMap.get(agrDetailChange.getMeasureName());
                        if (measureId == null) {
                            CommodityMeasure commodityMeasure = this.commodityMeasureMapper.selectByName(agrDetailChange.getMeasureName());
                            if (commodityMeasure != null) {
                                measureId = commodityMeasure.getMeasureId();
                                agreementDetailChange.setMeasureId(measureId);
                                measureNameAndIdMap.put(agrDetailChange.getMeasureName(), measureId);
                            }
                        } else {
                            agreementDetailChange.setMeasureId(measureId);
                        }
                    }
                    agreementDetailChange.setDetailChangeId(agreementDetailChangeSkuSeq);
                    agreementDetailChange.setBuyPrice(MoneyUtil.BigDecimal2Long((BigDecimal)agrDetailChange.getBuyPrice()));
                    agreementDetailChange.setBuyPriceSum(MoneyUtil.BigDecimal2Long((BigDecimal)agrDetailChange.getBuyPriceSum()));
                    agreementDetailChange.setSalePrice(MoneyUtil.BigDecimal2Long((BigDecimal)agrDetailChange.getSalePrice()));
                    agreementDetailChange.setSalePriceSum(MoneyUtil.BigDecimal2Long((BigDecimal)agrDetailChange.getSalePriceSum()));
                    agreementDetailChange.setBrandId(brandId);
                    agreementDetailChange.setCreateTime(new Date());
                    agreementDetailChange.setCreateLoginId(addAgrDetailChangeReqBO.getUserId());
                    agreementDetailChange.setIsDelete((byte)0);
                    agreementDetailChange.setSupplyCycle(agrDetailChange.getSupplyCycle());
                    list.add(agreementDetailChange);
                    if (null == addAgrDetailChangeReqBO.getFormulaId()) continue;
                    this.initAgrAdjustPriceFormulaChange(agrDetailChange, addAgrDetailChangeReqBO, agreementDetailChangeSkuSeq, agrAdjustPriceFormulaChangeList, adjustPriceFormula, adjustPriceForMulaInfos);
                }
                if (agrAdjustPriceFormulaChangeList.size() > 0) {
                    this.agrAdjustPriceFormulaChangeMapper.insertAgrAdjustPriceFormulaChangeBatch(agrAdjustPriceFormulaChangeList);
                }
                this.agreementDetailChangeMapper.insertByList(list);
            }
            rsp.setSuccess(true);
        }
        catch (Exception e) {
            rsp.setSuccess(false);
            logger.error("\u65b0\u589e\u8865\u5145\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u589e\u8865\u5145\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    private Long getBrandId(AddAgrDetailChangeBO agrDetailChange) throws Exception {
        Brand oldBrand = this.brandMapper.selectByName(agrDetailChange.getBrandName());
        Long brandId = 0L;
        if (null == oldBrand) {
            GenerateBrandSeqRspBO generateBrandSeqRspBO = this.generateBrandSeqService.generateBrandSeq();
            brandId = generateBrandSeqRspBO.getBrandId();
            Brand record = new Brand();
            record.setBrandId(generateBrandSeqRspBO.getBrandId());
            record.setBrandName(agrDetailChange.getBrandName());
            record.setEffTime(DelFormatHelper.getNowYearAndMonthDay());
            record.setExpTime(DelFormatHelper.getNowYearAndMonthDay((String)"2050-12-31"));
            record.setBrandStatus(Constant.BRAND_STATUS_OPEN);
            record.setCreateLoginId(agrDetailChange.getUserId());
            record.setCreateTime(new Date());
            record.setIsDelete(Constant.IS_DELETE);
            BrandConsumerBO brandConsumerBO = new BrandConsumerBO();
            BeanUtils.copyProperties((Object)record, (Object)brandConsumerBO);
            MqProducer.sendMsg((String)"BRAND_INSERT_TOPIC", (String)CommodityTopicConstant.BRAND_INSERT_TAG, (Object)brandConsumerBO);
        } else {
            brandId = oldBrand.getBrandId();
        }
        return brandId;
    }

    private void initAgrAdjustPriceFormulaChange(AddAgrDetailChangeBO agrDetailChange, AddAgrDetailChangeReqBO addAgrDetailChangeReqBO, Long agreementDetailChangeSkuSeq, List<AgrAdjustPriceFormulaChange> agrAdjustPriceFormulaChangeList, AdjustPriceFormula adjustPriceFormula, List<AdjustPriceForMulaInfo> adjustPriceForMulaInfos) {
        try {
            if (adjustPriceFormula != null) {
                AgrAdjustPriceFormulaChange agrAdjustPriceFormulaChange;
                for (AgrAdjustPriceFormulaChangeVO agrAdjustPriceFormulaChangeVO : agrDetailChange.getAgrAdjustPriceFormulaChanges()) {
                    agrAdjustPriceFormulaChange = new AgrAdjustPriceFormulaChange();
                    agrAdjustPriceFormulaChange.setDetailChangeId(agreementDetailChangeSkuSeq);
                    agrAdjustPriceFormulaChange.setAgrFormulaName(adjustPriceFormula.getFormulaName());
                    agrAdjustPriceFormulaChange.setAgrFormulaValue(adjustPriceFormula.getFormulaValue());
                    agrAdjustPriceFormulaChange.setAgrCreateComp(adjustPriceFormula.getCreateComp());
                    agrAdjustPriceFormulaChange.setAgrFormulaInfoType(agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoType());
                    agrAdjustPriceFormulaChange.setAgrFormulaInfoFlag(agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoFlag());
                    agrAdjustPriceFormulaChange.setAgrFormulaInfoShowDesc(agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoShowDesc());
                    agrAdjustPriceFormulaChange.setAgrFormulaInfoDesc(agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoDesc());
                    agrAdjustPriceFormulaChange.setAgrFormulaInfoValueType(agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoValueType());
                    agrAdjustPriceFormulaChange.setAgrFormulaInfoValue(MoneyUtil.BigDecimal2Long((BigDecimal)agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoValue()));
                    agrAdjustPriceFormulaChange.setSupplierId(agrDetailChange.getSupplierId());
                    agrAdjustPriceFormulaChange.setCreateLoginId(addAgrDetailChangeReqBO.getUserId());
                    agrAdjustPriceFormulaChange.setCreateTime(new Date());
                    agrAdjustPriceFormulaChange.setIsDelete(Constant.IS_DELETE.byteValue());
                    agrAdjustPriceFormulaChangeList.add(agrAdjustPriceFormulaChange);
                }
                if (adjustPriceForMulaInfos != null && adjustPriceForMulaInfos.size() > 0) {
                    for (AdjustPriceForMulaInfo adjustPriceForMulaInfo : adjustPriceForMulaInfos) {
                        agrAdjustPriceFormulaChange = new AgrAdjustPriceFormulaChange();
                        agrAdjustPriceFormulaChange.setDetailChangeId(agreementDetailChangeSkuSeq);
                        agrAdjustPriceFormulaChange.setAgrFormulaName(adjustPriceFormula.getFormulaName());
                        agrAdjustPriceFormulaChange.setAgrFormulaValue(adjustPriceFormula.getFormulaValue());
                        agrAdjustPriceFormulaChange.setAgrCreateComp(adjustPriceFormula.getCreateComp());
                        agrAdjustPriceFormulaChange.setAgrFormulaInfoType(adjustPriceForMulaInfo.getFormulaInfoType());
                        agrAdjustPriceFormulaChange.setAgrFormulaInfoFlag(adjustPriceForMulaInfo.getFormulaInfoFlag());
                        agrAdjustPriceFormulaChange.setAgrFormulaInfoShowDesc(adjustPriceForMulaInfo.getFormulaInfoShowDesc());
                        agrAdjustPriceFormulaChange.setAgrFormulaInfoDesc(adjustPriceForMulaInfo.getFormulaInfoDesc());
                        agrAdjustPriceFormulaChange.setAgrFormulaInfoValueType(adjustPriceForMulaInfo.getFormulaInfoValueType());
                        agrAdjustPriceFormulaChange.setSupplierId(agrDetailChange.getSupplierId());
                        agrAdjustPriceFormulaChange.setCreateLoginId(addAgrDetailChangeReqBO.getUserId());
                        agrAdjustPriceFormulaChange.setCreateTime(new Date());
                        agrAdjustPriceFormulaChange.setIsDelete(Constant.IS_DELETE.byteValue());
                        agrAdjustPriceFormulaChangeList.add(agrAdjustPriceFormulaChange);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u534f\u8bae\u8c03\u4ef7\u516c\u5f0f\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u521d\u59cb\u5316\u534f\u8bae\u8c03\u4ef7\u516c\u5f0f\u5931\u8d25");
        }
    }

    public AddAgrDetailChangeRspBO addUploadAgrDetailChange(AddAgrDetailChangeBO addAgrDetailChangeBO) {
        CommodityMeasure commodityMeasure;
        EMdmMaterial eMdmMaterial;
        if (this.isDebugEnabled) {
            logger.debug("\u65b0\u589e\u8865\u5145\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + addAgrDetailChangeBO.toString());
        }
        AddAgrDetailChangeRspBO rsp = new AddAgrDetailChangeRspBO();
        if (null != addAgrDetailChangeBO.getIsMaterialId() && 1 == addAgrDetailChangeBO.getChangeType() && 1 == addAgrDetailChangeBO.getIsMaterialId() && null == (eMdmMaterial = this.eMdmMaterialMapper.selectByCode(addAgrDetailChangeBO.getMaterialId()))) {
            rsp.setSuccess(false);
            rsp.setResultMsg("\u6b64\u7269\u6599\u7f16\u7801[" + addAgrDetailChangeBO.getMaterialId() + "]\u4e0d\u5b58\u5728");
            return rsp;
        }
        AgreementDetailChange agreementDetailChange = new AgreementDetailChange();
        Long brandId = null;
        try {
            brandId = this.getBrandId(addAgrDetailChangeBO);
            BeanUtils.copyProperties((Object)agreementDetailChange, (Object)addAgrDetailChangeBO);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            rsp.setSuccess(false);
            rsp.setResultMsg("\u83b7\u53d6\u54c1\u724c\u51fa\u9519");
            return rsp;
        }
        agreementDetailChange.setRemark(addAgrDetailChangeBO.getRemark());
        if (!StringUtils.isEmpty((Object)addAgrDetailChangeBO.getCatalogId())) {
            try {
                MdmCatalogPO mdmCatalogPO = this.mdmCatalogMapper.getCheckByCatalogId(Long.valueOf(addAgrDetailChangeBO.getCatalogId()));
                if (null == mdmCatalogPO) {
                    rsp.setSuccess(false);
                    rsp.setResultMsg("\u6b64\u7269\u8d44\u5206\u7c7b\u4e0d\u5b58\u5728");
                    return rsp;
                }
                List<MdmCatalogPO> mdmCatalogPOSon = this.mdmCatalogMapper.getCheckByParentCatalogId(Long.valueOf(addAgrDetailChangeBO.getCatalogId()));
                if (mdmCatalogPOSon != null && mdmCatalogPOSon.size() > 0) {
                    rsp.setSuccess(false);
                    rsp.setResultMsg("\u6b64\u7269\u8d44\u5206\u7c7b\u4e0d\u662f\u672b\u7ea7\u5206\u7c7b");
                    return rsp;
                }
                agreementDetailChange.setCatalogName(mdmCatalogPO.getCatalogName());
            }
            catch (Exception e) {
                rsp.setSuccess(false);
                rsp.setResultMsg("\u6b64\u7269\u8d44\u5206\u7c7b\u4e0d\u5b58\u5728");
                return rsp;
            }
        }
        Long agreementDetailChangeSkuSeq = this.agreementDetailChangeMapper.generateAgreementDetailChangeSeq();
        if (addAgrDetailChangeBO.getMeasureId() == null && (commodityMeasure = this.commodityMeasureMapper.selectByName(addAgrDetailChangeBO.getMeasureName())) != null) {
            Long measureId = commodityMeasure.getMeasureId();
            agreementDetailChange.setMeasureId(measureId);
        }
        agreementDetailChange.setDetailChangeId(agreementDetailChangeSkuSeq);
        try {
            agreementDetailChange.setBuyPrice(MoneyUtil.BigDecimal2Long((BigDecimal)addAgrDetailChangeBO.getBuyPrice()));
            agreementDetailChange.setBuyPriceSum(MoneyUtil.BigDecimal2Long((BigDecimal)addAgrDetailChangeBO.getBuyPriceSum()));
            agreementDetailChange.setSalePrice(MoneyUtil.BigDecimal2Long((BigDecimal)addAgrDetailChangeBO.getSalePrice()));
            agreementDetailChange.setSalePriceSum(MoneyUtil.BigDecimal2Long((BigDecimal)addAgrDetailChangeBO.getSalePriceSum()));
        }
        catch (Exception e) {
            e.printStackTrace();
            rsp.setSuccess(false);
            rsp.setResultMsg("\u6570\u636e\u8f6c\u6362\u9519\u8bef");
            return rsp;
        }
        agreementDetailChange.setBrandId(brandId);
        agreementDetailChange.setCreateTime(new Date());
        agreementDetailChange.setCreateLoginId(addAgrDetailChangeBO.getUserId());
        agreementDetailChange.setIsDelete((byte)0);
        agreementDetailChange.setSupplyCycle(addAgrDetailChangeBO.getSupplyCycle());
        this.agreementDetailChangeMapper.insert(agreementDetailChange);
        rsp.setSuccess(true);
        return rsp;
    }

    private AddAgrDetailChangeRspBO checkEMdmMaterial(List<EMdmMaterial> eMdmMaterialList, List<String> materialIdList) {
        AddAgrDetailChangeRspBO addAgrDetailChangeRspBO = new AddAgrDetailChangeRspBO();
        addAgrDetailChangeRspBO.setSuccess(true);
        if (eMdmMaterialList == null || eMdmMaterialList.size() == 0) {
            addAgrDetailChangeRspBO.setSuccess(false);
            addAgrDetailChangeRspBO.setRespDesc("\u6240\u6709\u7269\u6599\u7f16\u7801\u5747\u4e0d\u5b58\u5728");
            return addAgrDetailChangeRspBO;
        }
        if (materialIdList.size() != eMdmMaterialList.size()) {
            StringBuilder materialIdsb = new StringBuilder();
            for (String materialId : materialIdList) {
                boolean exist = false;
                for (EMdmMaterial eMdmMaterial : eMdmMaterialList) {
                    if (!eMdmMaterial.getMaterialCode().toString().equals(materialId)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                if (materialIdsb.length() > 0) {
                    materialIdsb.append(",").append(materialId);
                    continue;
                }
                materialIdsb.append(materialId);
            }
            addAgrDetailChangeRspBO.setSuccess(false);
            addAgrDetailChangeRspBO.setRespDesc("\u7269\u6599\u7f16\u7801[" + materialIdsb.toString() + "]\u4e0d\u5b58\u5728");
            return addAgrDetailChangeRspBO;
        }
        StringBuilder materialIdsb = new StringBuilder();
        for (EMdmMaterial eMdmMaterial : eMdmMaterialList) {
            if (!StringUtils.isEmpty((Object)eMdmMaterial.getLongDesc())) continue;
            if (materialIdsb.length() > 0) {
                materialIdsb.append(",").append(eMdmMaterial.getMaterialCode());
                continue;
            }
            materialIdsb.append(eMdmMaterial.getMaterialCode());
        }
        if (materialIdsb.length() > 0) {
            addAgrDetailChangeRspBO.setSuccess(false);
            addAgrDetailChangeRspBO.setRespDesc("\u7269\u6599\u7f16\u7801[" + materialIdsb.toString() + "]\u4e0d\u5b58\u5728\u957f\u63cf\u8ff0");
            return addAgrDetailChangeRspBO;
        }
        return addAgrDetailChangeRspBO;
    }
}

