/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.gd.commodity.busi.DelChangeApplyService;
import com.gd.commodity.busi.bo.agreement.DelChangeApplyBO;
import com.gd.commodity.busi.bo.agreement.DelChangeApplyServiceReqBO;
import com.gd.commodity.busi.bo.agreement.DelChangeApplyServiceRspBO;
import com.gd.commodity.dao.AgreementChangeMapper;
import com.gd.commodity.dao.AgreementDetailChangeMapper;
import com.gd.commodity.dao.AgreementMajorChangeMapper;
import com.gd.commodity.dao.AgreementPriceChangeMapper;
import com.gd.commodity.dao.ScopeChangeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelChangeApplyServiceImpl
implements DelChangeApplyService {
    private static final Logger logger = LoggerFactory.getLogger(DelChangeApplyServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementChangeMapper agreementChangeMapper;
    private AgreementPriceChangeMapper agreementPriceChangeMapper;
    private AgreementDetailChangeMapper agreementDetailChangeMapper;
    private AgreementMajorChangeMapper agreementMajorChangeMapper;
    private ScopeChangeMapper scopeChangeMapper;

    public void setAgreementChangeMapper(AgreementChangeMapper agreementChangeMapper) {
        this.agreementChangeMapper = agreementChangeMapper;
    }

    public void setAgreementPriceChangeMapper(AgreementPriceChangeMapper agreementPriceChangeMapper) {
        this.agreementPriceChangeMapper = agreementPriceChangeMapper;
    }

    public void setAgreementDetailChangeMapper(AgreementDetailChangeMapper agreementDetailChangeMapper) {
        this.agreementDetailChangeMapper = agreementDetailChangeMapper;
    }

    public void setAgreementMajorChangeMapper(AgreementMajorChangeMapper agreementMajorChangeMapper) {
        this.agreementMajorChangeMapper = agreementMajorChangeMapper;
    }

    public void setScopeChangeMapper(ScopeChangeMapper scopeChangeMapper) {
        this.scopeChangeMapper = scopeChangeMapper;
    }

    public DelChangeApplyServiceRspBO delChangeApply(DelChangeApplyServiceReqBO delChangeApplyServiceReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5220\u9664\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + delChangeApplyServiceReqBO.toString());
        }
        DelChangeApplyServiceRspBO rsp = new DelChangeApplyServiceRspBO();
        try {
            if (delChangeApplyServiceReqBO != null && delChangeApplyServiceReqBO.getDelChangeApplyBOList() != null) {
                for (DelChangeApplyBO delChangeApplyBO : delChangeApplyServiceReqBO.getDelChangeApplyBOList()) {
                    if (delChangeApplyBO.getState() == null || !delChangeApplyBO.getState().equals(0) && !delChangeApplyBO.getState().equals(3)) continue;
                    this.updateChangeApply(delChangeApplyBO, rsp);
                }
            }
        }
        catch (Exception e) {
            rsp.setSuccess(false);
            logger.error("QryAgreementApproveLogServiceImpl========>\u5220\u9664\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5220\u9664\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    private void updateChangeApply(DelChangeApplyBO delChangeApplyBO, DelChangeApplyServiceRspBO rsp) {
        try {
            if (delChangeApplyBO.getChangeType() != null) {
                this.agreementChangeMapper.deleteById(delChangeApplyBO.getChangeId(), delChangeApplyBO.getAgreementId(), delChangeApplyBO.getSupplierId());
                switch (delChangeApplyBO.getChangeType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.agreementPriceChangeMapper.deleteById(delChangeApplyBO.getChangeId(), delChangeApplyBO.getAgreementId(), delChangeApplyBO.getSupplierId());
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        this.agreementDetailChangeMapper.deleteById(delChangeApplyBO.getChangeId(), delChangeApplyBO.getAgreementId(), delChangeApplyBO.getSupplierId());
                        break;
                    }
                    case 7: {
                        this.agreementMajorChangeMapper.deleteById(delChangeApplyBO.getChangeId(), delChangeApplyBO.getAgreementId(), delChangeApplyBO.getSupplierId());
                        this.scopeChangeMapper.deleteById(delChangeApplyBO.getChangeId(), delChangeApplyBO.getAgreementId(), delChangeApplyBO.getSupplierId());
                    }
                }
            }
            rsp.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("QryAgreementApproveLogServiceImpl========>\u5220\u9664\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5220\u9664\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
    }
}

