/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.consumer;

import com.cgd.base.mq.MqCunsumer;
import com.cgd.common.bo.MqSubScribeSingleBO;
import com.gd.commodity.constant.CommodityTopicConstant;
import com.gd.commodity.dao.AgreementApproveLogMapper;
import com.gd.commodity.dao.AgreementChangeMapper;
import com.gd.commodity.intfce.bo.agreement.AgrDelayConsumerReqBO;
import com.gd.commodity.po.AgreementChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class AgrDelayConsumer
implements MqCunsumer {
    private static final Logger logger = LoggerFactory.getLogger(AgrDelayConsumer.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementApproveLogMapper agreementApproveLogMapper;
    private AgreementChangeMapper agreementChangeMapper;

    public MqSubScribeSingleBO subscribe() {
        MqSubScribeSingleBO mqSubScribeSingleBO = new MqSubScribeSingleBO();
        mqSubScribeSingleBO.setConsumerId("AGREEMENT_DELAY_CID");
        mqSubScribeSingleBO.setTag(CommodityTopicConstant.AGREEMENT_DELAY_TAG);
        mqSubScribeSingleBO.setTopic("AGREEMENT_DELAY_TOPIC");
        return mqSubScribeSingleBO;
    }

    public void execute(String tag, Object msg) {
        try {
            AgrDelayConsumerReqBO agrDelayConsumerReqBO = (AgrDelayConsumerReqBO)msg;
            if (this.isDebugEnabled) {
                logger.debug("\u751f\u6210\u534f\u8bae\u5ef6\u671f\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff1a" + agrDelayConsumerReqBO.toString());
            }
            Integer approveResult = agrDelayConsumerReqBO.getApproveResult();
            AgreementChange agreementChange = new AgreementChange();
            BeanUtils.copyProperties((Object)agrDelayConsumerReqBO, (Object)agreementChange);
            agreementChange.setUpdateLoginId(agrDelayConsumerReqBO.getUpdateLoginId());
            if (approveResult == 1) {
                agreementChange.setState(2);
            }
            if (approveResult == 0) {
                agreementChange.setState(3);
            }
            agreementChange.setUpdateLoginId(agrDelayConsumerReqBO.getUpdateLoginId());
            this.agreementChangeMapper.updateAgrChgResultById(agreementChange);
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u534f\u8bae\u5ef6\u671f\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5931\u8d25" + e);
        }
    }

    public void setAgreementApproveLogMapper(AgreementApproveLogMapper agreementApproveLogMapper) {
        this.agreementApproveLogMapper = agreementApproveLogMapper;
    }

    public void setAgreementChangeMapper(AgreementChangeMapper agreementChangeMapper) {
        this.agreementChangeMapper = agreementChangeMapper;
    }
}

