/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.base.file.FileProcessing;
import com.cgd.base.file.oss.OssConfig;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.ohaotian.commodity.atom.GenerateSkuPicSeqService;
import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.busi.distribute.web.QryAndSaveOssProductPicService;
import com.ohaotian.commodity.busi.distribute.web.bo.QryAndSaveOssProductPicReqBO;
import com.ohaotian.commodity.busi.distribute.web.bo.QryAndSaveOssProductPicRspBO;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SkuPicMapper;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.commodity.dao.po.SkuPic;
import com.ohaotian.commodity.util.JschUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="qryAndSaveOssProductPicService")
public class QryAndSaveOssProductPicServiceImpl
implements QryAndSaveOssProductPicService {
    private static final Logger logger = LoggerFactory.getLogger(QryAndSaveOssProductPicService.class);
    public static final String FILE_NAME_ = "AGR";
    public static final String FILE_NAME_TXT = ".txt";
    public static final String DELIMITER = "/";
    public static final String OSS_NAME = "oss://";
    public static final String[] PIC_FORMAT = new String[]{"jpg", "png", "jpeg"};
    public static final String FTP_ROOT = "/var/ftp";
    @Value(value="${UPLOAD_SHELL_COMMAND}")
    private String shellCommond;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private SkuPicMapper skuPicMapper;
    @Autowired
    private GenerateSkuPicSeqService generateSkuPicSeqService;
    @Value(value="${ftp.commodity.host}")
    private String host;
    @Value(value="${ftp.commodity.user}")
    private String userName;
    @Value(value="${ftp.commodity.password}")
    private String password;

    public QryAndSaveOssProductPicRspBO saveQryOssProductPic(QryAndSaveOssProductPicReqBO qryAndSaveOssProductPicReqBO) {
        logger.debug("\u83b7\u53d6OSS\u56fe\u7247\u5217\u8868\u4e1a\u52a1\u670d\u52a1\uff1a" + qryAndSaveOssProductPicReqBO.toString());
        QryAndSaveOssProductPicRspBO qryAndSaveOssProductPicRspBO = new QryAndSaveOssProductPicRspBO();
        String agreementId = qryAndSaveOssProductPicReqBO.getAgreementId();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agreementId)) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8baeID\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String supplierIdStr = qryAndSaveOssProductPicReqBO.getSupplierId();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)supplierIdStr)) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u94fa\u8d27\u5546ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        Long supplierId = Long.valueOf(supplierIdStr);
        HashMap<String, List<String>> skuIdAndPicMap = new HashMap<String, List<String>>();
        Integer picCount = this.qryOssProductPic(qryAndSaveOssProductPicReqBO, skuIdAndPicMap);
        if (skuIdAndPicMap.isEmpty()) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6ca1\u6709\u5bf9\u5e94\u7684\u6587\u4ef6\u4fe1\u606f");
        }
        logger.debug("\u83b7\u53d6OSS\u56fe\u7247\u5217\u8868\uff1a" + ((Object)skuIdAndPicMap).toString());
        try {
            List<Sku> skuList = this.skuMapper.qrySkuByAgrAndSup(supplierId, Long.valueOf(agreementId));
            qryAndSaveOssProductPicRspBO.setRespCode("0000");
            qryAndSaveOssProductPicRspBO.setRespDesc("\u6210\u529f");
            if (skuList != null && skuList.size() > 0) {
                ArrayList<Sku> updateSkuList = new ArrayList<Sku>();
                ArrayList<SkuPic> insertSkuPicList = new ArrayList<SkuPic>();
                ArrayList<Long> deletePicSkuIdList = new ArrayList<Long>();
                int verifyCount = 0;
                List<Long> skuPicIdList = this.skuPicMapper.generateSkuPicSeqBatch(picCount);
                for (Sku sku : skuList) {
                    List skuPicList = (List)skuIdAndPicMap.get(sku.getSkuId().toString());
                    if (skuPicList == null || skuPicList.size() <= 0) continue;
                    this.initSkuPic(sku, skuPicList, insertSkuPicList, qryAndSaveOssProductPicReqBO.getUserId(), updateSkuList, skuPicIdList);
                    deletePicSkuIdList.add(sku.getSkuId());
                    ++verifyCount;
                }
                if (updateSkuList.size() > 0) {
                    this.skuMapper.updateSkuPicBatchBySkuId(updateSkuList, Long.parseLong(qryAndSaveOssProductPicReqBO.getSupplierId()));
                }
                if (insertSkuPicList.size() > 0) {
                    this.skuPicMapper.insertSkuPicBatch(insertSkuPicList);
                }
                if (skuList.size() != verifyCount) {
                    qryAndSaveOssProductPicRspBO.setRespDesc("\u8be5\u534f\u8bae\u8fd8\u6709" + (skuList.size() - verifyCount) + "\u6761\u5546\u54c1\u672a\u5339\u914d\u56fe\u7247");
                }
            }
            return qryAndSaveOssProductPicRspBO;
        }
        catch (Exception e) {
            logger.error("\u6838\u5b9e\u5546\u54c1\u56fe\u7247\u670d\u52a1\u5931\u8d25" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6838\u5b9e\u5546\u54c1\u56fe\u7247\u670d\u52a1\u5931\u8d25");
        }
    }

    private void initSkuPic(Sku sku, List<String> skuPicList, List<SkuPic> insertSkuPicList, Long userId, List<Sku> updateSkuList, List<Long> skuPicIdList) {
        for (String picUrl : skuPicList) {
            SkuPic skuPic = new SkuPic();
            skuPic.setSkuPicId(skuPicIdList.get(0));
            skuPicIdList.remove(0);
            skuPic.setCommodityId(sku.getCommodityId());
            skuPic.setSkuId(sku.getSkuId());
            skuPic.setSkuPicUrl(picUrl);
            skuPic.setSupplierId(sku.getSupplierId());
            skuPic.setCreateLoginId(userId);
            skuPic.setCreateTime(new Date());
            skuPic.setIsDelete(Constant.IS_DELETE);
            int index = skuPicList.indexOf(picUrl);
            skuPic.setPicOrder(index);
            String picFirst = picUrl.substring(picUrl.lastIndexOf("-") + 1, picUrl.lastIndexOf("."));
            if (picFirst.equals("001")) {
                skuPic.setIsPrimary(1);
                Sku updatesku = new Sku();
                updatesku.setSkuId(sku.getSkuId());
                updatesku.setSkuMainPicUrl(picUrl);
                updatesku.setUpdateLoginId(userId);
                updatesku.setUpdateTime(new Date());
                updateSkuList.add(updatesku);
            } else {
                skuPic.setIsPrimary(0);
            }
            insertSkuPicList.add(skuPic);
        }
    }

    private Integer qryOssProductPic(QryAndSaveOssProductPicReqBO qryAndSaveOssProductPicReqBO, Map<String, List<String>> skuIdAndPicMap) {
        Integer count = 0;
        String agreementId = qryAndSaveOssProductPicReqBO.getAgreementId();
        StringBuilder fileNameSb = new StringBuilder(agreementId);
        fileNameSb.append(FILE_NAME_).append(DELIMITER).append(agreementId).append(FILE_NAME_).append(FILE_NAME_TXT);
        logger.info("oss\u6587\u4ef6\u5730\u5740\uff1a" + fileNameSb.toString());
        File file = FileProcessing.downloadFile((String)fileNameSb.toString(), (String)"COMMODITY", (String)"");
        ArrayList<String> picNameList = new ArrayList<String>();
        OssConfig ossConfig = FileProcessing.getOssConfig();
        FileReader reader = null;
        BufferedReader br = null;
        try {
            reader = new FileReader(file);
            br = new BufferedReader(reader);
            String str = null;
            while ((str = br.readLine()) != null) {
                picNameList.add(str);
                logger.info(str);
            }
            br.close();
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            try {
                if (br != null) {
                    br.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38");
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                if (br != null) {
                    br.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38");
        }
        if (picNameList.size() > 0) {
            String regex = OSS_NAME + ossConfig.getBucketName();
            List<String> picList = Arrays.asList(PIC_FORMAT);
            for (String picName : picNameList) {
                Integer n;
                String[] picLastNameS;
                if (picName.lastIndexOf(".") < 1 || picName.lastIndexOf(DELIMITER) < 1) continue;
                String picUrl = picName.replaceFirst(regex, ossConfig.getAccessUrl());
                String picSuffix = picUrl.substring(picUrl.lastIndexOf(".") + 1);
                String picLastName = picUrl.substring(picUrl.lastIndexOf(DELIMITER) + 1);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)picSuffix) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)picLastName) || !picList.contains(picSuffix.toLowerCase()) || (picLastNameS = picLastName.split("-")).length < 2) continue;
                List<String> productPicList = skuIdAndPicMap.get(picLastNameS[0]);
                if (productPicList == null || productPicList.size() == 0) {
                    productPicList = new ArrayList<String>();
                    productPicList.add(picUrl);
                    skuIdAndPicMap.put(picLastNameS[0], productPicList);
                    Integer n2 = count;
                    n = count = Integer.valueOf(count + 1);
                    continue;
                }
                String picFirst = picUrl.substring(picUrl.lastIndexOf("-") + 1, picUrl.lastIndexOf("."));
                if (picFirst.equals("001")) {
                    productPicList.add(0, picUrl);
                } else {
                    productPicList.add(picUrl);
                }
                n = count;
                Integer n3 = count = Integer.valueOf(count + 1);
            }
        }
        return count;
    }

    public RspBusiBaseBO uploadPicture(QryAndSaveOssProductPicReqBO qryAndSaveOssProductPicReqBO) {
        RspBusiBaseBO rspBusiBaseBO = new RspBusiBaseBO();
        String command = this.shellCommond + " " + FTP_ROOT + qryAndSaveOssProductPicReqBO.getFtpUrl() + " " + qryAndSaveOssProductPicReqBO.getAgreementId() + FILE_NAME_;
        logger.info("upload shell: " + command);
        int result = JschUtils.runShell(command, this.host, this.userName, this.password);
        if (result == 1) {
            logger.error("\u83b7\u53d6OSS\u56fe\u7247\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff0c\u6267\u884c\u811a\u672c\u9519\u8bef\uff01");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u83b7\u53d6OSS\u56fe\u7247\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff0c\u6267\u884c\u811a\u672c\u9519\u8bef\uff01");
        }
        rspBusiBaseBO.setRespCode("0000");
        rspBusiBaseBO.setRespDesc("\u6210\u529f");
        return rspBusiBaseBO;
    }
}

