/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.cgd.base.util.DelFormatHelper;
import com.cgd.commodity.busi.QryOnSaleService;
import com.cgd.commodity.busi.bo.BusiOnSaleReqBO;
import com.cgd.commodity.busi.bo.BusiOnSaleRspBO;
import com.cgd.commodity.constant.Constant;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.search.builder.search.SearchBuilder;
import com.cgd.search.builder.search.SearchRequestBuilder;
import com.cgd.search.builder.search.SearchRequestBuilderAdapter;
import com.cgd.search.builder.search.filter.BooleanFilterCondition;
import com.cgd.search.builder.search.filter.FilterCondition;
import com.cgd.search.builder.search.filter.MatchFilterCondition;
import com.cgd.search.builder.search.query.BooleanQueryCondition;
import com.cgd.search.builder.search.query.MatchQueryCondition;
import com.cgd.search.builder.search.query.QueryCondition;
import com.cgd.search.builder.search.result.Result;
import com.cgd.search.builder.search.sort.SearchSortMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QryOnSaleServiceImpl
implements QryOnSaleService {
    private static final Logger logger = LoggerFactory.getLogger(QryOnSaleServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SearchRequestBuilderAdapter searchRequestBuilderAdapter;
    private Properties prop;

    public void setSearchRequestBuilderAdapter(SearchRequestBuilderAdapter searchRequestBuilderAdapter) {
        this.searchRequestBuilderAdapter = searchRequestBuilderAdapter;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public RspPageBO<BusiOnSaleRspBO> qryOnSale(BusiOnSaleReqBO busiOnSaleReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiOnSaleReqBO.toString());
        }
        if (null == busiOnSaleReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiOnSaleReqBO.getGuideCatalogId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u7c7b\u76ee[guideCatalogId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiOnSaleReqBO.getSkuLocation()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u4f4d\u7f6e\u53c2\u6570[skuLocation]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (!"-1".equals(busiOnSaleReqBO.getSupplierId()) && !"-1".equals(busiOnSaleReqBO.getGuideCatalogId())) {
                SearchBuilder searchBuilder = SearchBuilder.newBuilder((SearchRequestBuilder)this.searchRequestBuilderAdapter.requestBuilder());
                int from = busiOnSaleReqBO.getPageSize() * (busiOnSaleReqBO.getPageNo() - 1);
                searchBuilder.setFrom(from);
                searchBuilder.setSize(busiOnSaleReqBO.getPageSize());
                int os_total_count = Integer.parseInt(this.prop.getProperty("os.total_count"));
                if (from + busiOnSaleReqBO.getPageSize() > os_total_count) {
                    searchBuilder.setSize(os_total_count - from);
                }
                searchBuilder.setIndexName(String.valueOf(this.prop.getProperty("os.appName")));
                searchBuilder.fetchBuilder().addCol("sku_id").addCol("sku_name").addCol("l1_category_name").addCol("l2_category_name").addCol("l3_category_name").addCol("brand_name").addCol("supplier_id").addCol("supplier_name").addCol("on_shelve_time").addCol("agreement_price").addCol("market_price").addCol("discount_rate").addCol("sku_location");
                BooleanQueryCondition booleanQueryCondition = this.getBooleanQueryCondition(busiOnSaleReqBO);
                searchBuilder.queryBuilder().setCondition((QueryCondition)booleanQueryCondition);
                BooleanFilterCondition filter = new BooleanFilterCondition();
                if (null != busiOnSaleReqBO.getGuideCatalogId()) {
                    MatchFilterCondition match = new MatchFilterCondition();
                    match.setColumnName("l3_category_id");
                    match.setValue((Object)("\"" + busiOnSaleReqBO.getGuideCatalogId() + "*~~" + "2\""));
                    filter.must().add(match);
                }
                if (!filter.must().isEmpty() || !filter.should().isEmpty()) {
                    searchBuilder.filterBuilder().setFilterCondition((FilterCondition)filter);
                }
                if (!StringUtils.isEmpty((Object)busiOnSaleReqBO.getSortName())) {
                    if ("asc".equals(busiOnSaleReqBO.getSortOrder())) {
                        searchBuilder.sortBuilder().addCol("on_shelve_time", SearchSortMode.ASC);
                    }
                    if ("desc".equals(busiOnSaleReqBO.getSortOrder())) {
                        searchBuilder.sortBuilder().addCol("on_shelve_time", SearchSortMode.DESC);
                    }
                } else {
                    searchBuilder.sortBuilder().addCol("on_shelve_time", SearchSortMode.DESC);
                }
                Result result = searchBuilder.build();
                if (this.isDebugEnabled) {
                    logger.debug("\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u641c\u7d22\u5f15\u64ce\u51fa\u53c2\uff1a" + result.toString());
                }
                List<BusiOnSaleRspBO> busiOnSaleRspVOs = this.resolveResult(result);
                RspPageBO rspPageBo = new RspPageBO();
                rspPageBo.setRecordsTotal((int)result.getTotal());
                int pageTotal = 0;
                pageTotal = result.getTotal() % (long)busiOnSaleReqBO.getPageSize() == 0L ? (int)(result.getTotal() / (long)busiOnSaleReqBO.getPageSize()) : (int)(result.getTotal() / (long)busiOnSaleReqBO.getPageSize() + 1L);
                rspPageBo.setTotal(pageTotal);
                rspPageBo.setPageNo(busiOnSaleReqBO.getPageNo());
                rspPageBo.setRows(busiOnSaleRspVOs);
                return rspPageBo;
            }
            RspPageBO rspPageBo = new RspPageBO();
            rspPageBo.setRecordsTotal(0);
            rspPageBo.setTotal(0);
            rspPageBo.setPageNo(0);
            return rspPageBo;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u9519\uff1a" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
    }

    private BooleanQueryCondition getBooleanQueryCondition(BusiOnSaleReqBO busiOnSaleReqBO) {
        try {
            BooleanQueryCondition booleanQueryCondition = new BooleanQueryCondition();
            if (busiOnSaleReqBO.getSkuLocation() == 1 || busiOnSaleReqBO.getSkuLocation() == 2) {
                MatchQueryCondition match_1 = new MatchQueryCondition();
                match_1.setColumnName("sku_location");
                match_1.setValue("'" + busiOnSaleReqBO.getSkuLocation() + "'");
                booleanQueryCondition.must().add(match_1);
            }
            MatchQueryCondition match_2 = new MatchQueryCondition();
            match_2.setColumnName("sku_status");
            match_2.setValue("'" + Constant.SKU_STATUS_SHELVED + "'");
            booleanQueryCondition.must().add(match_2);
            if (null != busiOnSaleReqBO.getSupplierId()) {
                MatchQueryCondition match_3 = new MatchQueryCondition();
                match_3.setColumnName("supplier_id");
                match_3.setValue("'" + busiOnSaleReqBO.getSupplierId() + "'");
                booleanQueryCondition.must().add(match_3);
            }
            if (null != busiOnSaleReqBO.getSkuId()) {
                MatchQueryCondition match_5 = new MatchQueryCondition();
                match_5.setColumnName("id");
                match_5.setValue("'" + busiOnSaleReqBO.getSkuId() + "'");
                booleanQueryCondition.must().add(match_5);
            }
            if (null != busiOnSaleReqBO.getSkuName()) {
                MatchQueryCondition match_6 = new MatchQueryCondition();
                match_6.setColumnName("sku_name");
                match_6.setValue("'" + busiOnSaleReqBO.getSkuName().replaceAll(" ", "") + "'");
                booleanQueryCondition.must().add(match_6);
            }
            if (null != busiOnSaleReqBO.getBrandName()) {
                MatchQueryCondition match_7 = new MatchQueryCondition();
                match_7.setColumnName("brand_name");
                match_7.setValue("'" + busiOnSaleReqBO.getBrandName().replaceAll(" ", "") + "'");
                booleanQueryCondition.must().add(match_7);
            }
            return booleanQueryCondition;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u89e3\u6790\u67e5\u8be2\u6761\u4ef6\u51fa\u9519\uff1a" + e);
            throw new RuntimeException("\u89e3\u6790\u67e5\u8be2\u6761\u4ef6\u51fa\u9519");
        }
    }

    private List<BusiOnSaleRspBO> resolveResult(Result result) throws Exception {
        try {
            ArrayList<BusiOnSaleRspBO> list = new ArrayList<BusiOnSaleRspBO>();
            if (result.isStatus()) {
                JSONArray skuInfoResultJson = result.getItems();
                for (int i = 0; i < skuInfoResultJson.length(); ++i) {
                    JSONObject obj = skuInfoResultJson.getJSONObject(i);
                    BusiOnSaleRspBO busiOnSaleRspBO = new BusiOnSaleRspBO();
                    busiOnSaleRspBO.setSkuId(Long.valueOf(obj.getLong("sku_id")));
                    busiOnSaleRspBO.setSkuName(obj.getString("sku_name"));
                    busiOnSaleRspBO.setFirstCatalogName(obj.getString("l1_category_name"));
                    busiOnSaleRspBO.setSecondCatalogName(obj.getString("l2_category_name"));
                    String categoryName3 = obj.getString("l3_category_name");
                    if (!StringUtils.isEmpty((Object)categoryName3)) {
                        String[] categoryName3Attr = categoryName3.split("\\b");
                        if (categoryName3Attr.length > 1) {
                            busiOnSaleRspBO.setThirdCatalogName(categoryName3Attr[1]);
                        } else if (categoryName3Attr.length == 1) {
                            busiOnSaleRspBO.setThirdCatalogName(categoryName3Attr[0]);
                        } else {
                            busiOnSaleRspBO.setThirdCatalogName(categoryName3);
                        }
                    }
                    busiOnSaleRspBO.setBrandName(obj.getString("brand_name"));
                    busiOnSaleRspBO.setSupplierId(Long.valueOf(obj.getLong("supplier_id")));
                    busiOnSaleRspBO.setSupplierName(obj.getString("supplier_name"));
                    busiOnSaleRspBO.setMarketPrice(MoneyUtil.Long2BigDecimal((Long)obj.getLong("market_price")));
                    busiOnSaleRspBO.setAgreementPrice(MoneyUtil.Long2BigDecimal((Long)obj.getLong("agreement_price")));
                    Double rate = (double)obj.getLong("agreement_price") / (double)obj.getLong("market_price");
                    NumberFormat nFromat = NumberFormat.getPercentInstance();
                    String rates = nFromat.format(rate);
                    busiOnSaleRspBO.setDiscountRate(rates);
                    busiOnSaleRspBO.setPublishTime(DelFormatHelper.longToDate((long)obj.getLong("on_shelve_time")));
                    list.add(busiOnSaleRspBO);
                }
            }
            return list;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u6570\u636e\u51fa\u9519\uff1a" + e);
            throw new RuntimeException("\u89e3\u6790\u54cd\u5e94\u6570\u636e\u51fa\u9519");
        }
    }
}

