/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.gd.commodity.atom.GenerateAgrChangeSeqService;
import com.gd.commodity.busi.AddDetailChangeApplyService;
import com.gd.commodity.busi.AgreementApproveTaskService;
import com.gd.commodity.busi.bo.agreement.AddDetailChangeApplyReqBO;
import com.gd.commodity.busi.bo.agreement.AddDetailChangeApplyRspBO;
import com.gd.commodity.busi.bo.agreement.AgreementApproveTaskStartRspBO;
import com.gd.commodity.busi.bo.agreement.AgreementChangeBO;
import com.gd.commodity.busi.impl.AddStatusChangeApplyServiceImpl;
import com.gd.commodity.busi.vo.agreement.AgrAttachChgVo;
import com.gd.commodity.dao.AgreementChangeAttachMapper;
import com.gd.commodity.dao.AgreementChangeMapper;
import com.gd.commodity.dao.AgreementDetailChangeMapper;
import com.gd.commodity.po.AgreementChange;
import com.gd.commodity.po.AgreementChangeAttach;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class AddDetailChangeApplyServiceImpl
implements AddDetailChangeApplyService {
    private static final Logger logger = LoggerFactory.getLogger(AddStatusChangeApplyServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementChangeMapper agreementChangeMapper;
    private AgreementDetailChangeMapper agreementDetailChangeMapper;
    private GenerateAgrChangeSeqService generateAgrChangeSeqService;
    private AgreementChangeAttachMapper agreementChangeAttachMapper;
    private AgreementApproveTaskService agreementApproveTaskService;

    public void setAgreementChangeMapper(AgreementChangeMapper agreementChangeMapper) {
        this.agreementChangeMapper = agreementChangeMapper;
    }

    public void setAgreementDetailChangeMapper(AgreementDetailChangeMapper agreementDetailChangeMapper) {
        this.agreementDetailChangeMapper = agreementDetailChangeMapper;
    }

    public void setGenerateAgrChangeSeqService(GenerateAgrChangeSeqService generateAgrChangeSeqService) {
        this.generateAgrChangeSeqService = generateAgrChangeSeqService;
    }

    public void setAgreementChangeAttachMapper(AgreementChangeAttachMapper agreementChangeAttachMapper) {
        this.agreementChangeAttachMapper = agreementChangeAttachMapper;
    }

    public void setAgreementApproveTaskService(AgreementApproveTaskService agreementApproveTaskService) {
        this.agreementApproveTaskService = agreementApproveTaskService;
    }

    public AddDetailChangeApplyRspBO addDetailChangeApply(AddDetailChangeApplyReqBO addDetailChangeApplyReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u65b0\u589e\u8865\u5145\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + addDetailChangeApplyReqBO.toString());
        }
        AddDetailChangeApplyRspBO rsp = new AddDetailChangeApplyRspBO();
        try {
            List<AgreementChange> agreementChangeList = this.agreementChangeMapper.selectByAgreementIdAndState(addDetailChangeApplyReqBO.getAgreementId());
            if (agreementChangeList != null && agreementChangeList.size() > 0) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6b64\u534f\u8bae\u6709\u672a\u5b8c\u6210\u7684\u5ba1\u6279\u7533\u8bf7");
            }
            Integer detailCnt = this.agreementDetailChangeMapper.selectCntByIds(addDetailChangeApplyReqBO.getAgreementId(), addDetailChangeApplyReqBO.getSupplierId());
            if (detailCnt <= 0) {
                throw new BusinessException(null, "\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u6761\u8865\u5145\u534f\u8bae\u660e\u7ec6");
            }
            AgreementChange record = new AgreementChange();
            BeanUtils.copyProperties((Object)addDetailChangeApplyReqBO, (Object)record);
            if (addDetailChangeApplyReqBO.getOperateType().equals(0)) {
                record.setState(0);
            } else {
                record.setState(1);
            }
            record.setIsDelete(0);
            Long changeId = this.generateAgrChangeSeqService.generateAgrChangeSeq().getChangeId();
            record.setChangeId(changeId);
            record.setCreateLoginId(addDetailChangeApplyReqBO.getUserId());
            record.setCreateTime(new Date());
            this.agreementDetailChangeMapper.updateByIds(addDetailChangeApplyReqBO.getAgreementId(), addDetailChangeApplyReqBO.getSupplierId(), addDetailChangeApplyReqBO.getChangeCode(), changeId);
            if (addDetailChangeApplyReqBO.getAgrAttach() != null && addDetailChangeApplyReqBO.getAgrAttach().size() > 0) {
                AgreementChangeAttach att = null;
                LinkedList<AgreementChangeAttach> supplierAgreementAttaches = new LinkedList<AgreementChangeAttach>();
                for (AgrAttachChgVo vo : addDetailChangeApplyReqBO.getAgrAttach()) {
                    att = new AgreementChangeAttach();
                    att.setCreateLoginId(addDetailChangeApplyReqBO.getUserId());
                    att.setCreateTime(new Date());
                    att.setAgreementId(addDetailChangeApplyReqBO.getAgreementId());
                    att.setChangeCode(addDetailChangeApplyReqBO.getChangeCode());
                    att.setSupplierId(addDetailChangeApplyReqBO.getSupplierId());
                    att.setChangeId(changeId);
                    att.setAttachmentAddr(vo.getAttachmentAddr());
                    att.setAttachmentName(vo.getAttachmentName());
                    att.setIsDelete(0);
                    supplierAgreementAttaches.add(att);
                }
                this.agreementChangeAttachMapper.batchAddAgrChgAttachs(supplierAgreementAttaches);
            }
            if (addDetailChangeApplyReqBO.getOperateType().equals(1)) {
                AgreementChangeBO agreementChangeBO = new AgreementChangeBO();
                BeanUtils.copyProperties((Object)addDetailChangeApplyReqBO, (Object)agreementChangeBO);
                agreementChangeBO.setChangeId(changeId);
                agreementChangeBO.setUserId(addDetailChangeApplyReqBO.getOperatorId());
                agreementChangeBO.setUserName(addDetailChangeApplyReqBO.getOperator());
                AgreementApproveTaskStartRspBO agreementApproveTaskStartRspBO = this.agreementApproveTaskService.executeAgreementApproveTaskStartUp(agreementChangeBO);
                if (agreementApproveTaskStartRspBO.getRespCode().equals("0000")) {
                    record.setProcInstlId(agreementApproveTaskStartRspBO.getProcInstId());
                } else {
                    throw new BusinessException(agreementApproveTaskStartRspBO.getRespCode(), agreementApproveTaskStartRspBO.getRespDesc());
                }
            }
            this.agreementChangeMapper.insert(record);
            rsp.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u8865\u5145\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            rsp.setSuccess(false);
            rsp.setResultMsg("\u65b0\u589e\u8865\u5145\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u589e\u8865\u5145\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }
}

