/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.commodity.dao.EMdmMaterialMapper;
import com.cgd.commodity.po.CommodityTypePO;
import com.cgd.commodity.po.EMdmMaterial;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.gd.commodity.busi.QryAgrAddChangeService;
import com.gd.commodity.busi.bo.agreement.QryAgrAddChangeReqBO;
import com.gd.commodity.busi.bo.agreement.QryAgrAddChangeRspBO;
import com.gd.commodity.busi.vo.agreement.AgrAdjustPriceFormulaChangeVO;
import com.gd.commodity.dao.AgreementDetailChangeMapper;
import com.gd.commodity.dao.SupplierAgreementMapper;
import com.gd.commodity.po.AgreementDetailChange;
import com.gd.commodity.po.SupplierAgreement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class QryAgrAddChangeServiceImpl
implements QryAgrAddChangeService {
    private static final Logger logger = LoggerFactory.getLogger(QryAgrAddChangeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementDetailChangeMapper agreementDetailChangeMapper;
    private SupplierAgreementMapper supplierAgreementMapper;
    private EMdmMaterialMapper eMdmMaterialMapper;

    public void setAgreementDetailChangeMapper(AgreementDetailChangeMapper agreementDetailChangeMapper) {
        this.agreementDetailChangeMapper = agreementDetailChangeMapper;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void seteMdmMaterialMapper(EMdmMaterialMapper eMdmMaterialMapper) {
        this.eMdmMaterialMapper = eMdmMaterialMapper;
    }

    public RspPageBO<QryAgrAddChangeRspBO> qryAgrAddChange(QryAgrAddChangeReqBO qryAgrAddChangeReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u534f\u8bae\u53d8\u66f4\u8865\u5145\u7533\u8bf7\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\uff1a" + qryAgrAddChangeReqBO.toString());
        }
        RspPageBO rspPageBO = new RspPageBO();
        try {
            SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(qryAgrAddChangeReqBO.getAgreementId(), qryAgrAddChangeReqBO.getSupplierId());
            Page page = new Page(qryAgrAddChangeReqBO.getPageNo().intValue(), 10000);
            List<Object> qryAgrAddChangePO = new ArrayList();
            qryAgrAddChangePO = qryAgrAddChangeReqBO.getChangeId() != 0L ? this.agreementDetailChangeMapper.selectByAgrId(qryAgrAddChangeReqBO.getChangeId(), qryAgrAddChangeReqBO.getAgreementId(), qryAgrAddChangeReqBO.getSupplierId(), (Page<CommodityTypePO>)page) : this.agreementDetailChangeMapper.selectByAgrIdAndSupplierId(qryAgrAddChangeReqBO.getAgreementId(), qryAgrAddChangeReqBO.getSupplierId(), (Page<CommodityTypePO>)page);
            ArrayList<QryAgrAddChangeRspBO> rows = new ArrayList<QryAgrAddChangeRspBO>();
            ArrayList<String> materialIds = new ArrayList<String>();
            for (int i = 0; i < qryAgrAddChangePO.size(); ++i) {
                QryAgrAddChangeRspBO qryAgrAddChangeRspBO = new QryAgrAddChangeRspBO();
                BeanUtils.copyProperties((Object)qryAgrAddChangePO.get(i), (Object)qryAgrAddChangeRspBO);
                qryAgrAddChangeRspBO.setBuyPrice(MoneyUtil.Long2BigDecimal((Long)((AgreementDetailChange)qryAgrAddChangePO.get(i)).getBuyPrice()));
                qryAgrAddChangeRspBO.setBuyPriceSum(MoneyUtil.Long2BigDecimal((Long)((AgreementDetailChange)qryAgrAddChangePO.get(i)).getBuyPriceSum()));
                qryAgrAddChangeRspBO.setSalePrice(MoneyUtil.Long2BigDecimal((Long)((AgreementDetailChange)qryAgrAddChangePO.get(i)).getSalePrice()));
                qryAgrAddChangeRspBO.setSalePriceSum(MoneyUtil.Long2BigDecimal((Long)((AgreementDetailChange)qryAgrAddChangePO.get(i)).getSalePriceSum()));
                if (qryAgrAddChangeRspBO.getAgrAdjustPriceFormulaChanges() != null && qryAgrAddChangeRspBO.getAgrAdjustPriceFormulaChanges().size() > 0) {
                    for (AgrAdjustPriceFormulaChangeVO agrAdjustPriceFormulaChangeVO : qryAgrAddChangeRspBO.getAgrAdjustPriceFormulaChanges()) {
                        if (agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoValue() == null) continue;
                        agrAdjustPriceFormulaChangeVO.setAgrFormulaInfoValue(MoneyUtil.Long2BigDecimal((Long)agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoValue().longValue()));
                    }
                }
                rows.add(qryAgrAddChangeRspBO);
                if (!StringUtils.isNotBlank((CharSequence)((AgreementDetailChange)qryAgrAddChangePO.get(i)).getMaterialId()) || materialIds.contains(((AgreementDetailChange)qryAgrAddChangePO.get(i)).getMaterialId())) continue;
                materialIds.add(((AgreementDetailChange)qryAgrAddChangePO.get(i)).getMaterialId());
            }
            if (supplierAgreement.getAgreementSrc() != null && supplierAgreement.getAgreementSrc() == 1 && materialIds != null && materialIds.size() > 0) {
                List<EMdmMaterial> eMdmMaterialList = this.eMdmMaterialMapper.selectByCodeList(materialIds);
                block4: for (QryAgrAddChangeRspBO qryAgrAddChangeRspBO : rows) {
                    for (EMdmMaterial eMdmMaterial : eMdmMaterialList) {
                        if (!qryAgrAddChangeRspBO.getMaterialId().equals(eMdmMaterial.getMaterialCode().toString())) continue;
                        qryAgrAddChangeRspBO.setLongDesc(eMdmMaterial.getLongDesc());
                        continue block4;
                    }
                }
            }
            rspPageBO.setRows(rows);
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u534f\u8bae\u53d8\u66f4\u8865\u5145\u7533\u8bf7\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u534f\u8bae\u53d8\u66f4\u8865\u5145\u7533\u8bf7\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rspPageBO;
    }
}

