/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.gd.commodity.busi.QryAgrInfoService;
import com.gd.commodity.busi.bo.agreement.AgrAttach;
import com.gd.commodity.busi.bo.agreement.QryAgrInfoReqBO;
import com.gd.commodity.busi.bo.agreement.QryAgrInfoRspBO;
import com.gd.commodity.busi.vo.agreement.QryAgrAddPricePropRspVO;
import com.gd.commodity.dao.AgreementAddPricePropMapper;
import com.gd.commodity.dao.SupplierAgreementAttachMapper;
import com.gd.commodity.dao.SupplierAgreementMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryAgrInfoServiceImpl
implements QryAgrInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QryAgrInfoServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SupplierAgreementMapper supplierAgreementMapper;
    private SupplierAgreementAttachMapper supplierAgreementAttachMapper;
    private AgreementAddPricePropMapper agreementAddPricePropMapper;

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSupplierAgreementAttachMapper(SupplierAgreementAttachMapper supplierAgreementAttachMapper) {
        this.supplierAgreementAttachMapper = supplierAgreementAttachMapper;
    }

    public void setAgreementAddPricePropMapper(AgreementAddPricePropMapper agreementAddPricePropMapper) {
        this.agreementAddPricePropMapper = agreementAddPricePropMapper;
    }

    public QryAgrInfoRspBO qryAgrInfo(QryAgrInfoReqBO qryAgrInfoReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u534f\u8bae\u4e3b\u4f53\u5185\u5bb9\u548c\u9644\u4ef6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryAgrInfoReqBO.toString());
        }
        QryAgrInfoRspBO qryAgrInfoRspBO = new QryAgrInfoRspBO();
        try {
            qryAgrInfoRspBO = this.supplierAgreementMapper.getAgreementInfo(qryAgrInfoReqBO.getAgrId(), qryAgrInfoReqBO.getSupplierId());
            List<AgrAttach> agrAttach = this.supplierAgreementAttachMapper.qryAgrAttach(qryAgrInfoReqBO.getAgrId(), qryAgrInfoReqBO.getSupplierId());
            qryAgrInfoRspBO.setAgrAttach(agrAttach);
            List<QryAgrAddPricePropRspVO> agrAddPriceProps = this.agreementAddPricePropMapper.selectAddPriceDetailById(qryAgrInfoReqBO.getAgrId(), qryAgrInfoReqBO.getSupplierId());
            qryAgrInfoRspBO.setAgrAddPriceProps(agrAddPriceProps);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u534f\u8bae\u4e3b\u4f53\u5185\u5bb9\u548c\u9644\u4ef6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u534f\u8bae\u4e3b\u4f53\u5185\u5bb9\u548c\u9644\u4ef6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return qryAgrInfoRspBO;
    }
}

