/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.intfce.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.cgd.base.util.JsonUtils;
import com.cgd.commodity.busi.BusiAttributeChangeService;
import com.cgd.commodity.busi.CreateSKUService;
import com.cgd.commodity.busi.SkuStateUpdateService;
import com.cgd.commodity.busi.bo.AttributeExtPropChangeVO;
import com.cgd.commodity.busi.bo.BusiAttributeChangeReqBO;
import com.cgd.commodity.busi.bo.BusiAttributeChangeRspBO;
import com.cgd.commodity.busi.bo.BusiInfoSKUReqBO;
import com.cgd.commodity.busi.bo.BusiInfoSKURspBO;
import com.cgd.commodity.busi.bo.SkuPriceUpdateReqBO;
import com.cgd.commodity.busi.bo.SkuPriceUpdateRspBO;
import com.cgd.commodity.busi.bo.SkuStateUpdateReqBO;
import com.cgd.commodity.busi.bo.SkuStateUpdateRspBO;
import com.cgd.commodity.busi.vo.ElectricityParam;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.intfce.bo.SkuChangeReqBO;
import com.cgd.commodity.intfce.bo.SkuChangeRspBO;
import com.cgd.commodity.intfce.vo.SkuChangeReqVO;
import com.cgd.commodity.intfce.vo.SkuChangeRspVO;
import com.cgd.commodity.intfce.vo.SkuInfoChangeReqVO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.electricitysupplier.busi.QrySKUFromInterService;
import com.cgd.electricitysupplier.busi.QrySkuPriceService;
import com.cgd.electricitysupplier.busi.QrySkuStateService;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKURspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySkuPriceReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySkuPriceRspBO;
import com.cgd.electricitysupplier.busi.bo.SkuStateReqBO;
import com.cgd.electricitysupplier.busi.bo.SkuStateRsp;
import com.cgd.electricitysupplier.busi.bo.SkuStateRspBo;
import com.cgd.electricitysupplier.busi.vo.BusiQrySkuPriceRspVO;
import com.ohaotian.commodity.busi.distribute.SkuPriceUpdateExtService;
import com.ohaotian.commodity.intfce.SkuChangeExtService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="skuChangeExtService")
public class SkuChangeExtServiceImpl
implements SkuChangeExtService {
    private static final Logger logger = LoggerFactory.getLogger(SkuChangeExtServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private QrySkuPriceService qrySkuPriceService;
    @Autowired
    private SkuPriceUpdateExtService skuPriceUpdateExtService;
    @Autowired
    private QrySkuStateService qrySkuStateService;
    @Autowired
    private SkuStateUpdateService skuStateUpdateService;
    @Autowired
    private QrySKUFromInterService qrySKUFromInterService;
    @Autowired
    private BusiAttributeChangeService busiAttributeChangeService;
    @Autowired
    private CreateSKUService createSKUService;
    private Properties prop;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SkuChangeRspBO changeSKU(SkuChangeReqBO skuChangeReqBO) {
        if (isDebugEnabled) {
            logger.debug("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff1a" + skuChangeReqBO.toString());
        }
        if (null == skuChangeReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == skuChangeReqBO.getMsgGetType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u6d88\u606f\u7c7b\u578b[msgGetType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (6 == skuChangeReqBO.getMsgGetType()) {
            if (null == skuChangeReqBO.getSkus()) throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1sku\u96c6\u5408[skus]\u4e0d\u80fd\u4e3a\u7a7a");
            if (skuChangeReqBO.getSkus().isEmpty()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1sku\u96c6\u5408[skus]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            if (null == skuChangeReqBO.getSkuInfos()) throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1skuInfo\u96c6\u5408[skuInfos]\u4e0d\u80fd\u4e3a\u7a7a");
            if (skuChangeReqBO.getSkuInfos().isEmpty()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1skuInfo\u96c6\u5408[skuInfos]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        try {
            ArrayList<String> extSkuIds;
            ArrayList<SkuChangeRspVO> results = new ArrayList<SkuChangeRspVO>();
            if (Constant.MSG_GET_TYPE_PRICE.equals(skuChangeReqBO.getMsgGetType())) {
                BusiQrySkuPriceReqBO busiQrySkuPriceReqBO = new BusiQrySkuPriceReqBO();
                busiQrySkuPriceReqBO.setIsExtSku(Boolean.valueOf(true));
                busiQrySkuPriceReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                extSkuIds = new ArrayList<String>();
                for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                    extSkuIds.add(skuInfoChangeReqVO.getExtSkuId());
                }
                busiQrySkuPriceReqBO.setExtSkuIds(extSkuIds);
                BusiQrySkuPriceRspBO busiQrySkuPriceRspBO = this.qrySkuPriceService.qrySkuPrice(busiQrySkuPriceReqBO);
                results.addAll(this.callSkuPriceUpdate(busiQrySkuPriceRspBO, skuChangeReqBO));
            }
            if (Constant.MSG_GET_TYPE_SHELF.equals(skuChangeReqBO.getMsgGetType())) {
                SkuStateReqBO skuStateReqBO = new SkuStateReqBO();
                skuStateReqBO.setIsExtSkuId(Boolean.valueOf(true));
                skuStateReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                extSkuIds = new ArrayList();
                for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                    extSkuIds.add(skuInfoChangeReqVO.getExtSkuId());
                }
                skuStateReqBO.setExtSkuIds(extSkuIds);
                SkuStateRsp skuStateRsp = this.qrySkuStateService.qrySkuStatus(skuStateReqBO);
                results.addAll(this.callSkuStateUpdate(skuStateRsp, skuChangeReqBO));
            }
            if (Constant.MSG_GET_TYPE_SKU.equals(skuChangeReqBO.getMsgGetType())) {
                results.addAll(this.callAddOrDelSku(skuChangeReqBO));
            }
            if (Constant.MSG_GET_TYPE_SKU_SPEC.equals(skuChangeReqBO.getMsgGetType())) {
                results.addAll(this.callExtSkuDetail(skuChangeReqBO));
            }
            SkuChangeRspBO skuChangeRspBO = new SkuChangeRspBO();
            skuChangeRspBO.setIsSuccess(Boolean.valueOf(true));
            skuChangeRspBO.setSkus(results);
            return skuChangeRspBO;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u5931\u8d25" + e);
            SkuChangeRspBO skuChangeRspBO = new SkuChangeRspBO();
            skuChangeRspBO.setIsSuccess(Boolean.valueOf(false));
            skuChangeRspBO.setResultMsg("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u5931\u8d25" + e);
            return skuChangeRspBO;
        }
    }

    private List<SkuChangeRspVO> callSkuPriceUpdate(BusiQrySkuPriceRspBO busiQrySkuPriceRspBO, SkuChangeReqBO skuChangeReqBO) {
        ArrayList<SkuChangeRspVO> skuChangeRspVOs = new ArrayList<SkuChangeRspVO>();
        if ("0000".equals(busiQrySkuPriceRspBO.getRespCode())) {
            SkuChangeRspVO skuChangeRspVO;
            for (Object busiQrySkuPriceRspVO : busiQrySkuPriceRspBO.getSkuPrices()) {
                SkuPriceUpdateReqBO skuPriceUpdateReqBO = new SkuPriceUpdateReqBO();
                skuChangeRspVO = new SkuChangeRspVO();
                try {
                    skuPriceUpdateReqBO.setAgreementPrice(MoneyUtil.BigDecimal2Long((BigDecimal)busiQrySkuPriceRspVO.getPrice()));
                    skuPriceUpdateReqBO.setExtSkuId(busiQrySkuPriceRspVO.getSkuId());
                    skuPriceUpdateReqBO.setMarketPrice(MoneyUtil.BigDecimal2Long((BigDecimal)busiQrySkuPriceRspVO.getEcPrice()));
                    skuPriceUpdateReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                    SkuPriceUpdateRspBO skuPriceUpdateRspBO = this.skuPriceUpdateExtService.skuPriceExtUpdate(skuPriceUpdateReqBO);
                    if ("0000".equals(skuPriceUpdateRspBO.getRespCode())) {
                        if (skuPriceUpdateRspBO.getIsSuccess().booleanValue()) continue;
                        for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                            if (!busiQrySkuPriceRspVO.getSkuId().equals(skuInfoChangeReqVO.getExtSkuId())) continue;
                            skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                            skuChangeRspVO.setExtSkuId(busiQrySkuPriceRspVO.getSkuId());
                            skuChangeRspVO.setErrorMsg(skuPriceUpdateRspBO.getResultMsg());
                            skuChangeRspVOs.add(skuChangeRspVO);
                        }
                        continue;
                    }
                    for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                        if (!busiQrySkuPriceRspVO.getSkuId().equals(skuInfoChangeReqVO.getExtSkuId())) continue;
                        skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                        skuChangeRspVO.setExtSkuId(busiQrySkuPriceRspVO.getSkuId());
                        skuChangeRspVO.setErrorMsg(skuPriceUpdateRspBO.getRespDesc());
                        skuChangeRspVOs.add(skuChangeRspVO);
                    }
                }
                catch (Exception e) {
                    logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
                    skuChangeRspVO.setExtSkuId(busiQrySkuPriceRspVO.getSkuId());
                    skuChangeRspVO.setErrorMsg("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
                    skuChangeRspVOs.add(skuChangeRspVO);
                }
            }
            ArrayList<String> existSkuIds = new ArrayList<String>();
            for (BusiQrySkuPriceRspVO busiQrySkuPriceRspVO : busiQrySkuPriceRspBO.getSkuPrices()) {
                existSkuIds.add(busiQrySkuPriceRspVO.getSkuId());
            }
            for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                if (existSkuIds.contains(skuInfoChangeReqVO.getExtSkuId())) continue;
                skuChangeRspVO = new SkuChangeRspVO();
                skuChangeRspVO.setErrorMsg(busiQrySkuPriceRspBO.getResultMessage());
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVOs.add(skuChangeRspVO);
            }
        } else {
            logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + busiQrySkuPriceRspBO.getRespDesc());
            for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                SkuChangeRspVO skuChangeRspVO = new SkuChangeRspVO();
                skuChangeRspVO.setErrorMsg(busiQrySkuPriceRspBO.getRespDesc());
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVOs.add(skuChangeRspVO);
            }
        }
        return skuChangeRspVOs;
    }

    private List<SkuChangeRspVO> callSkuStateUpdate(SkuStateRsp skuStateRsp, SkuChangeReqBO skuChangeReqBO) {
        ArrayList<SkuChangeRspVO> skuChangeRspVOs = new ArrayList<SkuChangeRspVO>();
        if ("0000".equals(skuStateRsp.getRespCode())) {
            SkuChangeRspVO skuChangeRspVO;
            for (Object skuStateRspBo : skuStateRsp.getSkuStates()) {
                SkuStateUpdateReqBO skuStateUpdateReqBO = new SkuStateUpdateReqBO();
                skuChangeRspVO = new SkuChangeRspVO();
                try {
                    skuStateUpdateReqBO.setExtSkuId(skuStateRspBo.getSku());
                    skuStateUpdateReqBO.setSkuState(skuStateRspBo.getState());
                    skuStateUpdateReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                    SkuStateUpdateRspBO skuStateUpdateRspBO = this.skuStateUpdateService.updateSkuState(skuStateUpdateReqBO);
                    if ("0000".equals(skuStateUpdateRspBO.getRespCode())) {
                        if (skuStateUpdateRspBO.getIsSuccess().booleanValue()) continue;
                        for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                            if (!skuStateRspBo.getSku().equals(skuInfoChangeReqVO.getExtSkuId())) continue;
                            skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                            skuChangeRspVO.setExtSkuId(skuStateRspBo.getSku());
                            skuChangeRspVO.setErrorMsg(skuStateUpdateRspBO.getResultMsg());
                            skuChangeRspVOs.add(skuChangeRspVO);
                        }
                        continue;
                    }
                    skuChangeRspVO.setExtSkuId(skuStateRspBo.getSku());
                    skuChangeRspVO.setErrorMsg(skuStateUpdateRspBO.getRespDesc());
                    skuChangeRspVOs.add(skuChangeRspVO);
                }
                catch (Exception e) {
                    logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5b9a\u65f6\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
                    skuChangeRspVO.setExtSkuId(skuStateRspBo.getSku());
                    skuChangeRspVO.setErrorMsg("\u5546\u54c1\u8c03\u7528\u5b9a\u65f6\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
                    skuChangeRspVOs.add(skuChangeRspVO);
                }
            }
            ArrayList<String> existSkuIds = new ArrayList<String>();
            for (SkuStateRspBo skuStateRspBo : skuStateRsp.getSkuStates()) {
                existSkuIds.add(skuStateRspBo.getSku());
            }
            for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                if (existSkuIds.contains(skuInfoChangeReqVO.getExtSkuId())) continue;
                skuChangeRspVO = new SkuChangeRspVO();
                skuChangeRspVO.setErrorMsg(skuStateRsp.getResultMessage());
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVOs.add(skuChangeRspVO);
            }
        } else {
            logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5b9a\u65f6\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + skuStateRsp.getRespDesc());
            for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                SkuChangeRspVO skuChangeRspVO = new SkuChangeRspVO();
                skuChangeRspVO.setErrorMsg(skuStateRsp.getRespDesc());
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVOs.add(skuChangeRspVO);
            }
        }
        return skuChangeRspVOs;
    }

    private List<SkuChangeRspVO> callAddOrDelSku(SkuChangeReqBO skuChangeReqBO) {
        ArrayList<SkuChangeRspVO> skuChangeRspVOs = new ArrayList<SkuChangeRspVO>();
        for (SkuChangeReqVO skuChangeReqVO : skuChangeReqBO.getSkus()) {
            try {
                SkuChangeRspVO skuChangeRspVO = new SkuChangeRspVO();
                if (1 == skuChangeReqVO.getSkuPoolState()) {
                    BusiInfoSKUReqBO busiInfoSKUReqBO = new BusiInfoSKUReqBO();
                    busiInfoSKUReqBO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                    busiInfoSKUReqBO.setSkuLocation(Integer.valueOf(2));
                    busiInfoSKUReqBO.setSupplierName(this.prop.getProperty("SUPPLIER_NAME_" + skuChangeReqBO.getSupplierId()));
                    busiInfoSKUReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                    BusiInfoSKURspBO busiInfoSKURspBO = this.createSKUService.createSKU(busiInfoSKUReqBO);
                    if ("0000".equals(busiInfoSKURspBO.getRespCode())) {
                        if (!busiInfoSKURspBO.getIsSuccess().booleanValue()) {
                            skuChangeRspVO.setExtSkuChangeId(skuChangeRspVO.getExtSkuChangeId());
                            skuChangeRspVO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                            skuChangeRspVO.setErrorMsg(busiInfoSKURspBO.getResultDesc());
                            skuChangeRspVOs.add(skuChangeRspVO);
                        }
                    } else {
                        skuChangeRspVO.setExtSkuChangeId(skuChangeReqVO.getExtSkuChangeId());
                        skuChangeRspVO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                        skuChangeRspVO.setErrorMsg(busiInfoSKURspBO.getRespDesc());
                        skuChangeRspVOs.add(skuChangeRspVO);
                    }
                }
                if (2 != skuChangeReqVO.getSkuPoolState()) continue;
                SkuStateUpdateReqBO skuStateUpdateReqBO = new SkuStateUpdateReqBO();
                skuStateUpdateReqBO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                skuStateUpdateReqBO.setSkuState(Constant.SKU_STATUS_INVALID);
                skuStateUpdateReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                SkuStateUpdateRspBO skuStateUpdateRspBO = this.skuStateUpdateService.updateSkuState(skuStateUpdateReqBO);
                if ("0000".equals(skuStateUpdateRspBO.getRespCode())) {
                    if (skuStateUpdateRspBO.getIsSuccess().booleanValue()) continue;
                    skuChangeRspVO.setExtSkuChangeId(skuChangeReqVO.getExtSkuChangeId());
                    skuChangeRspVO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                    skuChangeRspVO.setErrorMsg(skuStateUpdateRspBO.getResultMsg());
                    skuChangeRspVOs.add(skuChangeRspVO);
                    continue;
                }
                skuChangeRspVO.setExtSkuChangeId(skuChangeReqVO.getExtSkuChangeId());
                skuChangeRspVO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                skuChangeRspVO.setErrorMsg(skuStateUpdateRspBO.getRespDesc());
                skuChangeRspVOs.add(skuChangeRspVO);
            }
            catch (Exception e) {
                logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u6267\u884c\u5546\u54c1\u6dfb\u52a0\u5220\u9664\u5931\u8d25\uff1a" + e);
                SkuChangeRspVO skuChangeRspVO = new SkuChangeRspVO();
                skuChangeRspVO.setExtSkuChangeId(skuChangeReqVO.getExtSkuChangeId());
                skuChangeRspVO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                skuChangeRspVO.setErrorMsg("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u6267\u884c\u5546\u54c1\u6dfb\u52a0\u5220\u9664\u5931\u8d25\uff1a" + e);
                skuChangeRspVOs.add(skuChangeRspVO);
            }
        }
        return skuChangeRspVOs;
    }

    private List<SkuChangeRspVO> callExtSkuDetail(SkuChangeReqBO skuChangeReqBO) {
        ArrayList<SkuChangeRspVO> skuChangeRspVOs = new ArrayList<SkuChangeRspVO>();
        for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
            SkuChangeRspVO skuChangeRspVO = new SkuChangeRspVO();
            try {
                BusiQrySKUReqBO busiQrySKUReqBO = new BusiQrySKUReqBO();
                busiQrySKUReqBO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                busiQrySKUReqBO.setIsExtSkuId(Boolean.valueOf(true));
                busiQrySKUReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                if (1L == skuChangeReqBO.getSupplierId()) {
                    busiQrySKUReqBO.setPriceFloatRate(Double.valueOf(1.04));
                } else {
                    busiQrySKUReqBO.setPriceFloatRate(Double.valueOf(1.04));
                }
                BusiQrySKURspBO busiQrySKURspBO = this.qrySKUFromInterService.qrySKUInfo(busiQrySKUReqBO);
                if ("0000".equals(busiQrySKURspBO.getRespCode()) && !StringUtils.isEmpty((CharSequence)busiQrySKURspBO.getSku())) {
                    BusiAttributeChangeRspBO busiAttributeChangeRspBO;
                    BusiAttributeChangeReqBO busiAttributeChangeReqBO = new BusiAttributeChangeReqBO();
                    busiAttributeChangeReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                    busiAttributeChangeReqBO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                    busiAttributeChangeReqBO.setSkuName(busiQrySKURspBO.getName());
                    busiAttributeChangeReqBO.setBrandName(busiQrySKURspBO.getBrandName());
                    busiAttributeChangeReqBO.setSkuMainPicUrl(busiQrySKURspBO.getImagePath());
                    busiAttributeChangeReqBO.setSkuDetail(busiQrySKURspBO.getIntroduction());
                    busiAttributeChangeReqBO.setPackParam(busiQrySKURspBO.getWareQD());
                    busiAttributeChangeReqBO.setOperatorId(skuChangeReqBO.getOperatorId());
                    busiAttributeChangeReqBO.setMoq(busiQrySKURspBO.getMoq());
                    if (!StringUtils.isEmpty((CharSequence)busiQrySKURspBO.getDeliveryTime())) {
                        busiAttributeChangeReqBO.setPreDeliverDay(Integer.valueOf(busiQrySKURspBO.getDeliveryTime()));
                    }
                    if (!busiQrySKURspBO.getAttribute().isEmpty()) {
                        AttributeExtPropChangeVO extPropBO;
                        ArrayList<AttributeExtPropChangeVO> extPropBOs = new ArrayList<AttributeExtPropChangeVO>();
                        if (Constant.JDSupplierId.intValue() == skuChangeReqBO.getSupplierId().intValue()) {
                            if (null != busiQrySKURspBO.getAttribute()) {
                                for (Map.Entry attributeEntry : busiQrySKURspBO.getAttribute().entrySet()) {
                                    if (!(attributeEntry.getValue() instanceof Map)) continue;
                                    Map propMap = (Map)attributeEntry.getValue();
                                    for (Map.Entry entry : propMap.entrySet()) {
                                        extPropBO = new AttributeExtPropChangeVO();
                                        extPropBO.setExtPropName((String)entry.getKey());
                                        extPropBO.setExtPropValue((String)entry.getValue());
                                        extPropBOs.add(extPropBO);
                                    }
                                }
                            }
                        } else {
                            String params = JSONArray.toJSONString(busiQrySKURspBO.getAttribute().get("param"));
                            if (!"null".equals(params)) {
                                ElectricityParam[] electricityParamArr = (ElectricityParam[])JsonUtils.jsonStringToJavaBean((String)params, ElectricityParam[].class);
                                List<ElectricityParam> electricityParams = Arrays.asList(electricityParamArr);
                                for (ElectricityParam electricityParam : electricityParams) {
                                    extPropBO = new AttributeExtPropChangeVO();
                                    extPropBO.setExtPropName(electricityParam.getAttrName());
                                    extPropBO.setExtPropValue(electricityParam.getAttrValue());
                                    extPropBOs.add(extPropBO);
                                }
                            }
                        }
                        busiAttributeChangeReqBO.setAttributeExtPropChanges(extPropBOs);
                    }
                    if ("0000".equals((busiAttributeChangeRspBO = this.busiAttributeChangeService.updateAttributeChange(busiAttributeChangeReqBO)).getRespCode())) {
                        if (busiAttributeChangeRspBO.getIsSuccess().booleanValue()) continue;
                        skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                        skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                        skuChangeRspVOs.add(skuChangeRspVO);
                        continue;
                    }
                    skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                    skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                    skuChangeRspVO.setErrorMsg(busiAttributeChangeRspBO.getRespDesc());
                    skuChangeRspVOs.add(skuChangeRspVO);
                    continue;
                }
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVO.setErrorMsg("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                skuChangeRspVOs.add(skuChangeRspVO);
            }
            catch (Exception e) {
                logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVO.setErrorMsg("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
                skuChangeRspVOs.add(skuChangeRspVO);
            }
        }
        return skuChangeRspVOs;
    }
}

