/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.atom.GenerateBrandSeqService;
import com.cgd.commodity.atom.bo.GenerateBrandSeqRspBO;
import com.cgd.commodity.busi.AddAgrDetailChangeService;
import com.cgd.commodity.busi.bo.agreement.AddAgrDetailChangeBO;
import com.cgd.commodity.busi.bo.agreement.AddAgrDetailChangeReqBO;
import com.cgd.commodity.busi.bo.agreement.AddAgrDetailChangeRspBO;
import com.cgd.commodity.busi.vo.agreement.AgrAdjustPriceFormulaChangeVO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.AdjustPriceForMulaInfoMapper;
import com.cgd.commodity.dao.AdjustPriceFormulaMapper;
import com.cgd.commodity.dao.AgrAdjustPriceFormulaChangeMapper;
import com.cgd.commodity.dao.AgreementDetailChangeMapper;
import com.cgd.commodity.dao.BrandMapper;
import com.cgd.commodity.dao.CommodityMeasureMapper;
import com.cgd.commodity.dao.EMdmMaterialMapper;
import com.cgd.commodity.intfce.bo.BrandConsumerBO;
import com.cgd.commodity.po.AdjustPriceForMulaInfo;
import com.cgd.commodity.po.AdjustPriceFormula;
import com.cgd.commodity.po.AgrAdjustPriceFormulaChange;
import com.cgd.commodity.po.AgreementDetailChange;
import com.cgd.commodity.po.Brand;
import com.cgd.commodity.po.CommodityMeasure;
import com.cgd.commodity.po.EMdmMaterial;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class AddAgrDetailChangeServiceImpl
implements AddAgrDetailChangeService {
    private static final Logger logger = LoggerFactory.getLogger(AddAgrDetailChangeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementDetailChangeMapper agreementDetailChangeMapper;
    private BrandMapper brandMapper;
    private GenerateBrandSeqService generateBrandSeqService;
    private EMdmMaterialMapper eMdmMaterialMapper;
    private AdjustPriceFormulaMapper adjustPriceFormulaMapper;
    private AgrAdjustPriceFormulaChangeMapper agrAdjustPriceFormulaChangeMapper;
    private AdjustPriceForMulaInfoMapper adjustPriceForMulaInfoMapper;
    private CommodityMeasureMapper commodityMeasureMapper;
    @Resource(name="brandInstServiceProducer")
    private ProxyMessageProducer producerBrand;
    @Value(value="${BRAND_INSERT_TOPIC}")
    private String topicNameBrand;
    @Value(value="${BRAND_INSERT_TOPIC_TAG}")
    private String tagNameBrand;

    public void setAdjustPriceForMulaInfoMapper(AdjustPriceForMulaInfoMapper adjustPriceForMulaInfoMapper) {
        this.adjustPriceForMulaInfoMapper = adjustPriceForMulaInfoMapper;
    }

    public void setAgreementDetailChangeMapper(AgreementDetailChangeMapper agreementDetailChangeMapper) {
        this.agreementDetailChangeMapper = agreementDetailChangeMapper;
    }

    public void setBrandMapper(BrandMapper brandMapper) {
        this.brandMapper = brandMapper;
    }

    public void setGenerateBrandSeqService(GenerateBrandSeqService generateBrandSeqService) {
        this.generateBrandSeqService = generateBrandSeqService;
    }

    public void seteMdmMaterialMapper(EMdmMaterialMapper eMdmMaterialMapper) {
        this.eMdmMaterialMapper = eMdmMaterialMapper;
    }

    public void setAdjustPriceFormulaMapper(AdjustPriceFormulaMapper adjustPriceFormulaMapper) {
        this.adjustPriceFormulaMapper = adjustPriceFormulaMapper;
    }

    public void setAgrAdjustPriceFormulaChangeMapper(AgrAdjustPriceFormulaChangeMapper agrAdjustPriceFormulaChangeMapper) {
        this.agrAdjustPriceFormulaChangeMapper = agrAdjustPriceFormulaChangeMapper;
    }

    public void setCommodityMeasureMapper(CommodityMeasureMapper commodityMeasureMapper) {
        this.commodityMeasureMapper = commodityMeasureMapper;
    }

    public AddAgrDetailChangeRspBO addAgrDetailChange(AddAgrDetailChangeReqBO addAgrDetailChangeReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u65b0\u589e\u8865\u5145\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + addAgrDetailChangeReqBO.toString());
        }
        AddAgrDetailChangeRspBO rsp = new AddAgrDetailChangeRspBO();
        String code = "";
        try {
            if (addAgrDetailChangeReqBO.getAgrDeatailChangeList().size() > 0) {
                for (AddAgrDetailChangeBO agrDetailChange : addAgrDetailChangeReqBO.getAgrDeatailChangeList()) {
                    if (1 != agrDetailChange.getChangeType()) continue;
                    code = agrDetailChange.getMaterialId();
                    EMdmMaterial eMdmMaterial = this.eMdmMaterialMapper.selectByCode(agrDetailChange.getMaterialId());
                    if (null != eMdmMaterial) continue;
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6b64\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728");
                }
            }
        }
        catch (Exception e) {
            logger.error("AddSupplierAgreementSkuServiceImpl========>\u65b0\u589e\u8865\u5145\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7269\u6599\u7f16\u7801" + code + "\u4e0d\u5b58\u5728");
        }
        try {
            ArrayList<AgreementDetailChange> list = new ArrayList<AgreementDetailChange>();
            if (addAgrDetailChangeReqBO != null && addAgrDetailChangeReqBO.getAgrDeatailChangeList().size() > 0) {
                for (AddAgrDetailChangeBO agrDetailChange : addAgrDetailChangeReqBO.getAgrDeatailChangeList()) {
                    Long brandId = this.getBrandId(agrDetailChange);
                    AgreementDetailChange agreementDetailChange = new AgreementDetailChange();
                    BeanUtils.copyProperties((Object)agreementDetailChange, (Object)agrDetailChange);
                    Long agreementDetailChangeSkuSeq = this.agreementDetailChangeMapper.generateAgreementDetailChangeSeq();
                    CommodityMeasure commodityMeasure = this.commodityMeasureMapper.selectByName(agrDetailChange.getMeasureName());
                    if (commodityMeasure != null) {
                        Long measureId = commodityMeasure.getMeasureId();
                        agreementDetailChange.setMeasureId(measureId);
                    }
                    agreementDetailChange.setDetailChangeId(agreementDetailChangeSkuSeq);
                    agreementDetailChange.setBuyPrice(MoneyUtils.BigDecimal2Long((BigDecimal)agrDetailChange.getBuyPrice()));
                    agreementDetailChange.setBuyPriceSum(MoneyUtils.BigDecimal2Long((BigDecimal)agrDetailChange.getBuyPriceSum()));
                    agreementDetailChange.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)agrDetailChange.getSalePrice()));
                    agreementDetailChange.setSalePriceSum(MoneyUtils.BigDecimal2Long((BigDecimal)agrDetailChange.getSalePriceSum()));
                    agreementDetailChange.setBrandId(brandId);
                    agreementDetailChange.setCreateTime(new Date());
                    agreementDetailChange.setCreateLoginId(addAgrDetailChangeReqBO.getUserId());
                    agreementDetailChange.setIsDelete((byte)0);
                    list.add(agreementDetailChange);
                    if (null == addAgrDetailChangeReqBO.getFormulaId()) continue;
                    this.initAgrAdjustPriceFormulaChange(agrDetailChange, addAgrDetailChangeReqBO, agreementDetailChangeSkuSeq);
                }
            }
            this.agreementDetailChangeMapper.insertByList(list);
            rsp.setSuccess(true);
        }
        catch (Exception e) {
            rsp.setSuccess(false);
            logger.error("\u65b0\u589e\u8865\u5145\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u589e\u8865\u5145\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    private Long getBrandId(AddAgrDetailChangeBO agrDetailChange) throws Exception {
        Brand oldBrand = this.brandMapper.selectByName(agrDetailChange.getBrandName());
        Long brandId = 0L;
        if (null == oldBrand) {
            GenerateBrandSeqRspBO generateBrandSeqRspBO = this.generateBrandSeqService.generateBrandSeq();
            brandId = generateBrandSeqRspBO.getBrandId();
            Brand record = new Brand();
            record.setBrandId(generateBrandSeqRspBO.getBrandId());
            record.setBrandName(agrDetailChange.getBrandName());
            record.setEffTime(DelFormatHelper.getNowYearAndMonthDay());
            record.setExpTime(DelFormatHelper.getNowYearAndMonthDay((String)"2050-12-31"));
            record.setBrandStatus(Constant.BRAND_STATUS_OPEN);
            record.setCreateLoginId(agrDetailChange.getUserId());
            record.setCreateTime(new Date());
            record.setIsDelete(Constant.IS_DELETE);
            BrandConsumerBO brandConsumerBO = new BrandConsumerBO();
            BeanUtils.copyProperties((Object)record, (Object)brandConsumerBO);
            this.producerBrand.sendOneway(new ProxyMessage(this.topicNameBrand, this.tagNameBrand, JSONObject.toJSONString((Object)brandConsumerBO)));
        } else {
            brandId = oldBrand.getBrandId();
        }
        return brandId;
    }

    private void initAgrAdjustPriceFormulaChange(AddAgrDetailChangeBO agrDetailChange, AddAgrDetailChangeReqBO addAgrDetailChangeReqBO, Long agreementDetailChangeSkuSeq) {
        try {
            AdjustPriceFormula adjustPriceFormula = this.adjustPriceFormulaMapper.selectByPrimaryKey(addAgrDetailChangeReqBO.getFormulaId());
            if (adjustPriceFormula != null) {
                for (AgrAdjustPriceFormulaChangeVO agrAdjustPriceFormulaChangeVO : agrDetailChange.getAgrAdjustPriceFormulaChanges()) {
                    AgrAdjustPriceFormulaChange agrAdjustPriceFormulaChange = new AgrAdjustPriceFormulaChange();
                    agrAdjustPriceFormulaChange.setDetailChangeId(agreementDetailChangeSkuSeq);
                    agrAdjustPriceFormulaChange.setAgrFormulaName(adjustPriceFormula.getFormulaName());
                    agrAdjustPriceFormulaChange.setAgrFormulaValue(adjustPriceFormula.getFormulaValue());
                    agrAdjustPriceFormulaChange.setAgrCreateComp(adjustPriceFormula.getCreateComp());
                    agrAdjustPriceFormulaChange.setAgrFormulaInfoType(agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoType());
                    agrAdjustPriceFormulaChange.setAgrFormulaInfoFlag(agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoFlag());
                    agrAdjustPriceFormulaChange.setAgrFormulaInfoShowDesc(agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoShowDesc());
                    agrAdjustPriceFormulaChange.setAgrFormulaInfoDesc(agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoDesc());
                    agrAdjustPriceFormulaChange.setAgrFormulaInfoValueType(agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoValueType());
                    agrAdjustPriceFormulaChange.setAgrFormulaInfoValue(MoneyUtils.BigDecimal2Long((BigDecimal)agrAdjustPriceFormulaChangeVO.getAgrFormulaInfoValue()));
                    agrAdjustPriceFormulaChange.setSupplierId(agrDetailChange.getSupplierId());
                    agrAdjustPriceFormulaChange.setCreateLoginId(addAgrDetailChangeReqBO.getUserId());
                    agrAdjustPriceFormulaChange.setCreateTime(new Date());
                    agrAdjustPriceFormulaChange.setIsDelete(Constant.IS_DELETE.byteValue());
                    this.agrAdjustPriceFormulaChangeMapper.insertSelective(agrAdjustPriceFormulaChange);
                }
                Byte formulaInfoType = 1;
                List<AdjustPriceForMulaInfo> adjustPriceForMulaInfos = this.adjustPriceForMulaInfoMapper.selectByFormulaId(addAgrDetailChangeReqBO.getFormulaId(), formulaInfoType);
                if (adjustPriceForMulaInfos != null && adjustPriceForMulaInfos.size() > 0) {
                    for (AdjustPriceForMulaInfo adjustPriceForMulaInfo : adjustPriceForMulaInfos) {
                        AgrAdjustPriceFormulaChange agrAdjustPriceFormulaChange = new AgrAdjustPriceFormulaChange();
                        agrAdjustPriceFormulaChange.setDetailChangeId(agreementDetailChangeSkuSeq);
                        agrAdjustPriceFormulaChange.setAgrFormulaName(adjustPriceFormula.getFormulaName());
                        agrAdjustPriceFormulaChange.setAgrFormulaValue(adjustPriceFormula.getFormulaValue());
                        agrAdjustPriceFormulaChange.setAgrCreateComp(adjustPriceFormula.getCreateComp());
                        agrAdjustPriceFormulaChange.setAgrFormulaInfoType(adjustPriceForMulaInfo.getFormulaInfoType());
                        agrAdjustPriceFormulaChange.setAgrFormulaInfoFlag(adjustPriceForMulaInfo.getFormulaInfoFlag());
                        agrAdjustPriceFormulaChange.setAgrFormulaInfoShowDesc(adjustPriceForMulaInfo.getFormulaInfoShowDesc());
                        agrAdjustPriceFormulaChange.setAgrFormulaInfoDesc(adjustPriceForMulaInfo.getFormulaInfoDesc());
                        agrAdjustPriceFormulaChange.setAgrFormulaInfoValueType(adjustPriceForMulaInfo.getFormulaInfoValueType());
                        agrAdjustPriceFormulaChange.setSupplierId(agrDetailChange.getSupplierId());
                        agrAdjustPriceFormulaChange.setCreateLoginId(addAgrDetailChangeReqBO.getUserId());
                        agrAdjustPriceFormulaChange.setCreateTime(new Date());
                        agrAdjustPriceFormulaChange.setIsDelete(Constant.IS_DELETE.byteValue());
                        this.agrAdjustPriceFormulaChangeMapper.insertSelective(agrAdjustPriceFormulaChange);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u534f\u8bae\u8c03\u4ef7\u516c\u5f0f\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u521d\u59cb\u5316\u534f\u8bae\u8c03\u4ef7\u516c\u5f0f\u5931\u8d25");
        }
    }
}

