/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryWaitOnShelfSkuService;
import com.cgd.commodity.busi.bo.QryWaitOnShelfSkuReqBO;
import com.cgd.commodity.busi.bo.QryWaitOnShelfSkuRspBO;
import com.cgd.commodity.busi.vo.QryWaitOnShelfSkuRspVO;
import com.cgd.commodity.dao.CatalogCommodityTypeMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.SkuApproveDetailLogMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.po.CatalogCommodityType;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QryWaitOnShelfSkuServiceImpl
implements QryWaitOnShelfSkuService {
    private static final Logger logger = LoggerFactory.getLogger(QryWaitOnShelfSkuServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;
    private SkuApproveDetailLogMapper skuApproveDetailLogMapper;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public void setCatalogCommodityTypeMapper(CatalogCommodityTypeMapper catalogCommodityTypeMapper) {
        this.catalogCommodityTypeMapper = catalogCommodityTypeMapper;
    }

    public void setSkuApproveDetailLogMapper(SkuApproveDetailLogMapper skuApproveDetailLogMapper) {
        this.skuApproveDetailLogMapper = skuApproveDetailLogMapper;
    }

    public RspPageBO<QryWaitOnShelfSkuRspBO> qryWaitOnShelfSku(QryWaitOnShelfSkuReqBO qryWaitOnShelfSkuReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5f85\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryWaitOnShelfSkuReqBO.toString());
        }
        if (null == qryWaitOnShelfSkuReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5f85\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.isEmpty((Object)qryWaitOnShelfSkuReqBO.getBrandName())) {
            qryWaitOnShelfSkuReqBO.setBrandName(qryWaitOnShelfSkuReqBO.getBrandName().replaceAll(" ", ""));
        }
        if (!StringUtils.isEmpty((Object)qryWaitOnShelfSkuReqBO.getSkuName())) {
            qryWaitOnShelfSkuReqBO.setSkuName(qryWaitOnShelfSkuReqBO.getSkuName().replaceAll(" ", ""));
        }
        try {
            if (!"-1".equals(qryWaitOnShelfSkuReqBO.getSupplierId()) && !"-1".equals(qryWaitOnShelfSkuReqBO.getGuideCatalogId())) {
                LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
                if (null != qryWaitOnShelfSkuReqBO.getGuideCatalogId()) {
                    List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(qryWaitOnShelfSkuReqBO.getGuideCatalogId());
                    for (CatalogCommodityType catalogCommodityType : catalogs) {
                        commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                    }
                }
                Page page = new Page(qryWaitOnShelfSkuReqBO.getPageNo(), qryWaitOnShelfSkuReqBO.getPageSize());
                List<QryWaitOnShelfSkuRspVO> qryWaitOnShelfSkuRspVOs = this.skuMapper.qryWaitOnShelfSku((Page<QryWaitOnShelfSkuRspVO>)page, qryWaitOnShelfSkuReqBO, commodityTypeIds);
                List<QryWaitOnShelfSkuRspBO> qryWaitOnShelfSkuRspBOs = this.resolveRsp(qryWaitOnShelfSkuRspVOs);
                RspPageBO rspPageBO = new RspPageBO();
                rspPageBO.setRecordsTotal(page.getTotalCount());
                rspPageBO.setTotal(page.getTotalPages());
                rspPageBO.setPageNo(qryWaitOnShelfSkuReqBO.getPageNo());
                rspPageBO.setRows(qryWaitOnShelfSkuRspBOs);
                if (this.isDebugEnabled) {
                    logger.debug("\u67e5\u8be2\u5f85\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + qryWaitOnShelfSkuReqBO.toString());
                }
                return rspPageBO;
            }
            RspPageBO rspPageBO = new RspPageBO();
            rspPageBO.setRecordsTotal(0);
            rspPageBO.setTotal(0);
            rspPageBO.setPageNo(0);
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f85\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5f85\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QryWaitOnShelfSkuRspBO> resolveRsp(List<QryWaitOnShelfSkuRspVO> qryWaitOnShelfSkuRspVOs) throws Exception {
        ArrayList<QryWaitOnShelfSkuRspBO> qryWaitOnShelfSkuRspBOs = new ArrayList<QryWaitOnShelfSkuRspBO>();
        if (!qryWaitOnShelfSkuRspVOs.isEmpty()) {
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            LinkedList<Long> skuIds = new LinkedList<Long>();
            for (QryWaitOnShelfSkuRspVO qryWaitOnShelfSkuRsp : qryWaitOnShelfSkuRspVOs) {
                commodityTypeIds.add(qryWaitOnShelfSkuRsp.getCommodityTypeId());
                skuIds.add(qryWaitOnShelfSkuRsp.getSkuId());
            }
            List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeId(commodityTypeIds);
            List<Long> approveDetailSkuIds = this.skuApproveDetailLogMapper.selectSkuApproveDetailLogBatBySkuId(skuIds);
            for (QryWaitOnShelfSkuRspVO qryWaitOnShelfSkuRspVO : qryWaitOnShelfSkuRspVOs) {
                QryWaitOnShelfSkuRspBO qryWaitOnShelfSkuRspBO = new QryWaitOnShelfSkuRspBO();
                qryWaitOnShelfSkuRspBO = this.getQryWaitOnShelfSkuRspBO(qryWaitOnShelfSkuRspBO, qryWaitOnShelfSkuRspVO);
                if (!catalogMaps.isEmpty()) {
                    for (Map<String, Object> map : catalogMaps) {
                        if (!map.get("commodityTypeId").equals(qryWaitOnShelfSkuRspVO.getCommodityTypeId())) continue;
                        qryWaitOnShelfSkuRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                        qryWaitOnShelfSkuRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                        qryWaitOnShelfSkuRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                    }
                }
                if (!approveDetailSkuIds.isEmpty()) {
                    if (approveDetailSkuIds.contains(qryWaitOnShelfSkuRspVO.getSkuId())) {
                        qryWaitOnShelfSkuRspBO.setIsReject(Integer.valueOf(0));
                    } else {
                        qryWaitOnShelfSkuRspBO.setIsReject(Integer.valueOf(1));
                    }
                } else {
                    qryWaitOnShelfSkuRspBO.setIsReject(Integer.valueOf(1));
                }
                qryWaitOnShelfSkuRspBOs.add(qryWaitOnShelfSkuRspBO);
            }
        }
        return qryWaitOnShelfSkuRspBOs;
    }

    private QryWaitOnShelfSkuRspBO getQryWaitOnShelfSkuRspBO(QryWaitOnShelfSkuRspBO qryWaitOnShelfSkuRspBO, QryWaitOnShelfSkuRspVO qryWaitOnShelfSkuRspVO) throws Exception {
        qryWaitOnShelfSkuRspBO.setSkuId(qryWaitOnShelfSkuRspVO.getSkuId());
        qryWaitOnShelfSkuRspBO.setSkuName(qryWaitOnShelfSkuRspVO.getSkuName());
        qryWaitOnShelfSkuRspBO.setExtSkuId(qryWaitOnShelfSkuRspVO.getExtSkuId());
        qryWaitOnShelfSkuRspBO.setSkuLocation(qryWaitOnShelfSkuRspVO.getSkuLocation());
        qryWaitOnShelfSkuRspBO.setBrandName(qryWaitOnShelfSkuRspVO.getBrandName());
        qryWaitOnShelfSkuRspBO.setSupplierId(qryWaitOnShelfSkuRspVO.getSupplierId());
        qryWaitOnShelfSkuRspBO.setSupplierName(qryWaitOnShelfSkuRspVO.getSupplierName());
        qryWaitOnShelfSkuRspBO.setPublishTime(qryWaitOnShelfSkuRspVO.getPublishTime());
        qryWaitOnShelfSkuRspBO.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)qryWaitOnShelfSkuRspVO.getAgreementPrice()));
        qryWaitOnShelfSkuRspBO.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)qryWaitOnShelfSkuRspVO.getMarketPrice()));
        Double rate = (double)qryWaitOnShelfSkuRspVO.getAgreementPrice().longValue() / (double)qryWaitOnShelfSkuRspVO.getMarketPrice().longValue();
        NumberFormat nFromat = NumberFormat.getPercentInstance();
        String rates = nFromat.format(rate);
        qryWaitOnShelfSkuRspBO.setDiscountRate(rates);
        return qryWaitOnShelfSkuRspBO;
    }
}

