/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.aliyun.opensearch.sdk.dependencies.org.json.JSONException;
import com.cgd.commodity.constant.Constant;
import com.ohaotian.commodity.busi.CmprSKUDimPrcEsService;
import com.ohaotian.commodity.busi.bo.BusiCmprSKUDimPrcEsReqBO;
import com.ohaotian.commodity.busi.bo.BusiCmprSKUDimPrcEsRspBO;
import com.ohaotian.commodity.busi.bo.BusiCmprSKUDimPrcEsRspInfo;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.es.builder.search.SearchRequestBuilderAdapter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;

public class CmprSKUDimPrcEsServiceImpl
implements CmprSKUDimPrcEsService {
    private static final Log log = LogFactory.getLog(CmprSKUDimPrcEsServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private SearchRequestBuilderAdapter searchRequestBuilderAdapter;
    private Properties prop;
    @Resource
    private TransportClient client;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public BusiCmprSKUDimPrcEsRspBO cmprSKUDimPrcsPrc(BusiCmprSKUDimPrcEsReqBO busiCmprSKUDimPrcReqBO) {
        BusiCmprSKUDimPrcEsRspBO bo = new BusiCmprSKUDimPrcEsRspBO();
        if (this.isDebugEnabled) {
            log.debug((Object)("\u6a21\u7cca\u6bd4\u4ef7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiCmprSKUDimPrcReqBO.toString()));
        }
        if (null == busiCmprSKUDimPrcReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6a21\u7cca\u6bd4\u4ef7\u4e1a\u52a1\u670d\u52a1\u5355\u54c1ID[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiCmprSKUDimPrcReqBO.getCommodityTypeId() || "".equals(busiCmprSKUDimPrcReqBO.getCommodityTypeId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6a21\u7cca\u6bd4\u4ef7\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u7c7b\u578bid[commodityTypeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (busiCmprSKUDimPrcReqBO.getUserId() != null) {
            bo.setIsLogin(Boolean.valueOf(true));
        } else {
            bo.setIsLogin(Boolean.valueOf(false));
        }
        ArrayList<BusiCmprSKUDimPrcEsRspInfo> busiCmprSKUDimPrcRspInfos = new ArrayList<BusiCmprSKUDimPrcEsRspInfo>();
        Long skuId = busiCmprSKUDimPrcReqBO.getSkuId();
        Long commodityTypeId = busiCmprSKUDimPrcReqBO.getCommodityTypeId();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (String)skuId.toString()));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (Object)Constant.SKU_STATUS_SHELVED));
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{"d_sku_es_dev"}).setTypes(new String[]{"default"}).setQuery((QueryBuilder)boolQueryBuilder).setFrom(0).setSize(1000).setExplain(true).execute().actionGet();
        SearchHits hits = response.getHits();
        if (hits.getHits().length <= 0) {
            throw new BusinessException("0000", "\u6a21\u7cca\u6bd4\u4ef7\u4e1a\u52a1\u670d\u52a1:[skuId]\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        Map obj = hits.getAt(0).getSource();
        String properties = String.valueOf(obj.get("properties"));
        log.debug((Object)("properties\uff1a" + properties.toString()));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (String)commodityTypeId.toString()));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (Object)Constant.SKU_STATUS_SHELVED));
        response = (SearchResponse)this.client.prepareSearch(new String[]{"d_sku_es_dev"}).setTypes(new String[]{"default"}).setQuery((QueryBuilder)boolQueryBuilder).addSort("sale_price", SortOrder.ASC).addSort("on_shelve_time", SortOrder.DESC).addSort("sold_number", SortOrder.DESC).setFrom(0).setSize(1000).setExplain(true).execute().actionGet();
        hits = response.getHits();
        for (int i = 0; i < hits.getHits().length; ++i) {
            Map objs = hits.getAt(i).getSource();
            Long currSkuId = Long.parseLong(String.valueOf(objs.get("sku_id")));
            if (currSkuId.longValue() == skuId.longValue()) continue;
            BusiCmprSKUDimPrcEsRspInfo busiCmprSKUDimPrcRspInfo = new BusiCmprSKUDimPrcEsRspInfo();
            busiCmprSKUDimPrcRspInfo.setSkuId(currSkuId);
            busiCmprSKUDimPrcRspInfo.setExtSkuId(String.valueOf(objs.get("ext_sku_id")));
            busiCmprSKUDimPrcRspInfo.setSkuName(String.valueOf(objs.get("sku_name")));
            busiCmprSKUDimPrcRspInfo.setSupplierId(Long.valueOf(Long.parseLong(String.valueOf(obj.get("supplier_id")))));
            busiCmprSKUDimPrcRspInfo.setSupplierName(String.valueOf(obj.get("supplier_name")));
            try {
                if (objs.get("market_price") != null) {
                    busiCmprSKUDimPrcRspInfo.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(objs.get("market_price")))));
                }
                if (busiCmprSKUDimPrcReqBO.getUserId() != null) {
                    if (objs.get("agreement_price") != null) {
                        busiCmprSKUDimPrcRspInfo.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(objs.get("agreement_price")))));
                    }
                    if (objs.get("member_price") != null) {
                        busiCmprSKUDimPrcRspInfo.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(objs.get("member_price")))));
                    }
                    if (objs.get("sale_price") != null) {
                        busiCmprSKUDimPrcRspInfo.setSalePrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(objs.get("sale_price")))));
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            busiCmprSKUDimPrcRspInfo.setPriPicAddr(String.valueOf(obj.get("picture_url")));
            busiCmprSKUDimPrcRspInfo.setSoldNumber(new BigDecimal(String.valueOf(obj.get("sold_number"))));
            if (Long.parseLong(String.valueOf(obj.get("on_shelve_time"))) != 0L) {
                busiCmprSKUDimPrcRspInfo.setOnShelveTime(new Date(Long.parseLong(String.valueOf(obj.get("on_shelve_time")))));
            }
            busiCmprSKUDimPrcRspInfos.add(busiCmprSKUDimPrcRspInfo);
        }
        bo.setBusiCmprSKUDimPrcRspInfos(busiCmprSKUDimPrcRspInfos);
        return bo;
    }
}

