/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.cgd.commodity.busi.bo.BusiOnSaleReqBO;
import com.cgd.commodity.busi.bo.BusiOnSaleRspBO;
import com.cgd.commodity.constant.Constant;
import com.ohaotian.commodity.busi.QryOnSaleEsService;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.es.builder.search.SearchRequestBuilderAdapter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QryOnSaleEsServiceImpl
implements QryOnSaleEsService {
    private static final Logger logger = LoggerFactory.getLogger(QryOnSaleEsServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SearchRequestBuilderAdapter searchRequestBuilderAdapter;
    private Properties prop;
    @Resource
    private TransportClient client;

    public void setSearchRequestBuilderAdapter(SearchRequestBuilderAdapter searchRequestBuilderAdapter) {
        this.searchRequestBuilderAdapter = searchRequestBuilderAdapter;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public RspPageBO<BusiOnSaleRspBO> qryOnSale(BusiOnSaleReqBO busiOnSaleReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiOnSaleReqBO.toString());
        }
        if (null == busiOnSaleReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiOnSaleReqBO.getGuideCatalogId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u7c7b\u76ee[guideCatalogId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiOnSaleReqBO.getSkuLocation()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u4f4d\u7f6e\u53c2\u6570[skuLocation]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (!"-1".equals(busiOnSaleReqBO.getSupplierId()) && !"-1".equals(busiOnSaleReqBO.getGuideCatalogId())) {
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (Object)Constant.SKU_STATUS_SHELVED));
                if (busiOnSaleReqBO.getSkuLocation() == 1 || busiOnSaleReqBO.getSkuLocation() == 2) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_location", (Object)busiOnSaleReqBO.getSkuLocation()));
                }
                if (null != busiOnSaleReqBO.getSupplierId()) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)busiOnSaleReqBO.getSupplierId()));
                }
                if (null != busiOnSaleReqBO.getSkuId()) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)busiOnSaleReqBO.getSkuId()));
                }
                if (null != busiOnSaleReqBO.getSkuName()) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_name", (Object)busiOnSaleReqBO.getSkuName().replaceAll(" ", "")));
                }
                if (null != busiOnSaleReqBO.getBrandName()) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"brand_name", (Object)busiOnSaleReqBO.getBrandName().replaceAll(" ", "")));
                }
                if (null != busiOnSaleReqBO.getGuideCatalogId()) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id", (String)(busiOnSaleReqBO.getGuideCatalogId() + "*~~" + "2")));
                }
                SearchResponse response = null;
                if (!StringUtils.isEmpty((Object)busiOnSaleReqBO.getSortName())) {
                    if ("asc".equals(busiOnSaleReqBO.getSortOrder())) {
                        response = (SearchResponse)this.client.prepareSearch(new String[]{"d_sku_es_dev"}).setTypes(new String[]{"default"}).setQuery((QueryBuilder)boolQueryBuilder).setFrom(0).addSort("on_shelve_time", SortOrder.ASC).setSize(1000).setExplain(true).execute().actionGet();
                    }
                    if ("desc".equals(busiOnSaleReqBO.getSortOrder())) {
                        response = (SearchResponse)this.client.prepareSearch(new String[]{"d_sku_es_dev"}).setTypes(new String[]{"default"}).setQuery((QueryBuilder)boolQueryBuilder).setFrom(0).addSort("on_shelve_time", SortOrder.DESC).setSize(1000).setExplain(true).execute().actionGet();
                    }
                } else {
                    response = (SearchResponse)this.client.prepareSearch(new String[]{"d_sku_es_dev"}).setTypes(new String[]{"default"}).setQuery((QueryBuilder)boolQueryBuilder).setFrom(0).addSort("on_shelve_time", SortOrder.DESC).setSize(1000).setExplain(true).execute().actionGet();
                }
                SearchHits hits = response.getHits();
                if (this.isDebugEnabled) {
                    logger.debug("\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u641c\u7d22\u5f15\u64ce\u51fa\u53c2\uff1a" + hits.toString());
                }
                List<BusiOnSaleRspBO> busiOnSaleRspVOs = this.resolveResult(hits);
                RspPageBO rspPageBo = new RspPageBO();
                rspPageBo.setRecordsTotal((int)hits.totalHits);
                boolean pageTotal = false;
                rspPageBo.setRows(busiOnSaleRspVOs);
                return rspPageBo;
            }
            RspPageBO rspPageBo = new RspPageBO();
            rspPageBo.setRecordsTotal(0);
            rspPageBo.setTotal(0);
            rspPageBo.setPageNo(0);
            return rspPageBo;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u9519\uff1a" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
    }

    private List<BusiOnSaleRspBO> resolveResult(SearchHits hits) throws Exception {
        try {
            ArrayList<BusiOnSaleRspBO> list = new ArrayList<BusiOnSaleRspBO>();
            for (int i = 0; i < hits.getHits().length; ++i) {
                Map obj = hits.getAt(i).getSource();
                BusiOnSaleRspBO busiOnSaleRspBO = new BusiOnSaleRspBO();
                busiOnSaleRspBO.setSkuId(Long.valueOf(Long.parseLong(String.valueOf(obj.get("sku_id")))));
                busiOnSaleRspBO.setSkuName(String.valueOf(obj.get("sku_name")));
                busiOnSaleRspBO.setFirstCatalogName(String.valueOf(obj.get("l1_category_name")));
                busiOnSaleRspBO.setSecondCatalogName(String.valueOf(obj.get("l2_category_name")));
                String categoryName3 = String.valueOf(obj.get("l3_category_name"));
                String[] split = categoryName3.split(",");
                String replace = split[0].replace("[", "");
                busiOnSaleRspBO.setThirdCatalogName(replace);
                busiOnSaleRspBO.setBrandName(String.valueOf(obj.get("brand_name")));
                busiOnSaleRspBO.setSupplierId(Long.valueOf(Long.parseLong(String.valueOf(obj.get("supplier_id")))));
                busiOnSaleRspBO.setSupplierName(String.valueOf(obj.get("supplier_name")));
                busiOnSaleRspBO.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(obj.get("market_price")))));
                busiOnSaleRspBO.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(obj.get("agreement_price")))));
                Double rate = Double.parseDouble(String.valueOf(obj.get("agreement_price"))) / Double.parseDouble(String.valueOf(obj.get("market_price")));
                NumberFormat nFromat = NumberFormat.getPercentInstance();
                String rates = nFromat.format(rate);
                busiOnSaleRspBO.setDiscountRate(rates);
                busiOnSaleRspBO.setPublishTime(DelFormatHelper.longToDate((long)Long.parseLong(String.valueOf(obj.get("on_shelve_time")))));
                list.add(busiOnSaleRspBO);
            }
            return list;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u6570\u636e\u51fa\u9519\uff1a" + e);
            throw new RuntimeException("\u89e3\u6790\u54cd\u5e94\u6570\u636e\u51fa\u9519");
        }
    }
}

