/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.cgd.commodity.busi.vo.QueryParam;
import com.ohaotian.commodity.busi.SearchBarEsService;
import com.ohaotian.commodity.busi.bo.SearchBarEsReqBO;
import com.ohaotian.commodity.busi.bo.SearchBarEsRspBO;
import com.ohaotian.commodity.busi.bo.SearchBarEsRspInfo;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Value;

public class SearchBarEsServiceImpl
implements SearchBarEsService {
    private static final Log log = LogFactory.getLog(SearchBarEsServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Resource
    private TransportClient client;
    @Value(value="${es.sku.index.name}")
    private String skuIndexName;
    @Value(value="${es.sku.type.name}")
    private String skuTypeName;

    public SearchBarEsRspBO qryBySearchBar(SearchBarEsReqBO searchBarReqBO) {
        log.info((Object)("\u2026\u2026\u2026\u2026\u2026\u2026\u2026\u2026\u2026\u2026\u2026\u2026\u2026\u2026\u9996\u9875\u5546\u54c1\u641c\u7d22\u2026\u2026\u2026\u2026\u2026\u2026\u2026\u2026" + this.skuIndexName + "&&" + this.skuTypeName));
        SearchBarEsRspBO bo = new SearchBarEsRspBO();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)2));
        if (searchBarReqBO.getQueryLocation() != null && searchBarReqBO.getQueryLocation() != 0) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_location", (Object)searchBarReqBO.getQueryLocation()));
        }
        if (searchBarReqBO.getQueryStr() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)searchBarReqBO.getQueryStr()));
        }
        LinkedList<String> hiddenParamsForRsp = new LinkedList<String>();
        if (searchBarReqBO.getQueryParams() != null) {
            for (int i = 0; i < searchBarReqBO.getQueryParams().size(); ++i) {
                QueryParam param = (QueryParam)searchBarReqBO.getQueryParams().get(i);
                hiddenParamsForRsp.add(param.getFilterId());
                if (param.getFilterId() == "supplier_id_name") {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id_name", (String)param.getFilterName()));
                    continue;
                }
                if (param.getFilterId() == "brand_id_name") {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id_name", (String)param.getFilterName()));
                    continue;
                }
                if (param.getFilterId() != "l3_category_id_name") continue;
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id_name", (String)param.getFilterName()));
            }
        }
        if (searchBarReqBO.getCategoryId() != null && searchBarReqBO.getLevel() != null) {
            if (searchBarReqBO.getLevel() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l1_category_id", (String)searchBarReqBO.getCategoryId()));
            } else if (searchBarReqBO.getLevel() == 2) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l2_category_id", (String)searchBarReqBO.getCategoryId()));
            } else if (searchBarReqBO.getLevel() == 3) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id", (String)(searchBarReqBO.getCategoryId() + "*~~" + 0)));
            }
        }
        SortOrder orderType = SortOrder.DESC;
        if (searchBarReqBO.getOrderType() != null && searchBarReqBO.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "on_shelve_time";
        if (searchBarReqBO.getOrderByColumn() != null) {
            if (searchBarReqBO.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (searchBarReqBO.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (searchBarReqBO.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (searchBarReqBO.getOrderByColumn() == 4) {
                sortField = "discount_rate";
            }
        }
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
        Integer pageNo = 0;
        Integer pageSize = 10;
        if (searchBarReqBO.getPageNo() != null && searchBarReqBO.getPageNo() > 0) {
            pageNo = searchBarReqBO.getPageNo() - 1;
        }
        if (searchBarReqBO.getPageSize() != null && searchBarReqBO.getPageSize() > 0) {
            pageSize = searchBarReqBO.getPageSize();
        }
        SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName, this.skuTypeName}).setQuery((QueryBuilder)boolQueryBuilder).addSort((SortBuilder)sortQuery).setFrom(pageNo.intValue()).setSize(pageSize.intValue()).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_supplier_id_name").field("supplier_id_name")).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_brand_id_name").field("brand_id_name")).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_l3_category_id_name").field("l3_category_id_name")).get();
        ArrayList<SearchBarEsRspInfo> rspInfos = new ArrayList<SearchBarEsRspInfo>();
        SearchBarEsRspInfo rspInfo = new SearchBarEsRspInfo();
        if (searchResponse.getHits().getTotalHits() == 0L) {
            throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u641c\u7d22\u680f\u641c\u7d22\u4e1a\u52a1 \u641c\u7d22\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6216\u641c\u7d22\u6761\u4ef6\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
        for (SearchHit hit : searchResponse.getHits()) {
            System.out.println("----skuid=" + hit.getSource().get("sku_id"));
            rspInfo = new SearchBarEsRspInfo();
            rspInfo.setSkuId(String.valueOf(hit.getSource().get("sku_id")));
            rspInfo.setExtSkuId(String.valueOf(hit.getSource().get("ext_sku_id")));
            rspInfo.setPriPicUrl(String.valueOf(hit.getSource().get("picture_url")));
            rspInfo.setSaleArea(String.valueOf(hit.getSource().get("sale_area")));
            rspInfo.setSkuName(String.valueOf(hit.getSource().get("sku_name")));
            rspInfo.setSkuLocation(String.valueOf(hit.getSource().get("sku_location")));
            rspInfo.setSupplierId(Long.valueOf(Long.parseLong(String.valueOf(hit.getSource().get("supplier_id")))));
            rspInfo.setSupplierName(String.valueOf(hit.getSource().get("supplier_name")));
            try {
                if (hit.getSource().get("market_price") != null) {
                    rspInfo.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(hit.getSource().get("market_price")))));
                }
                if (hit.getSource().get("sale_price") != null) {
                    rspInfo.setSalePrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(hit.getSource().get("sale_price")))));
                }
                if (hit.getSource().get("member_price") != null) {
                    rspInfo.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(hit.getSource().get("member_price")))));
                }
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
            rspInfos.add(rspInfo);
        }
        bo.setQueryStr(searchBarReqBO.getQueryStr());
        bo.setCategoryId(searchBarReqBO.getCategoryId());
        bo.setSupplierId(searchBarReqBO.getSupplierId());
        bo.setQueryLocation(searchBarReqBO.getQueryLocation());
        bo.setPageNo(searchBarReqBO.getPageNo());
        bo.setTotalCount(Long.valueOf(searchResponse.getHits().getTotalHits()));
        bo.setResult(rspInfos);
        if (searchBarReqBO.getUserId() != null) {
            bo.setIsLogin(Boolean.valueOf(true));
        } else {
            bo.setIsLogin(Boolean.valueOf(false));
        }
        LinkedList<QueryParam> testParams = new LinkedList<QueryParam>();
        LinkedList supplierValue = new LinkedList();
        LinkedList brandValue = new LinkedList();
        LinkedList category3Value = new LinkedList();
        System.out.println("group_by_supplier_id");
        Terms groupBySupplierId = (Terms)searchResponse.getAggregations().get("group_by_supplier_id_name");
        QueryParam supplierQP = new QueryParam();
        supplierQP.setFilterId("supplier_id_name");
        supplierQP.setFilterName("\u4f9b\u5e94\u5546");
        groupBySupplierId.getBuckets().forEach(bucket -> {
            supplierValue.add(bucket.getKey().toString());
            supplierQP.setFilterValues(supplierValue);
        });
        if (supplierValue != null && supplierValue.size() > 0 && !hiddenParamsForRsp.contains("supplier_id_name")) {
            testParams.add(supplierQP);
        }
        System.out.println("group_by_brand_id");
        Terms groupByBrandId = (Terms)searchResponse.getAggregations().get("group_by_brand_id_name");
        QueryParam brandQP = new QueryParam();
        brandQP.setFilterId("brand_id_name");
        brandQP.setFilterName("\u54c1\u724c");
        groupByBrandId.getBuckets().forEach(bucket -> {
            brandValue.add(bucket.getKey().toString());
            brandQP.setFilterValues(brandValue);
        });
        if (brandValue != null && brandValue.size() > 0 && !hiddenParamsForRsp.contains("brand_id_name")) {
            testParams.add(brandQP);
        }
        Terms groupByCategory3Id = (Terms)searchResponse.getAggregations().get("group_by_l3_category_id_name");
        QueryParam category3IdQP = new QueryParam();
        category3IdQP.setFilterId("l3_category_id_name");
        category3IdQP.setFilterName("\u5206\u7c7b");
        groupByCategory3Id.getBuckets().forEach(bucket -> {
            String[] values;
            String value = bucket.getKey().toString();
            if (value != null && value != "" && value.contains("*~~") && (values = value.split("\\*~~")).length > 2 && !values[2].equals("0")) {
                value = values[0] + "*~~" + values[1];
            }
            category3Value.add(value);
            category3IdQP.setFilterValues(category3Value);
        });
        if (category3Value != null && category3Value.size() > 0 && !hiddenParamsForRsp.contains("l3_category_id_name")) {
            testParams.add(category3IdQP);
        }
        bo.setQueryParams(testParams);
        return bo;
    }
}

