/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryChangeCodeService;
import com.cgd.commodity.busi.bo.agreement.QryChangeCodeServiceReqBO;
import com.cgd.commodity.busi.bo.agreement.QryChangeCodeServiceRspBO;
import com.cgd.commodity.dao.AgreementChangeMapper;
import com.cgd.manage.dic.dict.po.DicDictionary;
import com.cgd.user.dictionary.intfce.SelectDicValByPcodeAndCode;
import com.cgd.user.dictionary.intfce.bo.SelectSingleDictReqBO;
import com.cgd.user.dictionary.intfce.bo.SelectSingleDictRspBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryChangeCodeServiceImpl
implements QryChangeCodeService {
    private static final Logger logger = LoggerFactory.getLogger(QryChangeCodeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementChangeMapper agreementChangeMapper;
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;

    public QryChangeCodeServiceRspBO qryChangeCode(QryChangeCodeServiceReqBO qryChangeCodeServiceReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u83b7\u53d6\u7533\u8bf7\u7f16\u53f7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryChangeCodeServiceReqBO.toString());
        }
        QryChangeCodeServiceRspBO rsp = new QryChangeCodeServiceRspBO();
        Long maxNum = 1L;
        try {
            String changeCode2;
            List<String> list = this.agreementChangeMapper.selectChangeCodeByIdAndType(qryChangeCodeServiceReqBO.getAgreementId(), qryChangeCodeServiceReqBO.getChangeType(), qryChangeCodeServiceReqBO.getSupplierId());
            ArrayList<Long> serialNumList = new ArrayList<Long>();
            if (list != null && list.size() > 0) {
                for (String changeCode2 : list) {
                    if (changeCode2.length() <= 4) continue;
                    Long num = Long.parseLong(changeCode2.substring(changeCode2.length() - 4));
                    serialNumList.add(num);
                }
                if (serialNumList != null && serialNumList.size() > 0) {
                    maxNum = (Long)Collections.max(serialNumList);
                }
            }
            String chageTypeInitials = this.getChageTypeInitials(qryChangeCodeServiceReqBO);
            changeCode2 = "";
            if (maxNum != null && maxNum < 10000L) {
                String str_m = maxNum.toString();
                String str = "0000";
                str_m = str.substring(0, 4 - str_m.length()) + str_m;
                changeCode2 = qryChangeCodeServiceReqBO.getAgreementCode() + "-" + chageTypeInitials + "-" + str_m;
            } else if (maxNum >= 10000L) {
                throw new BusinessException("RSP_CODE_INDEX_OUT", "\u6d41\u6c34\u53f7\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc710000");
            }
            rsp.setChangeCode(changeCode2);
            rsp.setSuccess(true);
        }
        catch (Exception e) {
            if (maxNum >= 10000L) {
                rsp.setResultMsg("\u6d41\u6c34\u53f7\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc710000");
                rsp.setSuccess(false);
                throw new BusinessException("RSP_CODE_INDEX_OUT", "\u6d41\u6c34\u53f7\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc710000");
            }
            logger.error("\u83b7\u53d6\u53d8\u66f4\u7533\u8bf7\u7f16\u53f7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            rsp.setResultMsg("\u83b7\u53d6\u53d8\u66f4\u7533\u8bf7\u7f16\u53f7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
            rsp.setSuccess(false);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u83b7\u53d6\u53d8\u66f4\u7533\u8bf7\u7f16\u53f7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    private String getChageTypeInitials(QryChangeCodeServiceReqBO qryChangeCodeServiceReqBO) {
        String chageTypeInitials = "";
        SelectSingleDictReqBO selectSingleDictReqBO = new SelectSingleDictReqBO();
        selectSingleDictReqBO.setPcode("AGREEMENT_CHANGE_TYPE_INITIALS");
        selectSingleDictReqBO.setCode(qryChangeCodeServiceReqBO.getChangeType().toString());
        SelectSingleDictRspBO selectSingleDictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(selectSingleDictReqBO);
        DicDictionary dicDictionary = selectSingleDictRspBO.getDicDictionarys();
        if (dicDictionary != null) {
            chageTypeInitials = dicDictionary.getTitle();
        }
        return chageTypeInitials;
    }

    public void setAgreementChangeMapper(AgreementChangeMapper agreementChangeMapper) {
        this.agreementChangeMapper = agreementChangeMapper;
    }

    public void setSelectDicValByPcodeAndCode(SelectDicValByPcodeAndCode selectDicValByPcodeAndCode) {
        this.selectDicValByPcodeAndCode = selectDicValByPcodeAndCode;
    }
}

