/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryPubedSkusByAgrIdService;
import com.cgd.commodity.busi.bo.supply.QryPubedSkusByAgrIdReqBO;
import com.cgd.commodity.busi.bo.supply.QryPubedSkusByAgrIdRspBO;
import com.cgd.commodity.busi.vo.supply.QryPubedSkusByAgrIdRspVO;
import com.cgd.commodity.dao.CatalogCommodityTypeMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.po.CatalogCommodityType;
import com.cgd.commodity.po.SupplierAgreement;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryPubedSkusByAgrIdServiceImpl
implements QryPubedSkusByAgrIdService {
    private static final Logger logger = LoggerFactory.getLogger(QryPubedSkusByAgrIdServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;
    private SkuMapper skuMapper;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    private SupplierAgreementMapper supplierAgreementMapper;

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setCatalogCommodityTypeMapper(CatalogCommodityTypeMapper catalogCommodityTypeMapper) {
        this.catalogCommodityTypeMapper = catalogCommodityTypeMapper;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public RspPageBO<QryPubedSkusByAgrIdRspBO> qryPubedSkusByAgrId(QryPubedSkusByAgrIdReqBO qryPubedSkusByAgrIdReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryPubedSkusByAgrIdReqBO.toString());
        }
        try {
            int indexOf;
            String skuName;
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            if (null != qryPubedSkusByAgrIdReqBO.getCatalogId()) {
                List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(qryPubedSkusByAgrIdReqBO.getCatalogId());
                for (CatalogCommodityType catalogCommodityType : catalogs) {
                    commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                }
            }
            if ((skuName = qryPubedSkusByAgrIdReqBO.getSkuName()) != null && !"".equals(skuName) && (indexOf = skuName.indexOf(92)) != -1) {
                String name = skuName.replaceAll("\\\\", "\\\\\\\\");
                qryPubedSkusByAgrIdReqBO.setSkuName(name);
            }
            Page page = new Page(qryPubedSkusByAgrIdReqBO.getPageNo(), qryPubedSkusByAgrIdReqBO.getPageSize());
            SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(qryPubedSkusByAgrIdReqBO.getAgreementId(), qryPubedSkusByAgrIdReqBO.getSupplierId());
            List<QryPubedSkusByAgrIdRspVO> qryPubedSkuRspVOs = this.skuMapper.qryPubedSkusByAgrId((Page<QryPubedSkusByAgrIdReqBO>)page, qryPubedSkusByAgrIdReqBO, commodityTypeIds, supplierAgreement.getAgreementStatus());
            List<QryPubedSkusByAgrIdRspBO> qryPubedSkuRspBOs = this.resolveRsp(qryPubedSkuRspVOs, qryPubedSkusByAgrIdReqBO, supplierAgreement);
            RspPageBO rspPageBO = new RspPageBO();
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qryPubedSkusByAgrIdReqBO.getPageNo());
            rspPageBO.setRows(qryPubedSkuRspBOs);
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QryPubedSkusByAgrIdRspBO> resolveRsp(List<QryPubedSkusByAgrIdRspVO> qryPubedSkuRspVOs, QryPubedSkusByAgrIdReqBO qryPubedSkusByAgrIdReqBO, SupplierAgreement supplierAgreement) throws Exception {
        try {
            ArrayList<QryPubedSkusByAgrIdRspBO> qryPubSkuRspBOs = new ArrayList<QryPubedSkusByAgrIdRspBO>();
            if (!qryPubedSkuRspVOs.isEmpty()) {
                LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
                for (QryPubedSkusByAgrIdRspVO qryPubedSkusByAgrIdRspVO : qryPubedSkuRspVOs) {
                    commodityTypeIds.add(qryPubedSkusByAgrIdRspVO.getCommodityTypeId());
                }
                List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeIdAndLocation(commodityTypeIds);
                for (QryPubedSkusByAgrIdRspVO qryPubedSkusByAgrIdRspVO : qryPubedSkuRspVOs) {
                    QryPubedSkusByAgrIdRspBO qryPubedSkusByAgrIdRspBO = new QryPubedSkusByAgrIdRspBO();
                    qryPubedSkusByAgrIdRspBO = this.getQryPubSkuRspBO(qryPubedSkusByAgrIdRspBO, qryPubedSkusByAgrIdRspVO, supplierAgreement);
                    if (!catalogMaps.isEmpty()) {
                        for (Map<String, Object> map : catalogMaps) {
                            if (!map.get("commodityTypeId").equals(qryPubedSkusByAgrIdRspVO.getCommodityTypeId())) continue;
                            qryPubedSkusByAgrIdRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                            qryPubedSkusByAgrIdRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                            qryPubedSkusByAgrIdRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                        }
                    }
                    qryPubSkuRspBOs.add(qryPubedSkusByAgrIdRspBO);
                }
            }
            return qryPubSkuRspBOs;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25");
        }
    }

    private QryPubedSkusByAgrIdRspBO getQryPubSkuRspBO(QryPubedSkusByAgrIdRspBO qryPubedSkusByAgrIdRspBO, QryPubedSkusByAgrIdRspVO qryPubedSkusByAgrIdRspVO, SupplierAgreement supplierAgreement) {
        try {
            qryPubedSkusByAgrIdRspBO.setAgreementId(qryPubedSkusByAgrIdRspVO.getAgreementId());
            qryPubedSkusByAgrIdRspBO.setAgreementSkuId(qryPubedSkusByAgrIdRspVO.getAgreementSkuId());
            qryPubedSkusByAgrIdRspBO.setBrandName(qryPubedSkusByAgrIdRspVO.getBrandName());
            if (null != qryPubedSkusByAgrIdRspVO.getMarketPrice()) {
                qryPubedSkusByAgrIdRspBO.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)qryPubedSkusByAgrIdRspVO.getMarketPrice()));
            }
            qryPubedSkusByAgrIdRspBO.setSkuId(qryPubedSkusByAgrIdRspVO.getSkuId());
            qryPubedSkusByAgrIdRspBO.setSkuName(qryPubedSkusByAgrIdRspVO.getSkuName());
            if (4 == supplierAgreement.getAgreementStatus()) {
                qryPubedSkusByAgrIdRspBO.setSkuStatus(qryPubedSkusByAgrIdRspVO.getSkuStatus());
            }
            Byte status = 9;
            if (3 == supplierAgreement.getAgreementStatus()) {
                qryPubedSkusByAgrIdRspBO.setSkuStatus(status);
            }
            if (5 == supplierAgreement.getAgreementStatus()) {
                qryPubedSkusByAgrIdRspBO.setSkuStatus(status);
            }
            if (6 == supplierAgreement.getAgreementStatus()) {
                qryPubedSkusByAgrIdRspBO.setSkuStatus(status);
            }
            if (7 == supplierAgreement.getAgreementStatus()) {
                qryPubedSkusByAgrIdRspBO.setSkuStatus(status);
            }
            qryPubedSkusByAgrIdRspBO.setSupplierId(qryPubedSkusByAgrIdRspVO.getSupplierId());
            qryPubedSkusByAgrIdRspBO.setSupplierName(qryPubedSkusByAgrIdRspVO.getSupplierName());
            qryPubedSkusByAgrIdRspBO.setVendorId(qryPubedSkusByAgrIdRspVO.getVendorId());
            qryPubedSkusByAgrIdRspBO.setVendorName(qryPubedSkusByAgrIdRspVO.getVendorName());
            return qryPubedSkusByAgrIdRspBO;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u54cd\u5e94\u5b9e\u4f53\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u521d\u59cb\u5316\u54cd\u5e94\u5b9e\u4f53\u5931\u8d25");
        }
    }
}

