/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.user.org.busi.QryLittleActOrgByUserBusiService;
import com.cgd.user.org.busi.bo.QryLittleActOrgByUserReqBO;
import com.cgd.user.org.busi.bo.QryLittleActOrgByUserRspBO;
import com.cgd.user.org.busi.bo.UserOrganisationBO;
import com.gd.commodity.busi.QryAgrsByCurrUserService;
import com.gd.commodity.busi.bo.agreement.QryAgrsByCurrUserReqBO;
import com.gd.commodity.busi.bo.agreement.QryAgrsByCurrUserRspBO;
import com.gd.commodity.dao.AgreementScopeMapper;
import com.gd.commodity.dao.SupplierAgreementMapper;
import com.gd.commodity.dao.SupplierAgreementSkuMapper;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QryAgrsByCurrUserServiceImpl
implements QryAgrsByCurrUserService {
    private static final Logger logger = LoggerFactory.getLogger(QryAgrsByCurrUserServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private QryLittleActOrgByUserBusiService qryLittleActOrgByUserBusiService;
    private AgreementScopeMapper agreementScopeMapper;
    private SupplierAgreementMapper supplierAgreementMapper;
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;

    public void setQryLittleActOrgByUserBusiService(QryLittleActOrgByUserBusiService qryLittleActOrgByUserBusiService) {
        this.qryLittleActOrgByUserBusiService = qryLittleActOrgByUserBusiService;
    }

    public void setAgreementScopeMapper(AgreementScopeMapper agreementScopeMapper) {
        this.agreementScopeMapper = agreementScopeMapper;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSupplierAgreementSkuMapper(SupplierAgreementSkuMapper supplierAgreementSkuMapper) {
        this.supplierAgreementSkuMapper = supplierAgreementSkuMapper;
    }

    public RspPageBO<QryAgrsByCurrUserRspBO> qryAgrsByCurrUser(QryAgrsByCurrUserReqBO qryAgrsByCurrUserReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237\u67e5\u8be2\u5546\u57ce\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryAgrsByCurrUserReqBO.toString());
        }
        if (null == qryAgrsByCurrUserReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == qryAgrsByCurrUserReqBO.getAgreementSrc()) {
            Byte agrSrc = 1;
            qryAgrsByCurrUserReqBO.setAgreementSrc(agrSrc);
        }
        QryLittleActOrgByUserRspBO qryLittleActOrgByUserRspBO = this.getUserLittleActOrg(qryAgrsByCurrUserReqBO.getUserId());
        List<Long> agreementIds = this.getAgreementIds(qryLittleActOrgByUserRspBO);
        try {
            RspPageBO rspPageBO = new RspPageBO();
            if (!agreementIds.isEmpty()) {
                if (!StringUtils.isEmpty((Object)qryAgrsByCurrUserReqBO.getMaterialId())) {
                    agreementIds = this.supplierAgreementSkuMapper.qryAgrIdsByIdsAndMaterialName(agreementIds, qryAgrsByCurrUserReqBO.getMaterialId());
                }
                Page page = new Page(qryAgrsByCurrUserReqBO.getPageNo(), qryAgrsByCurrUserReqBO.getPageSize());
                if (!agreementIds.isEmpty()) {
                    List<QryAgrsByCurrUserRspBO> results = this.supplierAgreementMapper.qryBySelectCondition((Page<QryAgrsByCurrUserReqBO>)page, agreementIds, qryAgrsByCurrUserReqBO);
                    rspPageBO.setRecordsTotal(page.getTotalCount());
                    rspPageBO.setTotal(page.getTotalPages());
                    rspPageBO.setPageNo(qryAgrsByCurrUserReqBO.getPageNo());
                    rspPageBO.setRows(results);
                    return rspPageBO;
                }
            }
            rspPageBO.setRecordsTotal(0);
            rspPageBO.setTotal(0);
            rspPageBO.setPageNo(qryAgrsByCurrUserReqBO.getPageNo());
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237\u67e5\u8be2\u5546\u57ce\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237\u67e5\u8be2\u5546\u57ce\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private QryLittleActOrgByUserRspBO getUserLittleActOrg(Long userId) {
        try {
            QryLittleActOrgByUserReqBO qryLittleActOrgByUserReqBO = new QryLittleActOrgByUserReqBO();
            qryLittleActOrgByUserReqBO.setUserParamId(userId);
            return this.qryLittleActOrgByUserBusiService.qryLittleActOrgByUser(qryLittleActOrgByUserReqBO);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237\u67e5\u8be2\u5546\u57ce\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6839\u636e\u7528\u6237\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u3001\u9879\u76ee\u5355\u4f4d\u4fe1\u606f\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u6839\u636e\u7528\u6237\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u3001\u9879\u76ee\u5355\u4f4d\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<Long> getAgreementIds(QryLittleActOrgByUserRspBO qryLittleActOrgByUserRspBO) {
        try {
            ArrayList<Long> agreementIds = new ArrayList<Long>();
            if ("0000".equals(qryLittleActOrgByUserRspBO.getRespCode())) {
                Long provId = qryLittleActOrgByUserRspBO.getProvId();
                Long trade = qryLittleActOrgByUserRspBO.getTrade();
                UserOrganisationBO branchComp = qryLittleActOrgByUserRspBO.getBranchComp();
                UserOrganisationBO projectComp = qryLittleActOrgByUserRspBO.getProjectComp();
                Long orgId = null;
                List<Long> ids = null;
                if (qryLittleActOrgByUserRspBO.getProvId() != null && (ids = this.agreementScopeMapper.selectAgreementIdsByScopeCode(orgId = provId, 1L)).size() > 0) {
                    agreementIds.addAll(ids);
                }
                if (qryLittleActOrgByUserRspBO.getTrade() != null && (ids = this.agreementScopeMapper.selectAgreementIdsByScopeCode(orgId = trade, 2L)).size() > 0) {
                    agreementIds.addAll(ids);
                }
                if (qryLittleActOrgByUserRspBO.getBranchComp() != null && (ids = this.agreementScopeMapper.selectAgreementIdsByScopeCode(orgId = branchComp.getAutoId(), 3L)).size() > 0) {
                    agreementIds.addAll(ids);
                }
                if (qryLittleActOrgByUserRspBO.getProjectComp() != null && (ids = this.agreementScopeMapper.selectAgreementIdsByScopeCode(orgId = projectComp.getAutoId(), 4L)).size() > 0) {
                    agreementIds.addAll(ids);
                }
            }
            return agreementIds;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237\u67e5\u8be2\u5546\u57ce\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u7528\u6237\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u3001\u9879\u76ee\u5355\u4f4d\u4fe1\u606f\u670d\u52a1\u7ed3\u679c\u83b7\u53d6\u534f\u8baeID\u96c6\u5408\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6839\u636e\u7528\u6237\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u3001\u9879\u76ee\u5355\u4f4d\u4fe1\u606f\u670d\u52a1\u7ed3\u679c\u83b7\u53d6\u534f\u8baeID\u96c6\u5408\u5931\u8d25");
        }
    }
}

