/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.SkuStateUpdateService;
import com.cgd.commodity.busi.bo.SkuStateUpdateReqBO;
import com.cgd.commodity.busi.bo.SkuStateUpdateRspBO;
import com.cgd.commodity.constant.CommodityTopicConstant;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.intfce.bo.SkuStatuChangeLogConsumerReqBO;
import com.cgd.commodity.intfce.vo.SkuStatuChangeLogConsumerVO;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.util.RandomGUIDUtil;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.produce.MqProducer;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkuStateUpdateServiceImpl
implements SkuStateUpdateService {
    private static final Logger logger = LoggerFactory.getLogger(SkuStateUpdateServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public SkuStateUpdateRspBO updateSkuState(SkuStateUpdateReqBO skuStateUpdateReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5b9a\u65f6\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + skuStateUpdateReqBO.toString());
        }
        if (null == skuStateUpdateReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5b9a\u65f6\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == skuStateUpdateReqBO.getExtSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5b9a\u65f6\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[extSkuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == skuStateUpdateReqBO.getSkuState()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5b9a\u65f6\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u72b6\u6001[skuState]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SkuStateUpdateRspBO skuStateUpdateRspBO = new SkuStateUpdateRspBO();
            Sku oldSku = this.skuMapper.selectByExtSkuIdAndSupplierId(skuStateUpdateReqBO.getExtSkuId(), skuStateUpdateReqBO.getSupplierId());
            if (null == oldSku) {
                skuStateUpdateRspBO.setIsSuccess(Boolean.valueOf(false));
                skuStateUpdateRspBO.setResultMsg("\u4f9b\u5e94\u5546[" + skuStateUpdateReqBO.getSupplierId() + "]\u7684\u5546\u54c1[" + skuStateUpdateReqBO.getExtSkuId() + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            } else {
                Sku sku = new Sku();
                sku.setExtSkuId(skuStateUpdateReqBO.getExtSkuId());
                sku.setSupplierId(skuStateUpdateReqBO.getSupplierId());
                if (1 == skuStateUpdateReqBO.getSkuState()) {
                    sku.setSkuStatus(Constant.SKU_STATUS_SHELVEING);
                }
                if (0 == skuStateUpdateReqBO.getSkuState()) {
                    sku.setSkuStatus(Constant.SKU_STATUS_HAND_RACK);
                }
                if (6 == skuStateUpdateReqBO.getSkuState()) {
                    sku.setSkuStatus(Constant.SKU_STATUS_INVALID);
                }
                sku.setUpdateTime(new Date());
                this.skuMapper.updateSkuStateByExtSkuId(sku);
                this.sendMsg(skuStateUpdateReqBO, oldSku);
                skuStateUpdateRspBO.setIsSuccess(Boolean.valueOf(true));
            }
            return skuStateUpdateRspBO;
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private void sendMsg(SkuStateUpdateReqBO skuStateUpdateReqBO, Sku sku) {
        try {
            SkuStatuChangeLogConsumerReqBO skuStatuChangeLogConsumerReqBO = new SkuStatuChangeLogConsumerReqBO();
            SkuStatuChangeLogConsumerVO skus = new SkuStatuChangeLogConsumerVO();
            ArrayList<Long> skuIds = new ArrayList<Long>();
            skuIds.add(sku.getSkuId());
            skus.setSkuIds(skuIds);
            skus.setSupplierId(skuStateUpdateReqBO.getSupplierId());
            skuStatuChangeLogConsumerReqBO.setSku(skus);
            if (1 == skuStateUpdateReqBO.getSkuState()) {
                skuStatuChangeLogConsumerReqBO.setPostState(Constant.SKU_STATUS_SHELVEING);
            }
            if (0 == skuStateUpdateReqBO.getSkuState()) {
                skuStatuChangeLogConsumerReqBO.setPostState(Constant.SKU_STATUS_HAND_RACK);
            }
            if (6 == skuStateUpdateReqBO.getSkuState()) {
                skuStatuChangeLogConsumerReqBO.setPostState(Constant.SKU_STATUS_INVALID);
            }
            skuStatuChangeLogConsumerReqBO.setPreState(sku.getSkuStatus());
            skuStatuChangeLogConsumerReqBO.setCreateTime(new Date());
            skuStatuChangeLogConsumerReqBO.setRandomStr(RandomGUIDUtil.getRandomGUID());
            MqProducer.sendMsg((String)"SKU_STATE_UPDATE_TOPIC", (String)CommodityTopicConstant.SKU_STATE_UPDATE_TAG, (Object)skuStatuChangeLogConsumerReqBO);
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u65e5\u5fd7\u6d88\u8d39\u8005\u670d\u52a1\u6d88\u606f\u5931\u8d25" + e);
        }
    }
}

