/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.SubmitAgrService;
import com.cgd.commodity.busi.bo.agreement.SubmitAgrReqBO;
import com.cgd.commodity.busi.bo.agreement.SubmitAgrRspBO;
import com.cgd.commodity.busi.vo.AgrAdjustPriceFormulaRspVO;
import com.cgd.commodity.constant.CommodityTopicConstant;
import com.cgd.commodity.dao.AgrAdjustPriceFormulaMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.dao.SupplierAgreementSkuMapper;
import com.cgd.commodity.intfce.bo.CreateAgrApproveLogConsumerBO;
import com.cgd.commodity.po.SupplierAgreement;
import com.cgd.commodity.po.SupplierAgreementSku;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.produce.MqProducer;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitAgrServiceImpl
implements SubmitAgrService {
    private static final Logger logger = LoggerFactory.getLogger(SubmitAgrServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SupplierAgreementMapper supplierAgreementMapper;
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    private AgrAdjustPriceFormulaMapper agrAdjustPriceFormulaMapper;

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSupplierAgreementSkuMapper(SupplierAgreementSkuMapper supplierAgreementSkuMapper) {
        this.supplierAgreementSkuMapper = supplierAgreementSkuMapper;
    }

    public void setAgrAdjustPriceFormulaMapper(AgrAdjustPriceFormulaMapper agrAdjustPriceFormulaMapper) {
        this.agrAdjustPriceFormulaMapper = agrAdjustPriceFormulaMapper;
    }

    public SubmitAgrRspBO submitAgr(SubmitAgrReqBO submitAgrReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u63d0\u4ea4\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + submitAgrReqBO.toString());
        }
        SubmitAgrRspBO submitAgrRspBO = new SubmitAgrRspBO();
        try {
            int action = submitAgrReqBO.getAction();
            int status = 0;
            SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(submitAgrReqBO.getAgreementId(), submitAgrReqBO.getSupplierId());
            if (supplierAgreement != null && supplierAgreement.getIsAdjustPriceFormula() != null && supplierAgreement.getIsAdjustPriceFormula() == 1) {
                List<SupplierAgreementSku> supplierAgreementSkus = this.supplierAgreementSkuMapper.selectByAgreementId(submitAgrReqBO.getAgreementId(), submitAgrReqBO.getSupplierId());
                for (SupplierAgreementSku supplierAgreementSku : supplierAgreementSkus) {
                    List<AgrAdjustPriceFormulaRspVO> agrAdjustPriceFormulaRsp = this.agrAdjustPriceFormulaMapper.selectByAgrSkuIdAndSupId(supplierAgreementSku.getAgreementSkuId(), submitAgrReqBO.getSupplierId());
                    if (agrAdjustPriceFormulaRsp != null && agrAdjustPriceFormulaRsp.size() != 0) continue;
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6b64\u534f\u8bae\u542b\u6709\u8c03\u4ef7\u516c\u5f0f,\u8bf7\u786e\u8ba4\u6bcf\u6761\u534f\u8bae\u660e\u7ec6\u90fd\u6709\u8c03\u4ef7\u516c\u5f0f");
                }
            }
            if (action == 0) {
                status = 0;
            } else if (action == 1) {
                status = 2;
                this.sendMsg(submitAgrReqBO);
            }
            int updateRows = this.supplierAgreementMapper.updateAgrStateBySup(submitAgrReqBO.getAgreementId(), submitAgrReqBO.getSupplierId(), status);
            if (updateRows > 0) {
                submitAgrRspBO.setSubmitState(Integer.valueOf(1));
            } else {
                submitAgrRspBO.setSubmitState(Integer.valueOf(0));
            }
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63d0\u4ea4\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        return submitAgrRspBO;
    }

    private void sendMsg(SubmitAgrReqBO submitAgrReqBO) {
        try {
            CreateAgrApproveLogConsumerBO createAgrApproveLogConsumerBO = new CreateAgrApproveLogConsumerBO();
            createAgrApproveLogConsumerBO.setAgreementId(submitAgrReqBO.getAgreementId());
            createAgrApproveLogConsumerBO.setSupplierId(submitAgrReqBO.getSupplierId());
            createAgrApproveLogConsumerBO.setApproveType(Integer.valueOf(0));
            createAgrApproveLogConsumerBO.setApproveResult(Integer.valueOf(2));
            createAgrApproveLogConsumerBO.setCreateTime(new Date());
            createAgrApproveLogConsumerBO.setCreateLoginId(submitAgrReqBO.getUserId());
            MqProducer.sendMsg((String)"AGR_APPROVELOG_INSERT_TOPIC", (String)CommodityTopicConstant.AGR_APPROVELOG_INSERT_TAG, (Object)createAgrApproveLogConsumerBO);
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u6d88\u606f\u751f\u6210\u534f\u8bae\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25" + e);
        }
    }
}

