/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.consumer;

import com.cgd.commodity.busi.CreatSkuPriceChangeLogService;
import com.cgd.commodity.busi.bo.CreatSkuPriceChangeReqBO;
import com.cgd.commodity.busi.vo.CreatSkuPriceChangeReqVO;
import com.cgd.commodity.busi.vo.SkuPriceVO;
import com.cgd.commodity.constant.CommodityTopicConstant;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.intfce.bo.PriceChangeConsumerBO;
import com.cgd.commodity.intfce.vo.PriceChangeConsumerVO;
import com.ohaotian.plugin.mq.bo.MqSubScribeSingleBO;
import com.ohaotian.plugin.mq.interfce.MqCunsumer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceChangeServiceConsumer
implements MqCunsumer {
    private static final Logger logger = LoggerFactory.getLogger(PriceChangeServiceConsumer.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private CreatSkuPriceChangeLogService creatSkuPriceChangeLogService;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCreatSkuPriceChangeLogService(CreatSkuPriceChangeLogService creatSkuPriceChangeLogService) {
        this.creatSkuPriceChangeLogService = creatSkuPriceChangeLogService;
    }

    public MqSubScribeSingleBO subscribe() {
        MqSubScribeSingleBO mqSubScribeSingleBO = new MqSubScribeSingleBO();
        mqSubScribeSingleBO.setConsumerId("SKU_PRICE_CHANGE_CID");
        mqSubScribeSingleBO.setTag(CommodityTopicConstant.SKU_PRICE_CHANGE_TAG);
        mqSubScribeSingleBO.setTopic("SKU_PRICE_CHANGE_TOPIC");
        return mqSubScribeSingleBO;
    }

    public void execute(String tag, Object msg) {
        PriceChangeConsumerBO priceChangeConsumerBO = (PriceChangeConsumerBO)msg;
        if (isDebugEnabled) {
            logger.debug("\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u6d88\u8d39\u8005\u670d\u52a1\u5165\u53c2\uff1a" + priceChangeConsumerBO.toString());
        }
        try {
            if (!priceChangeConsumerBO.getSkus().isEmpty()) {
                ArrayList<String> extSkuIds = new ArrayList<String>();
                for (PriceChangeConsumerVO priceChangeConsumerVO : priceChangeConsumerBO.getSkus()) {
                    extSkuIds.add(priceChangeConsumerVO.getExtSkuId());
                }
                List<SkuPriceVO> skuPriceVOs = this.skuMapper.selectSkuBySupExtSkuIds(priceChangeConsumerBO.getSupplierId(), extSkuIds);
                CreatSkuPriceChangeReqBO creatSkuPriceChangeBO = this.initCreatSkuPriceChangeBO(priceChangeConsumerBO, skuPriceVOs);
                this.creatSkuPriceChangeLogService.creatSkuPriceChangeLog(creatSkuPriceChangeBO);
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u6d88\u8d39\u8005\u670d\u52a1\u51fa\u9519\uff1a" + e);
        }
    }

    private CreatSkuPriceChangeReqBO initCreatSkuPriceChangeBO(PriceChangeConsumerBO priceChangeConsumerBO, List<SkuPriceVO> skuPriceVOs) {
        try {
            if (!skuPriceVOs.isEmpty()) {
                CreatSkuPriceChangeReqBO creatSkuPriceChangeBO = new CreatSkuPriceChangeReqBO();
                ArrayList<CreatSkuPriceChangeReqVO> skuPriceLogs = new ArrayList<CreatSkuPriceChangeReqVO>();
                for (SkuPriceVO skuPriceVO : skuPriceVOs) {
                    CreatSkuPriceChangeReqVO creatSkuPriceChangeVO = new CreatSkuPriceChangeReqVO();
                    for (PriceChangeConsumerVO priceChangeConsumerVO : priceChangeConsumerBO.getSkus()) {
                        Double price;
                        if (!priceChangeConsumerVO.getExtSkuId().equals(skuPriceVO.getExtSkuId())) continue;
                        creatSkuPriceChangeVO.setSkuId(skuPriceVO.getSkuId());
                        creatSkuPriceChangeVO.setSkuLocation(skuPriceVO.getSkuLocation());
                        creatSkuPriceChangeVO.setSkuName(skuPriceVO.getSkuName());
                        creatSkuPriceChangeVO.setCurrencyType(skuPriceVO.getCurrencyType());
                        creatSkuPriceChangeVO.setPostAgreementPrice(priceChangeConsumerVO.getAgreementPrice());
                        creatSkuPriceChangeVO.setPostMarketPrice(priceChangeConsumerVO.getMarketPrice());
                        if (1L == priceChangeConsumerBO.getSupplierId()) {
                            price = (double)priceChangeConsumerVO.getAgreementPrice().longValue() * 1.04;
                            creatSkuPriceChangeVO.setPostMemberPrice(Long.valueOf(price.longValue()));
                            creatSkuPriceChangeVO.setPostSalePrice(Long.valueOf(price.longValue()));
                        } else {
                            price = (double)priceChangeConsumerVO.getAgreementPrice().longValue() * 1.04;
                            creatSkuPriceChangeVO.setPostMemberPrice(Long.valueOf(price.longValue()));
                            creatSkuPriceChangeVO.setPostSalePrice(Long.valueOf(price.longValue()));
                        }
                        if (null != priceChangeConsumerVO.getPreAgreementPrice() && null != priceChangeConsumerVO.getPreMarketPrice()) {
                            Double prePrice;
                            creatSkuPriceChangeVO.setPreAgreementPrice(priceChangeConsumerVO.getPreAgreementPrice());
                            creatSkuPriceChangeVO.setPreMarketPrice(priceChangeConsumerVO.getPreMarketPrice());
                            if (1L == priceChangeConsumerBO.getSupplierId()) {
                                prePrice = (double)priceChangeConsumerVO.getPreAgreementPrice().longValue() * 1.04;
                                creatSkuPriceChangeVO.setPreMemberPrice(Long.valueOf(prePrice.longValue()));
                                creatSkuPriceChangeVO.setPreSalePrice(Long.valueOf(prePrice.longValue()));
                            } else {
                                prePrice = (double)priceChangeConsumerVO.getPreAgreementPrice().longValue() * 1.04;
                                creatSkuPriceChangeVO.setPreMemberPrice(Long.valueOf(prePrice.longValue()));
                                creatSkuPriceChangeVO.setPreSalePrice(Long.valueOf(prePrice.longValue()));
                            }
                        } else {
                            creatSkuPriceChangeVO.setPreAgreementPrice(Long.valueOf(0L));
                            creatSkuPriceChangeVO.setPreMarketPrice(Long.valueOf(0L));
                            creatSkuPriceChangeVO.setPreMemberPrice(Long.valueOf(0L));
                            creatSkuPriceChangeVO.setPreSalePrice(Long.valueOf(0L));
                        }
                        creatSkuPriceChangeVO.setSupplierId(priceChangeConsumerBO.getSupplierId());
                        creatSkuPriceChangeVO.setCreateTime(priceChangeConsumerVO.getCreateTime());
                        skuPriceLogs.add(creatSkuPriceChangeVO);
                    }
                }
                creatSkuPriceChangeBO.setSkuPriceLogs(skuPriceLogs);
                return creatSkuPriceChangeBO;
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u6d88\u8d39\u8005\u670d\u52a1\u521d\u59cb\u5316\u4ef7\u683c\u53d8\u66f4\u65e5\u5fd7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5931\u8d25\uff1a" + e);
            return null;
        }
        return null;
    }
}

