/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.distribute.impl;

import com.cgd.commodity.busi.bo.BusiInfoSKUReqBO;
import com.cgd.commodity.busi.bo.BusiInfoSKURspBO;
import com.cgd.commodity.constant.CommodityTopicConstant;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.intfce.bo.SkuSyncExceptionLogBO;
import com.cgd.commodity.po.SkuSyncExceptionLog;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKURspBO;
import com.ohaotian.commodity.busi.distribute.CreateSKUExtService;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.produce.MqProducer;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="createSKUExtService")
public class CreateSKUExtServiceImpl
implements CreateSKUExtService {
    private static final Logger logger = LoggerFactory.getLogger(CreateSKUExtServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();

    public BusiInfoSKURspBO createSKUExt(BusiInfoSKUReqBO busiInfoSKUReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiInfoSKUReqBO.toString());
        }
        if (null == busiInfoSKUReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiInfoSKUReqBO.getSkuLocation()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5355\u54c1\u4f4d\u7f6e[skuLocation]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiInfoSKUReqBO.getExtSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5916\u90e8SKUID[extSkuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return null;
    }

    private void sendMsgForSkuSyncExceptionLog(BusiInfoSKUReqBO busiInfoSKUReqBO, BusiQrySKURspBO busiQrySKURspBO, String errorMsg) {
        SkuSyncExceptionLogBO skuSyncExceptionLogBO = new SkuSyncExceptionLogBO();
        try {
            SkuSyncExceptionLog skuSyncExceptionLog = new SkuSyncExceptionLog();
            skuSyncExceptionLog.setExtSkuId(busiQrySKURspBO.getSku());
            skuSyncExceptionLog.setSkuName(busiQrySKURspBO.getName());
            skuSyncExceptionLog.setSkuLocation(busiInfoSKUReqBO.getSkuLocation());
            skuSyncExceptionLog.setSupplierId(busiInfoSKUReqBO.getSupplierId());
            skuSyncExceptionLog.setCreateLoginId(busiInfoSKUReqBO.getCreateLoginId());
            skuSyncExceptionLog.setCreateTime(new Date());
            skuSyncExceptionLog.setIsDelete(Constant.IS_DELETE);
            skuSyncExceptionLog.setErrorMsg(errorMsg);
            BeanUtils.copyProperties((Object)skuSyncExceptionLogBO, (Object)skuSyncExceptionLog);
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25");
        }
        try {
            MqProducer.sendMsg((String)"SKU_SYNC_INSERT_TOPIC", (String)CommodityTopicConstant.SKU_SYNC_INSERT_TAG, (Object)skuSyncExceptionLogBO);
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u6d88\u606f\u5931\u8d25" + e);
            throw new BusinessException(null, "\u53d1\u9001\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u6d88\u606f\u5931\u8d25");
        }
    }
}

