/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryArgSkuOffShelfService;
import com.cgd.commodity.busi.bo.QryArgSkuOffShelfReqBO;
import com.cgd.commodity.busi.bo.QryArgSkuOffShelfRspBO;
import com.cgd.commodity.busi.vo.QryArgSkuOffShelfVo;
import com.cgd.commodity.dao.CatalogCommodityTypeMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.po.CatalogCommodityType;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QryArgSkuOffShelfServiceImpl
implements QryArgSkuOffShelfService {
    private static final Logger logger = LoggerFactory.getLogger(QryArgSkuOffShelfServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public void setCatalogCommodityTypeMapper(CatalogCommodityTypeMapper catalogCommodityTypeMapper) {
        this.catalogCommodityTypeMapper = catalogCommodityTypeMapper;
    }

    public RspPageBO<QryArgSkuOffShelfRspBO> qryArgSkuOffShelf(QryArgSkuOffShelfReqBO qryArgSkuOffShelfReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u4e0b\u67b6\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryArgSkuOffShelfReqBO.toString());
        }
        if (null == qryArgSkuOffShelfReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u4e0b\u67b6\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u4f9b\u8d27\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == qryArgSkuOffShelfReqBO.getAgreementId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u4e0b\u67b6\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u534f\u8baeId[agreementId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.isEmpty((Object)qryArgSkuOffShelfReqBO.getBrandName())) {
            qryArgSkuOffShelfReqBO.setBrandName(qryArgSkuOffShelfReqBO.getBrandName().replaceAll(" ", ""));
        }
        if (!StringUtils.isEmpty((Object)qryArgSkuOffShelfReqBO.getSkuName())) {
            qryArgSkuOffShelfReqBO.setSkuName(qryArgSkuOffShelfReqBO.getSkuName().replaceAll(" ", ""));
        }
        try {
            int indexOf;
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            if (null != qryArgSkuOffShelfReqBO.getCatalogId()) {
                List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(qryArgSkuOffShelfReqBO.getCatalogId());
                for (CatalogCommodityType catalogCommodityType : catalogs) {
                    commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                }
            }
            Page page = new Page(qryArgSkuOffShelfReqBO.getPageNo(), qryArgSkuOffShelfReqBO.getPageSize());
            String skuName = qryArgSkuOffShelfReqBO.getSkuName();
            if (skuName != null && !"".equals(skuName) && (indexOf = skuName.indexOf(92)) != -1) {
                String name = skuName.replaceAll("\\\\", "\\\\\\\\");
                qryArgSkuOffShelfReqBO.setSkuName(name);
            }
            List<QryArgSkuOffShelfVo> qryArgSkuOffShelfVos = this.skuMapper.qryArgSkuOffShelf((Page<QryArgSkuOffShelfVo>)page, qryArgSkuOffShelfReqBO, commodityTypeIds, qryArgSkuOffShelfReqBO.getAgrLocation());
            List<QryArgSkuOffShelfRspBO> qryArgSkuOffShelfRspBOs = this.resolveRsp(qryArgSkuOffShelfVos);
            RspPageBO rspPageBO = new RspPageBO();
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qryArgSkuOffShelfReqBO.getPageNo());
            rspPageBO.setRows(qryArgSkuOffShelfRspBOs);
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f85\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5f85\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QryArgSkuOffShelfRspBO> resolveRsp(List<QryArgSkuOffShelfVo> qryArgSkuOffShelfVos) throws Exception {
        ArrayList<QryArgSkuOffShelfRspBO> qryArgSkuOffShelfRspBOs = new ArrayList<QryArgSkuOffShelfRspBO>();
        if (!qryArgSkuOffShelfVos.isEmpty()) {
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            for (QryArgSkuOffShelfVo qryArgSkuOffShelfVo : qryArgSkuOffShelfVos) {
                commodityTypeIds.add(qryArgSkuOffShelfVo.getCommodityTypeId());
            }
            List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeIdAndLocation(commodityTypeIds);
            for (QryArgSkuOffShelfVo qryArgSkuOffShelf : qryArgSkuOffShelfVos) {
                QryArgSkuOffShelfRspBO qryArgSkuOffShelfRspBO = new QryArgSkuOffShelfRspBO();
                qryArgSkuOffShelfRspBO = this.getQryArgSkuOffShelfRspBO(qryArgSkuOffShelfRspBO, qryArgSkuOffShelf);
                if (!catalogMaps.isEmpty()) {
                    for (Map<String, Object> map : catalogMaps) {
                        if (!map.get("commodityTypeId").equals(qryArgSkuOffShelf.getCommodityTypeId())) continue;
                        qryArgSkuOffShelfRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                        qryArgSkuOffShelfRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                        qryArgSkuOffShelfRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                    }
                }
                qryArgSkuOffShelfRspBOs.add(qryArgSkuOffShelfRspBO);
            }
        }
        return qryArgSkuOffShelfRspBOs;
    }

    private QryArgSkuOffShelfRspBO getQryArgSkuOffShelfRspBO(QryArgSkuOffShelfRspBO qryArgSkuOffShelfRspBO, QryArgSkuOffShelfVo qryArgSkuOffShelf) throws Exception {
        qryArgSkuOffShelfRspBO.setSkuName(qryArgSkuOffShelf.getSkuName());
        qryArgSkuOffShelfRspBO.setSkuId(qryArgSkuOffShelf.getSkuId());
        qryArgSkuOffShelfRspBO.setSupplierId(qryArgSkuOffShelf.getSupplierId());
        qryArgSkuOffShelfRspBO.setVendorName(qryArgSkuOffShelf.getVendorName());
        qryArgSkuOffShelfRspBO.setBrandName(qryArgSkuOffShelf.getBrandName());
        qryArgSkuOffShelfRspBO.setSupplierName(qryArgSkuOffShelf.getSupplierName());
        if (null != qryArgSkuOffShelf.getMarketPrice()) {
            qryArgSkuOffShelfRspBO.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)qryArgSkuOffShelf.getMarketPrice()));
        }
        qryArgSkuOffShelfRspBO.setAgreementId(qryArgSkuOffShelf.getAgreementId());
        qryArgSkuOffShelfRspBO.setAgreementSkuId(qryArgSkuOffShelf.getAgreementSkuId());
        return qryArgSkuOffShelfRspBO;
    }
}

