/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.atom.GenerateSkuPicSeqService;
import com.cgd.commodity.atom.bo.GenerateSkuPicSeqRspBO;
import com.cgd.commodity.busi.SkuApproveService;
import com.cgd.commodity.busi.bo.SkuApproveRspBO;
import com.cgd.commodity.busi.vo.SkuHandOffShelfVO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.SkuInfoChangeLogMapper;
import com.cgd.commodity.dao.SkuInfoChangeMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuOffShelveLogMapper;
import com.cgd.commodity.dao.SkuOnShelveLogMapper;
import com.cgd.commodity.dao.SkuPicChangeMapper;
import com.cgd.commodity.dao.SkuPicMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.dao.SkuRecoveOnShelveLogMapper;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuInfoChange;
import com.cgd.commodity.po.SkuPic;
import com.cgd.commodity.po.SkuPicChange;
import com.cgd.commodity.po.SkuPrice;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SkuApproveServiceImpl
implements SkuApproveService {
    private static final Logger logger = LoggerFactory.getLogger(SkuApproveServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private SkuOnShelveLogMapper skuOnShelveLogMapper;
    @Autowired
    private SkuOffShelveLogMapper skuOffShelveLogMapper;
    @Autowired
    private SkuRecoveOnShelveLogMapper skuRecoveOnShelveLogMapper;
    @Autowired
    private SkuPicChangeMapper skuPicChangeMapper;
    @Autowired
    private SkuInfoChangeLogMapper skuInfoChangeLogMapper;
    @Autowired
    private SkuInfoChangeMapper skuInfoChangeMapper;
    @Autowired
    private SkuPicMapper skuPicMapper;
    @Autowired
    private GenerateSkuPicSeqService generateSkuPicSeqService;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;

    public SkuApproveRspBO skuApprove(Integer approveType, String procInstlId, Integer approveResult, Long supplierId, Long userId, Byte skuLocation) {
        SkuApproveRspBO SkuApproveRspBO2;
        block40: {
            if (this.isDebugEnabled) {
                logger.debug("\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1aapproveType=" + approveType + ",procInstlId=" + procInstlId + ",approveResult=" + approveResult + ",supplierId=" + supplierId);
            }
            SkuApproveRspBO2 = new SkuApproveRspBO();
            if (null == approveType) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1[approveType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (approveType > 4) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1approveType\u975e\u6cd5\uff0c\u53ea\u80fd\u4e3a[0:\u4e0a\u67b6\uff0c1:\u4e0b\u67b6\uff0c2\uff1a\u6062\u590d\u4e0a\u67b6\uff0c3\uff1a\u4fe1\u606f\u53d8\u66f4]");
            }
            if ("" == procInstlId || null == procInstlId) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1[procInstlId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == approveResult) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1[approveResult]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == supplierId) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == userId) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1[userId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            switch (approveResult) {
                case 0: {
                    approveResult = 1;
                    break;
                }
                case 1: {
                    approveResult = 2;
                    break;
                }
                case 2: {
                    approveResult = 0;
                    break;
                }
            }
            try {
                SelectUserInfoByUserIdReqBO selectUserInfoByUserIdReqBO = new SelectUserInfoByUserIdReqBO();
                selectUserInfoByUserIdReqBO.setUserId(userId);
                String userName = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoByUserIdReqBO).getName();
                List<Map<String, Long>> listMap = this.skuOnShelveLogMapper.selectSkusByProcInstId(approveType, procInstlId, supplierId);
                if (listMap != null && listMap.size() > 0) {
                    ArrayList<Long> skuIds = new ArrayList<Long>();
                    Long skuId = null;
                    for (Map<String, Long> map : listMap) {
                        skuId = map.get("SKU_ID");
                        skuIds.add(skuId);
                    }
                    SkuHandOffShelfVO skuHandOffShelfVO = new SkuHandOffShelfVO();
                    skuHandOffShelfVO.setSupplierId(supplierId);
                    skuHandOffShelfVO.setSkuIds(skuIds);
                    switch (approveType) {
                        case 0: {
                            if (approveResult == 2) {
                                Sku sku = null;
                                Sku record = null;
                                Date onshelvTime = null;
                                for (Long id : skuIds) {
                                    sku = this.skuMapper.selectBySkuIdAndSupplier(id, supplierId);
                                    if (sku == null || sku.getOnShelveWay() == null) continue;
                                    int onShelveWay = sku.getOnShelveWay();
                                    record = new Sku();
                                    record.setSkuId(id);
                                    record.setUpdateLoginId(userId);
                                    record.setUpdateTime(new Date());
                                    if (onShelveWay == 0) {
                                        record.setSkuStatus(Constant.SKU_STATUS_SHELVEING);
                                        this.skuMapper.updateByPrimaryKeySelective(record, supplierId);
                                        continue;
                                    }
                                    if (onShelveWay == 1) {
                                        record.setSkuStatus(Constant.SKU_STATUS_SHELVED);
                                        this.skuMapper.updateByPrimaryKeySelective(record, supplierId);
                                        continue;
                                    }
                                    if (onShelveWay != 2) continue;
                                    if (sku.getOnShelveTime() == null && sku.getPreOnShelveDay() != null) {
                                        int preDeliverDay = sku.getPreOnShelveDay();
                                        onshelvTime = this.plusDay(preDeliverDay);
                                        record.setOnShelveTime(onshelvTime);
                                        record.setSkuStatus(Constant.SKU_STATUS_SHELVEING);
                                        this.skuMapper.updateByPrimaryKeySelective(record, supplierId);
                                        continue;
                                    }
                                    if (sku.getOnShelveTime() == null || sku.getPreOnShelveDay() != null) continue;
                                    record.setSkuStatus(Constant.SKU_STATUS_SHELVEING);
                                    this.skuMapper.updateByPrimaryKeySelective(record, supplierId);
                                }
                            }
                            if (approveResult == 1) {
                                this.skuMapper.updateSkuStateOffShelfBySkuId(Constant.SKU_STATUS_BACKED, userId, skuHandOffShelfVO);
                            }
                            this.skuOnShelveLogMapper.updateSkusApproveStsByProcInstId(approveResult, userId, userName, procInstlId, supplierId);
                            break;
                        }
                        case 1: {
                            if (approveResult == 1) {
                                this.skuMapper.updateSkuStateOffShelfBySkuId(Constant.SKU_STATUS_SHELVED, userId, skuHandOffShelfVO);
                            } else if (approveResult == 2) {
                                this.skuMapper.updateSkuStateOffShelfBySkuId(Constant.SKU_STATUS_SUPPLIER_RACK, userId, skuHandOffShelfVO);
                            }
                            this.skuOffShelveLogMapper.updateSkusApproveStsByProcInstId(approveResult, userId, userName, procInstlId, supplierId);
                            break;
                        }
                        case 2: {
                            if (approveResult == 2) {
                                this.skuMapper.updateSkuStateOffShelfBySkuId(Constant.SKU_STATUS_SHELVED, userId, skuHandOffShelfVO);
                            }
                            this.skuRecoveOnShelveLogMapper.updateSkusApproveStsByProcInstId(approveResult, userId, userName, procInstlId, supplierId);
                            break;
                        }
                        case 3: {
                            if (approveResult == 2) {
                                SkuInfoChange skuInfoChange = null;
                                List<SkuPicChange> picChgs = null;
                                Long commodityId = null;
                                Sku record = null;
                                Sku sku = null;
                                SkuPrice skuPrice = null;
                                String skuMainPicUrl = null;
                                for (Map<String, Long> map : listMap) {
                                    Long changeId = map.get("CHANGE_ID");
                                    Long skuID = map.get("SKU_ID");
                                    Long suppId = map.get("SUPPLIER_ID");
                                    sku = this.skuMapper.selectBySkuIdAndSupplier(skuID, suppId);
                                    commodityId = sku.getCommodityId();
                                    picChgs = this.skuPicChangeMapper.selectChgPicByChangeIdAndSkuId(changeId, suppId, skuID);
                                    if (picChgs != null && picChgs.size() > 0) {
                                        this.skuPicMapper.deleteBySkuIdBatch(skuIds, suppId);
                                        ArrayList<SkuPic> pics = new ArrayList<SkuPic>();
                                        SkuPic skuPic = null;
                                        GenerateSkuPicSeqRspBO generateSkuPicSeqRspBO = null;
                                        for (SkuPicChange skuPicChange : picChgs) {
                                            generateSkuPicSeqRspBO = this.generateSkuPicSeqService.generateSkuPicSeq();
                                            skuPic = new SkuPic();
                                            skuPic.setSkuPicId(generateSkuPicSeqRspBO.getSkuPicId());
                                            skuPic.setSkuId(skuID);
                                            skuPic.setCommodityId(commodityId);
                                            skuPic.setSkuPicUrl(skuPicChange.getSkuPicUrl());
                                            skuPic.setSupplierId(sku.getSupplierId());
                                            skuPic.setCreateLoginId(userId);
                                            skuPic.setCreateTime(new Date());
                                            skuPic.setIsDelete(Constant.IS_DELETE);
                                            if (skuPicChange.getIsPrimary() != null) {
                                                if (skuPicChange.getIsPrimary() == 1) {
                                                    skuMainPicUrl = skuPicChange.getSkuPicUrl();
                                                }
                                                skuPic.setIsPrimary(skuPicChange.getIsPrimary().intValue());
                                            }
                                            if (skuPicChange.getPicOrder() != null) {
                                                skuPic.setPicOrder(skuPicChange.getPicOrder().intValue());
                                            }
                                            pics.add(skuPic);
                                        }
                                        this.skuPicMapper.insertSkuPicBatch(pics);
                                    }
                                    if ((skuInfoChange = this.skuInfoChangeMapper.selectByChangeIdAndSkuId(changeId, suppId, skuID)) == null) continue;
                                    record = new Sku();
                                    record.setSkuId(skuID);
                                    record.setSupplierId(suppId);
                                    record.setSkuName(skuInfoChange.getSkuName());
                                    record.setSkuDetail(skuInfoChange.getSkuDetail());
                                    record.setPackParam(skuInfoChange.getPackParam());
                                    record.setUpdateLoginId(userId);
                                    record.setUpdateTime(new Date());
                                    if (skuMainPicUrl != null) {
                                        record.setSkuMainPicUrl(skuMainPicUrl);
                                    }
                                    this.skuMapper.updateByPrimaryKeySelective(record, suppId);
                                    skuPrice = new SkuPrice();
                                    skuPrice.setSkuId(skuID);
                                    skuPrice.setSupplierId(suppId);
                                    skuPrice.setMarketPrice(skuInfoChange.getMarketPrice());
                                    skuPrice.setUpdateLoginId(userId);
                                    skuPrice.setUpdateTime(new Date());
                                    this.skuPriceMapper.updateBySkuIdKey(skuPrice);
                                }
                            }
                            this.skuInfoChangeLogMapper.updateSkusApproveStsByProcInstId(approveResult, userId, userName, procInstlId, supplierId, skuLocation);
                            break;
                        }
                        default: {
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5ba1\u6279\u7c7b\u578b\u9519\u8bef[ 0:\u4e0a\u67b6\uff0c1:\u4e0b\u67b6\uff0c2\uff1a\u6062\u590d\u4e0a\u67b6\uff0c3\uff1a\u4fe1\u606f\u53d8\u66f4]");
                        }
                    }
                    break block40;
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5f85\u5ba1\u6279\u8bb0\u5f55\u4e0d\u5b58\u5728!");
            }
            catch (Exception e) {
                logger.error("\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u51fa\u9519\uff1a" + e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u51fa\u9519:" + e);
            }
        }
        return SkuApproveRspBO2;
    }

    private Date plusDay(int num) throws Exception {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        Date today = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        c.add(5, num);
        Date endDate = f.parse(f.format(c.getTime()));
        return endDate;
    }

    public static void main(String[] args) throws Exception {
        SkuApproveServiceImpl skuservice = new SkuApproveServiceImpl();
        Date d = skuservice.plusDay(5);
        System.out.println(d);
    }
}

