/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.distribute.extend.impl;

import com.ohaotian.commodity.busi.distribute.extend.SkuPublishOnShelfExtService;
import com.ohaotian.commodity.busi.distribute.extend.bo.SkuPublishOnShelfExtReqBO;
import com.ohaotian.commodity.busi.distribute.extend.bo.SkuPublishOnShelfExtRspBO;
import com.ohaotian.commodity.common.exception.BusinessException;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SkuPicMapper;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.commodity.dao.po.SkuPic;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Qualifier
@Service
public class SkuPublishOnShelfExtServiceImpl
implements SkuPublishOnShelfExtService {
    private static final Logger logger = LoggerFactory.getLogger(SkuPublishOnShelfExtServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private SkuPicMapper skuPicMapper;

    @Override
    public SkuPublishOnShelfExtRspBO skuPublishOnShelfExt(SkuPublishOnShelfExtReqBO skuPublishOnShelfExtReqBO) {
        SkuPublishOnShelfExtRspBO skuPublishOnShelfExtRspBO = new SkuPublishOnShelfExtRspBO();
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u53d1\u5e03\u4e0a\u67b6\u6269\u5c55\u670d\u52a1\u5165\u53c2BO" + skuPublishOnShelfExtReqBO.toString());
        }
        if (null == skuPublishOnShelfExtReqBO || skuPublishOnShelfExtReqBO.getSkuIds().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d1\u5e03\u4e0a\u67b6\u6269\u5c55\u670d\u52a1\u5355\u54c1\u96c6\u5408[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Boolean isExitPic = true;
        try {
            for (Long skuId : skuPublishOnShelfExtReqBO.getSkuIds()) {
                Sku sku = this.skuMapper.selectByPrimaryKey(skuId);
                List<SkuPic> skuPics = this.skuPicMapper.selectBySkuIdAndSupplierId(skuId, skuPublishOnShelfExtReqBO.getSupplierId());
                if (null == sku || null == skuPics) {
                    throw new BusinessException(null, "\u5546\u54c1\u53d1\u5e03\u4e0a\u67b6\u6269\u5c55\u670d\u52a1\u67e5\u8be2sku\u6216\u8005sku\u56fe\u7247\u4e0d\u5b58\u5728");
                }
                if (null != sku.getSkuMainPicUrl() && !skuPics.isEmpty()) continue;
                isExitPic = false;
                break;
            }
            skuPublishOnShelfExtRspBO.setIsPicExit(isExitPic);
            return skuPublishOnShelfExtRspBO;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u53d1\u5e03\u4e0a\u67b6\u6269\u5c55\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException(null, "\u5546\u54c1\u53d1\u5e03\u4e0a\u67b6\u6269\u5c55\u670d\u52a1\u5931\u8d25");
        }
    }
}

