/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.AddAgrProducerChangeLogService;
import com.cgd.commodity.busi.bo.agreement.AddAgrProducerChangeLogReqBO;
import com.cgd.commodity.busi.bo.agreement.AddAgrProducerChangeLogRspBO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.AgreementAssignLogMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.po.AgreementAssignLog;
import com.cgd.commodity.po.SupplierAgreement;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAgrProducerChangeLogServiceImpl
implements AddAgrProducerChangeLogService {
    private static final Logger logger = LoggerFactory.getLogger(AddAgrProducerChangeLogServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    private SupplierAgreementMapper supplierAgreementMapper;
    private AgreementAssignLogMapper agreementAssignLogMapper;

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setAgreementAssignLogMapper(AgreementAssignLogMapper agreementAssignLogMapper) {
        this.agreementAssignLogMapper = agreementAssignLogMapper;
    }

    public AddAgrProducerChangeLogRspBO addAgrProducerChangeLog(AddAgrProducerChangeLogReqBO addAgrProducerChangeLogReqBO) {
        if (isDebugEnabled) {
            logger.debug("\u65b0\u589e\u534f\u8bae\u7f16\u5236\u4eba\u66f4\u65b0\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + addAgrProducerChangeLogReqBO.toString());
        }
        if (null == addAgrProducerChangeLogReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u534f\u8bae\u7f16\u5236\u4eba\u66f4\u65b0\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == addAgrProducerChangeLogReqBO.getUserName()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u534f\u8bae\u7f16\u5236\u4eba\u66f4\u65b0\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u7528\u6237\u540d\u79f0[userName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List<SupplierAgreement> supplierAgreements = this.supplierAgreementMapper.selectByIdAndAgrIds(addAgrProducerChangeLogReqBO.getAgreementIds(), addAgrProducerChangeLogReqBO.getSupplierId(), addAgrProducerChangeLogReqBO.getAgrLocation());
            List<AgreementAssignLog> agreementAssignLogs = this.initAgreementAssignLog(supplierAgreements, addAgrProducerChangeLogReqBO);
            AddAgrProducerChangeLogRspBO addAgrProducerChangeLogRspBO = new AddAgrProducerChangeLogRspBO();
            if (agreementAssignLogs.size() > 0) {
                this.agreementAssignLogMapper.batchInsert(agreementAssignLogs);
                addAgrProducerChangeLogRspBO.setIsSuccess(Boolean.valueOf(true));
                addAgrProducerChangeLogRspBO.setResultMsg("\u65b0\u589e\u6210\u529f");
            } else {
                addAgrProducerChangeLogRspBO.setIsSuccess(Boolean.valueOf(false));
                addAgrProducerChangeLogRspBO.setResultMsg("\u6ca1\u6709\u5bf9\u5e94\u7684\u534f\u8bae\u4fe1\u606f");
            }
            return addAgrProducerChangeLogRspBO;
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u534f\u8bae\u7f16\u5236\u4eba\u66f4\u65b0\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u589e\u534f\u8bae\u7f16\u5236\u4eba\u66f4\u65b0\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<AgreementAssignLog> initAgreementAssignLog(List<SupplierAgreement> supplierAgreements, AddAgrProducerChangeLogReqBO addAgrProducerChangeLogReqBO) throws Exception {
        try {
            LinkedList<AgreementAssignLog> agreementAssignLogs = new LinkedList<AgreementAssignLog>();
            if (null != supplierAgreements && supplierAgreements.size() > 0) {
                for (SupplierAgreement supplierAgreement : supplierAgreements) {
                    AgreementAssignLog agreementAssignLog = new AgreementAssignLog();
                    agreementAssignLog.setAgreementId(supplierAgreement.getAgreementId());
                    agreementAssignLog.setAgreementName(supplierAgreement.getAgreementName());
                    agreementAssignLog.setPostProducerId(addAgrProducerChangeLogReqBO.getAssignUserId());
                    agreementAssignLog.setPostProducerName(addAgrProducerChangeLogReqBO.getAssignUserName());
                    agreementAssignLog.setPreProducerId(supplierAgreement.getProducerId());
                    agreementAssignLog.setPreProducerName(supplierAgreement.getProducerName());
                    agreementAssignLog.setSupplierId(supplierAgreement.getSupplierId());
                    agreementAssignLog.setSupplierName(supplierAgreement.getSupplierName());
                    agreementAssignLog.setOperater(addAgrProducerChangeLogReqBO.getUserName());
                    agreementAssignLog.setOperateTime(new Date());
                    agreementAssignLog.setCreateLoginId(addAgrProducerChangeLogReqBO.getUserId());
                    agreementAssignLog.setCreateTime(new Date());
                    agreementAssignLog.setIsDelete(Constant.IS_DELETE.byteValue());
                    agreementAssignLogs.add(agreementAssignLog);
                }
            }
            return agreementAssignLogs;
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u534f\u8bae\u7f16\u5236\u4eba\u66f4\u65b0\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5165\u53c2\u5931\u8d25:" + e);
            throw new Exception("\u521d\u59cb\u5316\u53d8\u66f4\u8bb0\u5f55\u5165\u53c2\u5931\u8d25" + e);
        }
    }
}

