/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySkuInfoService;
import com.cgd.commodity.busi.bo.QrySkuInfoReqBO;
import com.cgd.commodity.busi.bo.QrySkuInfoRspBO;
import com.cgd.commodity.busi.vo.QrySkuInfoRspVO;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.dao.SupplierAgreementSkuMapper;
import com.cgd.commodity.po.SupplierAgreement;
import com.cgd.commodity.po.SupplierAgreementSku;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySkuInfoServiceImpl
implements QrySkuInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuInfoServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private SupplierAgreementMapper supplierAgreementMapper;
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSupplierAgreementSkuMapper(SupplierAgreementSkuMapper supplierAgreementSkuMapper) {
        this.supplierAgreementSkuMapper = supplierAgreementSkuMapper;
    }

    public QrySkuInfoRspBO qrySkuInfo(QrySkuInfoReqBO qrySkuInfoReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySkuInfoReqBO.toString());
        }
        if (null == qrySkuInfoReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u94fa\u8d27\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == qrySkuInfoReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1SKUID[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            QrySkuInfoRspVO qrySkuInfoRspVO = this.skuMapper.selectSkuInfo(qrySkuInfoReqBO.getSkuId(), qrySkuInfoReqBO.getSupplierId());
            if (null != qrySkuInfoRspVO) {
                SupplierAgreementSku supplierAgreementSku;
                SupplierAgreement supplierAgreement;
                QrySkuInfoRspBO qrySkuInfoRspBO = new QrySkuInfoRspBO();
                qrySkuInfoRspBO.setSkuId(qrySkuInfoRspVO.getSkuId());
                qrySkuInfoRspBO.setSkuLocation(qrySkuInfoRspVO.getSkuLocation());
                qrySkuInfoRspBO.setSkuName(qrySkuInfoRspVO.getSkuName());
                qrySkuInfoRspBO.setSkuState(qrySkuInfoRspVO.getSkuStatus());
                qrySkuInfoRspBO.setBrandName(qrySkuInfoRspVO.getBrandName());
                qrySkuInfoRspBO.setPreDeliverDay(qrySkuInfoRspVO.getPreDeliverDay());
                qrySkuInfoRspBO.setAgreementId(qrySkuInfoRspVO.getAgreementId());
                qrySkuInfoRspBO.setAgreementSkuId(qrySkuInfoRspVO.getAgreementSkuId());
                qrySkuInfoRspBO.setMeasureId(qrySkuInfoRspVO.getMeasureId());
                qrySkuInfoRspBO.setMeasureName(qrySkuInfoRspVO.getMeasureName());
                if (null != qrySkuInfoRspVO.getMarketPrice()) {
                    qrySkuInfoRspBO.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)qrySkuInfoRspVO.getMarketPrice()));
                }
                if (null != qrySkuInfoRspVO.getAgreementPrice()) {
                    qrySkuInfoRspBO.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)qrySkuInfoRspVO.getAgreementPrice()));
                }
                if (null != qrySkuInfoRspVO.getMemberPrice()) {
                    qrySkuInfoRspBO.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)qrySkuInfoRspVO.getMemberPrice()));
                }
                if (null != qrySkuInfoRspVO.getSalePrice()) {
                    qrySkuInfoRspBO.setSalePrice(MoneyUtils.Long2BigDecimal((Long)qrySkuInfoRspVO.getSalePrice()));
                }
                if (null != qrySkuInfoReqBO.getUserId()) {
                    qrySkuInfoRspBO.setIsLogin(Boolean.valueOf(true));
                } else {
                    qrySkuInfoRspBO.setIsLogin(Boolean.valueOf(false));
                }
                if (null != qrySkuInfoRspVO.getAgreementId() && null != (supplierAgreement = this.supplierAgreementMapper.selectById(qrySkuInfoRspVO.getAgreementId(), qrySkuInfoReqBO.getSupplierId()))) {
                    qrySkuInfoRspBO.setAdjustPrice(supplierAgreement.getAdjustPrice());
                    qrySkuInfoRspBO.setAdjustPriceFormula(supplierAgreement.getAdjustPriceFormula());
                }
                if (null != qrySkuInfoRspVO.getAgreementSkuId() && null != (supplierAgreementSku = this.supplierAgreementSkuMapper.selectById(qrySkuInfoRspVO.getAgreementSkuId(), qrySkuInfoReqBO.getSupplierId()))) {
                    qrySkuInfoRspBO.setMaterialId(supplierAgreementSku.getMaterialId());
                    qrySkuInfoRspBO.setMaterialName(supplierAgreementSku.getMaterialName());
                    qrySkuInfoRspBO.setModel(supplierAgreementSku.getModel());
                    qrySkuInfoRspBO.setSpec(supplierAgreementSku.getSpec());
                    qrySkuInfoRspBO.setFigure(supplierAgreementSku.getFigure());
                    qrySkuInfoRspBO.setTexture(supplierAgreementSku.getTexture());
                    qrySkuInfoRspBO.setManufacturer(supplierAgreementSku.getManufacturer());
                    qrySkuInfoRspBO.setBuyNumber(supplierAgreementSku.getBuyNumber());
                    if (null != supplierAgreementSku.getBuyPrice()) {
                        qrySkuInfoRspBO.setBuyPrice(MoneyUtils.Long2BigDecimal((Long)supplierAgreementSku.getBuyPrice()));
                    }
                    if (null != supplierAgreementSku.getBuyPriceSum()) {
                        qrySkuInfoRspBO.setBuyPriceSum(MoneyUtils.Long2BigDecimal((Long)supplierAgreementSku.getBuyPriceSum()));
                    }
                    qrySkuInfoRspBO.setMarkupRate(supplierAgreementSku.getMarkupRate());
                    if (null != supplierAgreementSku.getSalePriceSum()) {
                        qrySkuInfoRspBO.setSalePriceSum(MoneyUtils.Long2BigDecimal((Long)supplierAgreementSku.getSalePriceSum()));
                    }
                }
                return qrySkuInfoRspBO;
            }
            throw new BusinessException("RSP_CODE_SKU_NOT_EXIST", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u94fa\u8d27\u5546[" + qrySkuInfoReqBO.getSupplierId() + "]\u7684\u5546\u54c1[" + qrySkuInfoReqBO.getSkuId() + "]\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }
}

