/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.CheckPurchasableService;
import com.cgd.commodity.busi.bo.CheckPurchasableReqBO;
import com.cgd.commodity.busi.bo.CheckPurchasableRspBO;
import com.cgd.commodity.dao.AgreementScopeMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.po.AgreementScope;
import com.cgd.user.org.busi.QryLittleActOrgByUserBusiService;
import com.cgd.user.org.busi.bo.QryLittleActOrgByUserReqBO;
import com.cgd.user.org.busi.bo.QryLittleActOrgByUserRspBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CheckPurchasableServiceImpl
implements CheckPurchasableService {
    private static final Logger logger = LoggerFactory.getLogger(CheckPurchasableServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementScopeMapper agreementScopeMapper;
    private SkuPriceMapper skuPriceMapper;
    private QryLittleActOrgByUserBusiService qryLittleActOrgByUserBusiService;

    public void setAgreementScopeMapper(AgreementScopeMapper agreementScopeMapper) {
        this.agreementScopeMapper = agreementScopeMapper;
    }

    public void setSkuPriceMapper(SkuPriceMapper skuPriceMapper) {
        this.skuPriceMapper = skuPriceMapper;
    }

    public void setQryLittleActOrgByUserBusiService(QryLittleActOrgByUserBusiService qryLittleActOrgByUserBusiService) {
        this.qryLittleActOrgByUserBusiService = qryLittleActOrgByUserBusiService;
    }

    public CheckPurchasableRspBO checkPurchasable(CheckPurchasableReqBO checkPurchasableReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u662f\u5426\u53ef\u8d2d\u4e70\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + checkPurchasableReqBO.toString());
        }
        if (null == checkPurchasableReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u662f\u5426\u53ef\u8d2d\u4e70\u4e1a\u52a1\u670d\u52a1\u5355\u54c1Id[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == checkPurchasableReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u662f\u5426\u53ef\u8d2d\u4e70\u4e1a\u52a1\u670d\u52a1\u94fa\u8d27\u5546Id[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == checkPurchasableReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u662f\u5426\u53ef\u8d2d\u4e70\u4e1a\u52a1\u670d\u52a1\u7528\u6237Id[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List<AgreementScope> agreementScopeList;
            CheckPurchasableRspBO checkPurchasableRspBO = new CheckPurchasableRspBO();
            QryLittleActOrgByUserReqBO qryLittleActOrgByUserReqBO = new QryLittleActOrgByUserReqBO();
            qryLittleActOrgByUserReqBO.setUserParamId(checkPurchasableReqBO.getUserId());
            QryLittleActOrgByUserRspBO qryLittleActOrgByUserRspBO = this.qryLittleActOrgByUserBusi(qryLittleActOrgByUserReqBO);
            List<Long> agreementIds = this.skuPriceMapper.selectBySkuIdAndsupplierId(checkPurchasableReqBO.getSkuId(), checkPurchasableReqBO.getSupplierId());
            if (agreementIds != null && agreementIds.size() > 0) {
                Long agreementId = agreementIds.get(0);
                agreementScopeList = this.agreementScopeMapper.selectByAgreementId(agreementId, checkPurchasableReqBO.getSupplierId());
                if (agreementScopeList == null || agreementScopeList.size() <= 0) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u534f\u8baeId\u67e5\u8be2\u5546\u54c1\u534f\u8bae\u8303\u56f4\u8868\u6570\u636e\u4e0d\u5b58\u5728");
                }
            } else {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u4f9b\u8d27\u5546Id\u548cSkuId\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u8868\u6570\u636e\u4e0d\u5b58\u5728");
            }
            Integer flag = this.checkPurchasableList(agreementScopeList, qryLittleActOrgByUserRspBO);
            checkPurchasableRspBO.setRespCode("0000");
            checkPurchasableRspBO.setRespDesc("\u6210\u529f");
            checkPurchasableRspBO.setPurchasableFlag(flag);
            return checkPurchasableRspBO;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u662f\u5426\u53ef\u8d2d\u4e70\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u662f\u5426\u53ef\u8d2d\u4e70\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private QryLittleActOrgByUserRspBO qryLittleActOrgByUserBusi(QryLittleActOrgByUserReqBO qryLittleActOrgByUserReqBO) {
        try {
            QryLittleActOrgByUserRspBO qryLittleActOrgByUser = this.qryLittleActOrgByUserBusiService.qryLittleActOrgByUser(qryLittleActOrgByUserReqBO);
            return qryLittleActOrgByUser;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7528\u6237\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u3001\u9879\u76ee\u5355\u4f4d\u4fe1\u606f\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6839\u636e\u7528\u6237\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u3001\u9879\u76ee\u5355\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
    }

    private Integer checkPurchasableList(List<AgreementScope> agreementScopeList, QryLittleActOrgByUserRspBO qryLittleActOrgByUserRspBO) {
        Integer flg = 0;
        if (qryLittleActOrgByUserRspBO == null) {
            return flg;
        }
        if (agreementScopeList != null && agreementScopeList.size() > 0) {
            for (AgreementScope agreementScope : agreementScopeList) {
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 0) {
                    flg = 1;
                    break;
                }
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 1 && qryLittleActOrgByUserRspBO.getProvId() != null && qryLittleActOrgByUserRspBO.getProvId().equals(agreementScope.getScopeCode())) {
                    flg = 1;
                    break;
                }
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 2 && qryLittleActOrgByUserRspBO.getTrade() != null && qryLittleActOrgByUserRspBO.getTrade().equals(agreementScope.getScopeCode())) {
                    flg = 1;
                    break;
                }
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 3 && qryLittleActOrgByUserRspBO.getBranchComp() != null && qryLittleActOrgByUserRspBO.getBranchComp().getAutoId() != null && qryLittleActOrgByUserRspBO.getBranchComp().getAutoId().equals(agreementScope.getScopeCode())) {
                    flg = 1;
                    break;
                }
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 4 && qryLittleActOrgByUserRspBO.getProjectComp() != null && qryLittleActOrgByUserRspBO.getProjectComp().getAutoId() != null && qryLittleActOrgByUserRspBO.getProjectComp().getAutoId().equals(agreementScope.getScopeCode())) {
                    flg = 1;
                    break;
                }
                flg = 0;
            }
        }
        return flg;
    }
}

