/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.po.SkuPrice;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import com.cgd.workflow.bo.BpmStartReqBO;
import com.cgd.workflow.bo.BpmStartRspBO;
import com.cgd.workflow.busin.service.BpmStartBusinService;
import com.gd.commodity.busi.AgreementApproveTaskService;
import com.gd.commodity.busi.bo.agreement.AgreementApproveLogBO;
import com.gd.commodity.busi.bo.agreement.AgreementApproveTaskStartRspBO;
import com.gd.commodity.busi.bo.agreement.AgreementChangeBO;
import com.gd.commodity.busi.impl.AddStatusChangeApplyServiceImpl;
import com.gd.commodity.busi.vo.agreement.AddAgrProducerChangeLogReqVO;
import com.gd.commodity.constant.Constant;
import com.gd.commodity.dao.AgrAdjustPriceFormulaChangeMapper;
import com.gd.commodity.dao.AgrAdjustPriceFormulaMapper;
import com.gd.commodity.dao.AgreementAddPriceChangeMapper;
import com.gd.commodity.dao.AgreementAddPricePropMapper;
import com.gd.commodity.dao.AgreementAddPriceValueChangeMapper;
import com.gd.commodity.dao.AgreementAddPriceValueMapper;
import com.gd.commodity.dao.AgreementApproveLogMapper;
import com.gd.commodity.dao.AgreementChangeMapper;
import com.gd.commodity.dao.AgreementDetailChangeMapper;
import com.gd.commodity.dao.AgreementMajorChangeMapper;
import com.gd.commodity.dao.AgreementScopeMapper;
import com.gd.commodity.dao.PriceChangeMapper;
import com.gd.commodity.dao.ScopeChangeMapper;
import com.gd.commodity.dao.SupplierAgreementMapper;
import com.gd.commodity.dao.SupplierAgreementSkuMapper;
import com.gd.commodity.intfce.bo.agreement.AgrAddtionalDetailConsumerReqBO;
import com.gd.commodity.intfce.bo.agreement.AgrChangeConsumerReqBO;
import com.gd.commodity.intfce.bo.agreement.AgrDelayConsumerReqBO;
import com.gd.commodity.intfce.bo.agreement.AgrDetailsAndPriceChgConsumerReqBO;
import com.gd.commodity.intfce.bo.agreement.AgrStsChgConsumerReqBO;
import com.gd.commodity.intfce.bo.agreement.AssignStatusChangeConsumerBO;
import com.gd.commodity.intfce.bo.agreement.SkuPriceConsumerReqBO;
import com.gd.commodity.po.AgrAdjustPriceFormula;
import com.gd.commodity.po.AgrAdjustPriceFormulaChange;
import com.gd.commodity.po.AgreementAddPriceChange;
import com.gd.commodity.po.AgreementAddPriceProp;
import com.gd.commodity.po.AgreementAddPriceValue;
import com.gd.commodity.po.AgreementAddPriceValueChange;
import com.gd.commodity.po.AgreementApproveLogPO;
import com.gd.commodity.po.AgreementChange;
import com.gd.commodity.po.AgreementDetailChange;
import com.gd.commodity.po.AgreementMajorChange;
import com.gd.commodity.po.PriceChange;
import com.gd.commodity.po.SupplierAgreement;
import com.gd.commodity.po.SupplierAgreementSku;
import com.ohaotian.commodity.config.TopicConfig;
import com.ohaotian.plugin.base.bo.RspBusiBaseBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AgreementApproveTaskServiceImpl
implements AgreementApproveTaskService {
    private static final Logger logger = LoggerFactory.getLogger(AddStatusChangeApplyServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    @Autowired
    private AgreementApproveLogMapper agreementApproveLogMapper;
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private PriceChangeMapper priceChangeMapper;
    @Autowired
    private AgreementDetailChangeMapper agreementDetailChangeMapper;
    @Autowired
    private AgreementMajorChangeMapper agreementMajorChangeMapper;
    @Autowired
    private SupplierAgreementMapper supplierAgreementMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private ScopeChangeMapper scopeChangeMapper;
    @Autowired
    private AgreementAddPriceChangeMapper agreementAddPriceChangeMapper;
    @Autowired
    private AgreementAddPriceValueChangeMapper agreementAddPriceValueChangeMapper;
    @Autowired
    private AgreementAddPricePropMapper agreementAddPricePropMapper;
    @Autowired
    private AgreementAddPriceValueMapper agreementAddPriceValueMapper;
    @Autowired
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    @Autowired
    private AgrAdjustPriceFormulaChangeMapper agrAdjustPriceFormulaChangeMapper;
    @Autowired
    private AgrAdjustPriceFormulaMapper agrAdjustPriceFormulaMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private BpmStartBusinService bpmStartBusinService;
    @Resource
    TopicConfig topicConfig;
    @Resource(name="agrAddtionalDetailProducer")
    private ProxyMessageProducer agrAddtionalDetailProducer;
    @Resource(name="agrChangeProducer")
    private ProxyMessageProducer agrChangeProducer;
    @Resource(name="agrDelayProducer")
    private ProxyMessageProducer agrDelayProducer;
    @Resource(name="agrDetailsAndPriceChgProducer")
    private ProxyMessageProducer agrDetailsAndPriceChgProducer;
    @Resource(name="agrStsChgChgProducer")
    private ProxyMessageProducer agrStsChgChgProducer;
    @Resource(name="assignStatusChangeProducer")
    private ProxyMessageProducer assignStatusChangeProducer;

    public RspBusiBaseBO addAgreementApproveTask(AgreementApproveLogBO agreementApproveLogBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + agreementApproveLogBO.toString());
        }
        RspBusiBaseBO rspBusiBaseBO = new RspBusiBaseBO();
        String errorStr = this.checkMustParams(agreementApproveLogBO);
        if (errorStr.length() > 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5ba1\u6838\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u4e1a\u52a1\u670d\u52a1\u534f\u8bae\u96c6\u5408[approveInfos]\u4e2d\u534f\u8bae" + errorStr + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date nowDate = new Date();
        AgreementApproveLogPO agreementApproveLogPO = new AgreementApproveLogPO();
        BeanUtils.copyProperties((Object)agreementApproveLogBO, (Object)agreementApproveLogPO);
        agreementApproveLogPO.setApproveResult(2);
        agreementApproveLogPO.setCreateTime(nowDate);
        agreementApproveLogPO.setUpdateTime(nowDate);
        agreementApproveLogPO.setUpdateLoginId(agreementApproveLogPO.getCreateLoginId());
        agreementApproveLogPO.setIsDelete(0);
        StringBuilder names = new StringBuilder();
        StringBuilder acceptIds = new StringBuilder();
        for (String acceptId : agreementApproveLogBO.getAcceptIds()) {
            if (acceptIds.length() == 0) {
                acceptIds.append(acceptId);
            } else {
                acceptIds.append(",").append(acceptId);
            }
            SelectUserInfoByUserIdReqBO selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
            selectUserInfoReqBO.setUserId(Long.valueOf(acceptId));
            SelectUserInfoByUserIdRspBO selectUserInfoByUserIdRspBO = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
            if (names.length() == 0) {
                names.append(selectUserInfoByUserIdRspBO.getName());
                continue;
            }
            names.append(",").append(selectUserInfoByUserIdRspBO.getName());
        }
        agreementApproveLogPO.setAcceptIdJson(acceptIds.toString());
        agreementApproveLogPO.setAcceptNameJson(names.toString());
        try {
            this.agreementApproveLogMapper.insert(agreementApproveLogPO);
        }
        catch (Exception e) {
            logger.error("\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            e.printStackTrace();
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rspBusiBaseBO;
    }

    public RspBusiBaseBO executeAgreementApproveTaskToEnd(Long approveRecordId, Integer approveResult, String comment, Long userId, String userName) {
        RspBusiBaseBO rspBusiBaseBO = new RspBusiBaseBO();
        AgreementApproveLogPO agreementApproveLogPO = null;
        try {
            agreementApproveLogPO = this.agreementApproveLogMapper.selectByPrimaryKey(approveRecordId);
        }
        catch (Exception e) {
            logger.error("\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u5f85\u529e\u4efb\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        if (agreementApproveLogPO == null) {
            logger.error("\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u5f85\u529e\u4efb\u52a1\u5931\u8d25");
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        agreementApproveLogPO.setComment(comment);
        agreementApproveLogPO.setApproveResult(approveResult);
        boolean successFlag = this.sendMsg(agreementApproveLogPO, userId);
        if (!successFlag) {
            rspBusiBaseBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
            rspBusiBaseBO.setRespDesc("\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u5f85\u529e\u4efb\u52a1\u5931\u8d25");
        }
        return rspBusiBaseBO;
    }

    public RspBusiBaseBO executeAgreementApproveTaskEnd(Long approveRecordId, Integer approveResult, String comment, Long userId, String userName) {
        RspBusiBaseBO rspBusiBaseBO = new RspBusiBaseBO();
        return rspBusiBaseBO;
    }

    public AgreementApproveTaskStartRspBO executeAgreementApproveTaskStartUp(AgreementChangeBO agreementChangeBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u534f\u8bae\u53d8\u66f4\u5ba1\u6279\u5de5\u4f5c\u6d41\u542f\u52a8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + agreementChangeBO.toString());
        }
        AgreementApproveTaskStartRspBO agreementApproveTaskStartRspBO = new AgreementApproveTaskStartRspBO();
        BpmStartReqBO bpmStartReqBO = new BpmStartReqBO();
        bpmStartReqBO.setApplyerId(agreementChangeBO.getUserId());
        bpmStartReqBO.setUserId(agreementChangeBO.getUserId());
        bpmStartReqBO.setBusinessTitle("\u534f\u8bae\u53d8\u66f4\u5ba1\u6279");
        bpmStartReqBO.setStartFlag("1");
        bpmStartReqBO.setBusinessType("16");
        bpmStartReqBO.setDetailUrl("detailUrl");
        bpmStartReqBO.setBusinessId(agreementChangeBO.getAgreementId().toString());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("interface", 0);
        SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(agreementChangeBO.getAgreementId(), agreementChangeBO.getSupplierId());
        if (supplierAgreement.getAgreementSrc() != null && (supplierAgreement.getAgreementSrc().toString().equals("0") || supplierAgreement.getAgreementSrc().toString().equals("3"))) {
            variables.put("interface", 1);
            bpmStartReqBO.setBusinessType("15");
            logger.info("\u8be2\u6bd4\u4ef7\u534f\u8bae\u53d8\u66f4\u5ba1\u6279\u5de5\u4f5c\u6d41\u542f\u52a8\uff1a" + bpmStartReqBO.toString());
        }
        variables.put("changeId", agreementChangeBO.getChangeId());
        variables.put("agreementId", agreementChangeBO.getAgreementId());
        variables.put("supplierId", agreementChangeBO.getSupplierId());
        variables.put("changeCode", agreementChangeBO.getChangeCode());
        variables.put("approveType", agreementChangeBO.getChangeType());
        variables.put("userId", agreementChangeBO.getUserId());
        variables.put("userName", agreementChangeBO.getUserName());
        bpmStartReqBO.setVariables(variables);
        BpmStartRspBO bpmStartRspBO = this.bpmStartBusinService.bpmStart(bpmStartReqBO);
        agreementApproveTaskStartRspBO.setProcessInitiator(bpmStartRspBO.getProcessInitiator());
        agreementApproveTaskStartRspBO.setProcInstId(bpmStartRspBO.getProcInstId());
        agreementApproveTaskStartRspBO.setRespCode(bpmStartRspBO.getRespCode());
        agreementApproveTaskStartRspBO.setRespDesc(bpmStartRspBO.getRespDesc());
        return agreementApproveTaskStartRspBO;
    }

    private boolean sendMsg(AgreementApproveLogPO agreementApproveLogPO, Long approveLoginId) {
        boolean successFlag = false;
        Integer approveType = agreementApproveLogPO.getApproveType();
        logger.debug("\u5ba1\u6279\u7c7b\u578b\uff1a" + approveType + ",\u534f\u8baeId=" + agreementApproveLogPO.getAgreementId());
        AgreementChange postAgreementChange = null;
        AgrDetailsAndPriceChgConsumerReqBO agrDetailsAndPriceChgConsumerReqBO = null;
        SkuPriceConsumerReqBO skuPriceConsumerReqBO = null;
        AgrAddtionalDetailConsumerReqBO agrAddtionalDetailConsumerReqBO = null;
        AgrChangeConsumerReqBO agrChangeConsumerReqBO = null;
        try {
            switch (approveType) {
                case 0: {
                    AgrStsChgConsumerReqBO agrStsChgConsumerReqBO0 = new AgrStsChgConsumerReqBO();
                    agrStsChgConsumerReqBO0.setOperId(approveLoginId);
                    agrStsChgConsumerReqBO0.setAgreementStatus(Constant.AGR_STATUS_USING);
                    agrStsChgConsumerReqBO0.setCreateTime(new Date());
                    agrStsChgConsumerReqBO0.setAgreementId(agreementApproveLogPO.getAgreementId());
                    agrStsChgConsumerReqBO0.setApproveResult(agreementApproveLogPO.getApproveResult());
                    agrStsChgConsumerReqBO0.setApproveType(agreementApproveLogPO.getApproveType());
                    agrStsChgConsumerReqBO0.setChangeCode(agreementApproveLogPO.getChangeCode());
                    agrStsChgConsumerReqBO0.setChangeId(agreementApproveLogPO.getChangeId());
                    agrStsChgConsumerReqBO0.setSupplierId(agreementApproveLogPO.getSupplierId());
                    agrStsChgConsumerReqBO0.setComment(agreementApproveLogPO.getComment());
                    this.updateStatus(agrStsChgConsumerReqBO0);
                    this.agrStsChgChgProducer.sendOneway(new ProxyMessage(this.topicConfig.getAgrStsChgTopicName(), this.topicConfig.getAgrStsChgTagName(), JSONObject.toJSONString((Object)agrStsChgConsumerReqBO0)));
                    break;
                }
                case 1: {
                    AgrStsChgConsumerReqBO agrStsChgConsumerReqBO1 = new AgrStsChgConsumerReqBO();
                    agrStsChgConsumerReqBO1.setOperId(approveLoginId);
                    agrStsChgConsumerReqBO1.setAgreementStatus(Constant.AGR_STATUS_PAUSE);
                    agrStsChgConsumerReqBO1.setCreateTime(new Date());
                    agrStsChgConsumerReqBO1.setAgreementId(agreementApproveLogPO.getAgreementId());
                    agrStsChgConsumerReqBO1.setApproveResult(agreementApproveLogPO.getApproveResult());
                    agrStsChgConsumerReqBO1.setApproveType(agreementApproveLogPO.getApproveType());
                    agrStsChgConsumerReqBO1.setChangeCode(agreementApproveLogPO.getChangeCode());
                    agrStsChgConsumerReqBO1.setChangeId(agreementApproveLogPO.getChangeId());
                    agrStsChgConsumerReqBO1.setSupplierId(agreementApproveLogPO.getSupplierId());
                    agrStsChgConsumerReqBO1.setComment(agreementApproveLogPO.getComment());
                    this.updateStatus(agrStsChgConsumerReqBO1);
                    this.agrStsChgChgProducer.sendOneway(new ProxyMessage(this.topicConfig.getAgrStsChgTopicName(), this.topicConfig.getAgrStsChgTagName(), JSONObject.toJSONString((Object)agrStsChgConsumerReqBO1)));
                    break;
                }
                case 2: {
                    AgrStsChgConsumerReqBO agrStsChgConsumerReqBO2 = new AgrStsChgConsumerReqBO();
                    agrStsChgConsumerReqBO2.setOperId(approveLoginId);
                    agrStsChgConsumerReqBO2.setAgreementStatus(Constant.AGR_STATUS_USING);
                    agrStsChgConsumerReqBO2.setCreateTime(new Date());
                    agrStsChgConsumerReqBO2.setAgreementId(agreementApproveLogPO.getAgreementId());
                    agrStsChgConsumerReqBO2.setApproveResult(agreementApproveLogPO.getApproveResult());
                    agrStsChgConsumerReqBO2.setApproveType(agreementApproveLogPO.getApproveType());
                    agrStsChgConsumerReqBO2.setChangeCode(agreementApproveLogPO.getChangeCode());
                    agrStsChgConsumerReqBO2.setChangeId(agreementApproveLogPO.getChangeId());
                    agrStsChgConsumerReqBO2.setSupplierId(agreementApproveLogPO.getSupplierId());
                    agrStsChgConsumerReqBO2.setComment(agreementApproveLogPO.getComment());
                    this.updateStatus(agrStsChgConsumerReqBO2);
                    this.agrStsChgChgProducer.sendOneway(new ProxyMessage(this.topicConfig.getAgrStsChgTopicName(), this.topicConfig.getAgrStsChgTagName(), JSONObject.toJSONString((Object)agrStsChgConsumerReqBO2)));
                    break;
                }
                case 3: {
                    AgrStsChgConsumerReqBO agrStsChgConsumerReqBO3 = new AgrStsChgConsumerReqBO();
                    agrStsChgConsumerReqBO3.setOperId(approveLoginId);
                    agrStsChgConsumerReqBO3.setAgreementStatus(Constant.AGR_STATUS_TERMINATE);
                    agrStsChgConsumerReqBO3.setCreateTime(new Date());
                    agrStsChgConsumerReqBO3.setAgreementId(agreementApproveLogPO.getAgreementId());
                    agrStsChgConsumerReqBO3.setApproveResult(agreementApproveLogPO.getApproveResult());
                    agrStsChgConsumerReqBO3.setApproveType(agreementApproveLogPO.getApproveType());
                    agrStsChgConsumerReqBO3.setChangeCode(agreementApproveLogPO.getChangeCode());
                    agrStsChgConsumerReqBO3.setChangeId(agreementApproveLogPO.getChangeId());
                    agrStsChgConsumerReqBO3.setSupplierId(agreementApproveLogPO.getSupplierId());
                    agrStsChgConsumerReqBO3.setComment(agreementApproveLogPO.getComment());
                    this.updateStatus(agrStsChgConsumerReqBO3);
                    this.agrStsChgChgProducer.sendOneway(new ProxyMessage(this.topicConfig.getAgrStsChgTopicName(), this.topicConfig.getAgrStsChgTagName(), JSONObject.toJSONString((Object)agrStsChgConsumerReqBO3)));
                    break;
                }
                case 4: {
                    List<PriceChange> priceChanges = this.priceChangeMapper.selectByChgId(agreementApproveLogPO.getChangeId(), agreementApproveLogPO.getSupplierId());
                    for (PriceChange priceChange : priceChanges) {
                        Long agreementSkuId = priceChange.getAgreementSkuId();
                        skuPriceConsumerReqBO = new SkuPriceConsumerReqBO();
                        agrDetailsAndPriceChgConsumerReqBO = new AgrDetailsAndPriceChgConsumerReqBO();
                        BeanUtils.copyProperties((Object)agreementApproveLogPO, (Object)agrDetailsAndPriceChgConsumerReqBO);
                        agrDetailsAndPriceChgConsumerReqBO.setAgreementSkuId(agreementSkuId);
                        agrDetailsAndPriceChgConsumerReqBO.setBuyPrice(priceChange.getPostBuyPrice());
                        agrDetailsAndPriceChgConsumerReqBO.setBuyPriceSum(priceChange.getPostSalePriceSum());
                        agrDetailsAndPriceChgConsumerReqBO.setMarkupRate(priceChange.getPostMarkupRate());
                        agrDetailsAndPriceChgConsumerReqBO.setSalePrice(priceChange.getPostSalePrice());
                        agrDetailsAndPriceChgConsumerReqBO.setSalePriceSum(priceChange.getPostSalePriceSum());
                        agrDetailsAndPriceChgConsumerReqBO.setUpdateLoginId(approveLoginId);
                        agrDetailsAndPriceChgConsumerReqBO.setAgreementId(agreementApproveLogPO.getAgreementId());
                        skuPriceConsumerReqBO.setAgreementPrice(priceChange.getPostBuyPrice());
                        skuPriceConsumerReqBO.setSalePrice(priceChange.getPostSalePrice());
                        skuPriceConsumerReqBO.setMemberPrice(priceChange.getPostSalePrice());
                        agrDetailsAndPriceChgConsumerReqBO.setSkuPriceConsumerReqBO(skuPriceConsumerReqBO);
                        agrDetailsAndPriceChgConsumerReqBO.setCreateTime(new Date());
                        this.updateAgrDetailsById(agrDetailsAndPriceChgConsumerReqBO);
                        this.agrDetailsAndPriceChgProducer.sendOneway(new ProxyMessage(this.topicConfig.getAgrDetailsPriceChgTopicName(), this.topicConfig.getAgrDetailsPriceChgTagName(), JSONObject.toJSONString((Object)agrDetailsAndPriceChgConsumerReqBO)));
                    }
                    break;
                }
                case 5: {
                    postAgreementChange = this.agreementChangeMapper.selectByPrimaryKey(agreementApproveLogPO.getChangeId(), agreementApproveLogPO.getSupplierId());
                    if (postAgreementChange == null) break;
                    Date postInvalidDate = postAgreementChange.getPostInvalidDate();
                    AgrDelayConsumerReqBO agrDelayConsumerReqBO = new AgrDelayConsumerReqBO();
                    agrDelayConsumerReqBO.setUpdateLoginId(approveLoginId);
                    agrDelayConsumerReqBO.setPostInvalidDate(postInvalidDate);
                    agrDelayConsumerReqBO.setAgreementId(agreementApproveLogPO.getAgreementId());
                    agrDelayConsumerReqBO.setApproveResult(agreementApproveLogPO.getApproveResult());
                    agrDelayConsumerReqBO.setApproveType(agreementApproveLogPO.getApproveType());
                    agrDelayConsumerReqBO.setChangeCode(agreementApproveLogPO.getChangeCode());
                    agrDelayConsumerReqBO.setChangeId(agreementApproveLogPO.getChangeId());
                    agrDelayConsumerReqBO.setComment(agreementApproveLogPO.getComment());
                    agrDelayConsumerReqBO.setSupplierId(agreementApproveLogPO.getSupplierId());
                    this.updateApprovedStatus(agrDelayConsumerReqBO);
                    this.agrDelayProducer.sendOneway(new ProxyMessage(this.topicConfig.getAgrDelayTopicName(), this.topicConfig.getAgrDelayTagName(), JSONObject.toJSONString((Object)agrDelayConsumerReqBO)));
                    break;
                }
                case 6: {
                    List<AgreementDetailChange> changes = this.agreementDetailChangeMapper.selectAgreementDetailChangesByChgId(agreementApproveLogPO.getChangeId(), agreementApproveLogPO.getSupplierId());
                    for (AgreementDetailChange chg : changes) {
                        agrAddtionalDetailConsumerReqBO = new AgrAddtionalDetailConsumerReqBO();
                        BeanUtils.copyProperties((Object)agreementApproveLogPO, (Object)agrAddtionalDetailConsumerReqBO);
                        BeanUtils.copyProperties((Object)chg, (Object)agrAddtionalDetailConsumerReqBO);
                        agrAddtionalDetailConsumerReqBO.setChangeType(Integer.valueOf(chg.getChangeType().intValue()));
                        agrAddtionalDetailConsumerReqBO.setUpdateLoginId(approveLoginId);
                        if (1 == agreementApproveLogPO.getApproveResult()) {
                            if (1 == chg.getChangeType()) {
                                SupplierAgreementSku supplierAgreementSku = new SupplierAgreementSku();
                                supplierAgreementSku.setBrandId(chg.getBrandId());
                                supplierAgreementSku.setBrandName(chg.getBrandName());
                                supplierAgreementSku.setBuyNumber(chg.getBuyNumber());
                                supplierAgreementSku.setBuyPrice(chg.getBuyPrice());
                                supplierAgreementSku.setBuyPriceSum(chg.getBuyPriceSum());
                                supplierAgreementSku.setCreateLoginId(chg.getCreateLoginId());
                                supplierAgreementSku.setCreateTime(new Date());
                                supplierAgreementSku.setFigure(chg.getFigure());
                                supplierAgreementSku.setIsDelete(Constant.IS_DELETE.byteValue());
                                supplierAgreementSku.setManufacturer(chg.getManufacturer());
                                supplierAgreementSku.setMarkupRate(chg.getMarkupRate());
                                supplierAgreementSku.setMaterialId(chg.getMaterialId());
                                supplierAgreementSku.setMaterialName(chg.getMaterialName());
                                supplierAgreementSku.setMeasureId(chg.getMeasureId());
                                supplierAgreementSku.setMeasureName(chg.getMeasureName());
                                supplierAgreementSku.setModel(chg.getModel());
                                supplierAgreementSku.setSalePrice(chg.getSalePrice());
                                supplierAgreementSku.setSalePriceSum(chg.getSalePriceSum());
                                supplierAgreementSku.setSpec(chg.getSpec());
                                supplierAgreementSku.setSupplierId(chg.getSupplierId());
                                supplierAgreementSku.setTexture(chg.getTexture());
                                supplierAgreementSku.setAgreementId(chg.getAgreementId());
                                supplierAgreementSku.setSupplyCycle(chg.getSupplyCycle());
                                Long supplierAgreementSkuSeq = this.supplierAgreementSkuMapper.generateSupplierAgreementSkuSeq();
                                supplierAgreementSku.setAgreementSkuId(supplierAgreementSkuSeq);
                                this.supplierAgreementSkuMapper.insert(supplierAgreementSku);
                                List<AgrAdjustPriceFormulaChange> agrAdjustPriceFormulaChanges = this.agrAdjustPriceFormulaChangeMapper.selectByDetailChangeId(chg.getDetailChangeId());
                                if (null != agrAdjustPriceFormulaChanges && agrAdjustPriceFormulaChanges.size() > 0) {
                                    ArrayList<AgrAdjustPriceFormula> agrAdjustPriceFormulas = new ArrayList<AgrAdjustPriceFormula>();
                                    for (AgrAdjustPriceFormulaChange agrAdjustPriceFormulaChange : agrAdjustPriceFormulaChanges) {
                                        AgrAdjustPriceFormula agrAdjustPriceFormula = new AgrAdjustPriceFormula();
                                        agrAdjustPriceFormula.setAgreementSkuId(supplierAgreementSkuSeq);
                                        agrAdjustPriceFormula.setAgrCreateComp(agrAdjustPriceFormulaChange.getAgrCreateComp());
                                        agrAdjustPriceFormula.setAgrFormulaInfoDesc(agrAdjustPriceFormulaChange.getAgrFormulaInfoDesc());
                                        agrAdjustPriceFormula.setAgrFormulaInfoFlag(agrAdjustPriceFormulaChange.getAgrFormulaInfoFlag());
                                        agrAdjustPriceFormula.setAgrFormulaInfoShowDesc(agrAdjustPriceFormulaChange.getAgrFormulaInfoShowDesc());
                                        agrAdjustPriceFormula.setAgrFormulaInfoType(agrAdjustPriceFormulaChange.getAgrFormulaInfoType());
                                        agrAdjustPriceFormula.setAgrFormulaInfoValue(agrAdjustPriceFormulaChange.getAgrFormulaInfoValue());
                                        agrAdjustPriceFormula.setAgrFormulaInfoValueType(agrAdjustPriceFormulaChange.getAgrFormulaInfoValueType());
                                        agrAdjustPriceFormula.setAgrFormulaName(agrAdjustPriceFormulaChange.getAgrFormulaName());
                                        agrAdjustPriceFormula.setAgrFormulaValue(agrAdjustPriceFormulaChange.getAgrFormulaValue());
                                        agrAdjustPriceFormula.setCreateLoginId(agrAdjustPriceFormulaChange.getCreateLoginId());
                                        agrAdjustPriceFormula.setCreateTime(new Date());
                                        agrAdjustPriceFormula.setIsDelete(Constant.IS_DELETE.byteValue());
                                        agrAdjustPriceFormula.setSupplierId(agrAdjustPriceFormulaChange.getSupplierId());
                                        agrAdjustPriceFormulas.add(agrAdjustPriceFormula);
                                    }
                                    if (agrAdjustPriceFormulas.size() > 0) {
                                        this.agrAdjustPriceFormulaMapper.insertAgrAdjustPriceFormulaBatch(agrAdjustPriceFormulas);
                                    }
                                }
                            } else if (0 == chg.getChangeType()) {
                                Long agreementSkuId = chg.getAgreementSkuId();
                                Long supplierId = chg.getSupplierId();
                                this.supplierAgreementSkuMapper.updateAgrIsDeleteById(agreementSkuId, supplierId);
                                this.agrAdjustPriceFormulaMapper.deleteByAgrSkuId(agreementSkuId, supplierId);
                            }
                        }
                        this.agrAddtionalDetailProducer.sendOneway(new ProxyMessage(this.topicConfig.getAgrAddiDetailTopicName(), this.topicConfig.getAgrAddiDetailTagName(), JSONObject.toJSONString((Object)agrAddtionalDetailConsumerReqBO)));
                    }
                    break;
                }
                case 7: {
                    agrChangeConsumerReqBO = new AgrChangeConsumerReqBO();
                    BeanUtils.copyProperties((Object)agreementApproveLogPO, (Object)agrChangeConsumerReqBO);
                    AgreementMajorChange agreementMajorChange = this.agreementMajorChangeMapper.selectByChgId(agreementApproveLogPO.getChangeId(), agreementApproveLogPO.getSupplierId());
                    if (agreementMajorChange.getPostAdjustPrice() != null) {
                        agrChangeConsumerReqBO.setAdjustPrice(Integer.valueOf(agreementMajorChange.getPostAdjustPrice().intValue()));
                    }
                    if (agreementMajorChange.getPostServiceRate() != null) {
                        agrChangeConsumerReqBO.setServiceRate(agreementMajorChange.getPostServiceRate());
                    }
                    agrChangeConsumerReqBO.setAdjustPriceFormula(agreementMajorChange.getPostAdjustPriceFormula());
                    agrChangeConsumerReqBO.setMatPayEnt(agreementMajorChange.getPostMatPayEnt());
                    agrChangeConsumerReqBO.setPilPayEnt(agreementMajorChange.getPostPilPayEnt());
                    agrChangeConsumerReqBO.setPrePayEnt(agreementMajorChange.getPostPrePayEnt());
                    agrChangeConsumerReqBO.setQuaPayEnt(agreementMajorChange.getPostQuaPayEnt());
                    agrChangeConsumerReqBO.setVerPayEnt(agreementMajorChange.getPostVerPayEnt());
                    agrChangeConsumerReqBO.setProPayEnt(agreementMajorChange.getPostProPayEnt());
                    agrChangeConsumerReqBO.setMatPaySup(agreementMajorChange.getPostMatPaySup());
                    agrChangeConsumerReqBO.setPilPaySup(agreementMajorChange.getPostPilPaySup());
                    agrChangeConsumerReqBO.setProPaySup(agreementMajorChange.getPostProPaySup());
                    agrChangeConsumerReqBO.setQuaPaySup(agreementMajorChange.getPostQuaPaySup());
                    agrChangeConsumerReqBO.setVerPaySup(agreementMajorChange.getPostVerPaySup());
                    agrChangeConsumerReqBO.setPrePaySup(agreementMajorChange.getPostPrePaySup());
                    agrChangeConsumerReqBO.setPayClause(agreementMajorChange.getPostPayClause());
                    if (agreementMajorChange.getPostWarantty() != null) {
                        agrChangeConsumerReqBO.setWaranty(Integer.valueOf(agreementMajorChange.getPostWarantty().intValue()));
                    }
                    if (agreementMajorChange.getPostSupplyCycle() != null) {
                        agrChangeConsumerReqBO.setSupplyCycle(Integer.valueOf(agreementMajorChange.getPostSupplyCycle()));
                    }
                    if (agreementMajorChange.getPostScopeType() != null) {
                        agrChangeConsumerReqBO.setScopeType(Integer.valueOf(agreementMajorChange.getPostScopeType().intValue()));
                    }
                    if (agreementMajorChange.getPostIsDispatch() != null) {
                        agrChangeConsumerReqBO.setIsDispatch(agreementMajorChange.getPostIsDispatch());
                    }
                    agrChangeConsumerReqBO.setUpdateLoginId(approveLoginId);
                    agrChangeConsumerReqBO.setRemark(agreementMajorChange.getRemark());
                    agrChangeConsumerReqBO.setMajorChangeId(agreementMajorChange.getMajorChangeId());
                    if (agreementMajorChange == null) break;
                    Integer approveResult = agreementApproveLogPO.getApproveResult();
                    if (approveResult == 1) {
                        List<AgreementAddPriceChange> changeRecords;
                        SupplierAgreement supplierAgreement = new SupplierAgreement();
                        BeanUtils.copyProperties((Object)agrChangeConsumerReqBO, (Object)supplierAgreement);
                        supplierAgreement.setScopeType(agrChangeConsumerReqBO.getScopeType().byteValue());
                        supplierAgreement.setIsAddPrice(agreementMajorChange.getPostIsAddPrice());
                        supplierAgreement.setServiceRate(agrChangeConsumerReqBO.getServiceRate());
                        if (agreementMajorChange.getPostWarantty() != null) {
                            supplierAgreement.setWarantty(agreementMajorChange.getPostWarantty());
                        }
                        if (agreementMajorChange.getPostAdjustPrice() != null) {
                            supplierAgreement.setAdjustPrice(agreementMajorChange.getPostAdjustPrice());
                        }
                        this.supplierAgreementMapper.updateAgrMajorById(supplierAgreement);
                        if (this.scopeChangeMapper.selectScopeChgCntByMajorId(agreementMajorChange.getMajorChangeId(), agreementMajorChange.getSupplierId()) > 0) {
                            this.agreementScopeMapper.updateAgrScopeById(approveLoginId, agreementMajorChange.getAgreementId(), agreementMajorChange.getSupplierId());
                            this.agreementScopeMapper.insertScopeByScopeChg(agreementMajorChange.getMajorChangeId(), agreementMajorChange.getSupplierId(), approveLoginId);
                        }
                        if ((changeRecords = this.agreementAddPriceChangeMapper.selectByChangeId(agreementApproveLogPO.getChangeId())) != null && changeRecords.size() > 0) {
                            this.agreementAddPriceValueMapper.deleteByAgreementId(agreementMajorChange.getAgreementId(), agreementMajorChange.getSupplierId());
                            this.agreementAddPricePropMapper.deleteByAgreementId(agreementMajorChange.getAgreementId(), agreementMajorChange.getSupplierId());
                            ArrayList<AgreementAddPriceProp> list = new ArrayList<AgreementAddPriceProp>();
                            AgreementAddPriceProp agreementAddPriceProp = null;
                            Byte isDelete = 0;
                            List<AgreementAddPriceValueChange> agreementAddPriceValueChanges = null;
                            ArrayList<AgreementAddPriceValue> agreementAddPriceValues = null;
                            AgreementAddPriceValue agreementAddPriceValue = null;
                            for (AgreementAddPriceChange agreementAddPriceChange : changeRecords) {
                                Long agrAddPricePropSeq = this.agreementAddPricePropMapper.generateAgrAddPricePropSeq();
                                agreementAddPriceProp = new AgreementAddPriceProp();
                                agreementAddPriceProp.setAddPriceDefId(agrAddPricePropSeq);
                                agreementAddPriceProp.setAddPriceDefCode(agreementAddPriceChange.getAddPriceDefCode());
                                agreementAddPriceProp.setAddPriceDefName(agreementAddPriceChange.getAddPriceDefName());
                                agreementAddPriceProp.setAddPriceDefShowName(agreementAddPriceChange.getAddPriceDefShowName());
                                agreementAddPriceProp.setAgreementId(agreementAddPriceChange.getAgreementId());
                                agreementAddPriceProp.setCreateLoginId(agreementAddPriceChange.getCreateLoginId());
                                agreementAddPriceProp.setCreateTime(new Date());
                                agreementAddPriceProp.setIsDelete(isDelete);
                                agreementAddPriceProp.setRemark(agreementAddPriceChange.getRemark());
                                agreementAddPriceProp.setSupplierId(agreementAddPriceChange.getSupplierId());
                                list.add(agreementAddPriceProp);
                                agreementAddPriceValueChanges = this.agreementAddPriceValueChangeMapper.selectByPriceDefId(agreementAddPriceChange.getAddPriceDefId());
                                if (agreementAddPriceValueChanges == null || agreementAddPriceValueChanges.size() <= 0) continue;
                                agreementAddPriceValues = new ArrayList<AgreementAddPriceValue>();
                                for (AgreementAddPriceValueChange agreementAddPriceValueChange : agreementAddPriceValueChanges) {
                                    agreementAddPriceValue = new AgreementAddPriceValue();
                                    agreementAddPriceValue.setAddPriceDefId(agrAddPricePropSeq);
                                    agreementAddPriceValue.setAddPriceFluctuateType(agreementAddPriceValueChange.getAddPriceFluctuateType());
                                    agreementAddPriceValue.setAddPriceFluctuateValue(agreementAddPriceValueChange.getAddPriceFluctuateValue());
                                    agreementAddPriceValue.setAddPriceValue(agreementAddPriceValueChange.getAddPriceValue());
                                    agreementAddPriceValue.setAddPriceValueName(agreementAddPriceValueChange.getAddPriceValueName());
                                    agreementAddPriceValue.setCreateLoginId(agreementAddPriceValueChange.getCreateLoginId());
                                    agreementAddPriceValue.setCreateTime(new Date());
                                    agreementAddPriceValue.setIsDelete(isDelete);
                                    agreementAddPriceValue.setRemark(agreementAddPriceValueChange.getRemark());
                                    agreementAddPriceValue.setSupplierId(agreementAddPriceValueChange.getSupplierId());
                                    agreementAddPriceValues.add(agreementAddPriceValue);
                                }
                                this.agreementAddPriceValueMapper.insertBatch(agreementAddPriceValues);
                            }
                            this.agreementAddPricePropMapper.insertBatch(list);
                        }
                    }
                    this.agrChangeProducer.sendOneway(new ProxyMessage(this.topicConfig.getAgrChgTopicName(), this.topicConfig.getAgrChgTagName(), JSONObject.toJSONString((Object)agrChangeConsumerReqBO)));
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6838\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u8d25" + e);
            return successFlag;
        }
        successFlag = true;
        return successFlag;
    }

    private void updateStatus(AgrStsChgConsumerReqBO agrStsChgConsumerReqBO) {
        Integer approveResult = agrStsChgConsumerReqBO.getApproveResult();
        SupplierAgreement supplierAgreement = new SupplierAgreement();
        BeanUtils.copyProperties((Object)agrStsChgConsumerReqBO, (Object)supplierAgreement);
        supplierAgreement.setUpdateLoginId(agrStsChgConsumerReqBO.getOperId());
        supplierAgreement.setUpdateTime(new Date());
        Byte pauseStatus = Constant.AGR_STATUS_PAUSE.byteValue();
        Byte backStatus = Constant.AGR_STATUS_BACK.byteValue();
        SupplierAgreement agreement = this.supplierAgreementMapper.selectById(supplierAgreement.getAgreementId(), supplierAgreement.getSupplierId());
        if (approveResult == 1) {
            supplierAgreement.setAgreementStatus(agrStsChgConsumerReqBO.getAgreementStatus().byteValue());
            Integer approveType = agrStsChgConsumerReqBO.getApproveType();
            if (approveType == 0 && (agreement.getAgreementSrc().intValue() == 0 || agreement.getAgreementSrc().intValue() == 3)) {
                try {
                    AssignStatusChangeConsumerBO assignStatusChangeConsumerBO = new AssignStatusChangeConsumerBO();
                    ArrayList<AddAgrProducerChangeLogReqVO> addAgrProducerChangeLogReqVOs = new ArrayList<AddAgrProducerChangeLogReqVO>();
                    AddAgrProducerChangeLogReqVO addAgrProducerChangeLogReqVO = new AddAgrProducerChangeLogReqVO();
                    addAgrProducerChangeLogReqVO.setAgreementId(agreement.getAgreementId());
                    addAgrProducerChangeLogReqVO.setAgreementName(agreement.getAgreementName());
                    addAgrProducerChangeLogReqVO.setCreateLoginId(agreement.getCreateLoginId());
                    addAgrProducerChangeLogReqVO.setCreateTime(new Date());
                    addAgrProducerChangeLogReqVO.setIsDelete(Byte.valueOf((byte)1));
                    addAgrProducerChangeLogReqVO.setOperater(agreement.getProducerName());
                    addAgrProducerChangeLogReqVO.setOperateTime(new Date());
                    addAgrProducerChangeLogReqVO.setPostProducerId(agreement.getProducerId());
                    addAgrProducerChangeLogReqVO.setPostProducerName(agreement.getProducerName());
                    addAgrProducerChangeLogReqVO.setPreProducerId(agreement.getProducerId());
                    addAgrProducerChangeLogReqVO.setPreProducerName(agreement.getProducerName());
                    addAgrProducerChangeLogReqVO.setSupplierId(agreement.getSupplierId());
                    addAgrProducerChangeLogReqVO.setSupplierName(agreement.getSupplierName());
                    addAgrProducerChangeLogReqVO.setUpdateLoginId(agreement.getUpdateLoginId());
                    addAgrProducerChangeLogReqVO.setAgrLocation(agreement.getAgrLocation());
                    addAgrProducerChangeLogReqVO.setUpdateTime(new Date());
                    addAgrProducerChangeLogReqVOs.add(addAgrProducerChangeLogReqVO);
                    assignStatusChangeConsumerBO.setAddAgrProducerChangeLogReqVOs(addAgrProducerChangeLogReqVOs);
                    this.assignStatusChangeProducer.sendOneway(new ProxyMessage(this.topicConfig.getAssignStatusChangeTopicName(), this.topicConfig.getAssignStatusChangeTagName(), JSONObject.toJSONString((Object)assignStatusChangeConsumerBO)));
                }
                catch (Exception e) {
                    logger.error("\u6839\u636e\u534f\u8bae\u66f4\u65b0\u7f16\u5236\u4eba\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u65b0\u589e\u5386\u53f2\u8bb0\u5f55\u6d88\u606f\u5931\u8d25" + e);
                }
            }
            if (approveType == 1) {
                supplierAgreement.setAgreementStatus(pauseStatus);
            }
        } else if (approveResult == 0) {
            supplierAgreement.setAgreementStatus(backStatus);
            Integer approveType = agrStsChgConsumerReqBO.getApproveType();
            if (approveType == 1 || approveType == 3) {
                Byte usingStatus = Constant.AGR_STATUS_USING.byteValue();
                supplierAgreement.setAgreementStatus(usingStatus);
            }
            if (agreement != null && agreement.getAgreementStatus() != null && agreement.getAgreementStatus() == 3 && (approveType == 2 || approveType == 3)) {
                supplierAgreement.setAgreementStatus(pauseStatus);
            }
        }
        this.supplierAgreementMapper.updateAgrStsById(supplierAgreement);
    }

    private void updateApprovedStatus(AgrDelayConsumerReqBO agrDelayConsumerReqBO) {
        Integer approveResult = agrDelayConsumerReqBO.getApproveResult();
        if (approveResult == 1) {
            this.supplierAgreementMapper.updateAgrEndDateById(agrDelayConsumerReqBO.getAgreementId(), agrDelayConsumerReqBO.getSupplierId(), agrDelayConsumerReqBO.getPostInvalidDate(), agrDelayConsumerReqBO.getUpdateLoginId());
        }
    }

    private void updateAgrDetailsById(AgrDetailsAndPriceChgConsumerReqBO agrDetailsAndPriceChgConsumerReqBO) {
        Integer approveResult = agrDetailsAndPriceChgConsumerReqBO.getApproveResult();
        if (approveResult == 1) {
            SupplierAgreementSku supplierAgreementSku = new SupplierAgreementSku();
            BeanUtils.copyProperties((Object)agrDetailsAndPriceChgConsumerReqBO, (Object)supplierAgreementSku);
            this.supplierAgreementSkuMapper.updateAgrDetailsById(supplierAgreementSku);
            if (agrDetailsAndPriceChgConsumerReqBO.getSkuPriceConsumerReqBO() != null) {
                SkuPrice skuPrice = new SkuPrice();
                skuPrice.setAgreementSkuId(agrDetailsAndPriceChgConsumerReqBO.getAgreementSkuId());
                skuPrice.setSupplierId(agrDetailsAndPriceChgConsumerReqBO.getSupplierId());
                skuPrice.setSalePrice(agrDetailsAndPriceChgConsumerReqBO.getSkuPriceConsumerReqBO().getSalePrice());
                skuPrice.setMemberPrice(agrDetailsAndPriceChgConsumerReqBO.getSkuPriceConsumerReqBO().getMemberPrice());
                skuPrice.setAgreementPrice(agrDetailsAndPriceChgConsumerReqBO.getSkuPriceConsumerReqBO().getAgreementPrice());
                skuPrice.setUpdateLoginId(agrDetailsAndPriceChgConsumerReqBO.getUpdateLoginId());
                skuPrice.setUpdateTime(new Date());
                this.skuPriceMapper.updatePriceByAgrSkuId(skuPrice);
            }
            SupplierAgreement supplierAgreement = new SupplierAgreement();
            BeanUtils.copyProperties((Object)agrDetailsAndPriceChgConsumerReqBO, (Object)supplierAgreement);
            supplierAgreement.setUpdateLoginId(agrDetailsAndPriceChgConsumerReqBO.getUpdateLoginId());
            supplierAgreement.setUpdateTime(new Date());
            Byte usByteStatus = Constant.AGR_STATUS_USING.byteValue();
            supplierAgreement.setAgreementStatus(usByteStatus);
            this.supplierAgreementMapper.updateAgrStsById(supplierAgreement);
        }
    }

    private String checkMustParams(AgreementApproveLogBO agreementApproveLogBO) {
        StringBuffer errorStr = new StringBuffer();
        if (agreementApproveLogBO.getAgreementId() == null) {
            errorStr.append("\u534f\u8baeID[agreementId]");
        }
        if (null == agreementApproveLogBO.getSupplierId()) {
            errorStr.append("\u94fa\u8d27\u5355\u4f4dID[supplierId]");
        }
        if (null == agreementApproveLogBO.getApproveType()) {
            errorStr.append("\u5ba1\u6279\u7c7b\u578b[approveType]");
        }
        if (agreementApproveLogBO.getApproveType() != null && agreementApproveLogBO.getApproveType() != 0) {
            if (null == agreementApproveLogBO.getChangeId()) {
                errorStr.append("\u53d8\u66f4ID[changeId]");
            }
            if (StringUtils.isBlank((CharSequence)agreementApproveLogBO.getChangeCode())) {
                errorStr.append("\u7533\u8bf7\u7f16\u53f7[changeCode]");
            }
        }
        if (agreementApproveLogBO.getAcceptIds() == null || agreementApproveLogBO.getAcceptIds().size() == 0) {
            errorStr.append("\u5f85\u529e\u4eba[acceptId]");
        }
        if (StringUtils.isBlank((CharSequence)agreementApproveLogBO.getTaskId())) {
            errorStr.append("\u5de5\u4f5c\u6d41\u4efb\u52a1ID[taskId]");
        }
        if (StringUtils.isBlank((CharSequence)agreementApproveLogBO.getTaskNode())) {
            errorStr.append("\u5de5\u4f5c\u6d41\u8282\u70b9[taskNode]");
        }
        if (StringUtils.isBlank((CharSequence)agreementApproveLogBO.getProcInstlId())) {
            errorStr.append("\u5de5\u4f5c\u6d41\u5b9e\u4f8bID[procInstlId]");
        }
        if (agreementApproveLogBO.getCreateLoginId() == null) {
            errorStr.append("\u5f53\u524d\u767b\u9646\u4ebaID[createLoginId]");
        }
        return errorStr.toString();
    }
}

