/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.manage.market.impl;

import com.ohaotian.commodity.busi.manage.market.web.QueryElecSkuBrandService;
import com.ohaotian.commodity.busi.manage.market.web.bo.QueryElecSkuBrandReqBO;
import com.ohaotian.commodity.busi.manage.market.web.bo.QueryElecSkuBrandRspBO;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryElecSkuBrandService")
public class QueryElecSkuBrandServiceImpl
implements QueryElecSkuBrandService {
    private static final Logger logger = LoggerFactory.getLogger(QueryElecSkuBrandServiceImpl.class);
    private final boolean isDebugEnablled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;

    public RspPageBO<QueryElecSkuBrandRspBO> queryElecSkuBrand(QueryElecSkuBrandReqBO queryElecSkuBrandReqBO) {
        if (this.isDebugEnablled) {
            logger.debug("\u5206\u9875\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u54c1\u724c\u670d\u52a1\u5165\u53c2:" + queryElecSkuBrandReqBO.toString());
        }
        if (0 == queryElecSkuBrandReqBO.getPageNo()) {
            queryElecSkuBrandReqBO.setPageNo(1);
        }
        RspPageBO rspPage = new RspPageBO();
        ArrayList<QueryElecSkuBrandRspBO> rspBOList = new ArrayList<QueryElecSkuBrandRspBO>();
        Page page = new Page(queryElecSkuBrandReqBO.getPageNo(), queryElecSkuBrandReqBO.getPageSize());
        try {
            List<String> brandNameList = this.skuMapper.qryBrandNameByPage((Page<String>)page, queryElecSkuBrandReqBO.getBrandName());
            for (String value : brandNameList) {
                QueryElecSkuBrandRspBO queryElecSkuBrandRspBO = new QueryElecSkuBrandRspBO();
                queryElecSkuBrandRspBO.setBrandName(value);
                rspBOList.add(queryElecSkuBrandRspBO);
            }
            rspPage.setRecordsTotal(page.getTotalCount());
            rspPage.setRows(rspBOList);
            rspPage.setTotal(page.getTotalPages());
            rspPage.setPageNo(queryElecSkuBrandReqBO.getPageNo());
            rspPage.setRespCode("0000");
            rspPage.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u67e5\u8be2\u54c1\u724c\u670d\u52a1\uff08\u652f\u6301\u6a21\u7cca\u67e5\u8be2\uff09\u670d\u52a1\u51fa\u9519" + e);
            rspPage.setRespCode("8888");
            rspPage.setRespDesc("\u5931\u8d25");
        }
        return rspPage;
    }
}

