/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.price.impl;

import com.ohaotian.commodity.busi.price.BatchQuerySkuPriceBusiService;
import com.ohaotian.commodity.busi.price.bo.BatchQuerySkuPriceReqBO;
import com.ohaotian.commodity.busi.price.bo.BatchQuerySkuPriceRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuPriceBO;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.po.SkuPrice;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="batchQuerySkuPriceBusiService")
@Qualifier
public class BatchQuerySkuPriceBusiServiceImpl
implements BatchQuerySkuPriceBusiService {
    private static final Logger logger = LoggerFactory.getLogger(BatchQuerySkuPriceBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private final SkuPriceMapper skuPriceMapper;

    @Autowired
    public BatchQuerySkuPriceBusiServiceImpl(SkuPriceMapper skuPriceMapper) {
        Assert.notNull((Object)skuPriceMapper, (String)"SkuPriceMapper\u4e0d\u80fd\u4e3a\u7a7a");
        this.skuPriceMapper = skuPriceMapper;
    }

    public BatchQuerySkuPriceRspBO batchQuerySkuPrice(BatchQuerySkuPriceReqBO batchQuerySkuPriceReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5355\u54c1\u4ef7\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + batchQuerySkuPriceReqBO.toString());
        }
        BatchQuerySkuPriceRspBO rspBO = new BatchQuerySkuPriceRspBO();
        try {
            List<SkuPrice> skuPrices = this.skuPriceMapper.selectBySkuIdsAndSupplierId(batchQuerySkuPriceReqBO.getSkuIds(), batchQuerySkuPriceReqBO.getSupplierId());
            ArrayList<SkuPriceBO> skuPriceBOS = new ArrayList<SkuPriceBO>();
            for (SkuPrice price : skuPrices) {
                SkuPriceBO skuPriceBO = new SkuPriceBO();
                BeanUtils.copyProperties((Object)price, (Object)skuPriceBO);
                skuPriceBOS.add(skuPriceBO);
            }
            rspBO.setPrices(skuPriceBOS);
        }
        catch (Exception e) {
            logger.error("\u5355\u54c1\u4ef7\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u54c1\u4ef7\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        return rspBO;
    }
}

