/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.custom.search.impl;

import com.ohaotian.commodity.busi.bo.SearchBarEsRspInfo;
import com.ohaotian.commodity.custom.search.SearchEsResultService;
import com.ohaotian.commodity.custom.search.bo.SearchEsQueryRspBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsResultRspBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsRspInfoBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import java.util.ArrayList;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier
public class SearchEsResultServiceImpl
implements SearchEsResultService {
    private static final Logger logger = LoggerFactory.getLogger(SearchEsResultServiceImpl.class);

    public SearchEsResultRspBO searchResult(SearchEsQueryRspBO searchEsQueryRspBO) {
        logger.info("SearchEsResultService\u5165\u53c2\uff1a" + searchEsQueryRspBO.toString());
        SearchEsResultRspBO bo = new SearchEsResultRspBO();
        ArrayList<SearchEsRspInfoBO> rspInfos = new ArrayList<SearchEsRspInfoBO>();
        SearchBarEsRspInfo rspInfo = new SearchBarEsRspInfo();
        SearchResponse searchResponse = searchEsQueryRspBO.getSearchResponse();
        if (searchResponse.getHits().getTotalHits() == 0L) {
            throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u641c\u7d22\u680f\u641c\u7d22\u4e1a\u52a1 \u641c\u7d22\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6216\u641c\u7d22\u6761\u4ef6\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
        for (SearchHit hit : searchResponse.getHits()) {
            System.out.println("----skuid=" + hit.getSource().get("sku_id"));
            rspInfo = new SearchBarEsRspInfo();
            rspInfo.setSkuId(String.valueOf(hit.getSource().get("sku_id")));
            rspInfo.setExtSkuId(String.valueOf(hit.getSource().get("ext_sku_id")));
            rspInfo.setPriPicUrl(String.valueOf(hit.getSource().get("picture_url")));
            rspInfo.setSaleArea(String.valueOf(hit.getSource().get("sale_area")));
            rspInfo.setSkuName(String.valueOf(hit.getSource().get("sku_name")));
            rspInfo.setSkuLocation(String.valueOf(hit.getSource().get("sku_location")));
            rspInfo.setSupplierId(Long.valueOf(Long.parseLong(String.valueOf(hit.getSource().get("supplier_id")))));
            rspInfo.setSupplierName(String.valueOf(hit.getSource().get("supplier_name")));
            try {
                if (hit.getSource().get("market_price") != null) {
                    rspInfo.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(hit.getSource().get("market_price")))));
                }
                if (hit.getSource().get("sale_price") != null) {
                    rspInfo.setSalePrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(hit.getSource().get("sale_price")))));
                }
                if (hit.getSource().get("member_price") != null) {
                    rspInfo.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(hit.getSource().get("member_price")))));
                }
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
            SearchEsRspInfoBO SearchBarEsRspInfoVO = new SearchEsRspInfoBO();
            BeanUtils.copyProperties((Object)rspInfo, (Object)SearchBarEsRspInfoVO);
            rspInfos.add(SearchBarEsRspInfoVO);
        }
        bo.setTotalCount(Long.valueOf(searchResponse.getHits().getTotalHits()));
        bo.setResult(rspInfos);
        return bo;
    }
}

