/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.intfce.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.atom.GenerateBrandSeqService;
import com.cgd.commodity.atom.bo.GenerateBrandSeqRspBO;
import com.cgd.commodity.dao.BrandMapper;
import com.cgd.commodity.dao.CommodityTypeMapper;
import com.cgd.commodity.dao.EMdmMaterialMapper;
import com.cgd.commodity.intfce.bo.BrandConsumerBO;
import com.cgd.commodity.po.Brand;
import com.cgd.commodity.po.CommodityType;
import com.cgd.commodity.po.EMdmMaterial;
import com.gd.commodity.busi.UpdateAgreementSkuIsDeleteService;
import com.gd.commodity.busi.bo.agreement.SupplierAgreementSkuReqBO;
import com.gd.commodity.busi.bo.agreement.UpdateAgreementSkuIsDeleteServiceReqBo;
import com.gd.commodity.busi.bo.agreement.UpdateAgreementSkuIsDeleteServiceRspBo;
import com.gd.commodity.busi.vo.agreement.AgrAdjustPriceFormulaInfoVO;
import com.gd.commodity.constant.Constant;
import com.gd.commodity.dao.AdjustPriceForMulaInfoMapper;
import com.gd.commodity.dao.AdjustPriceFormulaMapper;
import com.gd.commodity.dao.AgrAdjustPriceFormulaMapper;
import com.gd.commodity.dao.CommodityMeasureMapper;
import com.gd.commodity.dao.SupplierAgreementSkuMapper;
import com.gd.commodity.intfce.BatAddSupplierAgreementSkuService;
import com.gd.commodity.intfce.bo.agreement.BatAddSupplierAgreementSkuReqBO;
import com.gd.commodity.intfce.bo.agreement.BatAddSupplierAgreementSkuRspBO;
import com.gd.commodity.po.AdjustPriceForMulaInfo;
import com.gd.commodity.po.AdjustPriceFormula;
import com.gd.commodity.po.AgrAdjustPriceFormula;
import com.gd.commodity.po.CommodityMeasure;
import com.gd.commodity.po.SupplierAgreementSku;
import com.ohaotian.commodity.config.TopicConfig;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class BatAddSupplierAgreementSkuServiceImpl
implements BatAddSupplierAgreementSkuService {
    private static final Logger logger = LoggerFactory.getLogger(BatAddSupplierAgreementSkuServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private UpdateAgreementSkuIsDeleteService updateAgreementSkuIsDeleteService;
    @Autowired
    private BrandMapper brandMapper;
    @Autowired
    private CommodityMeasureMapper commodityMeasureMapper;
    @Autowired
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    @Autowired
    private GenerateBrandSeqService generateBrandSeqService;
    @Autowired
    private EMdmMaterialMapper eMdmMaterialMapper;
    @Autowired
    private AdjustPriceFormulaMapper adjustPriceFormulaMapper;
    private AdjustPriceForMulaInfoMapper adjustPriceForMulaInfoMapper;
    @Autowired
    private AgrAdjustPriceFormulaMapper agrAdjustPriceFormulaMapper;
    @Autowired
    private CommodityTypeMapper commodityTypeMapper;
    @Resource
    private TopicConfig topicConfig;
    @Resource(name="brandInstServiceProducer")
    private ProxyMessageProducer producerBrand;

    public void setAdjustPriceForMulaInfoMapper(AdjustPriceForMulaInfoMapper adjustPriceForMulaInfoMapper) {
        this.adjustPriceForMulaInfoMapper = adjustPriceForMulaInfoMapper;
    }

    public BatAddSupplierAgreementSkuRspBO addSupplierAgreementSkuBat(BatAddSupplierAgreementSkuReqBO batAddSupplierAgreementSkuReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6279\u91cf\u63d2\u5165\u534f\u8bae\u660e\u7ec6\u670d\u52a1\u5165\u53c2\uff1a" + batAddSupplierAgreementSkuReqBO.toString());
        }
        try {
            BatAddSupplierAgreementSkuRspBO batAddSupplierAgreementSkuRspBO = new BatAddSupplierAgreementSkuRspBO();
            if (StringUtils.isEmpty((Object)batAddSupplierAgreementSkuReqBO.getUploadAgreementFlag()) || "0".equals(batAddSupplierAgreementSkuReqBO.getUploadAgreementFlag())) {
                UpdateAgreementSkuIsDeleteServiceReqBo updateAgreementSkuIsDeleteServiceReqBo = new UpdateAgreementSkuIsDeleteServiceReqBo();
                updateAgreementSkuIsDeleteServiceReqBo.setAgreementId(batAddSupplierAgreementSkuReqBO.getAgreementId());
                updateAgreementSkuIsDeleteServiceReqBo.setSupplierId(batAddSupplierAgreementSkuReqBO.getSupplierId());
                UpdateAgreementSkuIsDeleteServiceRspBo updateAgreementSkuIsDeleteServiceRspBo = this.updateAgreementSkuIsDeleteService.updateAgreementSkuIsDelete(updateAgreementSkuIsDeleteServiceReqBo);
                if (null != updateAgreementSkuIsDeleteServiceRspBo && "0000".equals(updateAgreementSkuIsDeleteServiceRspBo.getRespCode())) {
                    batAddSupplierAgreementSkuRspBO = this.addSupplierAgreementSku(batAddSupplierAgreementSkuReqBO);
                } else {
                    batAddSupplierAgreementSkuRspBO.setIsSuccess(Boolean.valueOf(false));
                    batAddSupplierAgreementSkuRspBO.setRespCode(updateAgreementSkuIsDeleteServiceRspBo.getRespCode());
                    batAddSupplierAgreementSkuRspBO.setResultMsg(updateAgreementSkuIsDeleteServiceRspBo.getRespDesc());
                    batAddSupplierAgreementSkuRspBO.setRespDesc(updateAgreementSkuIsDeleteServiceRspBo.getRespDesc());
                }
            } else {
                batAddSupplierAgreementSkuRspBO = this.addSupplierAgreementSku(batAddSupplierAgreementSkuReqBO);
            }
            if (null == batAddSupplierAgreementSkuRspBO.getIsSuccess()) {
                batAddSupplierAgreementSkuRspBO.setIsSuccess(Boolean.valueOf(true));
            }
            return batAddSupplierAgreementSkuRspBO;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u63d2\u5165\u534f\u8bae\u660e\u7ec6\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6279\u91cf\u63d2\u5165\u534f\u8bae\u660e\u7ec6\u670d\u52a1\u5931\u8d25");
        }
    }

    private BatAddSupplierAgreementSkuRspBO addSupplierAgreementSku(BatAddSupplierAgreementSkuReqBO batAddSupplierAgreementSkuReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + batAddSupplierAgreementSkuReqBO.toString());
        }
        BatAddSupplierAgreementSkuRspBO supplierAgreementSkuRspBO = new BatAddSupplierAgreementSkuRspBO();
        ArrayList<String> materialIdList = new ArrayList<String>();
        HashMap<String, CommodityMeasure> measureNameMap = new HashMap<String, CommodityMeasure>();
        for (SupplierAgreementSkuReqBO supplierAgreementSkuReqBO : batAddSupplierAgreementSkuReqBO.getSupplierAgreementSkus()) {
            if (supplierAgreementSkuReqBO.getMarkupRate().intValue() > 999) {
                supplierAgreementSkuRspBO.setIsSuccess(Boolean.valueOf(false));
                supplierAgreementSkuRspBO.setRespCode("8888");
                supplierAgreementSkuRspBO.setRespDesc("\u52a0\u4ef7\u6bd4\u7387\u4e0d\u80fd\u8d85\u8fc71000");
                supplierAgreementSkuRspBO.setResultMsg("\u52a0\u4ef7\u6bd4\u7387\u4e0d\u80fd\u8d85\u8fc71000");
                return supplierAgreementSkuRspBO;
            }
            if (StringUtils.isEmpty((Object)supplierAgreementSkuReqBO.getMaterialId()) || materialIdList.contains(supplierAgreementSkuReqBO.getMaterialId()) || supplierAgreementSkuReqBO.getIsMaterialId() != 1) continue;
            materialIdList.add(supplierAgreementSkuReqBO.getMaterialId());
        }
        List<EMdmMaterial> eMdmMaterialList = this.eMdmMaterialMapper.selectByCodeList(materialIdList);
        supplierAgreementSkuRspBO = this.checkEMdmMaterial(eMdmMaterialList, materialIdList);
        if (!supplierAgreementSkuRspBO.getIsSuccess().booleanValue()) {
            return supplierAgreementSkuRspBO;
        }
        List<CommodityType> commodityTypeList = this.commodityTypeMapper.selectByEMdmMaterialCatalogId(eMdmMaterialList);
        HashMap<Long, CommodityType> commodityTypeMap = new HashMap<Long, CommodityType>();
        if (commodityTypeList != null && commodityTypeList.size() > 0) {
            for (CommodityType commodityType : commodityTypeList) {
                commodityTypeMap.put(commodityType.getCatalogId(), commodityType);
            }
        }
        HashMap<Long, EMdmMaterial> eMdmMaterialMap = new HashMap<Long, EMdmMaterial>();
        for (EMdmMaterial eMdmMaterial : eMdmMaterialList) {
            eMdmMaterialMap.put(eMdmMaterial.getMaterialCode(), eMdmMaterial);
        }
        ArrayList<SupplierAgreementSku> arrayList = new ArrayList<SupplierAgreementSku>();
        HashMap<String, Long> brandNameIdMap = new HashMap<String, Long>();
        AdjustPriceFormula adjustPriceFormula = null;
        List<AdjustPriceForMulaInfo> adjustPriceForMulaInfos = null;
        Long agrAdjustPriceFormulaId = batAddSupplierAgreementSkuReqBO.getAgrAdjustPriceFormulaId();
        if (null != agrAdjustPriceFormulaId) {
            adjustPriceFormula = this.adjustPriceFormulaMapper.selectByPrimaryKey(agrAdjustPriceFormulaId);
            Byte formulaInfoType = 1;
            adjustPriceForMulaInfos = this.adjustPriceForMulaInfoMapper.selectByFormulaId(agrAdjustPriceFormulaId, formulaInfoType);
        }
        ArrayList<AgrAdjustPriceFormula> agrAdjustPriceFormulaList = new ArrayList<AgrAdjustPriceFormula>();
        try {
            for (SupplierAgreementSkuReqBO supplierAgreementSkuReqBO : batAddSupplierAgreementSkuReqBO.getSupplierAgreementSkus()) {
                CommodityMeasure commodityMeasure;
                CommodityType commodityType;
                SupplierAgreementSku supplierAgreementSkuPO = new SupplierAgreementSku();
                BeanUtils.copyProperties((Object)supplierAgreementSkuReqBO, (Object)supplierAgreementSkuPO);
                Long supplierAgreementSkuSeq = this.supplierAgreementSkuMapper.generateSupplierAgreementSkuSeq();
                supplierAgreementSkuPO.setAgreementSkuId(supplierAgreementSkuSeq);
                supplierAgreementSkuPO.setBuyPrice(MoneyUtils.BigDecimal2Long((BigDecimal)supplierAgreementSkuReqBO.getBuyPrice()));
                supplierAgreementSkuPO.setBuyPriceSum(MoneyUtils.BigDecimal2Long((BigDecimal)supplierAgreementSkuReqBO.getBuyPriceSum()));
                supplierAgreementSkuPO.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)supplierAgreementSkuReqBO.getSalePrice()));
                supplierAgreementSkuPO.setSalePriceSum(MoneyUtils.BigDecimal2Long((BigDecimal)supplierAgreementSkuReqBO.getSalePriceSum()));
                supplierAgreementSkuPO.setMaterialId(supplierAgreementSkuReqBO.getMaterialId());
                supplierAgreementSkuPO.setIsDelete((byte)0);
                EMdmMaterial eMdmMaterial = (EMdmMaterial)eMdmMaterialMap.get(Long.valueOf(supplierAgreementSkuReqBO.getMaterialId()));
                if (null != eMdmMaterial && null != (commodityType = (CommodityType)commodityTypeMap.get(eMdmMaterial.getCatalogId()))) {
                    supplierAgreementSkuPO.setCommodityTypeId(commodityType.getCommodityTypeId());
                }
                Long brandId = null;
                if (!StringUtils.isEmpty((Object)supplierAgreementSkuReqBO.getBrandName()) && (brandId = (Long)brandNameIdMap.get(supplierAgreementSkuReqBO.getBrandName())) == null) {
                    Brand oldBrand = this.brandMapper.selectByName(supplierAgreementSkuReqBO.getBrandName());
                    if (null == oldBrand) {
                        GenerateBrandSeqRspBO generateBrandSeqRspBO = this.generateBrandSeqService.generateBrandSeq();
                        brandId = generateBrandSeqRspBO.getBrandId();
                        Brand record = new Brand();
                        record.setBrandId(generateBrandSeqRspBO.getBrandId());
                        record.setBrandName(supplierAgreementSkuReqBO.getBrandName());
                        record.setEffTime(DelFormatHelper.getNowYearAndMonthDay());
                        record.setExpTime(DelFormatHelper.getNowYearAndMonthDay((String)"2050-12-31"));
                        record.setBrandStatus(Constant.BRAND_STATUS_OPEN);
                        record.setCreateLoginId(supplierAgreementSkuReqBO.getUserId());
                        record.setCreateTime(new Date());
                        record.setIsDelete(Constant.IS_DELETE);
                        BrandConsumerBO brandConsumerBO = new BrandConsumerBO();
                        BeanUtils.copyProperties((Object)record, (Object)brandConsumerBO);
                        this.producerBrand.sendOneway(new ProxyMessage(this.topicConfig.getBrandTopicName(), this.topicConfig.getBrandTagName(), JSONObject.toJSONString((Object)brandConsumerBO)));
                    } else {
                        brandId = oldBrand.getBrandId();
                    }
                    brandNameIdMap.put(supplierAgreementSkuReqBO.getBrandName(), brandId);
                }
                if ((commodityMeasure = (CommodityMeasure)measureNameMap.get(supplierAgreementSkuReqBO.getMeasureName())) == null) {
                    commodityMeasure = this.commodityMeasureMapper.selectByName(supplierAgreementSkuReqBO.getMeasureName());
                    if (commodityMeasure != null) {
                        Long measureId = commodityMeasure.getMeasureId();
                        if (commodityMeasure.getMeasureType() == 0) {
                            supplierAgreementSkuPO.setBuyNumber(supplierAgreementSkuReqBO.getBuyNumber().setScale(0, 1));
                        }
                        supplierAgreementSkuPO.setMeasureId(measureId);
                        measureNameMap.put(supplierAgreementSkuReqBO.getMeasureName(), commodityMeasure);
                    }
                } else {
                    supplierAgreementSkuPO.setMeasureId(commodityMeasure.getMeasureId());
                }
                supplierAgreementSkuPO.setBrandId(brandId);
                supplierAgreementSkuPO.setCreateTime(new Date());
                supplierAgreementSkuPO.setCreateLoginId(supplierAgreementSkuReqBO.getUserId());
                arrayList.add(supplierAgreementSkuPO);
                if (null == agrAdjustPriceFormulaId) continue;
                this.initAgrAdjustPriceFormula(supplierAgreementSkuReqBO, supplierAgreementSkuSeq, adjustPriceFormula, adjustPriceForMulaInfos, agrAdjustPriceFormulaList);
            }
            this.supplierAgreementSkuMapper.batchInsert(arrayList);
            if (agrAdjustPriceFormulaList != null && agrAdjustPriceFormulaList.size() > 0) {
                this.agrAdjustPriceFormulaMapper.insertAgrAdjustPriceFormulaBatch(agrAdjustPriceFormulaList);
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            supplierAgreementSkuRspBO.setIsSuccess(Boolean.valueOf(false));
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                supplierAgreementSkuRspBO.setResultMsg(resultCode);
                return supplierAgreementSkuRspBO;
            }
            supplierAgreementSkuRspBO.setResultMsg("\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            return supplierAgreementSkuRspBO;
        }
        supplierAgreementSkuRspBO.setIsSuccess(Boolean.valueOf(true));
        supplierAgreementSkuRspBO.setResultMsg("\u534f\u8bae\u660e\u7ec6\u521d\u59cb\u5316\u6210\u529f");
        return supplierAgreementSkuRspBO;
    }

    private void initAgrAdjustPriceFormula(SupplierAgreementSkuReqBO supplierAgreementSkuReqBO, Long supplierAgreementSkuSeq, AdjustPriceFormula adjustPriceFormula, List<AdjustPriceForMulaInfo> adjustPriceForMulaInfos, List<AgrAdjustPriceFormula> agrAdjustPriceFormulaList) {
        if (adjustPriceFormula != null) {
            AgrAdjustPriceFormula agrAdjustPriceFormula;
            for (AgrAdjustPriceFormulaInfoVO agrAdjustPriceFormulaInfoVO : supplierAgreementSkuReqBO.getAgrAdjustPriceFormulaInfos()) {
                agrAdjustPriceFormula = new AgrAdjustPriceFormula();
                agrAdjustPriceFormula.setAgreementSkuId(supplierAgreementSkuSeq);
                agrAdjustPriceFormula.setAgrFormulaName(adjustPriceFormula.getFormulaName());
                agrAdjustPriceFormula.setAgrFormulaValue(adjustPriceFormula.getFormulaValue());
                agrAdjustPriceFormula.setAgrCreateComp(adjustPriceFormula.getCreateComp());
                agrAdjustPriceFormula.setAgrFormulaInfoType(agrAdjustPriceFormulaInfoVO.getAgrFormulaInfoType());
                agrAdjustPriceFormula.setAgrFormulaInfoFlag(agrAdjustPriceFormulaInfoVO.getAgrFormulaInfoFlag());
                agrAdjustPriceFormula.setAgrFormulaInfoShowDesc(agrAdjustPriceFormulaInfoVO.getAgrFormulaInfoShowDesc());
                agrAdjustPriceFormula.setAgrFormulaInfoDesc(agrAdjustPriceFormulaInfoVO.getAgrFormulaInfoDesc());
                agrAdjustPriceFormula.setAgrFormulaInfoValueType(agrAdjustPriceFormulaInfoVO.getAgrFormulaInfoValueType());
                try {
                    agrAdjustPriceFormula.setAgrFormulaInfoValue(MoneyUtils.BigDecimal2Long((BigDecimal)agrAdjustPriceFormulaInfoVO.getAgrFormulaInfoValue()));
                }
                catch (Exception e) {
                    logger.error("\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u534f\u8bae\u8c03\u4ef7\u516c\u5f0f\u5931\u8d25" + e);
                    throw new BusinessException("RSP_CODE_DAO_ERROR", "\u521d\u59cb\u5316\u534f\u8bae\u8c03\u4ef7\u516c\u5f0f\u5931\u8d25");
                }
                agrAdjustPriceFormula.setSupplierId(supplierAgreementSkuReqBO.getSupplierId());
                agrAdjustPriceFormula.setCreateLoginId(supplierAgreementSkuReqBO.getUserId());
                agrAdjustPriceFormula.setCreateTime(new Date());
                agrAdjustPriceFormula.setIsDelete(Constant.IS_DELETE.byteValue());
                agrAdjustPriceFormulaList.add(agrAdjustPriceFormula);
            }
            if (adjustPriceForMulaInfos != null && adjustPriceForMulaInfos.size() > 0) {
                for (AdjustPriceForMulaInfo adjustPriceForMulaInfo : adjustPriceForMulaInfos) {
                    agrAdjustPriceFormula = new AgrAdjustPriceFormula();
                    agrAdjustPriceFormula.setAgreementSkuId(supplierAgreementSkuSeq);
                    agrAdjustPriceFormula.setAgrFormulaName(adjustPriceFormula.getFormulaName());
                    agrAdjustPriceFormula.setAgrFormulaValue(adjustPriceFormula.getFormulaValue());
                    agrAdjustPriceFormula.setAgrCreateComp(adjustPriceFormula.getCreateComp());
                    agrAdjustPriceFormula.setAgrFormulaInfoType(adjustPriceForMulaInfo.getFormulaInfoType());
                    agrAdjustPriceFormula.setAgrFormulaInfoFlag(adjustPriceForMulaInfo.getFormulaInfoFlag());
                    agrAdjustPriceFormula.setAgrFormulaInfoShowDesc(adjustPriceForMulaInfo.getFormulaInfoShowDesc());
                    agrAdjustPriceFormula.setAgrFormulaInfoDesc(adjustPriceForMulaInfo.getFormulaInfoDesc());
                    agrAdjustPriceFormula.setAgrFormulaInfoValueType(adjustPriceForMulaInfo.getFormulaInfoValueType());
                    agrAdjustPriceFormula.setSupplierId(supplierAgreementSkuReqBO.getSupplierId());
                    agrAdjustPriceFormula.setCreateLoginId(supplierAgreementSkuReqBO.getUserId());
                    agrAdjustPriceFormula.setCreateTime(new Date());
                    agrAdjustPriceFormula.setIsDelete(Constant.IS_DELETE.byteValue());
                    agrAdjustPriceFormulaList.add(agrAdjustPriceFormula);
                }
            }
        }
    }

    private BatAddSupplierAgreementSkuRspBO checkEMdmMaterial(List<EMdmMaterial> eMdmMaterialList, List<String> materialIdList) {
        BatAddSupplierAgreementSkuRspBO supplierAgreementSkuRspBO = new BatAddSupplierAgreementSkuRspBO();
        supplierAgreementSkuRspBO.setIsSuccess(Boolean.valueOf(true));
        if (eMdmMaterialList == null || eMdmMaterialList.size() == 0) {
            supplierAgreementSkuRspBO.setIsSuccess(Boolean.valueOf(false));
            supplierAgreementSkuRspBO.setRespCode("8888");
            supplierAgreementSkuRspBO.setRespDesc("\u6240\u6709\u7269\u6599\u7f16\u7801\u5747\u4e0d\u5b58\u5728");
            supplierAgreementSkuRspBO.setResultMsg("\u6240\u6709\u7269\u6599\u7f16\u7801\u5747\u4e0d\u5b58\u5728");
            return supplierAgreementSkuRspBO;
        }
        if (materialIdList.size() != eMdmMaterialList.size()) {
            StringBuilder materialIdsb = new StringBuilder();
            for (String materialId : materialIdList) {
                boolean exist = false;
                for (EMdmMaterial eMdmMaterial : eMdmMaterialList) {
                    if (!eMdmMaterial.getMaterialCode().toString().equals(materialId)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                if (materialIdsb.length() > 0) {
                    materialIdsb.append(",").append(materialId);
                    continue;
                }
                materialIdsb.append(materialId);
            }
            supplierAgreementSkuRspBO.setIsSuccess(Boolean.valueOf(false));
            supplierAgreementSkuRspBO.setRespCode("8888");
            supplierAgreementSkuRspBO.setRespDesc("\u7269\u6599\u7f16\u7801[" + materialIdsb.toString() + "]\u4e0d\u5b58\u5728");
            supplierAgreementSkuRspBO.setResultMsg("\u7269\u6599\u7f16\u7801[" + materialIdsb.toString() + "]\u4e0d\u5b58\u5728");
            return supplierAgreementSkuRspBO;
        }
        StringBuilder materialIdsb = new StringBuilder();
        for (EMdmMaterial eMdmMaterial : eMdmMaterialList) {
            if (!StringUtils.isEmpty((Object)eMdmMaterial.getLongDesc())) continue;
            if (materialIdsb.length() > 0) {
                materialIdsb.append(",").append(eMdmMaterial.getMaterialCode());
                continue;
            }
            materialIdsb.append(eMdmMaterial.getMaterialCode());
        }
        if (materialIdsb.length() > 0) {
            supplierAgreementSkuRspBO.setIsSuccess(Boolean.valueOf(false));
            supplierAgreementSkuRspBO.setRespCode("8888");
            supplierAgreementSkuRspBO.setRespDesc("\u7269\u6599\u7f16\u7801[" + materialIdsb.toString() + "]\u4e0d\u5b58\u5728\u957f\u63cf\u8ff0");
            supplierAgreementSkuRspBO.setResultMsg("\u7269\u6599\u7f16\u7801[" + materialIdsb.toString() + "]\u4e0d\u5b58\u5728\u957f\u63cf\u8ff0");
            return supplierAgreementSkuRspBO;
        }
        return supplierAgreementSkuRspBO;
    }
}

