/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.sku.impl;

import com.ohaotian.commodity.busi.picture.QuerySkuPicBusiService;
import com.ohaotian.commodity.busi.picture.bo.QuerySkuPicReqBO;
import com.ohaotian.commodity.busi.picture.bo.QuerySkuPicRspBO;
import com.ohaotian.commodity.busi.price.BatchQuerySkuPriceBusiService;
import com.ohaotian.commodity.busi.price.bo.BatchQuerySkuPriceReqBO;
import com.ohaotian.commodity.busi.price.bo.BatchQuerySkuPriceRspBO;
import com.ohaotian.commodity.busi.sku.QuerySkuDetailBusiService;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailReqBO;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuPriceRspBO;
import com.ohaotian.commodity.busi.spec.QuerySkuSpecBusiService;
import com.ohaotian.commodity.busi.spec.bo.QuerySkuSpecReqBO;
import com.ohaotian.commodity.busi.spec.bo.QuerySkuSpecRspBO;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="querySkuDetailBusiService")
@Qualifier
public class QuerySkuDetailBusiServiceImpl
implements QuerySkuDetailBusiService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuDetailBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private BatchQuerySkuPriceBusiService batchQuerySkuPriceBusiService;
    @Autowired
    private QuerySkuSpecBusiService querySkuSpecBusiService;
    @Autowired
    private QuerySkuPicBusiService querySkuPicBusiService;

    public QuerySkuDetailRspBO querySkuDetail(QuerySkuDetailReqBO querySkuDetailReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + querySkuDetailReqBO.toString());
        }
        if (querySkuDetailReqBO.getSkuId() == null && StringUtils.isBlank((String)querySkuDetailReqBO.getExtSkuId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5355\u54c1Id[skuId]\u548c\u5916\u90e8\u5355\u54c1Id[extSkuId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        QuerySkuDetailRspBO rspBO = new QuerySkuDetailRspBO();
        try {
            Sku sku = new Sku();
            sku = querySkuDetailReqBO.getSkuId() != null ? this.skuMapper.selectBySkuIdAndSupplier(querySkuDetailReqBO.getSkuId(), querySkuDetailReqBO.getSupplierId()) : this.skuMapper.qryBySupplierIdAndExtSkuId(querySkuDetailReqBO.getSupplierId(), querySkuDetailReqBO.getExtSkuId());
            BeanUtils.copyProperties((Object)sku, (Object)rspBO);
            BatchQuerySkuPriceReqBO batchQuerySkuPriceReqBO = new BatchQuerySkuPriceReqBO();
            batchQuerySkuPriceReqBO.setSkuIds(Arrays.asList(sku.getSkuId()));
            batchQuerySkuPriceReqBO.setSupplierId(sku.getSupplierId());
            BatchQuerySkuPriceRspBO batchQuerySkuPriceRspBO = this.batchQuerySkuPriceBusiService.batchQuerySkuPrice(batchQuerySkuPriceReqBO);
            rspBO.setPrice((SkuPriceRspBO)batchQuerySkuPriceRspBO.getPrices().get(0));
            QuerySkuSpecReqBO querySkuSpecReqBO = new QuerySkuSpecReqBO();
            querySkuSpecReqBO.setSkuId(sku.getSkuId());
            querySkuSpecReqBO.setSupplierId(sku.getSupplierId());
            QuerySkuSpecRspBO querySkuSpecRspBO = this.querySkuSpecBusiService.querySkuSpec(querySkuSpecReqBO);
            rspBO.setSpecs(querySkuSpecRspBO.getSpecs());
            QuerySkuPicReqBO querySkuPicReqBO = new QuerySkuPicReqBO();
            querySkuPicReqBO.setSkuId(sku.getSkuId());
            querySkuPicReqBO.setSupplierId(sku.getSupplierId());
            QuerySkuPicRspBO querySkuPicRspBO = this.querySkuPicBusiService.querySkuPic(querySkuPicReqBO);
            rspBO.setPictures(querySkuPicRspBO.getPictures());
        }
        catch (Exception e) {
            logger.error("\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rspBO;
    }
}

