/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.BatchUpdateSkuPrice;
import com.cgd.commodity.busi.bo.BatchUpdateSkuPriceReqBo;
import com.cgd.commodity.busi.bo.BatchUpdateSkuPriceRspBo;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuPrice;
import com.cgd.electricitysupplier.busi.QrySkuPriceService;
import com.cgd.electricitysupplier.busi.bo.BusiQrySkuPriceReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySkuPriceRspBO;
import com.cgd.electricitysupplier.busi.vo.BusiQrySkuPriceRspVO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchUpdateSkuPriceImpl
implements BatchUpdateSkuPrice {
    private static final Logger logger = LoggerFactory.getLogger(BatchUpdateSkuPriceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private QrySkuPriceService qrySkuPriceService;
    private SkuPriceMapper skuPriceMapper;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setQrySkuPriceService(QrySkuPriceService qrySkuPriceService) {
        this.qrySkuPriceService = qrySkuPriceService;
    }

    public void setSkuPriceMapper(SkuPriceMapper skuPriceMapper) {
        this.skuPriceMapper = skuPriceMapper;
    }

    public BatchUpdateSkuPriceRspBo batchUpdateSkuPrice(BatchUpdateSkuPriceReqBo batchUpdateSkuPriceReqBo) {
        if (isDebugEnabled) {
            logger.debug("\u6279\u91cf\u66f4\u65b0\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4ef7\u683c\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + batchUpdateSkuPriceReqBo.toString());
        }
        BatchUpdateSkuPriceRspBo batchUpdateSkuPriceRspBo = new BatchUpdateSkuPriceRspBo();
        try {
            if (null == batchUpdateSkuPriceReqBo.getSupplierId()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6279\u91cf\u66f4\u65b0\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4ef7\u683c\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (batchUpdateSkuPriceReqBo.getSkuIds().isEmpty()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5546\u54c1ID\u96c6\u5408[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (batchUpdateSkuPriceReqBo.getSkuIds().size() > 100) {
                throw new BusinessException("RSP_CODE_SKU_NUM_MORE", "\u5546\u54c1\u4ef7\u683c\u5b9e\u65f6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u83b7\u53d6\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u6700\u591a\u652f\u6301100\u79cd\u5546\u54c1");
            }
            HashMap<String, Object> skuIdsParam = new HashMap<String, Object>();
            List skuIds = batchUpdateSkuPriceReqBo.getSkuIds();
            skuIdsParam.put("skuIds", skuIds);
            skuIdsParam.put("supplierId", batchUpdateSkuPriceReqBo.getSupplierId());
            List<String> extSkuIdList = this.skuMapper.qrySkuByIdsAndSupplierId(skuIdsParam);
            if (!extSkuIdList.isEmpty()) {
                BusiQrySkuPriceReqBO busiQrySkuPriceReqBO = new BusiQrySkuPriceReqBO();
                busiQrySkuPriceReqBO.setExtSkuIds(extSkuIdList);
                busiQrySkuPriceReqBO.setSupplierId(batchUpdateSkuPriceReqBo.getSupplierId());
                busiQrySkuPriceReqBO.setIsExtSku(Boolean.valueOf(true));
                BusiQrySkuPriceRspBO qrySkuPrice = this.qrySkuPriceService.qrySkuPrice(busiQrySkuPriceReqBO);
                if (!qrySkuPrice.getSkuPrices().isEmpty()) {
                    for (BusiQrySkuPriceRspVO busiQrySkuPrice : qrySkuPrice.getSkuPrices()) {
                        Sku oldSku = this.skuMapper.selectByExtSkuIdAndSupplierId(busiQrySkuPrice.getSkuId(), batchUpdateSkuPriceReqBo.getSupplierId());
                        if (null == oldSku) {
                            batchUpdateSkuPriceRspBo.setIsSuccess(Boolean.valueOf(false));
                            batchUpdateSkuPriceRspBo.setResultMsg("\u4f9b\u5e94\u5546[" + batchUpdateSkuPriceReqBo.getSupplierId() + "]\u7684\u5546\u54c1[" + busiQrySkuPrice.getSkuId() + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                            batchUpdateSkuPriceRspBo.setRespCode("8888");
                            batchUpdateSkuPriceRspBo.setRespDesc("\u5931\u8d25");
                            return batchUpdateSkuPriceRspBo;
                        }
                        List<SkuPrice> skuPrices = this.skuPriceMapper.selectBySkuId(oldSku.getSkuId(), oldSku.getSupplierId());
                        SkuPrice skuPrice = new SkuPrice();
                        skuPrice.setSkuId(oldSku.getSkuId());
                        skuPrice.setSupplierId(batchUpdateSkuPriceReqBo.getSupplierId());
                        if (null != busiQrySkuPrice.getPrice()) {
                            Double price;
                            skuPrice.setAgreementPrice(MoneyUtils.BigDecimal2Long((BigDecimal)busiQrySkuPrice.getPrice()));
                            if (1L == batchUpdateSkuPriceReqBo.getSupplierId()) {
                                price = (double)MoneyUtils.BigDecimal2Long((BigDecimal)busiQrySkuPrice.getPrice()).longValue() * 1.04;
                                skuPrice.setMemberPrice(price.longValue());
                                skuPrice.setSalePrice(price.longValue());
                            } else {
                                price = (double)MoneyUtils.BigDecimal2Long((BigDecimal)busiQrySkuPrice.getPrice()).longValue() * 1.04;
                                skuPrice.setMemberPrice(price.longValue());
                                skuPrice.setSalePrice(price.longValue());
                            }
                        }
                        if (null != busiQrySkuPrice.getEcPrice()) {
                            skuPrice.setMarketPrice(MoneyUtils.BigDecimal2Long((BigDecimal)busiQrySkuPrice.getEcPrice()));
                        }
                        if (!skuPrices.isEmpty()) {
                            skuPrice.setUpdateTime(new Date());
                            this.skuPriceMapper.updateBySkuIdKey(skuPrice);
                            continue;
                        }
                        skuPrice.setCreateTime(new Date());
                        skuPrice.setCurrencyType(0);
                        skuPrice.setIsDelete(0);
                        this.skuPriceMapper.insertSelective(skuPrice);
                    }
                }
            }
            batchUpdateSkuPriceRspBo.setIsSuccess(Boolean.valueOf(true));
            batchUpdateSkuPriceRspBo.setResultMsg("\u6279\u91cf\u66f4\u65b0\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4ef7\u683c\u4e1a\u52a1\u670d\u52a1\u6210\u529f");
            batchUpdateSkuPriceRspBo.setRespCode("0000");
            batchUpdateSkuPriceRspBo.setRespDesc("\u6210\u529f");
            return batchUpdateSkuPriceRspBo;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4ef7\u683c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            batchUpdateSkuPriceRspBo.setIsSuccess(Boolean.valueOf(false));
            batchUpdateSkuPriceRspBo.setResultMsg("\u6279\u91cf\u66f4\u65b0\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4ef7\u683c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            batchUpdateSkuPriceRspBo.setRespCode("8888");
            batchUpdateSkuPriceRspBo.setRespDesc("\u5931\u8d25");
            return batchUpdateSkuPriceRspBo;
        }
    }
}

